/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.LDevNickname;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public abstract class CreateModifyVolumeBase
extends AbstractJobImpl {
    protected CreateModifyVolumeBase(String pDeviceSerial, String pMethodName, String pUserName, String pIPAddress, CIMObjectPath pOwningSrvc, String pAffectedElementClassName, String pOwningJobElementClassName, HitachiJobCallbackIF pCallback) throws WBEMException {
        super(pDeviceSerial, pMethodName, pUserName, pIPAddress, pOwningSrvc, pAffectedElementClassName, pOwningJobElementClassName, pCallback);
    }

    protected CreateModifyVolumeBase(String pDeviceSerial, String pMethodName, String pUserName, String pIPAddress, CIMObjectPath pOwningSrvc, String[] pAffectedElementClassNames, String pOwningJobElementClassName, HitachiJobCallbackIF pCallback) throws WBEMException {
        super(pDeviceSerial, pMethodName, pUserName, pIPAddress, pOwningSrvc, pAffectedElementClassNames, pOwningJobElementClassName, pCallback);
    }

    protected DeviceNumber verifyVolumeCreated(CreateVolumeDataBase volData) throws WBEMException {
        if (null == volData) {
            throw new WBEMException("verifyVolumeCreated: Parameter can not be null.");
        }
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        DeviceNumber dn = null;
        boolean nickUpdated = false;
        for (int retryCount = -1; !nickUpdated && retryCount < 20; ++retryCount) {
            if (null == dn) {
                dn = DeviceNumber.find(volData.getCreatedDNStr(), device.getRMIObject());
            }
            if (null != dn) {
                if (null == volData.getElementName()) {
                    nickUpdated = true;
                } else {
                    LDevNickname nick = LDevNickname.find(dn);
                    if (null != nick && nick.getNickname().equalsIgnoreCase(volData.getElementName())) {
                        nickUpdated = true;
                        mLogger.log(Level.INFO, "LDEV nickname updated {0}", nick);
                    }
                }
            }
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.log(Level.FINE, "Volume({0}) was{1} created and element name was{2} changed, will retry in {3} seconds", new Object[]{volData.getCreatedDNStr(), null == dn ? " not" : "", !nickUpdated ? " not" : "", 30});
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
        }
        if (null == dn) {
            throw new WBEMException("Volume (" + volData + ") was not added to cache");
        }
        if (!nickUpdated) {
            mLogger.log(Level.SEVERE, "LDEV nickname was not updated {0}", volData);
        }
        return dn;
    }

    public static interface CreateVolumeDataBase {
        public String getCreatedDNStr();

        public String getElementName();

        public long getSize();
    }
}

