/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedDeleteProtocolController;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class DeleteProtocolController
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    private final boolean deleteVols;
    private final PortandHostGroupInfo hostGroup;
    private final ISCSITargetPort.ISCSITarget iSCSITarget;
    private UnsignedInteger32 retVal;

    public DeleteProtocolController(String userName, String ipAddress, CIMObjectPath owningService, PortandHostGroupInfo phg, ISCSITargetPort.ISCSITarget iSCSI, boolean deleteUnits) throws WBEMException {
        super(null != phg ? phg.getSerialNumber() : iSCSI.getSerialNumber(), "DeleteProtocolController", userName, ipAddress, owningService, new String[]{"CIM_AffectedJobElement", "CIM_AffectedJobElement"}, "HITACHI_StorageCSOwningJobElement", null);
        this.setCallback(this);
        this.hostGroup = phg;
        this.iSCSITarget = iSCSI;
        this.deleteVols = deleteUnits;
        this.retVal = ProviderConstants.UINT32_ZED;
    }

    @Override
    protected Object getActionItem() {
        return null != this.hostGroup ? this.hostGroup : this.iSCSITarget;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedDeleteProtocolController();
    }

    public PortandHostGroupInfo getHostGroup() {
        return this.hostGroup;
    }

    public ISCSITargetPort.ISCSITarget getiSCSITarget() {
        return this.iSCSITarget;
    }

    public UnsignedInteger32 getRetVal() {
        return this.retVal;
    }

    public boolean isDeleteVols() {
        return this.deleteVols;
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            this.getRMIResult();
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    void setRetVal(UnsignedInteger32 retVal) {
        this.retVal = retVal;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteProtocolController [hostGroup=");
        builder.append(this.hostGroup);
        builder.append(", iSCSITarget=");
        builder.append(this.iSCSITarget);
        builder.append(", deleteChildrenPC=");
        builder.append(this.deleteVols);
        builder.append("]");
        return builder.toString();
    }
}

