/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedModifyPortLabelJob;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.io.Serializable;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ModifyPortLabel
extends AbstractJobImpl
implements HitachiJobCallbackIF,
CacheUpdateNotifier {
    private static final String CCN_HITACHI_AFFECTEDJOBELEMENTPORTLABEL = "HITACHI_AffectedJobElementPortLabel";
    private final FCPort thePort;
    private final String newLabel;
    private final String ctrlID;
    private final String domainID;
    private boolean jobDone = false;
    private WBEMException storedError = null;

    public ModifyPortLabel(String pUserName, String pIPAddress, CIMObjectPath owningService, String label, CIMObjectPath objPath, FCPort obj, String ctrID, String domainID) throws WBEMException {
        super(obj.getSerialNumber(), "ModifyPortLabel_" + obj.getByPortKindNo(), pUserName, pIPAddress, owningService, CCN_HITACHI_AFFECTEDJOBELEMENTPORTLABEL, CCN_HITACHI_AFFECTEDJOBELEMENTPORTLABEL, null);
        this.thePort = obj;
        this.newLabel = label;
        this.ctrlID = ctrID;
        this.domainID = domainID;
        this.setCallback(this);
        this.setAffectedElements(new CIMObjectPath[]{objPath});
        CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, this.getDeviceSerial());
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        try {
            Object device;
            if (pObj instanceof PortandHostGroupInfo) {
                PortandHostGroupInfo port = PortandHostGroupInfo.find(((PortandHostGroupInfo)pObj).getSerialNumber(), null, Short.toString(((PortandHostGroupInfo)pObj).getCtrlID()), Short.toString(((PortandHostGroupInfo)pObj).getPortID()), Short.toString(((PortandHostGroupInfo)pObj).getHostgroupID()), null, false, null);
                if (!this.newLabel.equals(port.getHostGroupNickName())) {
                    this.storedError = new WBEMException(String.format("Port %d was modified but the name is %s but should be %s", this.thePort.getPort(), port.getHostGroupNickName(), this.newLabel));
                }
            } else if (pObj instanceof ISCSITargetPort) {
                device = RMIObjectMapping.getRMIObjectMapping(((ISCSITargetPort)pObj).getSerialNumber());
                RMIObjectCache rmiObj = ((RMIObjectMapping)device).getRMIObject();
                ISCSITargetPort port = ISCSITargetPort.find(rmiObj, ((ISCSITargetPort)pObj).getPortId());
                ISCSITargetPort.ISCSITarget target = port.getTarget(this.getDomainID());
                if (!this.newLabel.equals(target.getAlias())) {
                    this.storedError = new WBEMException(String.format("Port %d was modified but the name is %s but should be %s", this.thePort.getPort(), target.getAlias(), this.newLabel));
                }
            } else {
                mLogger.log(Level.SEVERE, "Unexpected object passed to function: {0}", pObj);
                this.storedError = new WBEMException("Unexpected object passed to function: " + pObj);
            }
            device = this;
            synchronized (device) {
                this.jobDone = true;
                this.notifyAll();
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Error finding modified HostGroup/iSCSITarget: " + pObj, e);
            this.storedError = e;
        }
        catch (Throwable t) {
            this.storedError = new WBEMException(1, "Unexpected error finding modified HostGroup/iSCSITarget: " + pObj, null, t);
        }
    }

    @Override
    protected FCPort getActionItem() {
        return this.thePort;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedModifyPortLabelJob();
    }

    public short getCtrlID() {
        return Short.parseShort(this.ctrlID);
    }

    public short getDomainID() {
        return Short.parseShort(this.domainID);
    }

    public FCPort getFCPort() {
        return this.thePort;
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public short getPortID() {
        return this.thePort.getPort();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(50);
                break;
            }
            case AFTER_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(75);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                this.getHitachiJobServiceObject().markServerJobStarted(90);
                break;
            }
            case AFTER_JOB_COMPLETE: {
                this.processResult();
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult() throws WBEMException {
        WBEMException we = null;
        try {
            this.getRMIResult();
            this.verifyNameChange();
            if (null != this.storedError) {
                we = this.storedError;
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable e) {
            we = new WBEMException(1, "Exception getting transaction result: " + e, null, e);
        }
        finally {
            this.unsubscribe();
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    @Override
    protected void setError(Throwable error) {
        super.setError(error);
        this.unsubscribe();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateVolumeLabel ");
        builder.append(this.getActionItem());
        return builder.toString();
    }

    private void unsubscribe() {
        CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, this.getDeviceSerial());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNameChange() throws WBEMException {
        while (!this.jobDone && !HitachiCacheMangerService.isShuttingDown()) {
            ModifyPortLabel modifyPortLabel = this;
            synchronized (modifyPortLabel) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    mLogger.log(Level.SEVERE, "Wait was interuptted, job is in an unknown state", e);
                    throw new WBEMException("Wait was interuptted, job is in an unknown state");
                }
            }
        }
    }
}

