/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs.workers;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.DeviceNumber;
import java.rmi.RemoteException;
import java.util.List;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_EXDPGOperation;
import sanproject.common.Robj_interface_EXDsetAOUReleaseVvol_IN;
import sanproject.serverux.data.SANRmiException;

public class DeleteThinVolume {
    private final Robj_interface_EXDsetAOUReleaseVvol_IN releaseVol;
    private final RMIObjectCache rmiObj;

    public DeleteThinVolume(RMIObjectCache rmiObj) throws WBEMException {
        this.rmiObj = rmiObj;
        try {
            this.releaseVol = (Robj_interface_EXDsetAOUReleaseVvol_IN)this.rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.EXDSETAOURELEASEVVOL_IN);
        }
        catch (RemoteException | SANRmiException e) {
            throw new WBEMException(1, "Error creating EXDsetAOUReleaseVvol_IN object: " + e, null, e);
        }
    }

    public void addDN(DeviceNumber dn) throws WBEMException {
        if (!dn.isAOUVol()) {
            throw new WBEMException(4, "Passed in DeviceNumber is not a thin volume, dn: " + dn.getDn());
        }
        try {
            Robj_interface_EXDPGOperation vvolData = (Robj_interface_EXDPGOperation)this.rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.EXDPGOPERATION);
            vvolData.setIFB4(dn.getFb4());
            vvolData.setIPG(dn.getPg());
            this.releaseVol.setRobjPG(vvolData);
        }
        catch (RemoteException | SANRmiException e) {
            throw new WBEMException(1, "Error creating EXDPGOperation object: " + e, null, e);
        }
    }

    public void addDNs(List<DeviceNumber> dns) throws WBEMException {
        for (DeviceNumber dn : dns) {
            this.addDN(dn);
        }
    }

    public Robj_interface_EXDsetAOUReleaseVvol_IN getReleaseVol() {
        return this.releaseVol;
    }
}

