/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.providers.profiles;

import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.providers.BaseAssociatorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.provider.ProviderHandle;

public abstract class BaseSoftwareIdentityAssoc
extends BaseAssociatorProvider {
    private CIMInstance wbemServerSoftware = null;
    private final List<String> dependentList = new ArrayList<String>();
    protected final String CCN_NAME;
    protected final String CCN_ANTECEDENT;
    protected final String CCN_DEPENDENT;

    protected BaseSoftwareIdentityAssoc(String clzName, String dependent, String antecedent) {
        this.CCN_NAME = clzName;
        this.CCN_DEPENDENT = dependent;
        this.CCN_ANTECEDENT = antecedent;
    }

    private void getDependents(CIMObjectPath op) {
        try {
            CIMObjectPath regProfileOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.CCN_DEPENDENT, null);
            CloseableIterator response = mHandle.enumerateClasses(regProfileOP, true, false, false);
            while (response.hasNext()) {
                CIMClass clz = (CIMClass)response.next();
                String clzName = clz.getName().toLowerCase();
                this.dependentList.add(clzName);
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Error enumerating classes of " + this.CCN_DEPENDENT, t);
        }
        Collections.sort(this.dependentList);
    }

    protected CIMInstance getWBEMServerSoftware(CIMObjectPath op) {
        CIMInstance ret;
        boolean logNull = true;
        if (null == this.wbemServerSoftware) {
            this.setWBEMServerSoftware(op);
            logNull = false;
        }
        if (null == this.wbemServerSoftware && logNull) {
            mLogger.log(Level.SEVERE, "Could not find instance of {0}", this.CCN_ANTECEDENT);
        }
        if (null != this.wbemServerSoftware) {
            CIMObjectPath wssOp = this.wbemServerSoftware.getObjectPath();
            ret = new CIMInstance(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), wssOp.getNamespace(), wssOp.getObjectName(), wssOp.getKeys()), this.wbemServerSoftware.getProperties());
        } else {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void initialize(ProviderHandle handle) throws WBEMException {
        ProviderHandle t = mHandle;
        if (null == t) {
            Class<BaseInstrumentation> clazz = BaseInstrumentation.class;
            // MONITORENTER : com.hitachi.smi.instrumentation.BaseInstrumentation.class
            t = mHandle;
            if (null == t) {
                t = mHandle = handle;
            }
            // MONITOREXIT : clazz
        }
        this.setWBEMServerSoftware(new CIMObjectPath(null, null, null, ProviderLibs.getInteropNamespace(), this.CCN_ANTECEDENT, null));
    }

    protected boolean isDependent(CIMObjectPath profileOP) {
        return this.isDependent(profileOP.getObjectName());
    }

    protected boolean isDependent(String clzName) {
        boolean ret = false;
        int index = Collections.binarySearch(this.dependentList, clzName.toLowerCase());
        if (index >= 0) {
            ret = true;
        } else {
            mLogger.log(Level.FINE, "{0} is not in the dependents list {1}", new Object[]{clzName, this.dependentList});
        }
        return ret;
    }

    private synchronized void setWBEMServerSoftware(CIMObjectPath op) {
        if (null == this.wbemServerSoftware) {
            CIMObjectPath opSoftwareClass = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.CCN_ANTECEDENT, null);
            UnsignedInteger32 maxObjects = new UnsignedInteger32(100L);
            try {
                EnumerateResponse response = mHandle.enumerateInstances(opSoftwareClass, null, null, null, null, false, maxObjects);
                boolean gotFirst = false;
                while (!gotFirst || !response.isEnd()) {
                    CIMInstance softInst;
                    CloseableIterator pIter;
                    if (gotFirst) {
                        response = mHandle.getInstancesWithPath(opSoftwareClass, response.getContext(), maxObjects);
                    } else {
                        gotFirst = true;
                    }
                    if (!(pIter = response.getResponses()).hasNext()) continue;
                    this.wbemServerSoftware = softInst = (CIMInstance)pIter.next();
                    try {
                        mHandle.closeEnumeration(opSoftwareClass, response.getContext());
                    }
                    catch (WBEMException we) {
                        mLogger.log(Level.FINE, "Error closing enumeration - this is ok", we);
                    }
                    break;
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Exception enumerating " + this.CCN_ANTECEDENT, t);
            }
        }
        if (this.dependentList.isEmpty()) {
            this.getDependents(op);
        }
    }
}

