/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.process;

import sanproject.session.common.exception.SJsessionAuthenticationException;
import sanproject.session.server.process.SJsessionProcessBase;

public class SJsessionProcess4SN2_NOR_EM
extends SJsessionProcessBase {
    private static final String ADMIN_USER_GROUP = "Administrator User Group";

    public SJsessionProcess4SN2_NOR_EM(String appID, String loginType) {
        super(appID, loginType);
    }

    protected boolean execAuthentication() throws SJsessionAuthenticationException {
        String LOG_SUBTITLE = "execAuthentication";
        this.logger.trace("SessionServer", this.LOG_TITLE, "execAuthentication", "Start.");
        boolean ret = false;
        String userID = (String)this.loginEntry.get("AUTHENTICATION_USERID");
        ret = super.execAuthentication();
        if (ret) {
            String[] groupIDs = this.authBase.getGroupID();
            if (groupIDs == null) {
                this.logger.error("SessionServer", this.LOG_TITLE, "execAuthentication", "Authentication error occured. (Group ID noting.) User ID:" + userID);
                ret = false;
            } else {
                boolean checkGroup = false;
                for (String group : groupIDs) {
                    if (group == null || !group.equals(ADMIN_USER_GROUP)) continue;
                    checkGroup = true;
                    break;
                }
                if (!checkGroup) {
                    this.logger.error("SessionServer", this.LOG_TITLE, "execAuthentication", "Authentication error occured. (Not Administrator User Group.) User ID:" + userID);
                    ret = false;
                }
            }
        }
        this.logger.trace("SessionServer", this.LOG_TITLE, "execAuthentication", "End.");
        return ret;
    }
}

