/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.receive;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import sanproject.session.common.exception.SJsessionAuthenticationException;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.common.exception.SJsessionParameterException;
import sanproject.session.common.receive.inf.SJsessionReceiveServerInterface;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.inf.SJsessionProcessInterface;
import sanproject.session.server.process.plugin.SJsessionProcessPluginItem;
import sanproject.session.server.process.plugin.SJsessionProcessPluginManager;
import sanproject.session.server.receive.manager.SJsessionReceiveModuleManager;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginItem;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginManager;
import sanproject.session.server.store.SJsessionStoreHouse;
import sanproject.session.server.store.manager.SJsessionEventManager;
import sanproject.session.server.unique.SJsessionUniqueIDManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionReceiveBase
extends UnicastRemoteObject
implements SJsessionReceiveServerInterface {
    private static final long serialVersionUID = 1L;
    protected static final String LOG_FUNCTION = "SessionServer";
    protected final transient String LOG_TITLE = this.getClass().getSimpleName();
    protected transient SJcLoggerInterface logger = SJsessionServerUty.getLogger();
    protected transient SJsessionStoreHouse storeHouse = null;
    protected transient String connectionID;
    protected transient String appID = null;
    protected transient int polling_time;
    protected transient int session_timeout;
    protected transient boolean keepflg;
    protected transient int keeptime;
    protected transient boolean notify_flg = false;

    public SJsessionReceiveBase(String appid) throws RemoteException {
        this.appID = appid;
    }

    @Override
    public void initialize() throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "initialize";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initialize", "Start.");
        SJsessionReceivePluginItem item = SJsessionReceivePluginManager.getPluginItem(this.appID);
        this.polling_time = item.getPollingTime();
        this.session_timeout = item.getSessionTimeout();
        this.keepflg = item.getReceiverKeepflg();
        this.keeptime = item.getReceiverKeepTime();
        this.notify_flg = item.getNotifyFlg();
        if (this.keepflg) {
            this.connectionID = UUID.randomUUID().toString();
            this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initialize", "ConnectionID:" + this.connectionID);
        }
        int minID = item.getConnectionIDmin();
        int maxID = item.getConnectionIDmax();
        SJsessionUniqueIDManager.createIDManager(this.appID, minID, maxID);
        if (this.isNecessaryChangeNofity()) {
            SJsessionEventManager.startHandler(this.connectionID, this.appID);
        }
        this.storeHouse = SJsessionStoreHouse.getInstance();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initialize", "End.");
    }

    protected boolean isNecessaryChangeNofity() {
        boolean ret = false;
        if (this.keepflg && this.notify_flg && this.connectionID != null) {
            ret = true;
        }
        return ret;
    }

    @Override
    public HashMap<String, Object> getReceiveInfo() throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "getReceiveInfo";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getReceiveInfo", "Start.");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("CONNECTIONID", this.connectionID);
        ret.put("ALIVEPOLLINGPERIOD", this.polling_time);
        ret.put("NOTIFYFLAG", this.notify_flg);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getReceiveInfo", "End.");
        return ret;
    }

    @Override
    public HashMap login(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "login";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "login", "Start.");
        HashMap<String, Object> ret = null;
        if (!this.checkLoginParameter(info)) {
            throw new SJsessionParameterException("107001");
        }
        String loginType = (String)info.get("LOGINTYPE");
        SJsessionProcessInterface process = this.getProcessObj(loginType);
        ret = process.authentication(info);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "login", "End.");
        return ret;
    }

    protected SJsessionProcessInterface getProcessObj(String loginType) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "getProcessObj";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "getProcessObj", "Start.");
        SJsessionProcessInterface process = null;
        SJsessionProcessPluginItem item = SJsessionProcessPluginManager.getPluginItem(this.appID, loginType);
        if (item == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "getProcessObj", "request process plugin doesn't exist. loginType:" + loginType);
            throw new SJsessionAuthenticationException("107000");
        }
        String className = item.getClassName();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getProcessObj", "process className:" + className);
        try {
            process = (SJsessionProcessInterface)SJcInstanceCreateUty.newInstance(className, new Class[]{String.class, String.class}, new Object[]{this.appID, loginType});
        }
        catch (ClassCastException cce) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "getProcessObj", "ClassCastException", cce);
            throw new SJsessionAuthenticationException("107000");
        }
        if (process == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "getProcessObj", "request process cannot be created.");
            throw new SJsessionAuthenticationException("107000");
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "getProcessObj", "End.");
        return process;
    }

    protected boolean checkLoginParameter(HashMap<String, Object> info) throws RemoteException {
        Object[][] loginEntry = new Object[][]{{"AUTHENTICATION_USERID", String.class, true}, {"AUTHENTICATION_PASSWORD", String.class, true}, {"LOGINTYPE", String.class, true}, {"LANG", String.class, true}, {"ADDRESS", String.class, true}};
        Object[][] reLoginEntry = new Object[][]{{"GLOBALSESSIONID", String.class, true}, {"USER_IDENTICALNAME", String.class, true}, {"IDENTICAL_USERID", Integer.class, true}, {"DISPLAY_USERID", String.class, true}, {"AUTHENTICATION_NAME", String.class, true}, {"USERGROUPS", String[].class, true}, {"RESOURCE_ROLE", SJcRoleResourceContainer.class, true}, {"AUTHENTICATION_OBJECT", Object.class, false}, {"LOGINTIME", Date.class, true}};
        if (!SJsessionServerUty.checkParams(info, loginEntry)) {
            return false;
        }
        if (this.isReLogin(info)) {
            return SJsessionServerUty.checkParams(info, reLoginEntry);
        }
        return true;
    }

    @Override
    public void logout(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "logout";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "logout", "Start.");
        Object[][] check_item = new Object[][]{{"GLOBALSESSIONID", String.class, true}, {"FORCED_FLAG", Boolean.class, false}};
        if (!SJsessionServerUty.checkParams(info, check_item)) {
            throw new SJsessionParameterException("107001");
        }
        String gid = (String)info.get("GLOBALSESSIONID");
        Boolean forcedFlg = (Boolean)info.get("FORCED_FLAG");
        if (forcedFlg != null && forcedFlg.booleanValue()) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "logout", "forced logout cannot be use.");
            throw new SJsessionParameterException(gid);
        }
        this.storeHouse.removeLoginInfo(gid, this.appID);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "logout", "End.");
    }

    @Override
    public HashMap alive_session(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "alive_session";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "alive_session", "Start.");
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        Object[][] check_item = new Object[][]{{"GLOBALSESSIONID_ALIVE_LIST", List.class, true}};
        if (!SJsessionServerUty.checkParams(info, check_item)) {
            throw new SJsessionParameterException("107001");
        }
        List inList = (List)info.get("GLOBALSESSIONID_ALIVE_LIST");
        List<String> outList = this.storeHouse.notifyAlive(this.appID, inList);
        ret.put("GLOBALSESSIONID_ALIVE_LIST", outList);
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "alive_session", "End.");
        return ret;
    }

    @Override
    public HashMap getLoginUserList() throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "getLoginUserList";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getLoginUserList", "Start.");
        HashMap<String, List<HashMap<String, Object>>> ret = new HashMap<String, List<HashMap<String, Object>>>();
        List<HashMap<String, Object>> list = this.storeHouse.getSessionList();
        ret.put("SESSION_LIST", list);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getLoginUserList", "End.");
        return ret;
    }

    @Override
    public HashMap changeNotify() throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "changeNotify";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "changeNotify", "Start.");
        HashMap<String, Object> ret = null;
        ret = SJsessionEventManager.getEvent(this.connectionID);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "changeNotify", "End.");
        return ret;
    }

    @Override
    public String getConnectionID() throws RemoteException {
        return this.connectionID;
    }

    @Override
    public long getKeepTime() throws RemoteException {
        return this.keeptime;
    }

    @Override
    public void finish() throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "finish";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "Start. Connection ID:" + this.connectionID);
        if (this.isNecessaryChangeNofity()) {
            SJsessionEventManager.stopHandler(this.connectionID);
        }
        if (this.keepflg) {
            SJsessionReceiveModuleManager receiveMgr = SJsessionReceiveModuleManager.getInstance();
            receiveMgr.removeReceiveModule(this.connectionID);
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "End.");
    }

    @Override
    public boolean isAvailable() throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "isAvailable";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "isAvailable", "Start.");
        boolean ret = false;
        if (this.keepflg) {
            SJsessionReceiveModuleManager receiveMgr = SJsessionReceiveModuleManager.getInstance();
            ret = receiveMgr.checkAvailable(this.connectionID);
            if (!ret) {
                this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "isAvailable", "module not alive. ID:" + this.connectionID);
            }
        } else {
            ret = true;
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "isAvailable", "End.");
        return ret;
    }

    protected boolean isReLogin(HashMap<String, Object> info) throws RemoteException, SJsessionException {
        boolean rtnFlg = false;
        Object[][] check_item = new Object[][]{{"RELOGIN_FLG", Boolean.class, false}};
        if (!SJsessionServerUty.checkParams(info, check_item)) {
            throw new SJsessionParameterException("107001");
        }
        Boolean reLoginFlg = (Boolean)info.get("RELOGIN_FLG");
        if (reLoginFlg != null) {
            rtnFlg = reLoginFlg;
        }
        return rtnFlg;
    }

    @Override
    public HashMap reLogin(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "reLogin";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "reLogin", "Start.");
        HashMap ret = new HashMap();
        ArrayList<String> out_list = new ArrayList<String>();
        Object[][] check_item = new Object[][]{{"RELOGIN_LIST", List.class, true}};
        if (!SJsessionServerUty.checkParams(info, check_item)) {
            throw new SJsessionParameterException("107001");
        }
        List in_list = this.checkReLogin(info);
        ListIterator iterator = in_list.listIterator();
        while (iterator.hasNext()) {
            HashMap map = null;
            map = (HashMap)iterator.next();
            String gsid = (String)map.get("GLOBALSESSIONID");
            try {
                if (this.storeHouse.isExsist(gsid)) {
                    this.storeHouse.reauthenticateSession(gsid, this.appID);
                } else {
                    map.put("RELOGIN_FLG", Boolean.TRUE);
                    this.login(map);
                }
            }
            catch (SJsessionException ex) {
                continue;
            }
            out_list.add(gsid);
        }
        ret.put("RELOGINED_GSID_LIST", out_list);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "reLogin", "End.");
        return ret;
    }

    protected List checkReLogin(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "checkReLogin";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "checkReLogin", "Start.");
        List list = null;
        try {
            list = (List)info.get("RELOGIN_LIST");
        }
        catch (ClassCastException cce) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "checkReLogin", "HashMap class of reLogin-list is invald.", cce);
            throw new SJsessionParameterException("107001");
        }
        ArrayList<HashMap> availableReLogin = new ArrayList<HashMap>();
        List<String> gsidList = SJsessionEventManager.getRemoveSessionIDList(this.appID);
        for (HashMap map : list) {
            String gsid = (String)map.get("GLOBALSESSIONID");
            if (gsidList.contains(gsid)) continue;
            this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "checkReLogin", "re-login possible. GSID:" + gsid);
            availableReLogin.add(map);
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "checkReLogin", "End.");
        return availableReLogin;
    }
}

