/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.unique;

import java.io.Serializable;
import java.util.HashMap;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.unique.SJsessionUniqueIDTableInfo;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionUniqueIDInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SESSION_UNIQUE_ID_MIN = 1;
    public static final int SESSION_UNIQUE_ID_MAX = 706;
    private static final int INITIAL_POSITION = -1;
    private SJsessionUniqueIDTableInfo[] table = null;
    private HashMap<String, Integer> pos = null;
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionUniqueIDInfo.class.getSimpleName();

    public SJsessionUniqueIDInfo() {
        this.initTable();
        this.pos = new HashMap();
    }

    public void initTable() {
        this.table = new SJsessionUniqueIDTableInfo[706];
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = new SJsessionUniqueIDTableInfo();
        }
    }

    public boolean assignGSID(int conid, String gsid) {
        if (conid <= 0 || conid > this.table.length) {
            return false;
        }
        this.table[conid - 1].setGrobalID(gsid);
        return true;
    }

    public void updatePosMap(String appID, int conid) {
        this.pos.put(appID, new Integer(conid));
    }

    public int getNextID(String appID, int maxID, int minID) {
        int ret = -1;
        Integer ipos = this.pos.get(appID);
        if (ipos != null) {
            ret = ipos;
        }
        ret = ret >= maxID || ret < minID ? minID : ++ret;
        return ret;
    }

    public int getUnAssignedID(String appID, int maxID, int minID) {
        int preID;
        int result = 0;
        if (appID == null || maxID > 706 || minID < 1) {
            return result;
        }
        if (this.pos.get(appID) == null) {
            this.pos.put(appID, -1);
        }
        preID = (preID = this.pos.get(appID).intValue()) >= maxID || preID < minID ? minID : ++preID;
        result = this.searchID(preID, maxID);
        if (result == 0) {
            result = this.searchID(minID, preID);
        }
        return result;
    }

    private int searchID(int start, int end) {
        int result = 0;
        for (int i = start; i <= end; ++i) {
            if (this.table[i - 1].getGrobalID() != null || this.table[i - 1].getLockFlg()) continue;
            result = i;
            break;
        }
        return result;
    }

    public int searchIDByGID(String gsid) {
        int result = 0;
        for (int i = 1; i <= this.table.length; ++i) {
            if (this.table[i - 1].getGrobalID() == null || !this.table[i - 1].getGrobalID().equals(gsid)) continue;
            result = i;
            break;
        }
        return result;
    }

    public HashMap<String, Integer> getPosMap() {
        return this.pos;
    }

    public void setPosMap(HashMap<String, Integer> pos) {
        this.pos = pos;
    }

    public SJsessionUniqueIDTableInfo[] getIDTable() {
        return this.table;
    }

    public void setIDTable(SJsessionUniqueIDTableInfo[] table) {
        this.table = table;
    }

    public void assignLockFlg(int conid, boolean lockFlg) {
        String LOG_SUBTITLE = "assigLockFlg";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start.");
        if (conid <= 0 || conid > this.table.length) {
            logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "CUID is invalid.");
            return;
        }
        boolean beforeFlg = this.table[conid - 1].getLockFlg();
        this.table[conid - 1].setLockFlg(lockFlg);
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "CUID:" + conid + "," + "Lock(Before):" + beforeFlg + "," + "Lock(After):" + lockFlg);
        logger.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
    }
}

