/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.pg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import sanproject.client.baseinfo.com.RJBaseInfoComboAdapter;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoTablePanel;
import sanproject.client.baseinfo.pg.RJBaseInfoItemFolder;
import sanproject.client.baseinfo.pg.RJBaseInfoItemPage;
import sanproject.client.baseinfo.pg.RJBaseInfoPGLDEVTablePanel;
import sanproject.client.baseinfo.pg.RJBaseInfoPGPGElement;
import sanproject.client.baseinfo.pg.RJBaseInfoPGPGTableModel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcBaseComboBox;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcComboBoxModel;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.DKCgetLDEVStatusByPG;

public class RJBaseInfoPGPGTablePanel
extends RJBaseInfoTablePanel
implements ActionListener {
    RJBaseInfoPGLDEVTablePanel ldevPanel = null;
    private JLabel statusField = new JLabel();
    private RJcButton detailButton = null;
    private RJcButton nextBtn = null;
    private RJcButton prevBtn = null;
    private JComboBox folderComboBox = null;
    private RJBaseInfoItemFolder folderItem = null;
    DKCgetLDEVStatusByPG[] status = null;
    RJBaseInfoPGPGElement[] statusList = null;
    public static final int PG_PAGE_MAX = 4096;
    private int folderStatus = 0;
    private JComboBox pageCombo = null;
    private int pageCount = 0;

    public RJBaseInfoPGPGTablePanel(RJBaseInfoPGLDEVTablePanel rJBaseInfoPGLDEVTablePanel, RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(rJBaseInfoDataSupplier);
        this.ldevPanel = rJBaseInfoPGLDEVTablePanel;
        RJBaseInfoPGPGTableModel rJBaseInfoPGPGTableModel = new RJBaseInfoPGPGTableModel(rJBaseInfoDataSupplier);
        this.createTable(rJBaseInfoPGPGTableModel);
        this.add((Component)this.createSouthPanel(), "South");
    }

    public void showTable(RJBaseInfoItemFolder rJBaseInfoItemFolder, int n) {
        if (rJBaseInfoItemFolder != null && rJBaseInfoItemFolder.getFolder() != null) {
            this.folderItem = rJBaseInfoItemFolder;
            this.pageCount = n;
            if (n < 0) {
                int n2;
                this.status = null;
                this.statusList = null;
                this.folderStatus = 0;
                this.pageCount = 0;
                RJBaseInfoPGPGTableModel rJBaseInfoPGPGTableModel = new RJBaseInfoPGPGTableModel(this.supplier);
                this.createTable(rJBaseInfoPGPGTableModel);
                RJiPGIndex[] rJiPGIndexArray = (RJiPGIndex[])this.supplier.getPGIndex(rJBaseInfoItemFolder.getFolder());
                this.status = this.supplier.getLDEVStatusByPG(rJiPGIndexArray);
                this.supplier.getAllRSGInfo();
                ArrayList<RJBaseInfoPGPGElement> arrayList = new ArrayList<RJBaseInfoPGPGElement>();
                block3: for (n2 = 0; n2 < this.status.length; ++n2) {
                    RJBaseInfoPGPGElement rJBaseInfoPGPGElement = new RJBaseInfoPGPGElement(this.status[n2], this.supplier);
                    arrayList.add(rJBaseInfoPGPGElement);
                    switch (this.status[n2].getByLDEVStatus()) {
                        case 0: 
                        case 1: 
                        case 9: {
                            if (this.folderStatus == 127) continue block3;
                            this.folderStatus = 1;
                            continue block3;
                        }
                        default: {
                            this.folderStatus = 127;
                        }
                    }
                }
                if (arrayList != null || !arrayList.isEmpty()) {
                    this.statusList = arrayList.toArray(new RJBaseInfoPGPGElement[0]);
                }
                n2 = this.statusList.length % 4096 == 0 ? this.statusList.length / 4096 : this.statusList.length / 4096 + 1;
                this.initPageComboBox(null, this.statusList.length, n2);
                this.pageCombo.setEnabled(n2 > 1);
            }
            this.supplier.putLog("[BaseInfo]", "[showTable]", "AddRow Start = [" + this.pageCount + "]");
            this.model.beginSetting();
            this.getTable().setSelectionMode(0);
            for (int i = 4096 * this.pageCount; i < this.statusList.length && i < 4096 * (this.pageCount + 1); ++i) {
                ((RJBaseInfoPGPGTableModel)this.model).addRow(this.statusList[i]);
            }
            this.model.completeSetting();
            this.supplier.putLog("[BaseInfo]", "[showTable]", "AddRow End");
            this.setStatusLabel(this.folderStatus);
            this.setPrevButtonEnabled(this.pageCount != 0);
            this.setNextButtonEnabled(this.statusList.length > 4096 * (this.pageCount + 1));
        } else {
            this.reset();
            this.setStatusLabel(0);
            this.setPrevButtonEnabled(false);
            this.setNextButtonEnabled(false);
            this.setDetailButtonEnabled(false);
            this.pageCombo.removeAllItems();
            this.pageCombo.setEnabled(false);
        }
        this.repaint();
    }

    private void initPageComboBox(RJBaseInfoItemPage rJBaseInfoItemPage, int n, int n2) {
        ArrayList<RJBaseInfoItemPage> arrayList = new ArrayList<RJBaseInfoItemPage>();
        RJBaseInfoItemPage rJBaseInfoItemPage2 = null;
        int n3 = 0;
        for (int i = 0; i < n; i += 4096) {
            rJBaseInfoItemPage2 = new RJBaseInfoItemPage(n3 + 1, n2);
            arrayList.add(rJBaseInfoItemPage2);
            ++n3;
        }
        if (arrayList.isEmpty()) {
            rJBaseInfoItemPage2 = new RJBaseInfoItemPage(0, 0);
            arrayList.add(0, rJBaseInfoItemPage2);
        }
        RJcComboBoxModel rJcComboBoxModel = new RJcComboBoxModel(arrayList);
        rJcComboBoxModel.setSelectedItem(null);
        this.pageCombo.setModel(rJcComboBoxModel);
        if (rJBaseInfoItemPage == null || !arrayList.contains(rJBaseInfoItemPage)) {
            rJBaseInfoItemPage = (RJBaseInfoItemPage)this.pageCombo.getItemAt(0);
        }
        this.pageCombo.setSelectedItem(rJBaseInfoItemPage);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        RJBaseInfoPGPGElement rJBaseInfoPGPGElement = null;
        int n = this.getTable().getSelectedRow();
        int n2 = -1;
        if (n >= 0) {
            object = this.getDataModel().getRow(n);
            rJBaseInfoPGPGElement = (RJBaseInfoPGPGElement)((RJaDataModelEntry)object).get("PG");
            n2 = rJBaseInfoPGPGElement.getStatus();
        }
        boolean bl = !((DefaultListSelectionModel)(object = (DefaultListSelectionModel)listSelectionEvent.getSource())).isSelectionEmpty() && this.getSelectedCount() == 1 && n2 != 0;
        this.setDetailButtonEnabled(bl);
        this.ldevPanel.reset();
    }

    private void showLDEVStatusTable() {
        this.supplier.putLog("[BaseInfo]", "[showLDEVStatusTable]", "Start");
        RJBaseInfoPGPGElement rJBaseInfoPGPGElement = null;
        int n = this.getTable().getSelectedRow();
        this.supplier.putLog("[BaseInfo]", "[showLDEVStatusTable]", "indx = [" + n + "]");
        if (n >= 0) {
            RJaDataModelEntry rJaDataModelEntry = this.getDataModel().getRow(n);
            rJBaseInfoPGPGElement = (RJBaseInfoPGPGElement)rJaDataModelEntry.get("PG");
        }
        if (rJBaseInfoPGPGElement != null) {
            this.ldevPanel.showTable(rJBaseInfoPGPGElement);
        } else {
            this.ldevPanel.reset();
        }
        this.supplier.putLog("[BaseInfo]", "[showLDEVStatusTable]", "End");
    }

    private void setStatusLabel(int n) {
        String string = " ";
        switch (n) {
            case 1: {
                string = RJcGuide.text("CVS/COM_NORMAL");
                break;
            }
            case 127: {
                string = RJcGuide.text("CVS/COM_WARNING");
                break;
            }
        }
        this.statusField.setText(string);
    }

    public void setDetailButtonEnabled(boolean bl) {
        if (this.detailButton != null) {
            this.detailButton.setEnabled(bl);
        }
    }

    public void setNextButtonEnabled(boolean bl) {
        if (this.nextBtn != null) {
            this.nextBtn.setEnabled(bl);
        }
    }

    public void setPrevButtonEnabled(boolean bl) {
        if (this.prevBtn != null) {
            this.prevBtn.setEnabled(bl);
        }
    }

    private int getSelectedCount() {
        int[] nArray = this.model.getSelectedRows();
        int n = nArray.length;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            RJCom.waitCursor(this.getParent());
            this.supplier.putLog("[BaseInfo]", "[PG Status]", "actionPerformed Start");
            this.showLDEVStatusTable();
            this.supplier.putLog("[BaseInfo]", "[PG Status]", "actionPerformed End");
        }
        finally {
            RJCom.defCursor(this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBtn_actionPerformed(ActionEvent actionEvent) {
        try {
            RJCom.waitCursor(this.getParent());
            int n = this.pageCombo.getSelectedIndex();
            this.supplier.putLog("[BaseInfo]", "[PG Status]", "nextBtn_actionPerformed Start = [" + n + "]");
            this.pageCombo.setSelectedIndex(n + 1);
            this.supplier.putLog("[BaseInfo]", "[PG Status]", "nextBtn_actionPerformed End");
        }
        finally {
            RJCom.defCursor(this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prevBtn_actionPerformed(ActionEvent actionEvent) {
        try {
            RJCom.waitCursor(this.getParent());
            int n = this.pageCombo.getSelectedIndex();
            this.supplier.putLog("[BaseInfo]", "[PG Status]", "prevBtn_actionPerformed Start = [" + n + "]");
            this.pageCombo.setSelectedIndex(n - 1);
            this.supplier.putLog("[BaseInfo]", "[PG Status]", "prevBtn_actionPerformed End");
        }
        finally {
            RJCom.defCursor(this.getParent());
        }
    }

    private void pageComboItemSelected(ItemEvent itemEvent) {
        RJBaseInfoItemPage rJBaseInfoItemPage = (RJBaseInfoItemPage)this.pageCombo.getSelectedItem();
        this.supplier.putLog("[BaseInfo]", "[PG Status]", "pageComboItemSelected [" + rJBaseInfoItemPage + "] Start");
        this.showTable(this.folderItem, (Integer)rJBaseInfoItemPage.getValue() - 1);
        this.supplier.putLog("[BaseInfo]", "[PG Status]", "pageComboItemSelected [" + rJBaseInfoItemPage + "] End");
        this.pageCombo.setSelectedItem(rJBaseInfoItemPage);
        this.ldevPanel.reset();
    }

    public void setFolderComboBox(JComboBox jComboBox) {
        this.folderComboBox = jComboBox;
    }

    public JComboBox getFolderComboBox() {
        return this.folderComboBox;
    }

    public void setDetailButton(RJcButton rJcButton) {
        this.detailButton = rJcButton;
    }

    public RJcButton getDetailButton() {
        return this.detailButton;
    }

    private JPanel createSouthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(200, 32));
        jPanel.setBackground(RJcGuide.color("GroupCushionPanelBgClr"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setMinimumSize(new Dimension(200, 16));
        jPanel2.setBackground(RJcGuide.color("GroupCushionPanelBgClr"));
        jPanel2.setOpaque(false);
        this.prevBtn = this.getPrevBtn();
        this.prevBtn.setEnabled(false);
        this.nextBtn = this.getNextBtn();
        this.nextBtn.setEnabled(false);
        this.pageCombo = this.createPageComboBox();
        this.pageCombo.setEnabled(false);
        JLabel jLabel = new JLabel();
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.prevBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 13, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.pageCombo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 13, new Insets(0, 2, 0, 0), 0, 0));
        jPanel2.add((Component)this.nextBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 13, new Insets(0, 2, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setMinimumSize(new Dimension(200, 20));
        jPanel3.setBackground(RJcGuide.color("BasicInfo/PGTableMarginBgClr"));
        JLabel jLabel2 = new JLabel(RJcGuide.text("BasicInfo/LBL_PG_STATUS"));
        jLabel2.setForeground(RJcGuide.color("BasicInfo/PGTableStatusLbl"));
        jLabel2.setMinimumSize(new Dimension(120, 14));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setFont(RJcConst.boldFont);
        this.statusField.setForeground(RJcGuide.color("BasicInfo/PGTableStatusField"));
        this.statusField.setMinimumSize(new Dimension(100, 14));
        this.statusField.setHorizontalAlignment(2);
        this.statusField.setFont(RJcConst.boldFont);
        jPanel3.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 13, 13, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.statusField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 13, new Insets(0, 2, 0, 8), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public RJcButton getNextBtn() {
        this.nextBtn = new RJcButton("BasicInfo/NextBtn");
        this.nextBtn.setPreferredSize(new Dimension(100, 24));
        this.nextBtn.setToolTipText(RJcGuide.text("BasicInfo/NextBtn"));
        this.nextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJBaseInfoPGPGTablePanel.this.nextBtn_actionPerformed(actionEvent);
            }
        });
        return this.nextBtn;
    }

    public RJcButton getPrevBtn() {
        this.prevBtn = new RJcButton("BasicInfo/PrevBtn");
        this.prevBtn.setPreferredSize(new Dimension(100, 24));
        this.prevBtn.setToolTipText(RJcGuide.text("BasicInfo/PrevBtn"));
        this.prevBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJBaseInfoPGPGTablePanel.this.prevBtn_actionPerformed(actionEvent);
            }
        });
        return this.prevBtn;
    }

    private JComboBox createPageComboBox() {
        RJcBaseComboBox rJcBaseComboBox = new RJcBaseComboBox();
        rJcBaseComboBox.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoPGPGTablePanel.this.pageComboItemSelected(itemEvent);
            }
        });
        rJcBaseComboBox.setPreferredSize(new Dimension(100, 24));
        rJcBaseComboBox.setMinimumSize(new Dimension(100, 24));
        return rJcBaseComboBox;
    }
}

