/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sanproject.client.exdevice.com.Guidance;
import sanproject.client.exdevice.com.PresetViewTableDataModel;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.utility.Debug;

public class Operation {
    public static final Operation UNKNOWN_OPERATION;
    public static final Operation NO_OPERATION;
    private static Set operationsSet;
    private static Map modelMap;
    private Class operationTarget;
    private int operationType;
    private String operationName;
    private Class detailClass;

    protected Operation(Class clazz, int n, String string) {
        this(clazz, n, string, null);
    }

    protected Operation(Class clazz, int n, String string, Class clazz2) {
        String string2 = string;
        if (string == null || string.trim().equals("")) {
            string2 = "Unknown";
        }
        this.operationTarget = clazz;
        this.operationType = n;
        this.operationName = string2;
        this.detailClass = clazz2;
        Operation.regist(this);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Operation) {
            Operation operation = (Operation)object;
            bl = this.equals(operation.operationTarget, operation.operationType);
        }
        return bl;
    }

    public int hashCode() {
        int n = this.operationTarget == null ? 0 : this.operationTarget.hashCode();
        int n2 = n + this.operationType;
        return n2;
    }

    public String toString() {
        String string = "operation:[" + this.operationName + "]" + "";
        return string;
    }

    public boolean equals(Class clazz, int n) {
        boolean bl = false;
        if (this.operationTarget == clazz && this.operationType == n) {
            bl = true;
        }
        return bl;
    }

    public String getName() {
        String string = this.operationName;
        return string;
    }

    public PresetViewTableDataModel getDetailModel() throws EXDException {
        PresetViewTableDataModel presetViewTableDataModel = Operation.getTableDataModel(this);
        return presetViewTableDataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Operation[] values() {
        Operation[] operationArray;
        Set set = operationsSet;
        synchronized (set) {
            operationArray = new Operation[]{};
            operationArray = operationsSet.toArray(operationArray);
        }
        return operationArray;
    }

    public static Operation getOperation(Class clazz, int n) {
        Operation operation = UNKNOWN_OPERATION;
        Operation[] operationArray = Operation.values();
        for (int i = 0; i < operationArray.length; ++i) {
            Operation operation2 = operationArray[i];
            boolean bl = operation2.equals(clazz, n);
            if (!bl) continue;
            operation = operation2;
            break;
        }
        return operation;
    }

    public static Operation getCurrentOperation(PresetManager presetManager) {
        Operation operation = UNKNOWN_OPERATION;
        if (presetManager != null) {
            Class clazz = presetManager.getEntryClass();
            int n = presetManager.getEntryOperation();
            operation = Operation.getOperation(clazz, n);
        }
        return operation;
    }

    public static boolean isPossibleTo(PresetManager presetManager, Class clazz, int n) {
        Operation operation = Operation.getOperation(clazz, n);
        boolean bl = Operation.isPossibleTo(presetManager, operation);
        return bl;
    }

    public static boolean isPossibleTo(PresetManager presetManager, Operation operation) {
        Operation operation2 = Operation.getCurrentOperation(presetManager);
        boolean bl = true;
        if (!operation2.equals(NO_OPERATION) && !operation2.equals(operation)) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = operationsSet;
        synchronized (object) {
            operationsSet.clear();
        }
        object = modelMap;
        synchronized (object) {
            modelMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void regist(Operation operation) {
        Set set = operationsSet;
        synchronized (set) {
            operationsSet.add(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PresetViewTableDataModel getTableDataModel(Operation operation) throws EXDException {
        PresetViewTableDataModel presetViewTableDataModel = null;
        if (operation.detailClass != null) {
            Map map = modelMap;
            synchronized (map) {
                if (modelMap.containsKey(operation)) {
                    presetViewTableDataModel = (PresetViewTableDataModel)modelMap.get(operation);
                } else {
                    presetViewTableDataModel = Operation.createNewTableDataModel(operation.detailClass);
                    modelMap.put(operation, presetViewTableDataModel);
                }
            }
        }
        return presetViewTableDataModel;
    }

    private static synchronized PresetViewTableDataModel createNewTableDataModel(Class clazz) throws EXDException {
        PresetViewTableDataModel presetViewTableDataModel = null;
        try {
            Object t = clazz.newInstance();
            if (!(t instanceof PresetViewTableDataModel)) {
                Debug.println("is not 'PresetViewTableDataModel'.");
                Debug.println("  -> " + t);
                throw new EXDException(610, 7060);
            }
            presetViewTableDataModel = (PresetViewTableDataModel)t;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new EXDException(610, 7060);
        }
        return presetViewTableDataModel;
    }

    static {
        operationsSet = new HashSet();
        modelMap = new HashMap();
        int n = -1;
        UNKNOWN_OPERATION = new Operation(null, n - 1, Guidance.TEXT_UNKNOWNOPERATION.getText());
        NO_OPERATION = new Operation(null, n, Guidance.TEXT_NOOPERATION.getText());
    }
}

