/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import sanproject.client.data.RJDataPPKey;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.AddVolumeData;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.EmulationTypeManager;
import sanproject.client.exdevice.data.ExternalVolumeInfo;
import sanproject.client.exdevice.data.ExternalVolumeManager;
import sanproject.client.exdevice.data.LdevManager;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.ModifyTaker;
import sanproject.client.exdevice.data.PathDirector;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PathGroupManager;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PolicyInfo;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.SsidInfo;
import sanproject.client.exdevice.data.SsidManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.serverux.dataimpl.EXDDiscoveryDevice;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDLogicalPath;
import sanproject.serverux.dataimpl.EXDVpg;
import sanproject.serverux.dataimpl.EXDgetDiscoveryDevice_IN;
import sanproject.serverux.dataimpl.EXDgetDiscoveryDevice_OUT;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class AddVolumeDirector {
    private static final String LOG_NAME = "AddVolumeDirector";
    public static int ERP_CLIENT = AbstractDataControl.ERP_CLIENT;
    public static final int MSG_UNKNOWN_ERR = 7060;
    public static final int MSG_INVALID_EMULATION = 69008;
    public static final int MSG_INVALID_CLPR = 69027;
    public static final int MSG_VOLUME_EMPTY = 69009;
    public static final int MSG_UNSATISFY_PATHS = 69010;
    public static final int MSG_UNALLOCATE_VPG = 69011;
    public static final int MSG_UNALLOCATE_LDEV = 69012;
    public static final int MSG_UNALLOCATE_SSID = 69013;
    private PolicyInfo mPolicy;
    private PathDirector mPathDirector = null;
    private ArrayList mAddVolumeDatas = new ArrayList();
    private EmulationTypeManager mEmulationTypeManager = EmulationTypeManager.getInstance();
    private boolean mflgCmdOnly = false;
    private boolean mflgExcludeVma = false;

    public AddVolumeDirector(PolicyInfo policyInfo) throws EXDException {
        this.mPolicy = policyInfo;
        if (policyInfo == null) {
            Utility.putLog(LOG_NAME, "Message : Policy is null");
            throw new EXDException(ERP_CLIENT, 7060);
        }
        EmulationTypeInfo emulationTypeInfo = policyInfo.getEmulationTypeInfo();
        Collection collection = this.mEmulationTypeManager.getSelectionList(true);
        if (!collection.contains(emulationTypeInfo)) {
            Utility.putLog(LOG_NAME, "Message : Invalid Emulation : " + emulationTypeInfo);
            throw new EXDException(ERP_CLIENT, 69008);
        }
        int n = policyInfo.getClpr();
        LprManager lprManager = LprManager.getInstance();
        Collection collection2 = lprManager.getClprList(emulationTypeInfo);
        if (!collection2.contains(new Integer(n))) {
            Utility.putLog(LOG_NAME, "Message : Invalid CLPR : " + n);
            throw new EXDException(ERP_CLIENT, 69027);
        }
        VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
        this.mflgCmdOnly = !volumeOperationDataControl.isPPInstalled();
        this.mflgExcludeVma = !volumeOperationDataControl.isPPInstalled(RJDataPPKey.FUNC_NAME_OPENLDEVGuard);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CMD Only : ");
        stringBuffer.append(this.mflgCmdOnly);
        stringBuffer.append("\tExclude VMA : ");
        stringBuffer.append(this.mflgExcludeVma);
        Utility.putLog(LOG_NAME, stringBuffer.toString());
    }

    public PathDirector getPathDirector() throws EXDException {
        if (this.mPathDirector != null) {
            return this.mPathDirector;
        }
        VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
        this.mPathDirector = new PathDirector(volumeOperationDataControl);
        if (this.mPolicy.isEnableAutoDiscovery()) {
            this.mPathDirector.doDiscoveryAllPort();
        }
        return this.mPathDirector;
    }

    static EXDgetDiscoveryDevice_OUT discoveryVolume(PhysicalPathInfo[] physicalPathInfoArray) throws EXDException {
        Object object;
        int n;
        ModifyTaker modifyTaker;
        VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
        EXDgetDiscoveryDevice_IN eXDgetDiscoveryDevice_IN = new EXDgetDiscoveryDevice_IN();
        for (int i = 0; i < physicalPathInfoArray.length; ++i) {
            modifyTaker = physicalPathInfoArray[i];
            n = ((PhysicalPathInfo)modifyTaker).referPortId();
            object = ((PhysicalPathInfo)modifyTaker).getDisplayTargetAdr();
            eXDgetDiscoveryDevice_IN.setPhysicalPath((short)n, (String)object);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Discovery Volume Request:");
            stringBuffer.append(n);
            stringBuffer.append("@");
            stringBuffer.append((String)object);
            Utility.putLog(LOG_NAME, stringBuffer.toString());
        }
        EXDgetDiscoveryDevice_OUT eXDgetDiscoveryDevice_OUT = (EXDgetDiscoveryDevice_OUT)volumeOperationDataControl.comGet((SanRmiInputInterface)eXDgetDiscoveryDevice_IN);
        modifyTaker = physicalPathInfoArray[0].getProductInfo();
        for (n = 0; n < physicalPathInfoArray.length; ++n) {
            object = physicalPathInfoArray[n];
            int n2 = ((PhysicalPathInfo)object).referPortId();
            String string = ((PhysicalPathInfo)object).getDisplayTargetAdr();
            EXDDiscoveryDevice[] eXDDiscoveryDeviceArray = eXDgetDiscoveryDevice_OUT.getDiscoveryDevice((short)n2, string);
            int n3 = eXDDiscoveryDeviceArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Discovery Volume Result:");
            stringBuffer.append(n2);
            stringBuffer.append("@");
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(n3);
            stringBuffer.append("Volumes");
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            for (int i = 0; i < n3; ++i) {
                EXDDiscoveryDevice eXDDiscoveryDevice = eXDDiscoveryDeviceArray[i];
                EXDExternalDevice eXDExternalDevice = eXDDiscoveryDevice.getExternalDevice();
                eXDExternalDevice.setSubsystemId(((ProductInfo)modifyTaker).getId());
                EXDLogicalPath eXDLogicalPath = eXDDiscoveryDevice.getLogicalPath();
                eXDLogicalPath.setPhysicalpathID(((PhysicalPathInfo)object).getId());
            }
        }
        return eXDgetDiscoveryDevice_OUT;
    }

    public void doDiscoveryVolume(PathGroupInfo pathGroupInfo) throws EXDException {
        int n;
        Object[] objectArray;
        Object object;
        int n2;
        Object object2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        PhysicalPathInfo[] physicalPathInfoArray = new PhysicalPathInfo[]{};
        physicalPathInfoArray = pathGroupInfo.getPhysicalPathInfo().toArray(physicalPathInfoArray);
        EXDgetDiscoveryDevice_OUT eXDgetDiscoveryDevice_OUT = AddVolumeDirector.discoveryVolume(physicalPathInfoArray);
        ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
        Set set = externalVolumeManager.getChar2OfUnconfiguardVolumes();
        ProductInfo productInfo = physicalPathInfoArray[0].getProductInfo();
        for (int i = 0; i < physicalPathInfoArray.length; ++i) {
            object2 = physicalPathInfoArray[i];
            n2 = ((PhysicalPathInfo)object2).referPortId();
            object = ((PhysicalPathInfo)object2).getDisplayTargetAdr();
            objectArray = eXDgetDiscoveryDevice_OUT.getDiscoveryDevice((short)n2, (String)object);
            for (n = 0; n < objectArray.length; ++n) {
                Object object3;
                Object object4;
                ExternalVolumeInfo externalVolumeInfo;
                EXDDiscoveryDevice eXDDiscoveryDevice = objectArray[n];
                EXDExternalDevice eXDExternalDevice = eXDDiscoveryDevice.getExternalDevice();
                if (!eXDExternalDevice.isSupport()) {
                    ++n3;
                    continue;
                }
                if (this.mflgCmdOnly && !eXDExternalDevice.isCommandDevice()) {
                    ++n4;
                    continue;
                }
                if (eXDExternalDevice.isConfigured()) {
                    ++n6;
                    continue;
                }
                String string = eXDExternalDevice.getIdentity2();
                if (set.contains(string)) {
                    ++n6;
                    continue;
                }
                AddVolumeData addVolumeData = this.getSameVolume(eXDExternalDevice);
                if (addVolumeData == null) {
                    externalVolumeInfo = new EXDExternalVolume(eXDExternalDevice);
                    externalVolumeInfo.setPathGroupID(pathGroupInfo.getId());
                    object4 = new ExternalVolumeInfo((EXDExternalVolume)externalVolumeInfo);
                    object3 = ((ExternalVolumeInfo)object4).getVpgInfo();
                    EXDVpg eXDVpg = ((VpgInfo)object3).getEXDVpg();
                    eXDVpg.setPathGroupId(pathGroupInfo.getId());
                    addVolumeData = new AddVolumeData(productInfo, pathGroupInfo, (ExternalVolumeInfo)object4);
                    Collection collection = this.mEmulationTypeManager.getAdaptiveList(addVolumeData, true);
                    if (collection.isEmpty()) {
                        addVolumeData.removePreset();
                        continue;
                    }
                    this.mAddVolumeDatas.add(addVolumeData);
                }
                externalVolumeInfo = addVolumeData.getExternalVolumeInfo();
                object4 = externalVolumeInfo.getEXDExternalVolume();
                object3 = object4.getLogicalPathList();
                object3[i] = eXDDiscoveryDevice.getLogicalPath();
                object3[i].setPriority((byte)i);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Discovery Volume Result2:");
        stringBuffer.append("Create=");
        stringBuffer.append(this.mAddVolumeDatas.size());
        stringBuffer.append(" /Unsupport=");
        stringBuffer.append(n3);
        stringBuffer.append(" /CMD=");
        stringBuffer.append(n4);
        stringBuffer.append(" /VMA=");
        stringBuffer.append(n5);
        stringBuffer.append(" /Configuard=");
        stringBuffer.append(n6);
        Utility.putLog(LOG_NAME, stringBuffer.toString());
        if (this.mAddVolumeDatas.isEmpty()) {
            object2 = PathGroupManager.getInstance();
            ((PathGroupManager)object2).removePathGroup(pathGroupInfo);
            Utility.putLog(LOG_NAME, "Message : There is no External Volume that can be added.");
            throw new EXDException(ERP_CLIENT, 69009);
        }
        int n7 = physicalPathInfoArray.length;
        for (n2 = 0; n2 < this.mAddVolumeDatas.size(); ++n2) {
            object = (AddVolumeData)this.mAddVolumeDatas.get(n2);
            objectArray = ((AddVolumeData)object).getExternalVolumeInfo().getLogicalPathInfo();
            n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                ++n;
            }
            if (n7 == n) continue;
            Utility.putLog(LOG_NAME, "Message : Unsatisfied physical paths.");
            ((PresetData)object).setErrCode(ERP_CLIENT, 69010);
        }
    }

    public AddVolumeData[] getExtDev() {
        AddVolumeData[] addVolumeDataArray = new AddVolumeData[]{};
        return this.mAddVolumeDatas.toArray(addVolumeDataArray);
    }

    AddVolumeData getSameVolume(EXDExternalDevice eXDExternalDevice) {
        AddVolumeData addVolumeData = null;
        for (int i = 0; i < this.mAddVolumeDatas.size(); ++i) {
            AddVolumeData addVolumeData2 = (AddVolumeData)this.mAddVolumeDatas.get(i);
            if (!addVolumeData2.equals(eXDExternalDevice)) continue;
            addVolumeData = addVolumeData2;
            break;
        }
        return addVolumeData;
    }

    public void removeExtDev(AddVolumeData addVolumeData) {
        addVolumeData.removePreset();
        this.mAddVolumeDatas.remove(addVolumeData);
    }

    public boolean commit() {
        if (!this.chkCompVpgSetting()) {
            this.autoSetting();
        }
        boolean bl = true;
        PresetManager presetManager = PresetManager.getInstance();
        for (int i = 0; i < this.mAddVolumeDatas.size(); ++i) {
            AddVolumeData addVolumeData = (AddVolumeData)this.mAddVolumeDatas.get(i);
            presetManager.add(addVolumeData, 1);
            if (addVolumeData.getErrInfo().getErrorCode() == 0) continue;
            bl = false;
        }
        return bl;
    }

    void autoSetting() {
        int n;
        SsidInfo ssidInfo;
        int n2;
        RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray;
        Object object;
        int n3;
        AddVolumeData addVolumeData;
        EmulationTypeManager emulationTypeManager = EmulationTypeManager.getInstance();
        EmulationTypeInfo emulationTypeInfo = this.mPolicy.getEmulationTypeInfo();
        boolean bl = this.mPolicy.isEnableCacheMode();
        boolean bl2 = this.mPolicy.isEnableInflowControl();
        int n4 = this.mPolicy.getClpr();
        int n5 = this.mPolicy.getLdevMaxDivide();
        int n6 = VpgManager.EXG_MIN;
        for (int i = 0; i < this.mAddVolumeDatas.size(); ++i) {
            addVolumeData = (AddVolumeData)this.mAddVolumeDatas.get(i);
            if (addVolumeData.getErrInfo().getErrorCode() != 0) continue;
            n3 = addVolumeData.setExg(n6) ? 1 : 0;
            if (n3 == 0) {
                Utility.putLog(LOG_NAME, "Message : ExG-VPG was not allocated.");
                addVolumeData.setErrCode(ERP_CLIENT, 69011);
                continue;
            }
            n6 = addVolumeData.getPgInfo().getIFB4();
            Collection collection = emulationTypeManager.getAdaptiveList(addVolumeData, true);
            if (!collection.contains(emulationTypeInfo)) {
                Utility.putLog(LOG_NAME, "Message : Invalid Emulation : " + emulationTypeInfo);
                addVolumeData.setErrCode(ERP_CLIENT, 69008);
                continue;
            }
            addVolumeData.setEmulationType(emulationTypeInfo);
            addVolumeData.setCacheMode(bl);
            addVolumeData.setInflowControl(bl2);
            addVolumeData.setClpr(n4);
            addVolumeData.setMaxLdevCount(n5);
        }
        LdevManager ldevManager = LdevManager.getInstance();
        addVolumeData = this.mPolicy.getMappingStartLdev();
        n3 = this.mPolicy.getLdevMappingInterval();
        short s = (short)this.mPolicy.getSlpr();
        boolean bl3 = this.mPolicy.isEnableSlprLimited();
        for (int i = 0; i < this.mAddVolumeDatas.size(); ++i) {
            object = (AddVolumeData)this.mAddVolumeDatas.get(i);
            if (((PresetData)object).getErrInfo().getErrorCode() != 0) continue;
            rJiLDEVInfoDetailArray = ((AddVolumeData)object).getLdevInfo();
            boolean bl4 = ldevManager.setLdevId(rJiLDEVInfoDetailArray, emulationTypeInfo, (Robj_interface_RJiLDEVIndex)addVolumeData, n3, s, bl3);
            if (!bl4) {
                Utility.putLog(LOG_NAME, "Message : LDEV was not allocated.");
                ((PresetData)object).setErrCode(ERP_CLIENT, 69012);
            }
            ((AddVolumeData)object).setLdevs();
        }
        this.compLdevMapping();
        SsidManager ssidManager = SsidManager.getInstance();
        object = ssidManager.getUsableSsid(s, bl3);
        rJiLDEVInfoDetailArray = object.iterator();
        ArrayList<SsidInfo> arrayList = new ArrayList<SsidInfo>();
        SsidInfo[] ssidInfoArray = ssidManager.getSsidInfoList(s, bl3);
        for (n2 = 0; n2 < ssidInfoArray.length; ++n2) {
            ssidInfo = ssidInfoArray[n2];
            if (!ssidInfo.canSetSsid() || SsidInfo.chkSsid(n = ssidInfo.getSsid())) continue;
            if (rJiLDEVInfoDetailArray.hasNext()) {
                n = (Integer)rJiLDEVInfoDetailArray.next();
                ssidInfo.setSsid(n);
                continue;
            }
            arrayList.add(ssidInfo);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ssidInfo = (SsidInfo)arrayList.get(n2);
            Utility.putLog(LOG_NAME, "Message : SSID was not allocated. : " + ssidInfo.toString());
            block4: for (n = 0; n < this.mAddVolumeDatas.size(); ++n) {
                AddVolumeData addVolumeData2 = (AddVolumeData)this.mAddVolumeDatas.get(n);
                if (addVolumeData2.getErrInfo().getErrorCode() != 0) continue;
                RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray2 = addVolumeData2.getLdevInfo();
                for (int i = 0; i < rJiLDEVInfoDetailArray2.length; ++i) {
                    if (ssidInfo.compareTo((Robj_interface_RJiLDEVIndex)rJiLDEVInfoDetailArray2[i]) != 0) continue;
                    addVolumeData2.setErrCode(ERP_CLIENT, 69013);
                    continue block4;
                }
            }
        }
    }

    public void cancel() {
        for (int i = 0; i < this.mAddVolumeDatas.size(); ++i) {
            AddVolumeData addVolumeData = (AddVolumeData)this.mAddVolumeDatas.get(i);
            addVolumeData.removePreset();
        }
    }

    public PolicyInfo getPolicyInfo() {
        return this.mPolicy;
    }

    public boolean canVpgSetting(AddVolumeData[] addVolumeDataArray) {
        return true;
    }

    public boolean canLdevMapping(AddVolumeData[] addVolumeDataArray) {
        for (int i = 0; i < addVolumeDataArray.length; ++i) {
            AddVolumeData addVolumeData = addVolumeDataArray[i];
            EmulationTypeInfo emulationTypeInfo = addVolumeData.getEmulationType();
            if (emulationTypeInfo != null) continue;
            return false;
        }
        return true;
    }

    public boolean chkCompVpgSetting() {
        Iterator iterator = this.mAddVolumeDatas.iterator();
        while (iterator.hasNext()) {
            AddVolumeData addVolumeData = (AddVolumeData)iterator.next();
            EXDVpg eXDVpg = addVolumeData.getPgInfo();
            if (!VpgManager.chkExg(eXDVpg.getIFB4())) {
                return false;
            }
            if (VpgManager.chkPgid(eXDVpg.getIPG())) continue;
            return false;
        }
        return true;
    }

    public boolean chkCompLdevMapping() {
        Iterator iterator = this.mAddVolumeDatas.iterator();
        while (iterator.hasNext()) {
            AddVolumeData addVolumeData = (AddVolumeData)iterator.next();
            RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray = addVolumeData.getLdevInfo();
            for (int i = 0; i < rJiLDEVInfoDetailArray.length; ++i) {
                RJiLDEVInfoDetail rJiLDEVInfoDetail = rJiLDEVInfoDetailArray[i];
                if (rJiLDEVInfoDetail.getSLDKC() != -1) continue;
                return false;
            }
        }
        return true;
    }

    public void compLdevMapping() {
        SsidManager ssidManager = SsidManager.getInstance();
        for (int i = 0; i < this.mAddVolumeDatas.size(); ++i) {
            AddVolumeData addVolumeData = (AddVolumeData)this.mAddVolumeDatas.get(i);
            RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray = addVolumeData.getLdevInfo();
            ssidManager.setLdev((Robj_interface_RJiLDEVInfoDetail[])rJiLDEVInfoDetailArray);
            addVolumeData.setSsidRegistry();
        }
    }
}

