/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.dctl;

import java.util.Iterator;
import sanproject.client.ldevguard.dctl.ManageGuardStatus;
import sanproject.client.ldevguard.dctl.ManageLdevInfo;
import sanproject.client.ldevguard.dctl.ManageVtocArea;
import sanproject.client.ldevguard.dctl.RJDGDDataControl;
import sanproject.client.ldevguard.dctl.VrmLdevInterface;
import sanproject.client.openldevguard.dctl.com.ManageReadWriteDataInterface;

public class RJDGDLdev
implements VrmLdevInterface {
    private final int ldkcNumber;
    private final int cuNumber;
    private final int ldevNumber;
    private final RJDGDDataControl dataControl;
    private final ManageGuardStatus guardStatusManager;
    private final ManageVtocArea vtocAreaManager;
    private final ManageLdevInfo ldevInfoManager;

    public RJDGDLdev(RJDGDDataControl rJDGDDataControl, int n, int n2, int n3) {
        this.dataControl = rJDGDDataControl;
        this.ldkcNumber = n;
        this.cuNumber = n2;
        this.ldevNumber = n3;
        this.guardStatusManager = this.dataControl.getGuardStatusManager();
        this.vtocAreaManager = this.dataControl.getVtocAreaManager();
        this.ldevInfoManager = this.dataControl.getLdevInfoManager();
    }

    public boolean canChgAttribute() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canChgAttribute() && this.guardStatusManager.canChgGuardStatus(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canChgVtoc() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canChgVtoc() && this.vtocAreaManager.canChgVtocArea(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.ldevInfoManager.getLdevString(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getLdkc() {
        return this.ldkcNumber;
    }

    public int getCu() {
        return this.cuNumber;
    }

    public int getLdev() {
        return this.ldevNumber;
    }

    public byte getGuard() {
        return this.guardStatusManager.getGuardStatus(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public byte getOriginalGuard() {
        return this.guardStatusManager.getOriginalGuardStatus(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setGuard(byte by) {
        this.guardStatusManager.setGuardStatus(this.ldkcNumber, this.cuNumber, this.ldevNumber, by);
    }

    public int getStartCC() {
        return this.vtocAreaManager.getStartCC(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getStartHH() {
        return this.vtocAreaManager.getStartHH(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getEndCC() {
        return this.vtocAreaManager.getEndCC(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getEndHH() {
        return this.vtocAreaManager.getEndHH(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getTrackSize() {
        return this.vtocAreaManager.getTrackSize(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setVtocArea(int n, int n2) {
        this.vtocAreaManager.setEnd(this.ldkcNumber, this.cuNumber, this.ldevNumber, n, n2);
    }

    public long getCapacity() {
        return this.ldevInfoManager.getCapacity(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public String getEmulation() {
        return this.ldevInfoManager.getEmulationType(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isExternal() {
        return this.ldevInfoManager.isExternal(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isModify() {
        boolean bl = false;
        Iterator iterator = this.dataControl.getDataManagerRW(4).iterator();
        while (iterator.hasNext()) {
            ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            if (!manageReadWriteDataInterface.isModify(this.ldkcNumber, this.cuNumber, this.ldevNumber)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

