/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.gui.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import sanproject.client.ldevguard.gui.main.CUWrapper;
import sanproject.client.ldevguard.gui.main.LDEVGuardDataControlWrapper;
import sanproject.client.ldevguard.gui.main.LDEVGuardProperties;
import sanproject.client.ldevguard.gui.main.LDEVTableDataItem;
import sanproject.client.ldevguard.gui.main.LDEVWrapper;
import sanproject.client.ldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.com.TableSortedEvent;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.main.AbstractPagingTableModel;
import sanproject.client.openldevguard.gui.main.TableDataItem;
import sanproject.client.openldevguard.utility.ObjectUtilities;

class LDEVTableModel
extends AbstractPagingTableModel {
    private static final int MAXCOUNT_INPAGE = 8192;
    public static final String VIEWTYPE_EMPTY = "";
    public static final String VIEWTYPE_LDEV = "ldev";
    public static final int LDEVTYPE_LDEV = 0;
    public static final int LDEVTYPE_ATTRIBUTE = 1;
    public static final int LDEVTYPE_TYPE = 2;
    public static final int LDEVTYPE_CAPACITY = 3;
    public static final int LDEVTYPE_VTOCAREA = 4;
    public static final int LDEVTYPE_MAX_LENGTH = 5;
    private LDEVGuardDataControlWrapper mdcwWrapper;
    private List mlstRowDataList;
    private String mstrViewType;
    private int[] marrLDEVSorterType;
    private String[] marrLDEVColumnNames;
    private String[] marrLDEVColumnIDs;
    private volatile int miProtectCount;
    private volatile int miReadOnlyCount;
    private volatile int miReadWriteCount;

    LDEVTableModel(LDEVGuardDataControlWrapper lDEVGuardDataControlWrapper) {
        this.loadProperties();
        this.mdcwWrapper = lDEVGuardDataControlWrapper;
        this.mlstRowDataList = new ArrayList();
        this.mstrViewType = VIEWTYPE_EMPTY;
        this.marrLDEVSorterType = new int[5];
        this.marrLDEVColumnIDs = new String[5];
        this.marrLDEVColumnNames = new String[5];
        this.marrLDEVSorterType[0] = 2;
        this.marrLDEVColumnIDs[0] = VIEWTYPE_LDEV;
        this.marrLDEVColumnNames[0] = lDEVGuardDataControlWrapper.getGuidanceString("COMMON/LDEV");
        this.marrLDEVSorterType[1] = 1;
        this.marrLDEVColumnIDs[1] = "attribute";
        this.marrLDEVColumnNames[1] = lDEVGuardDataControlWrapper.getGuidanceString("COMMON/Attribute");
        this.marrLDEVSorterType[2] = 2;
        this.marrLDEVColumnIDs[2] = "type";
        this.marrLDEVColumnNames[2] = lDEVGuardDataControlWrapper.getGuidanceString("COMMON/Emulation");
        this.marrLDEVSorterType[3] = 2;
        this.marrLDEVColumnIDs[3] = "capacity";
        this.marrLDEVColumnNames[3] = lDEVGuardDataControlWrapper.getGuidanceString("COMMON/Capacity_Caption");
        this.marrLDEVSorterType[2] = 2;
        this.marrLDEVColumnIDs[4] = "vtoc";
        this.marrLDEVColumnNames[4] = lDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_VTOCAREA");
        this.miProtectCount = 0;
        this.miReadOnlyCount = 0;
        this.miReadWriteCount = 0;
    }

    public final int getMaxRowCountInPage() {
        int n = 8192;
        return n;
    }

    protected final List getAllRowDataList() {
        return this.mlstRowDataList;
    }

    protected final TableDataItem createCellObject(Object object, int n) {
        TableDataItem tableDataItem;
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            LDEVWrapper lDEVWrapper = (LDEVWrapper)object;
            tableDataItem = this.createLDEVTypeCellObject(lDEVWrapper, n);
        } else {
            tableDataItem = null;
        }
        return tableDataItem;
    }

    protected final TableDataItem[] getRowCellItems(Object object) {
        TableDataItem[] tableDataItemArray;
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            tableDataItemArray = new TableDataItem[5];
            for (int i = 0; i < 5; ++i) {
                tableDataItemArray[i] = this.createCellObject(object, i);
            }
        } else {
            tableDataItemArray = new TableDataItem[]{};
        }
        return tableDataItemArray;
    }

    protected final int getSorterType(int n) {
        int n2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? this.marrLDEVSorterType[n] : 2;
        return n2;
    }

    public final int getSortingIndex() {
        String string = ObjectUtilities.getClassName(this);
        String string2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? string + ".ldevtype_sortingindex" : null;
        int n = -1;
        if (string2 != null) {
            String string3 = LDEVGuardProperties.getProperty(string2);
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(n);
                LDEVGuardProperties.setProperty(string2, string4);
            }
        }
        return n;
    }

    public final int getSortKind(int n) {
        int n2 = this.getSortingIndex();
        int n3 = -1;
        if (n2 == n) {
            String string = ObjectUtilities.getClassName(this);
            String string2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? string + ".ldevtype_sortkind" : null;
            if (string2 != null) {
                String string3 = LDEVGuardProperties.getProperty(string2);
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = String.valueOf(n3);
                    LDEVGuardProperties.setProperty(string2, string4);
                }
            }
        }
        return n3;
    }

    protected final String[] getColumnNames() {
        String[] stringArray = this.mstrViewType.equals(VIEWTYPE_LDEV) ? this.marrLDEVColumnNames : new String[]{};
        return stringArray;
    }

    protected final String[] getColumnIDs() {
        String[] stringArray = this.mstrViewType.equals(VIEWTYPE_LDEV) ? this.marrLDEVColumnIDs : new String[]{};
        return stringArray;
    }

    private void loadProperties() {
        String string;
        String string2 = ObjectUtilities.getClassName(this);
        String string3 = string2 + ".ldevtype_sortingindex";
        int n = -1;
        if (ViewDefine.isSupportLoadViewProperties() && (string = LDEVGuardProperties.getProperty(string3)) != null && !string.equals(VIEWTYPE_EMPTY)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        string = String.valueOf(n);
        LDEVGuardProperties.setProperty(string3, string);
        string3 = string2 + ".ldevtype_sortkind";
        n = 0;
        if (ViewDefine.isSupportLoadViewProperties() && (string = LDEVGuardProperties.getProperty(string3)) != null && !string.equals(VIEWTYPE_EMPTY)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        string = String.valueOf(n);
        LDEVGuardProperties.setProperty(string3, string);
    }

    private TableDataItem createLDEVTypeCellObject(LDEVWrapper lDEVWrapper, int n) {
        TableDataItem tableDataItem;
        switch (n) {
            case 0: {
                tableDataItem = LDEVTableDataItem.createLDEVNumberCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 1: {
                tableDataItem = LDEVTableDataItem.createLDEVAttributeCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 2: {
                tableDataItem = LDEVTableDataItem.createLDEVTypeCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 3: {
                tableDataItem = LDEVTableDataItem.createLDEVCapacityCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 4: {
                tableDataItem = LDEVTableDataItem.createVTOCAreaCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            default: {
                tableDataItem = null;
            }
        }
        return tableDataItem;
    }

    public final void initializeData(CUWrapper cUWrapper) throws OpenLDEVGuardException {
        Object object;
        if (cUWrapper != null) {
            object = this.mdcwWrapper.getAllLDEVs(cUWrapper);
            this.mlstRowDataList = Arrays.asList(object);
            this.mstrViewType = VIEWTYPE_LDEV;
        } else {
            this.mlstRowDataList = new ArrayList();
            this.mstrViewType = VIEWTYPE_EMPTY;
        }
        this.countAttributes();
        this.updateCellData();
        object = new TableModelEvent(this, -1);
        this.fireTableChanged((TableModelEvent)object);
        int n = this.getSortingIndex();
        int n2 = this.getSortKind(n);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n, n2);
        this.fireTableSorted(tableSortedEvent);
    }

    public final void requestSort(int n) {
        int n2 = this.getSortKind(n);
        n2 = this.getNextSortKind(n, n2);
        this.updateSortingFlags(n, n2);
        this.updateSortCellData(n, n2);
        n2 = this.getRowCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2);
        this.fireTableChanged(tableModelEvent);
        n2 = this.getSortingIndex();
        int n3 = this.getSortKind(n2);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n2, n3);
        this.fireTableSorted(tableSortedEvent);
    }

    public final LDEVWrapper[] requestChangeAttribute(int[] nArray, byte by) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canChangeAttribute()) {
                    lDEVWrapper.changeAttribute(by);
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        this.countAttributes();
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestChangeVTOCArea(int[] nArray, int n, int n2) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n3 = this.getRowCount();
            int n4 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n5);
                if (lDEVWrapper.canChangeVTOCArea()) {
                    lDEVWrapper.changeVTOCArea(n, n2);
                    arrayList.add(lDEVWrapper);
                }
                if (n3 > n5) {
                    n3 = n5;
                }
                if (n4 >= n5) continue;
                n4 = n5;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n3, n4, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        return lDEVWrapperArray;
    }

    private void updateSortingFlags(int n, int n2) {
        if (!this.mstrViewType.equals(VIEWTYPE_EMPTY)) {
            String string = ObjectUtilities.getClassName(this);
            String string2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? string + ".ldevtype_" : VIEWTYPE_EMPTY;
            String string3 = String.valueOf(n);
            String string4 = String.valueOf(n2);
            LDEVGuardProperties.setProperty(string2 + "sortingindex", string3);
            LDEVGuardProperties.setProperty(string2 + "sortkind", string4);
        }
    }

    void countAttributes() {
        this.miProtectCount = 0;
        this.miReadOnlyCount = 0;
        this.miReadWriteCount = 0;
        Iterator iterator = this.mlstRowDataList.iterator();
        while (iterator.hasNext()) {
            int n;
            if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
                LDEVWrapper lDEVWrapper = (LDEVWrapper)iterator.next();
                n = lDEVWrapper.getAttribute();
            } else {
                n = 0;
            }
            if (n == -127) {
                ++this.miProtectCount;
                continue;
            }
            if (n == -126) {
                ++this.miReadOnlyCount;
                continue;
            }
            if (n != -128) continue;
            ++this.miReadWriteCount;
        }
    }

    public final void changePreviousPage() {
        int n = this.getShowPage();
        this.updateChangePageAt(n - 1);
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2, n3, -1);
        this.fireTableChanged(tableModelEvent);
    }

    public final void changeNextPage() {
        int n = this.getShowPage();
        this.updateChangePageAt(n + 1);
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2, n3, -1);
        this.fireTableChanged(tableModelEvent);
    }

    public final String getViewType() {
        return this.mstrViewType;
    }

    public final int getAttributeCount(byte by) {
        int n = by == -127 ? this.miProtectCount : (by == -126 ? this.miReadOnlyCount : (by == -128 ? this.miReadWriteCount : 0));
        return n;
    }

    public final Object getRowDataRowAt(int n) {
        TableDataItem tableDataItem = (TableDataItem)this.getValueAt(n, 0);
        Object object = tableDataItem.getReferencedObject();
        return object;
    }
}

