/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import sanproject.client.com.RJComStdKeySelection;
import sanproject.client.com.RJcConst;
import sanproject.client.monitor.com.RJHihDateFormat;

public class RJHihTimeComboModel {
    private static final long HOUR1 = 3600000L;
    private static final long DAY1 = 86400000L;
    private static final long TIME = -32400000L;
    private static int MIN = 1;
    private static int MINUTE1 = 60000;
    private static int MINUTE = 0;
    private GregorianCalendar calendar = new GregorianCalendar(RJcConst.tz);
    private RJHihDateFormat yyyyMMddHHmmformat = new RJHihDateFormat("yyyy/MM/dd HH:mm");
    private RJHihDateFormat yyyyMMddformat = new RJHihDateFormat("yyyy/MM/dd");
    private RJHihDateFormat HHformat = new RJHihDateFormat("HH");
    private RJHihDateFormat mmformat = new RJHihDateFormat("mm");
    public static final int FROM = 0;
    public static final int TO = 1;
    private int type = 0;
    private Date cTime = null;
    private Date sTime = null;
    private Date eTime;
    private DayComboModel dModel = null;
    private DayComboBox dComboBox = null;
    private Date sDay;
    private HourComboModel hModel = null;
    private HourComboBox hComboBox = null;
    private Date sHour;
    private MinuteComboModel mModel = null;
    private MinuteComboBox mComboBox = null;
    private Date sMinute;
    public static final int TYPE_FULL = 0;
    public static final int TYPE_SHORT = 1;
    public static final int TYPE_OTHER = 2;
    public static final int TYPE_SHORTX = 4;
    private RJHihTimeComboModel partner = null;

    public RJHihTimeComboModel() {
        this(0, null);
    }

    public RJHihTimeComboModel(RJHihTimeComboModel rJHihTimeComboModel) {
        this(0, rJHihTimeComboModel);
    }

    public RJHihTimeComboModel(int n) {
        this(n, null);
    }

    public RJHihTimeComboModel(int n, RJHihTimeComboModel rJHihTimeComboModel) {
        this.type = n;
        this.setPartner(rJHihTimeComboModel);
    }

    public void init(Date date, Date date2, int n) {
        this.sTime = this.filter((Date)date.clone());
        this.eTime = this.filter((Date)date2.clone());
        MIN = n;
        MINUTE = MINUTE1 * n;
        this.setTime(date);
    }

    private Date filter(Date date) {
        if (this.type == 1) {
            date.setTime(date.getTime() % 86400000L);
        }
        return date;
    }

    public void setPartner(RJHihTimeComboModel rJHihTimeComboModel) {
        this.partner = rJHihTimeComboModel;
    }

    public JComboBox getDayComboBox() {
        this.dModel = new DayComboModel(this);
        this.dComboBox = new DayComboBox(this.dModel);
        return this.dComboBox;
    }

    public JComboBox getHourComboBox() {
        this.hModel = new HourComboModel(this);
        this.hComboBox = new HourComboBox(this.hModel);
        this.hComboBox.setKeySelectionManager(new RJComStdKeySelection());
        return this.hComboBox;
    }

    public JComboBox getMinuteComboBox() {
        this.mModel = new MinuteComboModel(this);
        this.mComboBox = new MinuteComboBox(this.mModel);
        return this.mComboBox;
    }

    public int getSizeDay() {
        this.sDay = new Date(0L);
        int n = 90;
        int n2 = 0;
        int n3 = 0;
        int n4 = 365;
        if (this.sTime != null && this.eTime != null && this.cTime != null) {
            this.calendar.setTime(this.cTime);
            this.calendar.setTime(this.sTime);
            n2 = this.calendar.get(6);
            if (this.calendar.isLeapYear(1)) {
                ++n4;
            }
            this.calendar.setTime(this.eTime);
            n3 = this.calendar.get(6);
            n = n3 - n2 + 1;
            if (this.type == 2 && this.sTime.getTime() - this.eTime.getTime() >= 0L) {
                n = 2;
            }
            this.sDay.setTime(this.sTime.getTime());
            if (n < 0) {
                n = n4 - n2 + n3 + 1;
            }
        }
        return n;
    }

    public Object getElementAtDay(int n) {
        this.calendar.setTime(this.sDay);
        this.calendar.add(5, n);
        return this.yyyyMMddformat.format(this.calendar.getTime());
    }

    public int getSizeHour() {
        this.sHour = new Date(-32400000L);
        int n = 24;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.sTime != null && this.eTime != null && this.cTime != null) {
            this.calendar.setTime(this.eTime);
            n4 = this.calendar.get(6);
            this.calendar.setTime(this.cTime);
            n3 = this.calendar.get(6);
            this.calendar.setTime(this.sTime);
            n2 = this.calendar.get(6);
            if (n3 == n2) {
                this.sHour.setTime(this.sTime.getTime());
                n -= this.calendar.get(11);
            }
            if (n3 == n4) {
                this.calendar.setTime(this.eTime);
                if (n2 != n4) {
                    n = this.calendar.get(11) + 1;
                }
                if (n2 == n4) {
                    n -= 24 - this.calendar.get(11) - 1;
                }
            }
            if (this.type == 2) {
                this.sHour.setTime(this.sTime.getTime());
                n = 24;
            }
        }
        return n;
    }

    public Object getElementAtHour(int n) {
        this.calendar.setTime(this.sHour);
        this.calendar.add(11, n);
        return this.HHformat.format(this.calendar.getTime());
    }

    public int getSizeMinute() {
        this.sMinute = new Date(-32400000L);
        int n = 60 / MIN;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.sTime != null && this.eTime != null && this.cTime != null) {
            this.calendar.setTime(this.eTime);
            n4 = this.calendar.get(6);
            this.calendar.setTime(this.cTime);
            n3 = this.calendar.get(6);
            this.calendar.setTime(this.sTime);
            n2 = this.calendar.get(6);
            if (this.cTime.getTime() / 3600000L == this.sTime.getTime() / 3600000L) {
                this.sMinute.setTime(this.sTime.getTime());
                if (n3 == n2) {
                    n -= this.calendar.get(12) / MIN;
                }
            }
            if (this.cTime.getTime() / 3600000L == this.eTime.getTime() / 3600000L) {
                this.calendar.setTime(this.eTime);
                if (n3 == n4) {
                    n -= 60 / MIN - this.calendar.get(12) / MIN - 1;
                }
            }
        }
        return n;
    }

    public Object getElementAtMinute(int n) {
        this.calendar.setTime(this.sMinute);
        this.calendar.add(12, n * MIN);
        return this.mmformat.format(this.calendar.getTime());
    }

    public void selectedItemChanged() {
        String string = "1970/01/01";
        String string2 = "00";
        String string3 = "00";
        if (this.dModel != null && this.dModel.getSelectedItem() != null) {
            string = (String)this.dModel.getSelectedItem();
        }
        if (this.hModel != null && this.hModel.getSelectedItem() != null) {
            string2 = (String)this.hModel.getSelectedItem();
        }
        if (this.mModel != null && this.mModel.getSelectedItem() != null) {
            string3 = (String)this.mModel.getSelectedItem();
        }
        try {
            this.setTime(this.yyyyMMddHHmmformat.parse(string + " " + string2 + ":" + string3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.partner != null) {
            this.partner.setSTime(new Date(this.cTime.getTime() + (long)MINUTE));
        }
    }

    public Date getTime() {
        return this.cTime;
    }

    public void setTime(Date date) {
        int n;
        this.cTime = this.filter((Date)date.clone());
        this.calendar.setTime(this.cTime);
        int n2 = 0;
        Object object = this.hComboBox.getSelectedItem();
        if (object != null) {
            n2 = Integer.parseInt(object.toString());
        }
        if ((n = n2 - this.hComboBox.getSelectedIndex()) < 0 && this.type == 2) {
            this.dComboBox.setSelectedIndex(1);
        } else if (n >= 0 && this.type == 2) {
            this.dComboBox.setSelectedIndex(0);
        }
        if (this.cTime.compareTo(this.sTime) < 0) {
            this.cTime.setTime(this.sTime.getTime());
        }
        if (this.cTime.compareTo(this.eTime) > 0) {
            this.cTime.setTime(this.eTime.getTime());
        }
        if (this.hModel != null) {
            if (this.type != 1 && this.type != 4) {
                this.dModel.setSelectedItemX(this.yyyyMMddformat.format(this.cTime));
            }
            this.hModel.setSelectedItemX(this.HHformat.format(this.cTime));
            this.mModel.setSelectedItemX(this.mmformat.format(this.cTime));
        }
    }

    public Date getSTime() {
        return this.sTime;
    }

    public void setSTime(Date date) {
        this.sTime = this.filter((Date)date.clone());
        if (this.sTime.compareTo(this.cTime) > 0) {
            this.setTime(this.sTime);
        }
    }

    public Date getETime() {
        return this.eTime;
    }

    public void setETime(Date date) {
        this.eTime = this.filter((Date)date.clone());
        if (this.eTime.compareTo(this.cTime) < 0) {
            this.setTime(this.eTime);
        }
    }

    class MinuteComboModel
    extends DefaultComboBoxModel {
        private RJHihTimeComboModel parent = null;
        private boolean skipFlag = false;
        private int preSize = 0;

        MinuteComboModel(RJHihTimeComboModel rJHihTimeComboModel2) {
            this.parent = rJHihTimeComboModel2;
        }

        public int getSize() {
            int n = this.parent.getSizeMinute();
            if (this.preSize != n) {
                this.preSize = n;
                Object object = this.getSelectedItem();
                if (!this.skipFlag) {
                    this.setSelectedItemX(null);
                    this.setSelectedItemX(object);
                }
            }
            return n;
        }

        public Object getElementAt(int n) {
            return this.parent.getElementAtMinute(n);
        }

        public void selectedItemChanged() {
            if (!this.skipFlag) {
                this.parent.selectedItemChanged();
            }
        }

        public void setSelectedItemX(Object object) {
            this.skipFlag = true;
            super.setSelectedItem(object);
            this.skipFlag = false;
        }
    }

    class MinuteComboBox
    extends JComboBox {
        MinuteComboBox(ComboBoxModel comboBoxModel) {
            super(comboBoxModel);
        }

        public void selectedItemChanged() {
            super.selectedItemChanged();
            ((MinuteComboModel)this.getModel()).selectedItemChanged();
        }
    }

    class HourComboModel
    extends DefaultComboBoxModel {
        private RJHihTimeComboModel parent = null;
        private boolean skipFlag = false;
        private int preSize = 0;

        HourComboModel(RJHihTimeComboModel rJHihTimeComboModel2) {
            this.parent = rJHihTimeComboModel2;
        }

        public int getSize() {
            int n = this.parent.getSizeHour();
            if (this.preSize != n) {
                this.preSize = n;
                Object object = this.getSelectedItem();
                if (!this.skipFlag) {
                    this.setSelectedItemX(null);
                    this.setSelectedItemX(object);
                }
            }
            return n;
        }

        public Object getElementAt(int n) {
            return this.parent.getElementAtHour(n);
        }

        public void selectedItemChanged() {
            if (!this.skipFlag) {
                this.parent.selectedItemChanged();
            }
        }

        public void setSelectedItemX(Object object) {
            this.skipFlag = true;
            super.setSelectedItem(object);
            this.skipFlag = false;
        }
    }

    class HourComboBox
    extends JComboBox {
        HourComboBox(ComboBoxModel comboBoxModel) {
            super(comboBoxModel);
        }

        public void selectedItemChanged() {
            super.selectedItemChanged();
            ((HourComboModel)this.getModel()).selectedItemChanged();
        }
    }

    class DayComboModel
    extends DefaultComboBoxModel {
        private RJHihTimeComboModel parent = null;
        private boolean skipFlag = false;
        private int preSize = 0;

        DayComboModel(RJHihTimeComboModel rJHihTimeComboModel2) {
            this.parent = rJHihTimeComboModel2;
        }

        public int getSize() {
            int n = this.parent.getSizeDay();
            if (this.preSize != n) {
                this.preSize = n;
                Object object = this.getSelectedItem();
                if (!this.skipFlag) {
                    this.setSelectedItemX(null);
                    this.setSelectedItemX(object);
                }
            }
            return n;
        }

        public Object getElementAt(int n) {
            return this.parent.getElementAtDay(n);
        }

        public void selectedItemChanged() {
            if (!this.skipFlag) {
                this.parent.selectedItemChanged();
            }
        }

        public void setSelectedItemX(Object object) {
            this.skipFlag = true;
            super.setSelectedItem(object);
            this.skipFlag = false;
        }
    }

    class DayComboBox
    extends JComboBox {
        DayComboBox(ComboBoxModel comboBoxModel) {
            super(comboBoxModel);
        }

        public void selectedItemChanged() {
            super.selectedItemChanged();
            ((DayComboModel)this.getModel()).selectedItemChanged();
        }
    }
}

