/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.com;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;

public class StandardRadioButton
extends JRadioButton
implements KeyEventTransferable {
    private static final int MINIMUM_WIDTH = 70;
    private static final int DEFAULT_HEIGHT = 20;
    private transient Set msetEventRecievers = new HashSet();

    public StandardRadioButton() {
        this("", null, false);
    }

    public StandardRadioButton(Icon icon) {
        this("", icon, false);
    }

    public StandardRadioButton(Icon icon, boolean bl) {
        this("", icon, bl);
    }

    public StandardRadioButton(String string) {
        this(string, null, false);
    }

    public StandardRadioButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public StandardRadioButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public StandardRadioButton(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                StandardRadioButton.this.notifyReceivers(keyEvent);
            }
        };
        this.addKeyListener(keyAdapter);
    }

    public final synchronized void addKeyEventReceiver(KeyEventReceiver keyEventReceiver) {
        this.msetEventRecievers.add(keyEventReceiver);
    }

    public final synchronized void removeKeyEventReceiver(KeyEventReceiver keyEventReceiver) {
        this.msetEventRecievers.remove(keyEventReceiver);
    }

    public final synchronized void removeKeyEventReceivers() {
        this.msetEventRecievers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyReceivers(KeyEvent keyEvent) {
        Set set;
        Object object = this;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetEventRecievers);
        }
        object = set.iterator();
        while (object.hasNext() && !keyEvent.isConsumed()) {
            KeyEventReceiver keyEventReceiver = (KeyEventReceiver)object.next();
            keyEventReceiver.keyEventReceived(this, keyEvent);
        }
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!this.isPreferredSizeSet()) {
            if (dimension.width < 70) {
                dimension.width = 70;
            }
            dimension.height = 20;
        }
        Dimension dimension2 = dimension;
        return dimension2;
    }
}

