/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.openldevguard.dctl.RJODGDDataControl;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.com.DataLdkc;
import sanproject.client.openldevguard.dctl.com.ManageReadData;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.common.Robj_interface_RJSetGettingParamVol;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.serverux.dataimpl.RJSetGettingParamVol;

public class ManageLdkcCu
extends ManageReadData {
    private static final DataLdkc NULL_DATA_LDKC = new DataLdkc(-1);
    private final DataLdkc originalCompareData;
    private final RJODGDDataControl druDataControl;

    public ManageLdkcCu(RJODGDDataControl rJODGDDataControl) {
        super(2, "LDKC-CU", rJODGDDataControl, COMP_LDKC, NULL_DATA_LDKC);
        this.druDataControl = rJODGDDataControl;
        this.originalCompareData = new DataLdkc(-1);
    }

    private Robj_interface_RJiLDKCIndex[] initDataLdkc() throws Exception {
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        Logger.put(Level.FINE, this.logName, "        The initialization of LDKC data begins. ");
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        try {
            l = System.currentTimeMillis();
            objectArray = rJDataLDEVPart.getLDKCIndex();
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.INFO, this.logName, "RJDataException : getLDKCIndex()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer("        The initialization of LDKC data ends. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms> ");
        stringBuffer.append("<Num = ").append(objectArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        return objectArray;
    }

    private Robj_interface_RJiCUIndex[] initDataCu(Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray) throws Exception {
        RJSetGettingParamVol rJSetGettingParamVol = this.makeParamData();
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        StringBuffer stringBuffer = new StringBuffer("        The initialization of CU data begins. ");
        stringBuffer.append("<Num = ").append(robj_interface_RJiLDKCIndexArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        try {
            l = System.currentTimeMillis();
            objectArray = robj_interface_RJiLDKCIndexArray.length > 0 ? rJDataLDEVPart.getCUIndex(robj_interface_RJiLDKCIndexArray, (Robj_interface_RJSetGettingParamVol)rJSetGettingParamVol) : new Robj_interface_RJiCUIndex[]{};
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.WARNING, this.logName, "RJDataException : getCUIndex()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        Arrays.sort(objectArray);
        StringBuffer stringBuffer2 = new StringBuffer("        The initialization of CU data ends. ");
        stringBuffer2.append("<Time = ").append(l2 - l).append(" ms> ");
        stringBuffer2.append("<Num = ").append(objectArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        return objectArray;
    }

    private RJSetGettingParamVol makeParamData() {
        RJSetGettingParamVol rJSetGettingParamVol = new RJSetGettingParamVol();
        rJSetGettingParamVol.setBOpenVolume(true);
        return rJSetGettingParamVol;
    }

    protected Object[] getData() throws Exception {
        Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray = this.initDataLdkc();
        Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = this.initDataCu(robj_interface_RJiLDKCIndexArray);
        ArrayList<DataLdkc> arrayList = new ArrayList<DataLdkc>();
        for (int i = 0; i < robj_interface_RJiLDKCIndexArray.length; ++i) {
            DataLdkc dataLdkc = new DataLdkc(robj_interface_RJiLDKCIndexArray[i].getSLDKC());
            dataLdkc.addCuIndex(robj_interface_RJiCUIndexArray);
            if (dataLdkc.getCuGroupList().size() == 0) continue;
            arrayList.add(dataLdkc);
        }
        return arrayList.toArray();
    }

    protected boolean isSupport() {
        return true;
    }

    protected Exception makeException(int n, int n2) {
        return new RJODGDException(n, n2);
    }

    protected Object makeOriginalCompareData(int n, int n2, int n3) {
        this.originalCompareData.setSLDKC((short)n);
        return this.originalCompareData;
    }

    protected Object makeOriginalData(Object object) {
        return object;
    }

    public ArrayList getLdkcList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = this.getOriginalDataAll().iterator();
        while (iterator.hasNext()) {
            DataLdkc dataLdkc = (DataLdkc)iterator.next();
            arrayList.add(new Integer(dataLdkc.getSLDKC()));
        }
        return arrayList;
    }

    public ArrayList getCuGroupList(int n) {
        DataLdkc dataLdkc = (DataLdkc)this.getOriginalDataObject(n);
        return dataLdkc.getCuGroupList();
    }

    public ArrayList getCuList(int n, int n2) {
        DataLdkc dataLdkc = (DataLdkc)this.getOriginalDataObject(n);
        return dataLdkc.getCuList(n2);
    }

    public int[] getCuBitmap(int n, int n2) {
        DataLdkc dataLdkc = (DataLdkc)this.getOriginalDataObject(n);
        return dataLdkc.getCuBitmap(n2);
    }
}

