/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import sanproject.client.pool.RJPoolApplyItem;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.serverux.dataimpl.QSAddPoolData;
import sanproject.serverux.dataimpl.QSRecoveryPoolData;
import sanproject.serverux.dataimpl.QSUpdatePoolData;
import sanproject.serverux.dataimpl.SetAOUSIMComplete;
import sanproject.serverux.dataimpl.SetQSAddPool;
import sanproject.serverux.dataimpl.SetQSRecoveryPool;
import sanproject.serverux.dataimpl.SetQSSIMComplete;
import sanproject.serverux.dataimpl.SetQSUpdatePool;
import sanproject.serverux.dataimpl.SetQSVFSInitialize;

public class RJPoolApplyData {
    public static final int ID_ADD = 2;
    private static final int CMD_ADD = 1;
    public static final int ID_CHANGE = 4;
    private static final int CMD_CHANGE = 3;
    public static final int ID_RESTORE = 8;
    private static final int CMD_RESTORE = -1;
    public static final int ID_DELETE = 16;
    private static final int CMD_DELETE = 2;
    public static final int ID_ADDVOL = 1;
    private static final int CMD_ADDVOL = 1;
    public static final int ID_DELVOL = 32;
    private HashMap itemMap = new HashMap();
    private boolean simComplete = false;
    private RJPoolDataSupplier supplier;

    public RJPoolApplyData(RJPoolDataSupplier rJPoolDataSupplier) {
        this.supplier = rJPoolDataSupplier;
    }

    public void addPoolInfo(RJPoolApplyItem rJPoolApplyItem) {
        rJPoolApplyItem.setFunc(2);
        rJPoolApplyItem.setAllowFunc(3);
        this.registItem(rJPoolApplyItem);
        this.supplier.putLog("[Pool]", "[addPoolInfo]", rJPoolApplyItem.toString());
    }

    public void changePoolInfo(RJPoolApplyItem rJPoolApplyItem) {
        rJPoolApplyItem.setFunc(4);
        rJPoolApplyItem.setAllowFunc(4);
        this.registItem(rJPoolApplyItem);
        this.supplier.putLog("[Pool]", "[changePoolInfo]", rJPoolApplyItem.toString());
    }

    public void restorePoolInfo(RJPoolApplyItem rJPoolApplyItem) {
        rJPoolApplyItem.setFunc(8);
        rJPoolApplyItem.setAllowFunc(8);
        this.registItem(rJPoolApplyItem);
        this.supplier.putLog("[Pool]", "[restorePoolInfo]", rJPoolApplyItem.toString());
    }

    public void deletePoolInfo(RJPoolApplyItem rJPoolApplyItem) {
        rJPoolApplyItem.setFunc(16);
        rJPoolApplyItem.setAllowFunc(16);
        this.registItem(rJPoolApplyItem);
        this.supplier.putLog("[Pool]", "[deletePoolInfo]", rJPoolApplyItem.toString());
    }

    public void addPoolVol(RJPoolApplyItem rJPoolApplyItem) {
        rJPoolApplyItem.setFunc(1);
        rJPoolApplyItem.setAllowFunc(3);
        this.registItem(rJPoolApplyItem);
        this.supplier.putLog("[Pool]", "[addPoolVol]", rJPoolApplyItem.toString());
    }

    public void deletePoolVol(RJPoolApplyItem rJPoolApplyItem) {
        rJPoolApplyItem.setFunc(32);
        this.registItem(rJPoolApplyItem);
        this.supplier.putLog("[Pool]", "[deletePoolVol]", rJPoolApplyItem.toString());
    }

    public boolean isOK(int n) {
        boolean bl = false;
        int n2 = 65535;
        Set set = this.itemMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            RJPoolApplyItem rJPoolApplyItem = (RJPoolApplyItem)this.itemMap.get(n3);
            n2 &= rJPoolApplyItem.getAllowFunc();
        }
        if ((n2 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    private void registItem(RJPoolApplyItem rJPoolApplyItem) {
        Integer n = new Integer(rJPoolApplyItem.getPoolId());
        RJPoolApplyItem rJPoolApplyItem2 = (RJPoolApplyItem)this.itemMap.get(n);
        if (rJPoolApplyItem2 != null) {
            if (!rJPoolApplyItem2.merge(rJPoolApplyItem)) {
                this.itemMap.remove(n);
            }
        } else if (!rJPoolApplyItem.isInvalidity()) {
            this.itemMap.put(n, rJPoolApplyItem);
        }
    }

    public void setSimComplete(boolean bl) {
        this.simComplete = bl;
    }

    public int setNextApplyData() {
        int n = 0;
        if (this.isApplyData()) {
            n = this.setApplyData();
        } else if (this.isSimComplete()) {
            n = this.setSimCompleteData();
        }
        return n;
    }

    public void clearNextApplyData() {
        if (this.isApplyData()) {
            this.itemMap.clear();
        } else if (this.isSimComplete()) {
            this.setSimComplete(false);
        }
    }

    public void clearAllApplyData() {
        this.itemMap.clear();
        this.setSimComplete(false);
    }

    public int setApplyData() {
        QSRecoveryPoolData qSRecoveryPoolData;
        QSUpdatePoolData qSUpdatePoolData;
        QSUpdatePoolData qSUpdatePoolData2;
        QSAddPoolData qSAddPoolData;
        RJPoolApplyItem rJPoolApplyItem;
        int n = 0;
        ArrayList<QSAddPoolData> arrayList = new ArrayList<QSAddPoolData>();
        ArrayList<QSUpdatePoolData> arrayList2 = new ArrayList<QSUpdatePoolData>();
        ArrayList<QSRecoveryPoolData> arrayList3 = new ArrayList<QSRecoveryPoolData>();
        ArrayList<QSUpdatePoolData> arrayList4 = new ArrayList<QSUpdatePoolData>();
        ArrayList arrayList5 = new ArrayList();
        Set set = this.itemMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QSAddPoolData qSAddPoolData2;
            Integer n2 = (Integer)iterator.next();
            rJPoolApplyItem = (RJPoolApplyItem)this.itemMap.get(n2);
            if (rJPoolApplyItem == null) continue;
            qSAddPoolData = rJPoolApplyItem.createAddParam();
            if (qSAddPoolData != null) {
                if (qSAddPoolData.objPoolVolData == null) {
                    n = -1;
                    break;
                }
                arrayList.add(qSAddPoolData);
            }
            if ((qSUpdatePoolData2 = rJPoolApplyItem.createChangeParam()) != null) {
                arrayList2.add(qSUpdatePoolData2);
            }
            if ((qSUpdatePoolData = rJPoolApplyItem.createDeleteParam()) != null) {
                arrayList4.add(qSUpdatePoolData);
            }
            if ((qSRecoveryPoolData = rJPoolApplyItem.createRestoreParam()) != null) {
                arrayList3.add(qSRecoveryPoolData);
            }
            if ((qSAddPoolData2 = rJPoolApplyItem.createAddVolParam()) == null) continue;
            arrayList.add(qSAddPoolData2);
        }
        if (n == 0) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = arrayList.size();
            if (n7 > 0) {
                rJPoolApplyItem = new SetQSAddPool();
                ((SetQSAddPool)rJPoolApplyItem).lComannd = 1L;
                ((SetQSAddPool)rJPoolApplyItem).objPoolData = arrayList.toArray(new QSAddPoolData[0]);
                this.supplier.setObject(rJPoolApplyItem);
            }
            if ((n6 = arrayList2.size()) > 0) {
                qSAddPoolData = new SetQSUpdatePool();
                qSAddPoolData.lComannd = 3L;
                qSAddPoolData.objPoolData = arrayList2.toArray(new QSUpdatePoolData[0]);
                this.supplier.setObject(qSAddPoolData);
            }
            if ((n5 = arrayList4.size()) > 0) {
                qSUpdatePoolData2 = new SetQSUpdatePool();
                qSUpdatePoolData2.lComannd = 2L;
                qSUpdatePoolData2.objPoolData = arrayList4.toArray(new QSUpdatePoolData[0]);
                this.supplier.setObject(qSUpdatePoolData2);
            }
            if ((n4 = arrayList3.size()) > 0) {
                qSUpdatePoolData = new SetQSRecoveryPool();
                qSUpdatePoolData.objPoolData = arrayList3.toArray(new QSRecoveryPoolData[0]);
                this.supplier.setObject(qSUpdatePoolData);
            }
            if ((n3 = arrayList5.size()) > 0) {
                qSRecoveryPoolData = new SetQSAddPool();
                qSRecoveryPoolData.lComannd = 1L;
                qSRecoveryPoolData.objPoolData = arrayList5.toArray(new QSAddPoolData[0]);
                this.supplier.setObject(qSRecoveryPoolData);
            }
        }
        return n;
    }

    public void setInitializeData() {
        SetQSVFSInitialize setQSVFSInitialize = new SetQSVFSInitialize();
        this.supplier.setObject(setQSVFSInitialize);
    }

    public int setSimCompleteData() {
        SetQSSIMComplete setQSSIMComplete = new SetQSSIMComplete();
        this.supplier.setObject(setQSSIMComplete);
        SetAOUSIMComplete setAOUSIMComplete = new SetAOUSIMComplete();
        this.supplier.setObject(setAOUSIMComplete);
        return 0;
    }

    public boolean isApplyData() {
        return !this.itemMap.isEmpty();
    }

    public boolean isSimComplete() {
        return this.simComplete;
    }

    public boolean chkSts() {
        boolean bl = this.isApplyData() || this.isSimComplete();
        return bl;
    }

    public boolean isExist(RJPoolLdevElement rJPoolLdevElement) {
        boolean bl = false;
        int n = 0;
        Set set = this.itemMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            RJPoolApplyItem rJPoolApplyItem = (RJPoolApplyItem)this.itemMap.get(n2);
            n = rJPoolApplyItem.getAllowFunc();
            if (n != 3) continue;
            ArrayList arrayList = rJPoolApplyItem.getPoolVolList();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RJPoolLdevElement rJPoolLdevElement2 = (RJPoolLdevElement)iterator2.next();
                if (!rJPoolLdevElement2.equals(rJPoolLdevElement)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        return bl;
    }
}

