/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.swing;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;

public class LightRendererToComponentRenderer
extends JComponent
implements JCComponentCellRenderer {
    JCLightCellRenderer lightRenderer;
    JCCellInfo cellInfo;
    Object value;
    boolean selected;

    public LightRendererToComponentRenderer(JCLightCellRenderer jCLightCellRenderer) {
        this.lightRenderer = jCLightCellRenderer;
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return new Dimension(17, 17);
        }
        return this.lightRenderer.getPreferredSize(this.getGraphics(), this.cellInfo, this.value);
    }

    public Component getRendererComponent(JCCellInfo jCCellInfo, Object object, boolean bl) {
        this.cellInfo = jCCellInfo;
        this.value = object;
        this.selected = bl;
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.selected) {
            graphics.setColor(this.cellInfo.getSelectedBackground());
        } else {
            graphics.setColor(this.cellInfo.getBackground());
        }
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        super.paintComponent(graphics);
        this.lightRenderer.draw(graphics, this.cellInfo, this.value, this.selected);
        Container container = this.getParent();
        if (container != null && container instanceof CellRendererPane) {
            container.remove(this);
        }
    }
}

