/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartLabelLine;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.TrackChange;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCChartLabel
extends TrackChange
implements Serializable {
    protected JComponent component = new JLabel();
    protected JCChartLabelLine line = null;
    protected String text = null;
    protected JCChartLabelManager parent = null;
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int EAST = 4;
    public static final int WEST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTH = 7;
    public static final int SOUTHWEST = 8;
    public static final int CENTER = 9;
    public static final int AUTO = 10;
    public static final int ATTACH_NONE = 0;
    public static final int ATTACH_COORD = 1;
    public static final int ATTACH_DATACOORD = 2;
    public static final int ATTACH_DATAINDEX = 3;
    private static int index_no = 0;
    protected int anchor = 9;
    protected int attachMethod = 1;
    protected int attachX = 0;
    protected int attachY = 0;
    protected double dataAttachX = 0.0;
    protected double dataAttachY = 0.0;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected JCDataIndex attachDataIndex = null;
    protected ChartDataView dataView = null;
    protected boolean dwellLabel = false;
    protected int dwellDelay = 0;
    protected boolean connected = false;
    private Point attachBeforeAnchor = null;
    protected Point attachPoint = null;

    public JCChartLabel() {
        this.setText(null);
        this.component.setVisible(true);
    }

    public JCChartLabel(String string) {
        this.setText(string);
        this.component.setVisible(true);
    }

    protected void addConnectedLine() {
        this.line = new JCChartLabelLine();
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.component != null && !this.dwellLabel) {
            Component[] componentArray = jCChart.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] == this.component) {
                    jCChart.add((Component)this.line, n + 1);
                    break;
                }
                ++n;
            }
        }
    }

    protected boolean calcConnectingLine(Point point) {
        if (this.attachBeforeAnchor != null) {
            Cloneable cloneable;
            ChartDataView chartDataView = this.getDataView();
            if (chartDataView != null && (this.attachMethod == 2 || this.attachMethod == 3)) {
                Point point2 = this.getParentChart().getChartArea().getLocation();
                Rectangle rectangle = this.getParentChart().getChartArea().getPlotRect();
                cloneable = this.getParentChart().getChartArea().getInsets();
                if (this.attachBeforeAnchor.x < rectangle.x + point2.x || this.attachBeforeAnchor.x > rectangle.x + point2.x + rectangle.width + cloneable.left + cloneable.right || this.attachBeforeAnchor.y < rectangle.y + point2.y || this.attachBeforeAnchor.y > rectangle.y + point2.y + rectangle.height + cloneable.top + cloneable.bottom) {
                    return false;
                }
            }
            if (this.connected && this.attachPoint != null) {
                int n = this.component.getWidth();
                int n2 = this.component.getHeight();
                cloneable = null;
                if (this.attachPoint.y + n2 < this.attachBeforeAnchor.y) {
                    cloneable = new Point(this.attachPoint.x + n / 2, this.attachPoint.y + n2);
                } else if (this.attachPoint.y > this.attachBeforeAnchor.y) {
                    cloneable = new Point(this.attachPoint.x + n / 2, this.attachPoint.y);
                } else if (this.attachPoint.x > this.attachBeforeAnchor.x) {
                    cloneable = new Point(this.attachPoint.x, this.attachPoint.y + n2 / 2);
                } else if (this.attachPoint.x + n < this.attachBeforeAnchor.x) {
                    cloneable = new Point(this.attachPoint.x + n, this.attachPoint.y + n2 / 2);
                }
                if (cloneable != null) {
                    point.x = ((Point)cloneable).x;
                    point.y = ((Point)cloneable).y;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected void calcLineBounds(JCChartLabelLine jCChartLabelLine) {
        if (this.component == null || this.line == null) {
            jCChartLabelLine.setBounds(new Rectangle(0, 0, 0, 0));
            return;
        }
        Point point = new Point(0, 0);
        if (this.calcConnectingLine(point)) {
            Rectangle rectangle = new Rectangle();
            rectangle.x = Math.min(this.attachBeforeAnchor.x, point.x);
            rectangle.y = Math.min(this.attachBeforeAnchor.y, point.y);
            rectangle.width = Math.abs(this.attachBeforeAnchor.x - point.x) + 1;
            rectangle.height = Math.abs(this.attachBeforeAnchor.y - point.y) + 1;
            jCChartLabelLine.setBounds(rectangle);
            jCChartLabelLine.setStartPoint(new Point(this.attachBeforeAnchor.x - rectangle.x, this.attachBeforeAnchor.y - rectangle.y));
            jCChartLabelLine.setEndPoint(new Point(point.x - rectangle.x, point.y - rectangle.y));
            return;
        }
        jCChartLabelLine.setBounds(new Rectangle(0, 0, 0, 0));
    }

    protected void drawConnector(Graphics graphics) {
        if (this.component == null) {
            return;
        }
        Point point = new Point(0, 0);
        if (this.calcConnectingLine(point)) {
            graphics.drawLine(this.attachBeforeAnchor.x, this.attachBeforeAnchor.y, point.x, point.y);
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getAttachMethod() {
        return this.attachMethod;
    }

    protected Point getAttachPoint() {
        return this.attachPoint;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Point getCoord() {
        return new Point(this.attachX, this.attachY);
    }

    public JCDataCoord getDataCoord() {
        return new JCDataCoord(this.dataAttachX, this.dataAttachY);
    }

    public JCDataIndex getDataIndex() {
        return this.attachDataIndex;
    }

    public ChartDataView getDataView() {
        try {
            return this.dataView == null ? this.getParentChart().getDataView(0) : this.dataView;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void getDefaultLabel() {
        if (!(this.component instanceof JLabel)) {
            return;
        }
        if (this.attachDataIndex == null) {
            return;
        }
        ChartDataView chartDataView = this.attachDataIndex.getDataView();
        int n = this.attachDataIndex.getSeriesIndex();
        int n2 = this.attachDataIndex.getPoint();
        if (chartDataView == null || n < 0 || n2 < 0) {
            return;
        }
        JLabel jLabel = (JLabel)this.component;
        if (this.getParentManager() != null) {
            jLabel.setText(this.getParentManager().createAutoLabelText(chartDataView, n, n2));
        }
    }

    public Point getOffset() {
        return new Point(this.offsetX, this.offsetY);
    }

    public JCChart getParentChart() {
        JCChartLabelManager jCChartLabelManager = this.getParentManager();
        if (jCChartLabelManager != null) {
            return jCChartLabelManager.getParentChart();
        }
        return null;
    }

    public JCChartLabelManager getParentManager() {
        return this.parent;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isDwellLabel() {
        return this.dwellLabel;
    }

    /*
     * Unable to fully structure code
     */
    public void recalc() {
        if (this.component == null) {
            return;
        }
        if (this.text == null) {
            this.getDefaultLabel();
        }
        this.setChanged(true, 2, false);
        var1_1 = this.component.getPreferredSize();
        this.component.setSize(var1_1.width, var1_1.height);
        var2_2 = this.getDataView();
        if (var2_2 == null) {
            return;
        }
        var3_3 = null;
        var4_4 = this.component.getWidth() / 2;
        var5_5 = this.component.getHeight() / 2;
        var6_6 = true;
        var7_7 = 0.0;
        var9_8 = 0.0;
        try {
            switch (this.attachMethod) {
                case 1: {
                    var3_3 = new Point(this.attachX, this.attachY);
                    break;
                }
                case 2: {
                    if (var2_2.getChartType() == 11) break;
                    var3_3 = var2_2.dataCoordToCoord(this.dataAttachX, this.dataAttachY);
                    var7_7 = this.dataAttachX;
                    var9_8 = this.dataAttachY;
                    break;
                }
                case 3: {
                    var3_3 = var2_2.dataIndexToCoord(this.attachDataIndex);
                    if (this.attachDataIndex.getSeriesIndex() != -10) {
                        var7_7 = this.attachDataIndex.getSeries().getX(this.attachDataIndex.point);
                        var9_8 = this.attachDataIndex.getSeries().getY(this.attachDataIndex.point);
                        break;
                    }
                    var6_6 = false;
                    break;
                }
                default: {
                    return;
                }
            }
            var11_9 = var2_2.getXAxis();
            var12_10 = var2_2.getYAxis();
            switch (this.attachMethod) {
                case 2: 
                case 3: {
                    if (var6_6 && (var7_7 < var11_9.getMin() || var7_7 > var11_9.getMax() || var9_8 < var12_10.getMin() || var9_8 > var12_10.getMax())) {
                        var3_3 = null;
                    }
                    break;
                }
                default: {
                    ** if (var3_3 != null) goto lbl-1000
                }
            }
        }
        catch (Exception v0) {
            var3_3 = null;
        }
        if (var3_3 == null) lbl-1000:
        // 2 sources

        {
            this.attachBeforeAnchor = null;
            var3_3 = new Point(-9999, -9999);
        } else lbl-1000:
        // 2 sources

        {
            this.attachBeforeAnchor = new Point(var3_3.x, var3_3.y);
            var3_3.x -= var4_4;
            var3_3.y -= var5_5;
            switch (this.anchor) {
                case 1: 
                case 4: 
                case 6: {
                    var3_3.x += var4_4;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    var3_3.x -= var4_4;
                    break;
                }
            }
            switch (this.anchor) {
                case 1: 
                case 2: 
                case 3: {
                    var3_3.y -= var5_5;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    var3_3.y += var5_5;
                    break;
                }
            }
            var3_3.x += this.offsetX;
            var3_3.y += this.offsetY;
            this.setChanged(false, 0);
        }
        this.component.setLocation(var3_3.x, var3_3.y);
        this.attachPoint = new Point(var3_3.x, var3_3.y);
        if (this.line != null && this.isConnected() && !this.dwellLabel) {
            this.calcLineBounds(this.line);
        }
    }

    protected void removeConnectedLine() {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.line != null && !this.dwellLabel) {
            jCChart.remove(this.line);
        }
        this.line = null;
    }

    public void setAnchor(int n) {
        if (n == this.anchor) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.anchor = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Anchor value in JCChartLabel.  Should be one of NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, NORTHWEST, SOUTHWEST, CENTER or AUTO.");
            }
        }
        this.setChanged(true, 2);
    }

    public void setAttachMethod(int n) {
        if (n == this.attachMethod) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.attachMethod = n;
                this.setChanged(true, 2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AttachMethod in JCChartLabel. Should be one of ATTACH_NONE, ATTACH_COORD, ATTACH_DATACOORD, ATTACH_DATAINDEX.");
            }
        }
    }

    public void setChanged(boolean bl, int n) {
        if (bl != this.getChanged() || !this.getChanged(n)) {
            super.setChanged(bl, n);
        }
        if (bl && this.parent != null && this.parent.getParentChart() != null) {
            this.parent.updateParent(n);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        super.setChanged(bl, n, bl2);
    }

    public void setComponent(JComponent jComponent) {
        if (this.component == jComponent) {
            return;
        }
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && !this.dwellLabel && this.component != null) {
            if (this.isConnected() && this.line != null) {
                jCChart.remove(this.line);
            }
            jCChart.remove(this.component);
        }
        this.component = jComponent;
        if (jCChart != null && !this.dwellLabel && this.component != null) {
            if (this.isConnected() && this.line != null) {
                jCChart.add((Component)this.line, 0);
            }
            jCChart.add((Component)this.component, 0);
        }
        this.text = !(this.component instanceof JLabel) ? "" : null;
        this.setChanged(true, 2);
    }

    public void setConnected(boolean bl) {
        if (bl == this.connected) {
            return;
        }
        this.connected = bl;
        if (this.connected) {
            this.addConnectedLine();
        } else if (!this.connected) {
            this.removeConnectedLine();
        }
        this.setChanged(true, 2);
    }

    public void setCoord(Point point) {
        this.attachX = point.x;
        this.attachY = point.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataCoord(JCDataCoord jCDataCoord) {
        this.dataAttachX = jCDataCoord.x;
        this.dataAttachY = jCDataCoord.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataIndex(JCDataIndex jCDataIndex) {
        this.attachDataIndex = jCDataIndex;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        this.setChanged(true, 2);
    }

    public void setDwellLabel(boolean bl) {
        if (bl == this.dwellLabel) {
            return;
        }
        this.dwellLabel = bl;
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            if (bl) {
                if (this.component != null) {
                    jCChart.remove(this.component);
                }
                if (this.isConnected() && this.line != null) {
                    jCChart.remove(this.line);
                }
                this.getParentManager().addToDwellLabels(this);
            } else {
                jCChart.getChartLabelManager().removeFromDwellLabels(this);
                if (this.component != null) {
                    if (this.isConnected() && this.line != null) {
                        jCChart.add((Component)this.line, 0);
                    }
                    jCChart.add((Component)this.component, 0);
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setOffset(Point point) {
        this.offsetX = point.x;
        this.offsetY = point.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setParentManager(JCChartLabelManager jCChartLabelManager) {
        this.parent = jCChartLabelManager;
    }

    public void setText(String string) {
        this.text = string;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        if (this.component == null) {
            this.component = new JLabel(string2);
        } else if (this.component instanceof JLabel) {
            ((JLabel)this.component).setText(string2);
        }
        this.setChanged(true, 2);
    }

    public boolean shouldPopupHere(JCDataIndex jCDataIndex) {
        if (this.attachMethod != 3) {
            return false;
        }
        return jCDataIndex != null && jCDataIndex.equals(this.attachDataIndex) && this.component != null && this.component.isVisible();
    }
}

