/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp;

import java.io.Serializable;

public final class ServiceType
implements Serializable {
    private static final long serialVersionUID = 2821061127250972623L;
    private String type = new String();
    private final boolean isAbstract;
    private final String concreteType;
    private final String principleType;
    private final String abstractType;
    private final String namingAuthority;

    public ServiceType(String serviceType) {
        this.type = serviceType;
        if (!this.type.startsWith("service:")) {
            throw new IllegalArgumentException("Invalid service type: " + serviceType);
        }
        int principleStart = 8;
        int principleEnd = this.type.indexOf(":", 8);
        if (principleEnd != -1) {
            this.isAbstract = true;
            this.principleType = this.type.substring(8, principleEnd);
            this.abstractType = this.type.substring(0, principleEnd);
            this.concreteType = this.type.substring(principleEnd + 1);
        } else {
            this.isAbstract = false;
            this.principleType = this.type.substring(8);
            this.abstractType = "";
            this.concreteType = "";
        }
        int namingStart = this.type.indexOf(".") + 1;
        if (namingStart != 0) {
            int namingEnd = this.type.indexOf(":", namingStart);
            String na = "";
            na = namingEnd == -1 ? this.type.substring(namingStart) : this.type.substring(namingStart, namingEnd);
            if ("IANA".equalsIgnoreCase(na)) {
                this.namingAuthority = "";
                this.type = this.type.substring(0, namingStart - 1) + this.type.substring(namingStart + 4, this.type.length());
            } else {
                this.namingAuthority = na;
            }
        } else {
            this.namingAuthority = "";
        }
    }

    public boolean isServiceURL() {
        return true;
    }

    public boolean isAbstractType() {
        return this.isAbstract;
    }

    public boolean isNADefault() {
        return "".equals(this.namingAuthority);
    }

    public String getConcreteTypeName() {
        return this.concreteType;
    }

    public String getPrincipleTypeName() {
        return this.principleType;
    }

    public String getAbstractTypeName() {
        return this.abstractType;
    }

    public String getNamingAuthority() {
        return this.namingAuthority;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceType)) {
            return false;
        }
        ServiceType t = (ServiceType)obj;
        return this.isAbstract == t.isAbstract && this.concreteType.equals(t.concreteType) && this.principleType.equals(t.principleType) && this.abstractType.equals(t.abstractType) && this.namingAuthority.equals(t.namingAuthority);
    }

    public boolean matches(Object obj) {
        if (!(obj instanceof ServiceType)) {
            return false;
        }
        ServiceType t = (ServiceType)obj;
        return this.isAbstract ? this.equals(t) || t.toString().equals(this.getAbstractTypeName()) : this.equals(t);
    }

    public String toString() {
        return this.type;
    }

    public int hashCode() {
        return this.concreteType.hashCode() ^ this.principleType.hashCode() << 24 ^ this.abstractType.hashCode() << 16 ^ this.namingAuthority.hashCode() << 8;
    }
}

