/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteServer;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.JNIIFcontrol;
import sanproject.server.data.RmiConObjErr;
import sanproject.server.data.RmiConObjOutFile;
import sanproject.server.data.RmiControlObjImpl;

public class SanServer
extends RemoteServer {
    static JNIIFcontrol ctrl = new JNIIFcontrol();
    static int port_normal = 51099;
    static int port_custom = 51100;
    static final String IP_PATH = "C:\\dkc200\\others\\hicmdip.csv";
    static final String NAME_NORMAL = new String("webconsole1");
    static final String NAME_CUSTOM = new String("webconsole2");
    static final int USE_TCP = 0;
    static final String REMARK_NORMAL = new String("HITACHI WebConsole Normal");
    static final String REMARK_CUSTOM = new String("HITACHI WebConsole Custom");

    public static void main(String[] stringArray) {
        RmiControlObjImpl rmiControlObjImpl = null;
        try {
            Registry registry = LocateRegistry.createRegistry(1099);
            int n = JNIIFcontrol.getPort(NAME_NORMAL);
            if (n == 0) {
                JNIIFcontrol.setService(NAME_NORMAL, port_normal, 0, REMARK_NORMAL);
            } else if (n != -1) {
                port_normal = n;
            }
            n = JNIIFcontrol.getPort(NAME_CUSTOM);
            if (n == 0) {
                JNIIFcontrol.setService(NAME_CUSTOM, port_custom, 0, REMARK_CUSTOM);
            } else if (n != -1) {
                port_custom = n;
            }
            rmiControlObjImpl = new RmiControlObjImpl(port_normal);
            String string = InetAddress.getLocalHost().getHostAddress();
            Naming.rebind("rmi://" + string + "/RMIControl", rmiControlObjImpl);
            SanServer.outIPFile(string);
            System.out.println("SanServer: RMI Control Object has been created successfully.");
        }
        catch (GetRmiException getRmiException) {
            System.out.println("SanServer; GetRmiException " + getRmiException.nErrData);
            RmiConObjErr.putFileErrLog(getRmiException.nErrData, "SanServer main() File Error", false);
            getRmiException.printStackTrace(System.out);
        }
        catch (RemoteException remoteException) {
            System.out.println("SanServer: An Error occurred in registoration of RMIRegistry.");
            RmiConObjErr.putFileErrLog(0, "Server main() " + remoteException.getMessage(), false);
            remoteException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            System.out.println("SanServer: an exception occurred: " + exception.getMessage());
            RmiConObjErr.putFileErrLog(0, "Server main()" + exception.getMessage(), false);
            exception.printStackTrace(System.out);
        }
    }

    public static void outIPFile(String string) throws GetRmiException {
        boolean bl = false;
        int n = 4;
        int n2 = 0;
        while (n2 < n) {
            try {
                RmiConObjOutFile rmiConObjOutFile = new RmiConObjOutFile(IP_PATH);
                rmiConObjOutFile.putOneLine(string);
                bl = true;
                break;
            }
            catch (GetRmiException getRmiException) {
                if (n2 < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                } else {
                    throw getRmiException;
                }
                ++n2;
            }
        }
        if (!bl) {
            throw RmiConObjErr.makeException(4001);
        }
    }
}

