/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.abs.RJaTableColumn;
import sanproject.client.com.abs.RJaTablePushCellRenderer;

public class RJaTablePushMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    private RJaTablePushCellRenderer pressedRenderer = null;
    private int pressedRow = -1;
    private int pressedColumn = -1;

    public void mousePressed(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        this.pressedColumn = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        RJaTableColumn rJaTableColumn = (RJaTableColumn)tableColumnModel.getColumn(this.pressedColumn);
        int n2 = rJaTableColumn.getRowSpan();
        this.pressedRow = n / n2 * n2;
        this.pressedRenderer = (RJaTablePushCellRenderer)rJaTableColumn.getCellRenderer();
        this.pressedRenderer.setPressedRow(this.pressedRow);
        jTable.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.pressedRenderer != null) {
            JTable jTable = (JTable)mouseEvent.getSource();
            this.pressedRenderer.setPressedRow(-1);
            this.pressedRenderer = null;
            jTable.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.pressedRenderer != null) {
            JTable jTable = (JTable)mouseEvent.getSource();
            this.pressedRenderer.setPressedRow(-1);
            this.pressedRenderer = null;
            jTable.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
        int n2 = jTable.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0) {
            RJaTableColumn rJaTableColumn = (RJaTableColumn)tableColumnModel.getColumn(n);
            int n3 = rJaTableColumn.getRowSpan();
            n2 = n2 / n3 * n3;
            if (this.pressedRenderer != null && (n != this.pressedColumn || n2 != this.pressedRow)) {
                this.pressedRenderer.setPressedRow(-1);
                this.pressedRenderer = null;
                jTable.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

