/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.dcr;

import sanproject.client.data.RJDataLPRControler;
import sanproject.client.data.RJDataLPRInterface;
import sanproject.serverux.dataimpl.DCRCacheInfoData;

public class RJDCRDataDCRLPRInf
implements RJDataLPRInterface {
    long m_AllCash;
    long m_UsedCash;
    long m_FreeCash;
    long m_longUsedCash;
    long m_longFreeCash;
    long m_RAID1BIND;
    long m_RAID5BIND;
    long m_RAID1PRIO;
    long m_RAID5PRIO;
    int m_DCRCnt;
    int m_CLPRNo = 0;
    int m_SLPRNo = 0;
    RJDataLPRControler m_LPRControler = null;
    int m_UsedCnt = 0;

    public RJDCRDataDCRLPRInf(DCRCacheInfoData dCRCacheInfoData, RJDataLPRControler rJDataLPRControler) {
        this.m_LPRControler = rJDataLPRControler;
        this.m_SLPRNo = rJDataLPRControler.getCLPRtoSLPR(dCRCacheInfoData.nCLPRNo);
        this.m_AllCash = dCRCacheInfoData.lDCRTotalCacheSize;
        long l = this.m_UsedCash = dCRCacheInfoData.lDCRUseCacheSize;
        this.m_longUsedCash = l * 1024L;
        long l2 = this.m_FreeCash = dCRCacheInfoData.lDCRRemainCacheSize;
        this.m_longFreeCash = l2 * 1024L;
        this.m_RAID1BIND = dCRCacheInfoData.lDCRSetSizeRAID1BIND;
        this.m_RAID5BIND = dCRCacheInfoData.lDCRSetSizeRAID5BIND;
        this.m_RAID1PRIO = dCRCacheInfoData.lDCRSetSizeRAID1PRIO;
        this.m_RAID5PRIO = dCRCacheInfoData.lDCRSetSizeRAID5PRIO;
        this.m_CLPRNo = dCRCacheInfoData.nCLPRNo;
        this.m_DCRCnt = dCRCacheInfoData.nDCRCount;
        this.m_UsedCnt = dCRCacheInfoData.nDCRUsed;
    }

    public long getAllCash() {
        return this.m_AllCash;
    }

    public long getUsedCash() {
        return this.m_UsedCash;
    }

    public long getFreeCash() {
        return this.m_FreeCash;
    }

    public long getRAID1BIND() {
        return this.m_RAID1BIND;
    }

    public long getRAID5BIND() {
        return this.m_RAID5BIND;
    }

    public long getRAID1PRIO() {
        return this.m_RAID1PRIO;
    }

    public long getRAID5PRIO() {
        return this.m_RAID5PRIO;
    }

    public void setOpenDCR(long l, int n) {
        this.m_UsedCnt += n;
        this.m_UsedCash += l;
        this.m_FreeCash -= l;
    }

    public void setMFDCR(long l, int n) {
        this.m_UsedCnt += n;
        this.m_UsedCash += l;
        this.m_FreeCash -= l;
    }

    public void DelOpenDCR(long l, int n) {
        this.m_UsedCnt += n;
        this.m_UsedCash -= l;
        this.m_FreeCash += l;
    }

    public void DelMFDCR(long l, int n) {
        this.m_UsedCnt += n;
        this.m_UsedCash -= l;
        this.m_FreeCash += l;
    }

    public int getLPRNo() {
        return this.m_CLPRNo;
    }

    public int getDCRCount() {
        return this.m_DCRCnt;
    }

    public int getSLPR() {
        return this.m_SLPRNo;
    }

    public int getCLPR() {
        return this.m_CLPRNo;
    }

    public String getSLPRName() {
        String string = "-";
        if (this.m_LPRControler != null) {
            return this.m_LPRControler.getSLPRNoToName(this.getSLPR());
        }
        return string;
    }

    public String getCLPRName() {
        String string = "-";
        if (this.m_LPRControler != null) {
            return this.m_LPRControler.getCLPRNoToName(this.getCLPR());
        }
        return string;
    }

    public int getUsedCount() {
        return this.m_UsedCnt;
    }

    public int getAveCount() {
        return this.m_DCRCnt - this.m_UsedCnt;
    }
}

