/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.com.abs.RJaDataModel;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.DefaultTablePanel;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.Guidance;
import sanproject.client.exdevice.com.Operation;
import sanproject.client.exdevice.com.PresetDataElement;
import sanproject.client.exdevice.com.PresetViewTableDataModel;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.icon.IconManager;
import sanproject.client.exdevice.utility.Debug;

public class PresetViewPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "PresetViewer";
    private DefaultTablePanel tablePanel;
    private JLabel operationLabel;
    private JLabel countLabel;
    private Button closeButton;
    private JButton nextButton;
    private JButton backButton;
    private JLabel pageLabel;
    private boolean errorDetailFlg = false;

    public PresetViewPanel() {
        this(false);
    }

    public PresetViewPanel(boolean bl) {
        this.errorDetailFlg = bl;
        this.tablePanel = null;
        this.operationLabel = null;
        this.countLabel = null;
        this.closeButton = null;
        this.putLog(KEY_NAME, "create [PresetViewer].ErrorDetailFlg = " + bl);
        this.initialilzePanel();
        this.buildPanelLayout();
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            object = new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    PresetViewPanel.this.putLog(PresetViewPanel.KEY_NAME, "[PresetViewer] opened.");
                    try {
                        PresetViewPanel.this.executeCreateView();
                    }
                    catch (EXDException eXDException) {
                        PresetViewPanel.this.processEXDException(eXDException);
                    }
                }

                public void windowClosed(WindowEvent windowEvent) {
                    PresetViewPanel.this.destoryPanel();
                    PresetViewPanel.this.putLog(PresetViewPanel.KEY_NAME, "[PresetViewer] closed.");
                    window.removeWindowListener(this);
                }
            };
            window.addWindowListener((WindowListener)object);
        }
        if ((object = this.getWindowRootPane()) != null) {
            ((JRootPane)object).setDefaultButton(this.closeButton);
        }
    }

    public String getWindowName() {
        String string = "ExDevice";
        return string;
    }

    void updateOperation(Operation operation) {
        Debug.println("updateOperation(" + operation + ")");
        Operation operation2 = operation == null ? Operation.UNKNOWN_OPERATION : operation;
        String string = "" + Guidance.TEXT_OPERATION.getText() + " : " + operation2.getName() + "";
        this.operationLabel.setText(string);
    }

    void updateObjectCount() {
        Debug.println("updateObjectCount()");
        Object object = this.tablePanel.getDataModel();
        int n = object != null ? ((RJaDataModel)object).getRowCount() : 0;
        String string = this.errorDetailFlg ? Guidance.TEXT_TOTALNUM.getText() : Guidance.TEXT_NUMBEROFOBJECTS.getText();
        object = "" + string + " : " + n + "";
        this.countLabel.setText((String)object);
    }

    private void initialilzePanel() {
        this.tablePanel = new DefaultTablePanel();
        Object object = this.tablePanel.getScrollPane();
        ((JScrollPane)object).setVerticalScrollBarPolicy(22);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(32);
        this.operationLabel = new JLabel();
        this.operationLabel.setFont(RJComFont.labelFont);
        this.updateOperation(Operation.NO_OPERATION);
        this.countLabel = new JLabel();
        this.countLabel.setFont(RJComFont.labelFont);
        this.updateObjectCount();
        object = Guidance.BUTTON_CLOSE.getItemID();
        Object object2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetViewPanel.this.closeContentDialog();
            }
        };
        this.closeButton = new Button((String)object);
        this.closeButton.setAction((Action)object2);
        object = this.tablePanel.getScrollPane();
        object2 = IconManager.getInstance();
        this.backButton = new JButton();
        ((JScrollPane)object).setCorner("UPPER_RIGHT_CORNER", this.backButton);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetViewPanel.this.onClickPaging(false);
            }
        };
        this.backButton.setAction(abstractAction);
        this.backButton.setIcon(((IconManager)object2).getIcon("ExternalDevice_PageUp.gif"));
        this.nextButton = new JButton();
        ((JScrollPane)object).setCorner("LOWER_RIGHT_CORNER", this.nextButton);
        abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetViewPanel.this.onClickPaging(true);
            }
        };
        this.nextButton.setAction(abstractAction);
        this.nextButton.setIcon(((IconManager)object2).getIcon("ExternalDevice_PageDown.gif"));
        this.pageLabel = new JLabel();
        this.pageLabel.setFont(RJComFont.labelFont);
        this.updatePageCount();
    }

    private void destoryPanel() {
        PresetViewTableDataModel presetViewTableDataModel = (PresetViewTableDataModel)this.tablePanel.getDataModel();
        if (presetViewTableDataModel != null) {
            presetViewTableDataModel.removeAll();
            presetViewTableDataModel.setViewPanel(null);
        }
    }

    private void buildPanelLayout() {
        Object object = this.errorDetailFlg ? Guidance.TITLE_ERRORDETAIL.getItemID() : Guidance.TITLE_PRESETVIEW.getItemID();
        JPanel jPanel = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jPanel).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jPanel;
        Serializable serializable = new Dimension(0, 24);
        Serializable serializable2 = UIManager.getColor("Table.background");
        Object object2 = Guidance.COLOR_LINE.getColor();
        Object object3 = BorderFactory.createLineBorder((Color)object2);
        object2 = BorderFactory.createEmptyBorder(0, 16, 0, 16);
        Border border = BorderFactory.createCompoundBorder((Border)object3, (Border)object2);
        object3 = new GridLayout(1, 0, 4, 4);
        object2 = new JPanel((LayoutManager)object3);
        ((JComponent)object2).setOpaque(true);
        ((JComponent)object2).setBackground((Color)serializable2);
        ((Container)object2).add(this.operationLabel);
        ((Container)object2).add(this.countLabel);
        jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setLayout(new BorderLayout(4, 4));
        jPanel.setBackground((Color)serializable2);
        jPanel.setBorder(border);
        jPanel.setPreferredSize((Dimension)serializable);
        jPanel.add((Component)object2, "Center");
        jPanel.add((Component)this.pageLabel, "East");
        serializable = new RJcCushionPanel((JComponent)this.tablePanel, 1);
        ((Container)serializable).add(jPanel, "South");
        object = serializable;
        serializable2 = new GridLayout(1, 0, 4, 4);
        serializable = new JPanel();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add(this.closeButton);
        serializable2 = new BorderLayout(4, 4);
        border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        jPanel.setOpaque(false);
        jPanel.setBorder(border);
        jPanel.add((Component)serializable, "East");
        serializable = new Dimension(680, 296);
        serializable2 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)((Object)serializable2));
        this.setPreferredSize((Dimension)serializable);
        this.add((Component)rJcDlgMainTitlePanel, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel, "South");
    }

    private void executeCreateView() throws EXDException {
        this.putLog(KEY_NAME, "executeCreateView()");
        PresetManager presetManager = PresetManager.getInstance();
        Operation operation = Operation.getCurrentOperation(presetManager);
        PresetViewTableDataModel presetViewTableDataModel = operation.getDetailModel();
        presetViewTableDataModel.setErrorDetailMenu(this.errorDetailFlg);
        if (presetViewTableDataModel != null) {
            presetViewTableDataModel.setViewPanel(this);
            presetViewTableDataModel.removeAll();
            Collection collection = presetManager.getAllEntry();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PresetData presetData = (PresetData)iterator.next();
                PresetDataElement presetDataElement = presetViewTableDataModel.convertToElement(presetData);
                try {
                    RJcElement rJcElement = (RJcElement)((Object)presetDataElement);
                    presetViewTableDataModel.addRow(rJcElement);
                }
                catch (ClassCastException classCastException) {
                    this.putLog(KEY_NAME, "not 'RJcElement'. [" + presetDataElement + "]");
                }
            }
            this.tablePanel.createTable(presetViewTableDataModel);
            presetViewTableDataModel.absolutePage(0);
            this.updatePagingPanel();
        }
        this.updateOperation(operation);
        this.updateObjectCount();
    }

    public void onClickPaging(boolean bl) {
        RJaTableDataModel rJaTableDataModel = this.tablePanel.getDataModel();
        if (bl) {
            if (rJaTableDataModel.hasNextPage()) {
                rJaTableDataModel.nextPage();
            }
        } else if (rJaTableDataModel.hasPreviousPage()) {
            rJaTableDataModel.previousPage();
        }
        if (this.tablePanel.getTable().getRowCount() != 0) {
            this.tablePanel.getTable().setRowSelectionInterval(0, 0);
        }
        JScrollPane jScrollPane = this.tablePanel.getScrollPane();
        Point point = new Point(0, 0);
        jScrollPane.getViewport().setViewPosition(point);
        this.tablePanel.getTable().requestFocusInWindow();
        this.tablePanel.getTable().clearSelection();
        this.updatePagingPanel();
    }

    public void moveSelectedRow(int n) {
        if (n >= 0) {
            JViewport jViewport;
            Rectangle rectangle;
            Rectangle rectangle2 = this.tablePanel.getTable().getCellRect(n, 0, true);
            Point point = new Point(rectangle2.x, rectangle2.y - rectangle2.height);
            if (point.y < 0) {
                point.y = 0;
            }
            if (!(rectangle = (jViewport = this.tablePanel.getScrollPane().getViewport()).getViewRect()).contains(point)) {
                jViewport.setViewPosition(point);
            }
            this.tablePanel.getTable().clearSelection();
        }
    }

    void updatePagingPanel() {
        RJaTableDataModel rJaTableDataModel = this.tablePanel.getDataModel();
        this.nextButton.setVisible(rJaTableDataModel.hasNextPage());
        this.backButton.setVisible(rJaTableDataModel.hasPreviousPage());
        this.updatePageCount();
    }

    void updatePageCount() {
        Debug.println("updatePageCount()");
        String string = null;
        RJaTableDataModel rJaTableDataModel = this.tablePanel.getDataModel();
        if (rJaTableDataModel != null) {
            int n;
            int n2 = rJaTableDataModel.getPageRowCount();
            if (n2 == 0) {
                n2 = rJaTableDataModel.getRowCount() + 1;
            }
            if ((n = (int)Math.ceil((double)rJaTableDataModel.getRowCount() / (double)n2)) == 0) {
                n = 1;
            }
            int n3 = rJaTableDataModel.getPageTopRow() / n2 + 1;
            string = "" + n3 + " / " + n + "";
        }
        this.pageLabel.setText(string);
    }
}

