/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import sanproject.client.exdevice.data.SsidManager;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiSSIDInfo;
import sanproject.serverux.dataimpl.RJiSSIDInfo;

public class SsidInfo
implements Comparable {
    public static int NO_VALUE = -1;
    public static int SSID_MIN = 4;
    public static int SSID_MAX = 65534;
    protected RJiSSIDInfo mBaseSsidInfo = null;
    protected boolean mflgConfiguard = false;
    protected int mLdevCount = 0;
    int mHashCode = Integer.MAX_VALUE;

    protected SsidInfo() {
    }

    protected SsidInfo(RJiSSIDInfo rJiSSIDInfo) {
        this.mBaseSsidInfo = rJiSSIDInfo;
        this.mflgConfiguard = SsidInfo.chkSsid(this.mBaseSsidInfo.iSSID);
    }

    public int getSsid() {
        return this.mBaseSsidInfo.getISSID();
    }

    public boolean setSsid(int n) {
        SsidManager ssidManager = SsidManager.getInstance();
        boolean bl = ssidManager.reserveSsid(n);
        if (bl) {
            ssidManager.releaseSsid(this.getSsid());
            this.mBaseSsidInfo.iSSID = n;
        }
        return bl;
    }

    public boolean canSetSsid() {
        return !this.mflgConfiguard && this.mLdevCount > 0;
    }

    public Robj_interface_RJiCUIndex getCuIndex() {
        return this.mBaseSsidInfo;
    }

    public int getStartLdev() {
        return this.mBaseSsidInfo.getSStartLDEV();
    }

    public int getEndLdev() {
        return this.mBaseSsidInfo.getSEndLDEV();
    }

    void addLdev(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        ++this.mLdevCount;
    }

    void removeLdev(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        if (this.mLdevCount > 0) {
            --this.mLdevCount;
            if (!this.mflgConfiguard && this.mLdevCount == 0) {
                int n = this.getSsid();
                SsidManager ssidManager = SsidManager.getInstance();
                ssidManager.releaseSsid(n);
                this.mBaseSsidInfo.iSSID = NO_VALUE;
            }
        }
    }

    int getLdevCount() {
        return this.mLdevCount;
    }

    void applyComplete() {
        this.mflgConfiguard = true;
    }

    public static boolean chkSsid(int n) {
        return n >= SSID_MIN && n <= SSID_MAX;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof SsidInfo) {
            n = this.hashCode() - ((SsidInfo)object).hashCode();
        } else if (object instanceof Robj_interface_RJiLDEVIndex) {
            n = this.compareTo((Robj_interface_RJiLDEVIndex)object);
        } else if (object instanceof Robj_interface_RJiSSIDInfo) {
            n = this.compareTo((Robj_interface_RJiSSIDInfo)object);
        }
        return n;
    }

    public int compareTo(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        short s = robj_interface_RJiLDEVIndex.getSLDKC();
        short s2 = robj_interface_RJiLDEVIndex.getSCU();
        int n = robj_interface_RJiLDEVIndex.getSLDEV() & SsidManager.SSID_BOUNDARY_MASK;
        return this.compareTo(s, s2, n);
    }

    public int compareTo(Robj_interface_RJiSSIDInfo robj_interface_RJiSSIDInfo) {
        short s = robj_interface_RJiSSIDInfo.getSLDKC();
        short s2 = robj_interface_RJiSSIDInfo.getSCU();
        short s3 = robj_interface_RJiSSIDInfo.getSStartLDEV();
        return this.compareTo(s, s2, s3);
    }

    public int compareTo(int n, int n2, int n3) {
        int n4 = SsidInfo.chkValue(n, n2, n3);
        return this.hashCode() - n4;
    }

    public int hashCode() {
        if (this.mHashCode == Integer.MAX_VALUE) {
            this.mHashCode = SsidInfo.chkValue(this.mBaseSsidInfo.getSLDKC(), this.mBaseSsidInfo.getSCU(), this.mBaseSsidInfo.getSStartLDEV());
        }
        return this.mHashCode;
    }

    static int chkValue(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }
}

