/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.AddVolumeData;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PathGroupManager;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serverux.dataimpl.EXDVpg;
import sanproject.serverux.dataimpl.EXDgetVirtualPgInfo_IN;
import sanproject.serverux.dataimpl.EXDgetVirtualPgInfo_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class VpgManager
implements Singleton {
    private static final String LOG_NAME = "VpgManager";
    public static int EXG_OFFSET = 100;
    public static int EXG_MIN = EXG_OFFSET + 1;
    public static int EXG_MAX = EXG_OFFSET + 16384;
    public static int PGID_MIN = 1;
    public static int PGID_MAX = 4096;
    protected HashMap mVpgs = new HashMap();
    protected int mMaxVpgCnt = 0;
    protected ArrayList mAllocatedExg = new ArrayList(16);
    protected int mNextSearchExgNum = 0;
    protected int mNextSearchVpgNum = 0;
    static final Comparator COMP_VPG = new Comparator(){

        public int compare(Object object, Object object2) {
            EXDVpg eXDVpg = this.getObject(object);
            EXDVpg eXDVpg2 = this.getObject(object2);
            int n = eXDVpg.compareTo((Object)eXDVpg2);
            return n;
        }

        private EXDVpg getObject(Object object) {
            EXDVpg eXDVpg = object instanceof VpgInfo ? ((VpgInfo)object).getEXDVpg() : (EXDVpg)object;
            return eXDVpg;
        }
    };
    static /* synthetic */ Class class$sanproject$client$exdevice$data$VpgManager;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$AddVolumeData;

    VpgManager() {
    }

    public static synchronized VpgManager getInstance() {
        return (VpgManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$VpgManager == null ? (class$sanproject$client$exdevice$data$VpgManager = VpgManager.class$("sanproject.client.exdevice.data.VpgManager")) : class$sanproject$client$exdevice$data$VpgManager);
    }

    public void destroy() {
    }

    void initialize() throws EXDException {
        int n;
        Utility.putLog(LOG_NAME, "initialize");
        VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
        EXDgetVirtualPgInfo_IN eXDgetVirtualPgInfo_IN = new EXDgetVirtualPgInfo_IN();
        EXDgetVirtualPgInfo_OUT eXDgetVirtualPgInfo_OUT = (EXDgetVirtualPgInfo_OUT)volumeOperationDataControl.comGet((SanRmiInputInterface)eXDgetVirtualPgInfo_IN);
        EXDVpg[] eXDVpgArray = eXDgetVirtualPgInfo_OUT.getAllVpgForEXD();
        this.mVpgs = new HashMap(eXDVpgArray.length);
        this.mAllocatedExg.clear();
        this.mNextSearchExgNum = 0;
        this.mNextSearchVpgNum = 0;
        int[] nArray = new int[EXG_MAX + 1];
        for (n = 0; n < eXDVpgArray.length; ++n) {
            EXDVpg eXDVpg = eXDVpgArray[n];
            if (eXDVpg == null) continue;
            int n2 = eXDVpg.getIFB4();
            nArray[n2] = nArray[n2] + 1;
            VpgInfo vpgInfo = new VpgInfo(eXDVpg);
            this.mVpgs.put(eXDVpg, vpgInfo);
        }
        for (n = EXG_MIN; n < nArray.length; ++n) {
            if (nArray[n] != PGID_MAX) continue;
            this.mAllocatedExg.add(new Integer(n));
        }
        Collections.sort(this.mAllocatedExg);
        this.mMaxVpgCnt = eXDgetVirtualPgInfo_OUT.getNumOfEmptyVirtualPG();
        this.mMaxVpgCnt += this.getPgCnt();
    }

    void update() throws EXDException {
        Object object;
        Object object2 = VolumeOperationDataControl.getInstance();
        VpgInfo[] vpgInfoArray = new EXDgetVirtualPgInfo_IN();
        long l = System.currentTimeMillis();
        Object object3 = (EXDgetVirtualPgInfo_OUT)((AbstractDataControl)object2).comGet((SanRmiInputInterface)vpgInfoArray);
        long l2 = System.currentTimeMillis() - l;
        Utility.putLog(LOG_NAME, "Get VirtualPgInfo. <Time = " + l2 + " ms>");
        EXDVpg[] eXDVpgArray = object3.getAllVpgForEXD();
        object2 = this.mVpgs.values();
        vpgInfoArray = object2.toArray(new VpgInfo[object2.size()]);
        Arrays.sort(vpgInfoArray, COMP_VPG);
        BitSet bitSet = new BitSet(vpgInfoArray.length);
        for (int i = 0; i < eXDVpgArray.length; ++i) {
            object3 = eXDVpgArray[i];
            if (object3 == null) continue;
            int n = Arrays.binarySearch(vpgInfoArray, object3, COMP_VPG);
            if (n >= 0) {
                bitSet.set(n);
                object = vpgInfoArray[n];
                if (((VpgInfo)object).getEXDVpg().getId() != 0) continue;
                ((VpgInfo)object).setEXDVpg((EXDVpg)object3);
                continue;
            }
            object = new StringBuffer("Increase Data ->");
            ((StringBuffer)object).append(object3);
            Utility.putLog(LOG_NAME, ((StringBuffer)object).toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        PresetManager presetManager = PresetManager.getInstance();
        object3 = presetManager.getEntryClass();
        int n = presetManager.getEntryOperation();
        if (object3 == (class$sanproject$client$exdevice$data$AddVolumeData == null ? (class$sanproject$client$exdevice$data$AddVolumeData = VpgManager.class$("sanproject.client.exdevice.data.AddVolumeData")) : class$sanproject$client$exdevice$data$AddVolumeData) && n == 1) {
            object = presetManager.getAllEntry();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AddVolumeData addVolumeData = (AddVolumeData)iterator.next();
                EXDVpg eXDVpg = addVolumeData.getPgInfo();
                int n2 = Arrays.binarySearch(vpgInfoArray, eXDVpg, COMP_VPG);
                if (n2 < 0) continue;
                bitSet.set(n2);
            }
        }
        if (bitSet.cardinality() != vpgInfoArray.length) {
            object = new StringBuffer("Decrease Data -> ");
            ((StringBuffer)object).append(vpgInfoArray[bitSet.nextClearBit(0)]);
            Utility.putLog(LOG_NAME, ((StringBuffer)object).toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
    }

    public int getMaxPgCnt() {
        return this.mMaxVpgCnt;
    }

    public int getPgCnt() {
        return this.mVpgs.size();
    }

    public int remainPg() {
        return this.mMaxVpgCnt - this.getPgCnt();
    }

    boolean addPgInfo(int n, VpgInfo vpgInfo) {
        if (this.remainPg() > 0 && VpgManager.chkExg(n)) {
            EXDVpg eXDVpg = vpgInfo.getEXDVpg();
            while (n <= EXG_MAX) {
                Integer n2 = new Integer(n);
                int n3 = Collections.binarySearch(this.mAllocatedExg, n2);
                if (n3 < 0) {
                    int n4 = this.mNextSearchExgNum == n ? this.mNextSearchVpgNum : PGID_MIN;
                    for (int i = n4; i <= PGID_MAX; ++i) {
                        eXDVpg.setPGIndex(n, i);
                        if (this.mVpgs.containsKey(eXDVpg)) continue;
                        this.mVpgs.put(eXDVpg, vpgInfo);
                        this.mNextSearchExgNum = n;
                        this.mNextSearchVpgNum = i + 1;
                        return true;
                    }
                    this.mAllocatedExg.add(-n3 - 1, n2);
                }
                ++n;
            }
            eXDVpg.setPGIndex(0, 0);
        }
        return false;
    }

    void releasePg(Robj_interface_RJiPGIndex robj_interface_RJiPGIndex) {
        VpgInfo vpgInfo = (VpgInfo)this.mVpgs.remove(robj_interface_RJiPGIndex);
        if (vpgInfo != null) {
            EXDVpg eXDVpg = vpgInfo.getEXDVpg();
            int n = eXDVpg.getIFB4();
            int n2 = eXDVpg.getIPG();
            int n3 = Collections.binarySearch(this.mAllocatedExg, new Integer(n));
            if (n3 >= 0) {
                this.mAllocatedExg.remove(n3);
            }
            if (this.mNextSearchExgNum == n && this.mNextSearchVpgNum > n2) {
                this.mNextSearchVpgNum = n2;
            }
            eXDVpg.setPGIndex(0, 0);
        }
    }

    void deleteVpgInfo(VpgInfo vpgInfo) {
        PathGroupInfo pathGroupInfo = vpgInfo.getPathGroupInfo();
        Collection collection = this.getVpgInfo(pathGroupInfo);
        if (collection.size() == 1 && collection.contains(vpgInfo)) {
            PathGroupManager.getInstance().deletePathGroup(pathGroupInfo);
        }
        this.releasePg((Robj_interface_RJiPGIndex)vpgInfo.getEXDVpg());
    }

    VpgInfo getVpgInfo(Robj_interface_RJiPGIndex robj_interface_RJiPGIndex) {
        VpgInfo vpgInfo = (VpgInfo)this.mVpgs.get(robj_interface_RJiPGIndex);
        if (vpgInfo == null) {
            vpgInfo = new VpgInfo();
        }
        return vpgInfo;
    }

    Collection getVpgInfo(PathGroupInfo pathGroupInfo) {
        int n = pathGroupInfo.getId();
        ArrayList<VpgInfo> arrayList = new ArrayList<VpgInfo>(this.mVpgs.size());
        Iterator iterator = this.mVpgs.values().iterator();
        while (iterator.hasNext()) {
            VpgInfo vpgInfo = (VpgInfo)iterator.next();
            if (n != vpgInfo.getEXDVpg().referPathGroupId()) continue;
            arrayList.add(vpgInfo);
        }
        return arrayList;
    }

    Collection getVpgInfo(ProductInfo productInfo) {
        ArrayList arrayList = new ArrayList();
        Collection collection = productInfo.getPathGroupInfo();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PathGroupInfo pathGroupInfo = (PathGroupInfo)iterator.next();
            Collection collection2 = this.getVpgInfo(pathGroupInfo);
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    public static boolean chkExg(int n) {
        return n >= EXG_MIN && n <= EXG_MAX;
    }

    public static boolean chkPgid(int n) {
        return n >= PGID_MIN && n <= PGID_MAX;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

