/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.CheckBox;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.RadioButton;
import sanproject.client.exdevice.data.AddVolumeData;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.EmulationTypeManager;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.client.exdevice.luoperation.AddLUPolicyElement;
import sanproject.client.exdevice.luoperation.AddVolumeConfigElement;
import sanproject.client.exdevice.luoperation.AddVolumeDirectorElement;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.text.NumberDocument;

public class VPGSettingPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "VPGSetting";
    private AddVolumeDirectorElement volumeDirector;
    private AddVolumeConfigElement[] volumeElement;
    private JTextField exgField;
    private JComboBox emulationCombo;
    private CheckBox emulationCheckBox;
    private ItemListener emulationCheckChangeListener;
    private JComboBox ldevCountCombo;
    private RadioButton enableCacheMode;
    private RadioButton disableCacheMode;
    private RadioButton enableInflowControl;
    private RadioButton disableInflowControl;
    private JComboBox clprCombo;
    private JLabel slprLabel;
    private Button applyButton;
    private Button cancelButton;

    public VPGSettingPanel(AddVolumeDirectorElement addVolumeDirectorElement, AddVolumeConfigElement[] addVolumeConfigElementArray) {
        this.volumeDirector = addVolumeDirectorElement;
        this.volumeElement = addVolumeConfigElementArray;
        this.exgField = null;
        this.emulationCombo = null;
        this.ldevCountCombo = null;
        this.enableCacheMode = null;
        this.disableCacheMode = null;
        this.enableInflowControl = null;
        this.disableInflowControl = null;
        this.clprCombo = null;
        this.slprLabel = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.initializePanel();
        this.buildPanelLayout();
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            object = new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] opened.");
                }

                public void windowClosed(WindowEvent windowEvent) {
                    VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] closed.");
                    window.removeWindowListener(this);
                }
            };
            window.addWindowListener((WindowListener)object);
        }
        if ((object = this.getWindowRootPane()) != null) {
            ((JRootPane)object).setDefaultButton(this.cancelButton);
        }
    }

    public String getWindowName() {
        String string = "ExDevice_LU";
        return string;
    }

    public SettingValues getSettingValues() {
        SettingValues settingValues = new SettingValues(this);
        return settingValues;
    }

    private void updateCLPRList() {
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList();
        EmulationTypeInfo emulationTypeInfo = (EmulationTypeInfo)this.emulationCombo.getSelectedItem();
        if (emulationTypeInfo != null) {
            object2 = LprManager.getInstance();
            object = ((LprManager)object2).getClprList(emulationTypeInfo);
            arrayList.addAll(object);
        }
        object2 = this.clprCombo.getSelectedItem();
        this.clprCombo.removeAllItems();
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            this.clprCombo.addItem(e);
        }
        if (object2 != null) {
            this.clprCombo.setSelectedItem(object2);
        } else {
            this.clprCombo.setSelectedIndex(0);
        }
    }

    private void updateSLPRLabel() {
        Integer n = (Integer)this.clprCombo.getSelectedItem();
        int n2 = -1;
        if (n != null) {
            int n3 = n;
            LprManager lprManager = LprManager.getInstance();
            n2 = lprManager.getSlpr(n3);
        }
        String string = "";
        if (n2 != -1) {
            string = LocalGuidance.TEXT_SLPR.getText() + String.valueOf(n2);
        }
        this.slprLabel.setText(string);
    }

    private void initializePanel() {
        int n;
        Object object = new NumberDocument(5);
        this.exgField = new JTextField();
        this.exgField.setDocument((Document)object);
        this.exgField.setHorizontalAlignment(0);
        this.exgField.setColumns(5);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] update SLPRLabel.");
                    VPGSettingPanel.this.updateSLPRLabel();
                }
            }
        };
        Object[] objectArray = new DefaultListCellRenderer();
        objectArray.setHorizontalAlignment(4);
        this.clprCombo = new JComboBox();
        this.clprCombo.addItemListener((ItemListener)object);
        this.clprCombo.setRenderer(objectArray);
        this.slprLabel = new JLabel();
        this.slprLabel.setFont(RJComFont.labelFont);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] update CLPRList.");
                    VPGSettingPanel.this.updateCLPRList();
                }
            }
        };
        Object object2 = EmulationTypeManager.getInstance();
        Collection collection = ((EmulationTypeManager)object2).getSupportList();
        if (collection != null) {
            objectArray = collection.toArray();
            Arrays.sort(objectArray);
        } else {
            objectArray = new Object[]{};
        }
        this.emulationCombo = new JComboBox<Object>(objectArray);
        this.emulationCombo.addItemListener((ItemListener)object);
        this.onChangeEmulationCheck(false);
        this.emulationCheckChangeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = VPGSettingPanel.this.emulationCheckBox.isSelected();
                VPGSettingPanel.this.volumeDirector.setExceptOPENV(bl);
                VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] onChange ExceptOPEN-V.->" + bl + "");
                VPGSettingPanel.this.onChangeEmulationCheck(bl);
                VPGSettingPanel.this.updateCLPRList();
            }
        };
        object = LocalGuidance.TEXT_EXCEPT_OPENV.getText();
        this.emulationCheckBox = new CheckBox((String)object);
        this.emulationCheckBox.addItemListener(this.emulationCheckChangeListener);
        this.emulationCheckBox.setOpaque(false);
        this.emulationCheckBox.setFont(RJComFont.buttonFont);
        this.emulationCheckBox.setSelected(this.volumeDirector.isEnableExceptOPENV());
        int n2 = 2049;
        object2 = new ArrayList();
        ((ArrayList)object2).ensureCapacity(n2);
        for (int i = 0; i < n2; ++i) {
            Integer n3 = new Integer(i);
            ((ArrayList)object2).add(n3);
        }
        object = ((ArrayList)object2).toArray();
        Serializable serializable = new DefaultListCellRenderer();
        serializable.setHorizontalAlignment(4);
        this.ldevCountCombo = new JComboBox<Object>((E[])object);
        this.ldevCountCombo.setRenderer(serializable);
        object = LocalGuidance.BUTTON_ENABLE.getText();
        this.enableCacheMode = new RadioButton((String)object);
        this.enableCacheMode.setFont(RJComFont.labelFont);
        this.enableCacheMode.setOpaque(false);
        object = LocalGuidance.BUTTON_DISABLE.getText();
        this.disableCacheMode = new RadioButton((String)object);
        this.disableCacheMode.setFont(RJComFont.labelFont);
        this.disableCacheMode.setOpaque(false);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.enableCacheMode);
        ((ButtonGroup)object).add(this.disableCacheMode);
        object = LocalGuidance.BUTTON_ENABLE.getText();
        this.enableInflowControl = new RadioButton((String)object);
        this.enableInflowControl.setFont(RJComFont.labelFont);
        this.enableInflowControl.setOpaque(false);
        object = LocalGuidance.BUTTON_DISABLE.getText();
        this.disableInflowControl = new RadioButton((String)object);
        this.disableInflowControl.setFont(RJComFont.labelFont);
        this.disableInflowControl.setOpaque(false);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.enableInflowControl);
        ((ButtonGroup)object).add(this.disableInflowControl);
        object = LocalGuidance.BUTTON_OK.getItemID();
        serializable = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] onClick Apply.");
                VPGSettingPanel.this.onClickApply();
            }
        };
        this.applyButton = new Button((String)object);
        this.applyButton.setAction((Action)((Object)serializable));
        object = LocalGuidance.BUTTON_CANCEL.getItemID();
        serializable = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                VPGSettingPanel.this.putLog(VPGSettingPanel.KEY_NAME, "[VPGSetting] onClick Cancel.");
                VPGSettingPanel.this.onClickCancel();
            }
        };
        this.cancelButton = new Button((String)object);
        this.cancelButton.setAction((Action)((Object)serializable));
        object = this.volumeDirector.getTempPolicy();
        if (object == null) {
            object = this.volumeDirector.getPolicy();
        }
        if ((n = ((AddLUPolicyElement)object).getExG()) > 0) {
            this.exgField.setText(String.valueOf(n));
        }
        Comparable comparable = ((AddLUPolicyElement)object).getEmulationType();
        this.emulationCombo.setSelectedItem(comparable);
        int n4 = ((AddLUPolicyElement)object).getCLPRNumber();
        comparable = new Integer(n4);
        this.clprCombo.setSelectedItem(comparable);
        n4 = ((AddLUPolicyElement)object).getLDEVCount();
        comparable = new Integer(n4);
        this.ldevCountCombo.setSelectedItem(comparable);
        boolean bl = ((AddLUPolicyElement)object).isEnableCacheMode();
        this.enableCacheMode.setSelected(bl);
        this.disableCacheMode.setSelected(!bl);
        bl = ((AddLUPolicyElement)object).isEnableInflowControl();
        this.enableInflowControl.setSelected(bl);
        this.disableInflowControl.setSelected(!bl);
    }

    private void buildPanelLayout() {
        Object object = LocalGuidance.TITLE_VPGSETTING.getItemID();
        JPanel jPanel = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jPanel).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jPanel;
        jPanel = new RJcListPanel();
        Object object2 = "" + LocalGuidance.TEXT_EXTERNALGROPUP.getText() + " (" + (VpgManager.EXG_MIN - VpgManager.EXG_OFFSET) + " - " + (VpgManager.EXG_MAX - VpgManager.EXG_OFFSET) + ")" + "";
        Object object3 = LocalGuidance.TEXT_EXGHEADER.getText();
        Serializable serializable = new JLabel((String)object3);
        ((JComponent)serializable).setFont(RJComFont.labelFont);
        object3 = new BorderLayout(4, 4);
        Object object4 = new JPanel();
        ((Container)object4).setLayout((LayoutManager)object3);
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add((Component)serializable, "West");
        ((Container)object4).add((Component)this.exgField, "Center");
        serializable = new BorderLayout(4, 4);
        Serializable serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object4, "West");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = LocalGuidance.TEXT_EMULATIONTYPE.getText();
        serializable = Box.createVerticalStrut(1);
        object3 = Box.createHorizontalStrut(128);
        Object object5 = new SpringLayout();
        object4 = new JPanel();
        ((Container)object4).setLayout((LayoutManager)object5);
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add((Component)serializable);
        ((Container)object4).add(this.emulationCombo);
        ((Container)object4).add((Component)object3);
        RJComSpringUtilities.makeCompactGrid((Container)object4, 3, 1, 0, 0, 0, 0);
        serializable = Box.createHorizontalStrut(128);
        object3 = new BorderLayout(4, 4);
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)object3);
        serializable2.setOpaque(false);
        serializable2.add((Component)object4, "West");
        serializable2.add(this.emulationCheckBox, "Center");
        serializable2.add((Component)serializable, "East");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = LocalGuidance.TEXT_LDEVVPG.getText();
        serializable = Box.createVerticalStrut(1);
        object3 = Box.createHorizontalStrut(60);
        object5 = new SpringLayout();
        object4 = new JPanel();
        ((Container)object4).setLayout((LayoutManager)object5);
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add((Component)serializable);
        ((Container)object4).add(this.ldevCountCombo);
        ((Container)object4).add((Component)object3);
        RJComSpringUtilities.makeCompactGrid((Container)object4, 3, 1, 0, 0, 0, 0);
        serializable = new BorderLayout(4, 4);
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object4, "West");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = LocalGuidance.TEXT_USECACHE.getText();
        serializable = new GridLayout(1, 0, 4, 4);
        object4 = new JPanel();
        ((Container)object4).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add(this.enableCacheMode);
        ((Container)object4).add(this.disableCacheMode);
        serializable = new BorderLayout(4, 4);
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object4, "West");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = LocalGuidance.TEXT_INFLOWCONTROL.getText();
        serializable = new GridLayout(1, 0, 4, 4);
        object4 = new JPanel();
        ((Container)object4).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add(this.enableInflowControl);
        ((Container)object4).add(this.disableInflowControl);
        serializable = new BorderLayout(4, 4);
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object4, "West");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = LocalGuidance.TEXT_CLPR.getText();
        object3 = Box.createVerticalStrut(1);
        object5 = Box.createHorizontalStrut(48);
        SpringLayout springLayout = new SpringLayout();
        serializable = new JPanel();
        ((Container)serializable).setLayout(springLayout);
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add((Component)object3);
        ((Container)serializable).add(this.clprCombo);
        ((Container)serializable).add((Component)object5);
        RJComSpringUtilities.makeCompactGrid((Container)serializable, 3, 1, 0, 0, 0, 0);
        object3 = new BorderLayout(4, 4);
        object4 = new JPanel();
        ((Container)object4).setLayout((LayoutManager)object3);
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add((Component)serializable, "West");
        ((Container)object4).add((Component)this.slprLabel, "Center");
        serializable = new BorderLayout(4, 4);
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object4, "West");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = new BorderLayout(4, 4);
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)object2);
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "North");
        serializable2 = new GridLayout(1, 0, 4, 4);
        object2 = new JPanel();
        ((Container)object2).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add(this.applyButton);
        ((Container)object2).add(this.cancelButton);
        serializable2 = new BorderLayout(4, 4);
        object4 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        jPanel.setOpaque(false);
        jPanel.setBorder((Border)object4);
        jPanel.add((Component)object2, "East");
        object2 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)object2);
        this.add((Component)rJcDlgMainTitlePanel, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel, "South");
    }

    private void checkValues() throws EXDException {
        SettingValues settingValues = this.getSettingValues();
        this.putLog(KEY_NAME, "[VPGSetting] ExG -> " + settingValues.getExG() + ".");
        this.putLog(KEY_NAME, "[VPGSetting] EmulationType -> " + settingValues.getEmulationType() + ".");
        this.putLog(KEY_NAME, "[VPGSetting] LDEVCount -> " + settingValues.getLDEVCount() + ".");
        this.putLog(KEY_NAME, "[VPGSetting] CacheMode -> " + settingValues.isEnabledCacheMode() + ".");
        this.putLog(KEY_NAME, "[VPGSetting] InflowControl -> " + settingValues.isEnabledInflowControl() + ".");
        int n = settingValues.getExG();
        if (n != -1) {
            int n2 = settingValues.getExG() + VpgManager.EXG_OFFSET;
            if (!VpgManager.chkExg(n2)) {
                EXDException eXDException = new EXDException(610, 9130);
                throw eXDException;
            }
        } else {
            EXDException eXDException = new EXDException(610, 9361);
            throw eXDException;
        }
        EmulationTypeInfo emulationTypeInfo = settingValues.getEmulationType();
        if (emulationTypeInfo == null) {
            EXDException eXDException = new EXDException(610, 59016);
            throw eXDException;
        }
    }

    private void onClickApply() {
        try {
            this.checkValues();
            this.setDialogStatus(DialogContentsPanel.APPLY_STATUS);
            this.volumeDirector.setTempPolicy(this.getSettingValues());
            this.closeContentDialog();
        }
        catch (EXDException eXDException) {
            this.processEXDException(eXDException);
        }
    }

    private void onClickCancel() {
        this.closeContentDialog();
    }

    private void onChangeEmulationCheck(boolean bl) {
        Object object = EmulationTypeManager.getInstance();
        int n = this.volumeElement.length;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            AddVolumeConfigElement addVolumeConfigElement = this.volumeElement[i];
            AddVolumeData addVolumeData = addVolumeConfigElement.getConfigData();
            ArrayList arrayList2 = (ArrayList)((EmulationTypeManager)object).getAdaptiveList(addVolumeData, bl);
            if (i == 0) {
                Collections.sort(arrayList2);
                arrayList = arrayList2;
                continue;
            }
            Iterator iterator = arrayList2.iterator();
            ArrayList arrayList3 = new ArrayList();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                int n2 = Collections.binarySearch(arrayList, e);
                if (n2 < 0) continue;
                arrayList3.add(e);
            }
            if (arrayList3.size() <= 0) break;
            Collections.sort(arrayList3);
            arrayList = arrayList3;
        }
        Object[] objectArray = new EmulationTypeInfo[]{};
        objectArray = arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        object = this.emulationCombo.getSelectedItem();
        this.emulationCombo.removeAllItems();
        n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectArray[i];
            this.emulationCombo.addItem(object2);
        }
        if (object != null) {
            this.emulationCombo.setSelectedItem(object);
        } else {
            this.emulationCombo.setSelectedIndex(0);
        }
    }

    public static final class SettingValues {
        private VPGSettingPanel settingPanel;

        private SettingValues(VPGSettingPanel vPGSettingPanel) {
            this.settingPanel = vPGSettingPanel;
        }

        public int getExG() {
            String string = this.settingPanel.exgField.getText();
            int n = -1;
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
            return n;
        }

        public EmulationTypeInfo getEmulationType() {
            Object object = this.settingPanel.emulationCombo.getSelectedItem();
            EmulationTypeInfo emulationTypeInfo = null;
            if (object != null) {
                emulationTypeInfo = (EmulationTypeInfo)object;
            }
            return emulationTypeInfo;
        }

        public int getLDEVCount() {
            Object object = this.settingPanel.ldevCountCombo.getSelectedItem();
            int n = -1;
            if (object != null) {
                String string = object.toString();
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
            return n;
        }

        public boolean isEnabledCacheMode() {
            boolean bl = this.settingPanel.enableCacheMode.isSelected();
            return bl;
        }

        public boolean isEnabledInflowControl() {
            boolean bl = this.settingPanel.enableInflowControl.isSelected();
            return bl;
        }

        public int getCLPR() {
            Object object = this.settingPanel.clprCombo.getSelectedItem();
            int n = -1;
            if (object != null) {
                String string = object.toString();
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
            return n;
        }
    }
}

