/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hpav.pav;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComImagePanel;
import sanproject.client.com.RJComKeySelection;
import sanproject.client.com.RJcConst;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataPAVAliasItem;
import sanproject.client.hpav.com.RJPavAbstractDataSupplier;
import sanproject.client.hpav.com.RJPavException;
import sanproject.client.hpav.com.RJPavGuidance;
import sanproject.client.hpav.com.RJPavHeaderPanel;
import sanproject.client.hpav.com.RJPavPanel;
import sanproject.client.hpav.pav.RJPavAliasVolumeListPanel;
import sanproject.client.hpav.pav.RJPavBaseVolumeListPanel;
import sanproject.client.hpav.pav.RJPavCuComboBox;
import sanproject.client.hpav.pav.RJPavDButton;
import sanproject.client.hpav.pav.RJPavDataSupplier;
import sanproject.client.hpav.pav.RJPavDef;
import sanproject.client.hpav.pav.RJPavFreeVolumeListPanel;
import sanproject.client.hpav.pav.RJPavGButton;
import sanproject.client.hpav.pav.RJPavLdevElement;
import sanproject.client.hpav.pav.RJPavPavPanel;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDKCIndex;
import sanproject.serverux.dataimpl.PPKget1PPInfo;

public class RJPavCenterPanel
extends RJPavPanel
implements RJPavDef {
    private BorderLayout thisLayout = new BorderLayout();
    private JPanel northPanel = new JPanel();
    private GridBagLayout northLayout = new GridBagLayout();
    private JLabel cuLabel = new JLabel();
    private RJPavCuComboBox cuComboBox;
    private JLabel ldkcLabel = new JLabel();
    private RJPavCuComboBox ldkcComboBox;
    private JSplitPane centerSplitPanel = new JSplitPane();
    private JSplitPane leftSplitPanel = new JSplitPane();
    private JSplitPane rightSplitPanel = new JSplitPane();
    private JPanel baseGroundPanel = new JPanel();
    private BorderLayout baseGroundLayout = new BorderLayout();
    private JPanel basePanel = new JPanel();
    private BorderLayout baseLayout = new BorderLayout();
    private RJPavHeaderPanel baseHeaderPanel;
    private RJPavBaseVolumeListPanel baseListPanel;
    private JPanel aliasGroundPanel = new JPanel();
    private BorderLayout aliasGroundLayout = new BorderLayout();
    private JPanel aliasPanel = new JPanel();
    private BorderLayout aliasLayout = new BorderLayout();
    private RJPavHeaderPanel aliasHeaderPanel;
    private RJPavAliasVolumeListPanel aliasListPanel;
    private JPanel actionPanel = new JPanel();
    private GridBagLayout actionLayout = new GridBagLayout();
    private RJPavDButton dButton;
    private RJPavGButton gButton;
    private JPanel freeGroundPanel = new JPanel();
    private BorderLayout freeGroundLayout = new BorderLayout();
    private JPanel freePanel = new JPanel();
    private BorderLayout freeLayout = new BorderLayout();
    private RJPavHeaderPanel freeHeaderPanel;
    private RJPavFreeVolumeListPanel freeListPanel;
    private JPanel m_MoveLeft = new JPanel();
    private JPanel m_MoveRight = new JPanel();
    private JLabel UsedLabel = new JLabel();
    private JLabel UsedCapaLabel = new JLabel();
    private JLabel InstCapaLabel = new JLabel();
    private Border centerSplitBorder;
    private Border leftSplitBorder;
    private Border rightSplitBorder;
    private Border baseGroundBorder;
    private Border baseBorder;
    private Border aliasGroundBorder;
    private Border aliasBorder;
    private Border freeBorder;
    private Border actionBorder;
    private Timer timer;
    private boolean bComboSetting = false;
    private int nLatestLDKC = -1;
    private RJPavPavPanel mainPanel = null;
    private long lPPUsedCapacity = 0L;
    private long lPPInstalledCapacity = 0L;
    private boolean bUnlimited = false;
    private int iInstallStatus = 0;

    public RJPavCenterPanel() {
        super((RJPavAbstractDataSupplier)null);
    }

    public RJPavCenterPanel(RJPavDataSupplier rJPavDataSupplier, RJPavPavPanel rJPavPavPanel) {
        super(rJPavDataSupplier);
        this.mainPanel = rJPavPavPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.centerSplitBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.leftSplitBorder = BorderFactory.createEmptyBorder();
        this.rightSplitBorder = BorderFactory.createEmptyBorder();
        this.baseGroundBorder = BorderFactory.createEmptyBorder(0, 0, 0, 4);
        this.baseBorder = BorderFactory.createEmptyBorder(4, 4, 8, 4);
        this.aliasGroundBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        this.aliasBorder = BorderFactory.createEmptyBorder(4, 4, 8, 4);
        this.freeBorder = BorderFactory.createEmptyBorder(4, 4, 8, 4);
        this.actionBorder = BorderFactory.createEmptyBorder(0, 8, 0, 8);
        this.setLayout(this.thisLayout);
        this.setOpaque(false);
        this.thisLayout.setHgap(8);
        this.thisLayout.setVgap(4);
        this.northPanel.setLayout(this.northLayout);
        this.northPanel.setOpaque(false);
        this.cuLabel.setText(RJPavGuidance.text("HPAV/CuComboLbl"));
        this.cuLabel.setForeground(RJPavGuidance.color("HPAV/CuComboLbl"));
        this.cuLabel.setFont(RJComFont.labelFont);
        this.cuComboBox = new RJPavCuComboBox((RJPavDataSupplier)this.supplier);
        this.cuComboBox.setFont(RJcConst.normalFont);
        this.cuComboBox.setPreferredSize(new Dimension(60, 21));
        this.cuComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RJPavCenterPanel.this.cuComboBox_itemStateChanged(itemEvent);
            }
        });
        this.cuComboBox.setKeySelectionManager(new RJComKeySelection());
        this.ldkcLabel.setText(RJPavGuidance.text("HPAV/LdkcComboLbl"));
        this.ldkcLabel.setForeground(RJPavGuidance.color("HPAV/LdkcComboLbl"));
        this.ldkcLabel.setFont(RJComFont.labelFont);
        this.ldkcComboBox = new RJPavCuComboBox((RJPavDataSupplier)this.supplier);
        this.ldkcComboBox.setFont(RJcConst.normalFont);
        this.ldkcComboBox.setPreferredSize(new Dimension(60, 21));
        this.ldkcComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RJPavCenterPanel.this.ldkcComboBox_itemStateChanged(itemEvent);
            }
        });
        this.ldkcComboBox.setKeySelectionManager(new RJComKeySelection());
        this.UsedLabel.setText(RJPavGuidance.text("HPAV/Title") + " " + RJPavGuidance.text("HPAV/Used") + "(" + RJPavGuidance.text("COMMON/UNIT_TB") + "):");
        this.UsedLabel.setForeground(RJPavGuidance.color("HPAV/Used"));
        this.UsedLabel.setFont(RJComFont.labelFont);
        this.UsedCapaLabel.setForeground(RJPavGuidance.color("COMMON/UNIT_TB"));
        this.UsedCapaLabel.setFont(RJComFont.labelFont);
        this.InstCapaLabel.setForeground(RJPavGuidance.color("COMMON/UNIT_TB"));
        this.InstCapaLabel.setFont(RJComFont.labelFont);
        this.centerSplitPanel.setBorder(this.centerSplitBorder);
        this.centerSplitPanel.setDividerSize(0);
        this.centerSplitPanel.setContinuousLayout(true);
        this.centerSplitPanel.setOpaque(false);
        this.leftSplitPanel.setBorder(this.leftSplitBorder);
        this.leftSplitPanel.setDividerSize(0);
        this.leftSplitPanel.setContinuousLayout(true);
        this.leftSplitPanel.setOpaque(false);
        this.rightSplitPanel.setBorder(this.rightSplitBorder);
        this.rightSplitPanel.setDividerSize(0);
        this.rightSplitPanel.setContinuousLayout(true);
        this.rightSplitPanel.setOpaque(false);
        this.baseHeaderPanel = new RJPavHeaderPanel("HPAV/BaseVolumeTitle");
        this.baseGroundLayout.setVgap(4);
        this.baseGroundPanel.setLayout(this.baseGroundLayout);
        this.baseGroundPanel.setBorder(this.baseGroundBorder);
        this.basePanel.setLayout(this.baseLayout);
        this.basePanel.setBackground(RJPavGuidance.color("HPAV/BaseVolumePanelBgClr"));
        this.basePanel.setBorder(this.baseBorder);
        this.baseListPanel = new RJPavBaseVolumeListPanel("HPAV/BV", (RJPavDataSupplier)this.supplier);
        this.aliasHeaderPanel = new RJPavHeaderPanel("HPAV/AliasVolumeTitle");
        this.aliasGroundLayout.setVgap(4);
        this.aliasGroundPanel.setLayout(this.aliasGroundLayout);
        this.aliasGroundPanel.setBorder(this.aliasGroundBorder);
        this.aliasPanel.setLayout(this.aliasLayout);
        this.aliasPanel.setBackground(RJPavGuidance.color("HPAV/AliasVolumePanelBgClr"));
        this.aliasPanel.setBorder(this.aliasBorder);
        this.aliasListPanel = new RJPavAliasVolumeListPanel("HPAV/AV", (RJPavDataSupplier)this.supplier);
        this.freeHeaderPanel = new RJPavHeaderPanel("HPAV/FreeVolumeTitle");
        this.freeGroundLayout.setVgap(4);
        this.freeGroundPanel.setLayout(this.freeGroundLayout);
        this.freePanel.setBackground(RJPavGuidance.color("HPAV/FreeVolumePanelBgClr"));
        this.freePanel.setLayout(this.freeLayout);
        this.freePanel.setBorder(this.freeBorder);
        this.freeListPanel = new RJPavFreeVolumeListPanel("HPAV/FV", (RJPavDataSupplier)this.supplier);
        this.actionPanel.setLayout(this.actionLayout);
        this.actionPanel.setBorder(this.actionBorder);
        this.m_MoveLeft = RJComImagePanel.createLeftArrowPanel(this.supplier.getDataControl());
        this.m_MoveLeft.setPreferredSize(new Dimension(100, 100));
        this.m_MoveLeft.setMinimumSize(new Dimension(100, 100));
        this.m_MoveLeft.setLayout(null);
        this.m_MoveRight = RJComImagePanel.createRightArrowPanel(this.supplier.getDataControl());
        this.m_MoveRight.setPreferredSize(new Dimension(100, 100));
        this.m_MoveRight.setMinimumSize(new Dimension(100, 100));
        this.m_MoveRight.setLayout(null);
        this.dButton = new RJPavDButton((RJPavDataSupplier)this.supplier, "HPAV/ReleaseBtn");
        this.dButton.setMargin(new Insets(2, 4, 2, 4));
        this.dButton.setEnabled(false);
        this.dButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJPavCenterPanel.this.dButton_actionPerformed(actionEvent);
            }
        });
        this.gButton = new RJPavGButton((RJPavDataSupplier)this.supplier, "HPAV/AssignBtn");
        this.gButton.setMargin(new Insets(2, 4, 2, 4));
        this.gButton.setEnabled(false);
        this.gButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJPavCenterPanel.this.gButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.InstCapaLabel, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.northPanel.add((Component)this.UsedCapaLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.northPanel.add((Component)this.UsedLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.northPanel.add((Component)this.cuComboBox, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.northPanel.add((Component)this.cuLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.northPanel.add((Component)this.ldkcComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.northPanel.add((Component)this.ldkcLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.add((Component)this.centerSplitPanel, "Center");
        this.centerSplitPanel.add((Component)this.leftSplitPanel, "left");
        this.baseGroundPanel.setOpaque(false);
        this.leftSplitPanel.add((Component)this.baseGroundPanel, "left");
        this.baseGroundPanel.add((Component)this.baseHeaderPanel, "North");
        this.baseGroundPanel.add((Component)this.basePanel, "Center");
        this.basePanel.add((Component)this.baseListPanel, "Center");
        this.aliasGroundPanel.setOpaque(false);
        this.leftSplitPanel.add((Component)this.aliasGroundPanel, "right");
        this.aliasGroundPanel.add((Component)this.aliasHeaderPanel, "North");
        this.aliasGroundPanel.add((Component)this.aliasPanel, "Center");
        this.aliasPanel.add((Component)this.aliasListPanel, "Center");
        this.centerSplitPanel.add((Component)this.rightSplitPanel, "right");
        this.actionPanel.setOpaque(false);
        this.rightSplitPanel.add((Component)this.actionPanel, "left");
        this.dButton.setBounds(new Rectangle(10, 38, 60, 24));
        this.gButton.setBounds(new Rectangle(10, 38, 60, 24));
        this.m_MoveRight.add(this.dButton);
        this.m_MoveLeft.add(this.gButton);
        this.actionPanel.add((Component)this.m_MoveRight, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 20, 0), 0, 0));
        this.actionPanel.add((Component)this.m_MoveLeft, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 20, 0), 0, 0));
        this.freeGroundPanel.setOpaque(false);
        this.rightSplitPanel.add((Component)this.freeGroundPanel, "right");
        this.freeGroundPanel.add((Component)this.freeHeaderPanel, "North");
        this.freeGroundPanel.add((Component)this.freePanel, "Center");
        this.freePanel.add((Component)this.freeListPanel, "Center");
        this.leftSplitPanel.setDividerLocation(245);
        this.centerSplitPanel.setDividerLocation(545);
        this.rightSplitPanel.setDividerLocation(90);
        this.baseListPanel.setAliasListPanel(this.aliasListPanel);
        this.baseListPanel.setGButton(this.gButton);
        this.aliasListPanel.setBaseListPanel(this.baseListPanel);
        this.aliasListPanel.setDButton(this.dButton);
        this.freeListPanel.setGButton(this.gButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = this.baseListPanel.saveView();
        boolean bl4 = this.aliasListPanel.saveView();
        boolean bl5 = this.freeListPanel.saveView();
        this.baseListPanel.init();
        this.freeListPanel.init();
        this.dButton.setEnabledM(bl);
        this.gButton.setEnabledM(bl);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Integer n5 = this.ldkcComboBox.getSelectedValue();
        Integer n6 = this.cuComboBox.getSelectedValue();
        if (n5 != null) {
            n = n5;
        }
        if (n6 != null) {
            n2 = n6;
        }
        this.ldkcComboBox.setItems(null, -1);
        this.cuComboBox.setItems(null, -1);
        try {
            RJCom.waitCursor(this);
            this.supplier.init();
            PPKget1PPInfo pPKget1PPInfo = ((RJPavDataSupplier)this.supplier).getPAVLicense();
            this.iInstallStatus = pPKget1PPInfo.nInstall;
            this.bUnlimited = false;
            if (this.iInstallStatus == 1) {
                switch (pPKget1PPInfo.nKeyKind) {
                    case 2: 
                    case 4: 
                    case 7: {
                        if (pPKget1PPInfo.getPermitVol() == -1) {
                            this.InstCapaLabel.setText(RJPavGuidance.text("COMMON/Unlimited"));
                            this.bUnlimited = true;
                            break;
                        }
                        this.lPPInstalledCapacity = RJPavCenterPanel.convertTBtoKBLong(pPKget1PPInfo.getPermitVol());
                        this.InstCapaLabel.setText("(" + RJPavCenterPanel.convertKBtoTBString(this.lPPInstalledCapacity, 1) + ")");
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.InstCapaLabel.setText("---");
                        this.bUnlimited = true;
                        break;
                    }
                    case 8: {
                        this.lPPInstalledCapacity = RJPavCenterPanel.convertTBtoKBLong(pPKget1PPInfo.getPermitVol()) + RJPavCenterPanel.convertGBtoKBLong(pPKget1PPInfo.getLPermDiffCapa());
                        int n7 = pPKget1PPInfo.getPermitVol();
                        long l = pPKget1PPInfo.getLPermDiffCapa();
                        String string = "(" + Integer.toString(n7) + ".0";
                        if (l >= 0L) {
                            string = string.concat("+");
                        } else {
                            string = string.concat("-");
                            l *= -1L;
                        }
                        long l2 = l / 1024L;
                        string = string.concat(Long.toString(l2) + ".0)");
                        this.InstCapaLabel.setText(string);
                        break;
                    }
                    default: {
                        this.InstCapaLabel.setText(RJPavGuidance.text("HPAV/Notinstall"));
                        this.putLog("[HPAV]", "RJPavCenterPanel.init()", "nKeyKind = Invalid value!!", 0);
                        break;
                    }
                }
            } else {
                this.InstCapaLabel.setText(RJPavGuidance.text("HPAV/Notinstall"));
            }
            int[] nArray = null;
            int[] nArray2 = null;
            Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray = ((RJPavDataSupplier)this.supplier).getLDKCIndex();
            if (robj_interface_RJiLDKCIndexArray != null) {
                nArray = new int[robj_interface_RJiLDKCIndexArray.length];
                for (int i = 0; i < robj_interface_RJiLDKCIndexArray.length; ++i) {
                    nArray[i] = robj_interface_RJiLDKCIndexArray[i].getSLDKC();
                    if (n != nArray[i]) continue;
                    n3 = n;
                }
                if (n3 == -1) {
                    n2 = -1;
                    if (robj_interface_RJiLDKCIndexArray.length > 0) {
                        n3 = nArray[0];
                    }
                }
                if (n3 != -1) {
                    RJiLDKCIndex rJiLDKCIndex = new RJiLDKCIndex();
                    rJiLDKCIndex.setSLDKC((short)n3);
                    Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = ((RJPavDataSupplier)this.supplier).getCUIndex((Robj_interface_RJiLDKCIndex)rJiLDKCIndex);
                    if (robj_interface_RJiCUIndexArray != null) {
                        int n8;
                        nArray2 = new int[robj_interface_RJiCUIndexArray.length];
                        for (n8 = 0; n8 < robj_interface_RJiCUIndexArray.length; ++n8) {
                            nArray2[n8] = robj_interface_RJiCUIndexArray[n8].getSCU();
                            if (n2 != nArray2[n8]) continue;
                            n4 = n2;
                        }
                        if (n4 == -1 && robj_interface_RJiCUIndexArray.length > 0) {
                            n4 = nArray2[0];
                        }
                        if (n4 != -1 && n4 != n2) {
                            boolean bl6 = false;
                            for (n8 = 0; n8 < robj_interface_RJiCUIndexArray.length; ++n8) {
                                ArrayList arrayList = ((RJPavDataSupplier)this.supplier).getPAVAlias(robj_interface_RJiCUIndexArray[n8]);
                                if (arrayList == null || arrayList.size() <= 0) continue;
                                bl6 = true;
                                n4 = robj_interface_RJiCUIndexArray[n8].getSCU();
                                break;
                            }
                            if (!bl6) {
                                n4 = -1;
                            }
                        }
                    }
                }
            } else {
                n3 = -1;
                n4 = -1;
            }
            this.bComboSetting = true;
            if (n3 != -1) {
                this.ldkcComboBox.setItems(nArray, n3);
                this.nLatestLDKC = n3;
            } else {
                this.ldkcComboBox.setItems(null, -1);
            }
            this.bComboSetting = false;
            if (n4 != -1) {
                this.cuComboBox.setItems(nArray2, n4);
            } else {
                this.cuComboBox.setItems(null, -1);
                RJDataMsg rJDataMsg = RJCom.getMsg(this.supplier.getDataControl(), 9010, 9303);
                Object[] objectArray = new Object[]{RJPavGuidance.text("HPAV/OK")};
                RJComDialog.show(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            }
        }
        catch (RJPavException rJPavException) {
            bl2 = false;
        }
        finally {
            RJCom.defCursor(this);
        }
        ((RJPavDataSupplier)this.supplier).setBuffUsedCapacity(0L);
        this.renewUsedCapacity();
        if (bl3) {
            this.baseListPanel.restoreView();
        }
        if (bl4) {
            this.aliasListPanel.restoreView();
        }
        if (bl5) {
            this.freeListPanel.restoreView();
        }
        return bl2;
    }

    private void gButton_actionPerformed(ActionEvent actionEvent) {
        RJPavLdevElement[] rJPavLdevElementArray = this.freeListPanel.getSelectedElements();
        ArrayList arrayList = this.baseListPanel.createItems(rJPavLdevElementArray);
        RJPavLdevElement[] rJPavLdevElementArray2 = this.baseListPanel.getSelectedElements();
        if (arrayList.size() > 0) {
            ((RJPavDataSupplier)this.supplier).setPAVAlias(arrayList);
        }
        this.freeListPanel.removeElements(rJPavLdevElementArray);
        this.baseListPanel.addElements(rJPavLdevElementArray);
        if (!this.chkAddUsedCapacity(rJPavLdevElementArray2)) {
            return;
        }
    }

    private void dButton_actionPerformed(ActionEvent actionEvent) {
        RJPavLdevElement[] rJPavLdevElementArray = this.aliasListPanel.getSelectedElements();
        RJPavLdevElement[] rJPavLdevElementArray2 = this.baseListPanel.getSelectedElements();
        ArrayList<RJDataPAVAliasItem> arrayList = new ArrayList<RJDataPAVAliasItem>();
        for (int i = 0; i < rJPavLdevElementArray.length; ++i) {
            RJDataPAVAliasItem rJDataPAVAliasItem = new RJDataPAVAliasItem(rJPavLdevElementArray[i].getLDKC(), rJPavLdevElementArray[i].getCU(), rJPavLdevElementArray[i].getLDev(), rJPavLdevElementArray[i].getBaseLdev().getLDev());
            arrayList.add(rJDataPAVAliasItem);
        }
        ((RJPavDataSupplier)this.supplier).setPAVFreeLdev(arrayList);
        this.aliasListPanel.removeElements();
        this.freeListPanel.addElements(rJPavLdevElementArray);
        this.chkDelUsedCapacity(this.baseListPanel.getDataModel().elements(), rJPavLdevElementArray2);
    }

    private void cuComboBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Integer n = this.ldkcComboBox.getSelectedValue();
            Integer n2 = this.cuComboBox.getSelectedValue();
            if (n != null && n2 != null) {
                this.putLog("[HPAV]", "[CU#]", "ComboBox itemStateChanged(SELECTED): " + n + ":" + n2, 0);
                boolean bl = this.baseListPanel.saveView();
                boolean bl2 = this.freeListPanel.saveView();
                RJiCUIndex rJiCUIndex = new RJiCUIndex();
                rJiCUIndex.setCUIndex((short)n.intValue(), (short)n2.intValue());
                this.baseListPanel.showVolumeList((Robj_interface_RJiCUIndex)rJiCUIndex);
                this.freeListPanel.showVolumeList((Robj_interface_RJiCUIndex)rJiCUIndex);
                this.renewUsedCapacity();
                if (bl) {
                    this.baseListPanel.restoreView();
                }
                if (bl2) {
                    this.freeListPanel.restoreView();
                }
            }
        }
    }

    private void ldkcComboBox_itemStateChanged(ItemEvent itemEvent) {
        Integer n;
        if (itemEvent.getStateChange() == 1 && !this.bComboSetting && (n = this.ldkcComboBox.getSelectedValue()) != null && n != this.nLatestLDKC) {
            if (this.mainPanel.cancelData("ChgLDKC")) {
                this.nLatestLDKC = n;
            } else {
                this.bComboSetting = true;
                this.ldkcComboBox.setSelectedValue(new Integer(this.nLatestLDKC));
                this.bComboSetting = false;
            }
        }
    }

    public static long convertTBtoKBLong(int n) {
        long l = 0L;
        long l2 = 0L;
        l2 = n;
        l = l2 * 1024L * 1024L * 1024L;
        return l;
    }

    public static long convertGBtoKBLong(long l) {
        return l * 1024L * 1024L;
    }

    public static String convertKBtoTBString(long l, int n) {
        BigDecimal bigDecimal = new BigDecimal(Long.toString(l, 10));
        BigDecimal bigDecimal2 = new BigDecimal("1048576");
        bigDecimal = bigDecimal.divide(bigDecimal2, 0);
        bigDecimal2 = new BigDecimal("1024");
        bigDecimal = bigDecimal.divide(bigDecimal2, n, 0);
        String string = bigDecimal.toString();
        return string;
    }

    public boolean chkAddUsedCapacity(RJPavLdevElement[] rJPavLdevElementArray) {
        boolean bl = true;
        long l = 0L;
        Object[] objectArray = new Object[]{RJPavGuidance.text("HPAV/OK")};
        RJDataMsg rJDataMsg = null;
        for (int i = 0; i < rJPavLdevElementArray.length; ++i) {
            RJPavLdevElement rJPavLdevElement = rJPavLdevElementArray[i];
            if (rJPavLdevElement.isBaseCapacityFlag() || rJPavLdevElement.isAddCapacityFlag()) continue;
            long l2 = rJPavLdevElement.getLBASize() / 2L;
            l += l2;
            rJPavLdevElement.setAddCapacityFlag(true);
            rJPavLdevElement.setDelCapacityFlag(false);
            rJPavLdevElement.setName(rJPavLdevElement.getName() + RJPavGuidance.text("HPAV/Asterisk"));
        }
        if (!this.bUnlimited) {
            if (this.lPPInstalledCapacity < l + ((RJPavDataSupplier)this.supplier).getBuffUsedCapacity()) {
                rJDataMsg = RJCom.getMsg(this.supplier.getDataControl(), 9010, 65703);
                RJComDialog.show(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
                bl = false;
            } else if (this.lPPInstalledCapacity < this.lPPUsedCapacity + l + ((RJPavDataSupplier)this.supplier).getBuffUsedCapacity() && !((RJPavDataSupplier)this.supplier).isCalculating()) {
                rJDataMsg = RJCom.getMsg(this.supplier.getDataControl(), 9010, 65703);
                RJComDialog.show(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
                bl = false;
            }
            ((RJPavDataSupplier)this.supplier).addBuffUsedCapacity(l);
        }
        this.renewUsedCapacity();
        return bl;
    }

    public void chkDelUsedCapacity(Enumeration enumeration, RJPavLdevElement[] rJPavLdevElementArray) {
        RJPavLdevElement rJPavLdevElement;
        long l = 0L;
        ArrayList<RJPavLdevElement> arrayList = new ArrayList<RJPavLdevElement>();
        for (int i = 0; i < rJPavLdevElementArray.length; ++i) {
            rJPavLdevElement = rJPavLdevElementArray[i];
            if (rJPavLdevElement.isAccount() || !rJPavLdevElement.isAddCapacityFlag() || rJPavLdevElement.getAliasCount().getCount() >= 1) continue;
            long l2 = rJPavLdevElement.getLBASize() / 2L;
            ((RJPavDataSupplier)this.supplier).delBuffUsedCapacity(l2);
            rJPavLdevElement.setAddCapacityFlag(false);
            rJPavLdevElement.setName(rJPavLdevElement.getName());
        }
        this.renewUsedCapacity();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
            rJPavLdevElement = (RJPavLdevElement)rJaDataModelEntry.get("ELM");
            if (!rJPavLdevElement.getAliasList().isEmpty()) {
                ArrayList arrayList2 = rJPavLdevElement.getAliasList();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    RJPavLdevElement rJPavLdevElement2 = (RJPavLdevElement)iterator.next();
                    if (rJPavLdevElement2.getModify().isModify()) continue;
                    return;
                }
                continue;
            }
            arrayList.add(rJPavLdevElement);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            rJPavLdevElement = (RJPavLdevElement)iterator.next();
            if (!rJPavLdevElement.isAccount() || rJPavLdevElement.isDelCapacityFlag()) continue;
            long l3 = rJPavLdevElement.getLBASize() / 2L;
            l += l3;
            rJPavLdevElement.setBaseCapacityFlag(false);
            rJPavLdevElement.setAddCapacityFlag(false);
            rJPavLdevElement.setDelCapacityFlag(true);
            rJPavLdevElement.setName(rJPavLdevElement.getMasterName());
        }
        ((RJPavDataSupplier)this.supplier).delBuffUsedCapacity(l);
        this.renewUsedCapacity();
    }

    public boolean chkApplyUsedCapacity() {
        boolean bl = true;
        long l = 0L;
        ArrayList arrayList = ((RJPavDataSupplier)this.supplier).getAssignList();
        if (arrayList.size() > 0 && !this.bUnlimited && this.lPPUsedCapacity + ((RJPavDataSupplier)this.supplier).getBuffUsedCapacity() > this.lPPInstalledCapacity) {
            if (!((RJPavDataSupplier)this.supplier).isCalculating()) {
                RJDataMsg rJDataMsg = RJCom.getMsg(this.supplier.getDataControl(), 9010, 65703);
                Object[] objectArray = new Object[]{RJPavGuidance.text("HPAV/OK")};
                RJComDialog.show(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
                bl = false;
            } else {
                RJDataMsg rJDataMsg = RJCom.getMsg(this.supplier.getDataControl(), 9010, 79003);
                Object[] objectArray = new Object[]{RJPavGuidance.text("HPAV/OK")};
                RJComDialog.show(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            }
        }
        return bl;
    }

    public void renewUsedCapacity() {
        if (!this.bUnlimited && this.iInstallStatus != 0) {
            this.lPPUsedCapacity = ((RJPavDataSupplier)this.supplier).getUsedCapacity();
            String string = RJPavCenterPanel.convertKBtoTBString(this.lPPUsedCapacity + ((RJPavDataSupplier)this.supplier).getBuffUsedCapacity(), 2);
            if (((RJPavDataSupplier)this.supplier).isCalculating()) {
                string = "<" + string + ">";
            }
            this.UsedCapaLabel.setText(string);
        }
    }
}

