/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.lunm.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcBaseDialog;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcSouthPanel;
import sanproject.client.lunm.RJLunConstants;
import sanproject.client.lunm.RJLunGdata;
import sanproject.client.lunm.data.RJLunDataSupplier;
import sanproject.client.lunm.data.RJLunHostElement;
import sanproject.client.lunm.data.RJLunLUElement;
import sanproject.client.lunm.data.RJLunPortElement;

public class RJLunUUIDDlg
extends RJcBaseDialog
implements RJLunConstants {
    private RJLunDataSupplier m_Supplier;
    private JTextField m_UUIDText;
    private String m_strHostModeName;
    private ArrayList m_arryLUElement;
    private JButton m_OKButton;
    private JButton m_CancelButton;

    public RJLunUUIDDlg(Frame frame, RJLunDataSupplier rJLunDataSupplier, ArrayList arrayList) {
        super(frame);
        this.m_Supplier = rJLunDataSupplier;
        this.m_arryLUElement = arrayList;
        this.m_UUIDText = new JTextField();
        if (arrayList.size() == 1) {
            RJLunLUElement rJLunLUElement = (RJLunLUElement)arrayList.get(0);
            this.m_UUIDText.setText(rJLunLUElement.getLDEVElement().getUUID());
        }
        this.setResizable(false);
        this.setSize(new Dimension(500, 200));
        this.initInstance();
        this.m_UUIDText.setSelectionStart(0);
        this.m_UUIDText.setSelectionEnd(this.m_UUIDText.getText().length());
        this.m_UUIDText.requestFocus();
    }

    public String getDialogName() {
        return RJcGuide.text("LUNM/UUIDTitle");
    }

    protected JPanel createCenterComponent() {
        Serializable serializable;
        RJcConst rJcConst;
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel.setBorder(border);
        jPanel.setBackground(this.getBackgroundColor());
        if (this.m_arryLUElement != null) {
            rJcConst = (RJLunLUElement)this.m_arryLUElement.get(0);
            serializable = ((RJLunLUElement)rJcConst).getHostElement();
            RJLunPortElement rJLunPortElement = ((RJLunHostElement)serializable).getPortElement();
            String string = RJLunGdata.hModeCnv(((RJLunHostElement)serializable).getHostMode());
            int n = string.indexOf("[") + 1;
            this.m_strHostModeName = string.substring(n, string.length() - 1);
        }
        rJcConst = new RJcListPanel();
        ((RJcListPanel)rJcConst).addEntry("LUNM/UUIDLabel", this.createUUIDPanel(this.m_UUIDText));
        ((RJcListPanel)rJcConst).completed();
        this.m_UUIDText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                RJLunUUIDDlg.this.this_keyReleased(keyEvent);
            }
        });
        serializable = new JPanel();
        ((JComponent)serializable).setOpaque(false);
        jPanel.add((Component)serializable, "North");
        jPanel.add((Component)((Object)rJcConst), "Center");
        return jPanel;
    }

    protected RJcCushionPanel createUUIDPanel(JTextField jTextField) {
        Color color;
        String string;
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jTextField.setFont(RJComFont.itemFont);
        jPanel.setOpaque(false);
        jPanel.add((Component)jTextField, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_strHostModeName.equalsIgnoreCase("OpenVMS")) {
            string = RJcGuide.text("LUNM/NumericLabel");
            color = RJcGuide.color("LUNM/NumericLabel");
        } else {
            string = RJcGuide.text("LUNM/CharacterLabel");
            color = RJcGuide.color("LUNM/CharacterLabel");
        }
        jPanel.add((Component)new CommentLabel(string, color), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        rJcCushionPanel.setComponent(jPanel);
        return rJcCushionPanel;
    }

    protected JPanel createSouthComponent() {
        RJcSouthPanel rJcSouthPanel = new RJcSouthPanel();
        this.m_OKButton = super.newButton("COMMON/PGDSP_OKBTN");
        this.m_OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunUUIDDlg.this.OKButton_actionPerformed(actionEvent);
            }
        });
        this.m_CancelButton = super.newButton("LUNM/PGDSP_CANCELBTN");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunUUIDDlg.this.windowClosing();
            }
        });
        rJcSouthPanel.addComponent(this.m_OKButton, 0);
        rJcSouthPanel.addComponent(this.m_CancelButton, 0);
        return rJcSouthPanel;
    }

    protected void this_keyReleased(KeyEvent keyEvent) {
        if (this.m_strHostModeName.equalsIgnoreCase("OpenVMS")) {
            this.chkUUIDLength(5);
        } else {
            this.chkUUIDLength(64);
        }
    }

    protected void chkUUIDLength(int n) {
        String string = this.m_UUIDText.getText();
        if (string.length() > n) {
            this.m_OKButton.setEnabled(false);
        } else {
            this.m_OKButton.setEnabled(true);
        }
    }

    private void OKButton_actionPerformed(ActionEvent actionEvent) {
        if (this.m_strHostModeName.equalsIgnoreCase("OpenVMS")) {
            if (this.chkNumeric(Short.MAX_VALUE, 1)) {
                this.setUUID(this.m_arryLUElement, this.m_UUIDText.getText());
            }
        } else if (this.chkCharacter()) {
            this.setUUID(this.m_arryLUElement, this.m_UUIDText.getText());
        }
    }

    private void setUUID(ArrayList arrayList, String string) {
        ArrayList<RJLunLUElement> arrayList2 = new ArrayList<RJLunLUElement>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJLunLUElement rJLunLUElement = (RJLunLUElement)iterator.next();
            if (rJLunLUElement.getUUID().compareTo(string) == 0) continue;
            arrayList2.add(rJLunLUElement);
        }
        if (!arrayList2.isEmpty()) {
            this.m_Supplier.setUUID(arrayList2, string);
            super.windowClosing();
        } else {
            super.windowClosing();
        }
    }

    private boolean chkNumeric(int n, int n2) {
        boolean bl;
        block6: {
            bl = true;
            String string = this.m_UUIDText.getText();
            if (string.length() > 0) {
                try {
                    int n3 = Integer.parseInt(string);
                    if (n3 < n2 || n3 > n || string.startsWith("0")) {
                        RJLunGdata.MsgBox(1110, 65752);
                        bl = false;
                        break block6;
                    }
                    byte[] byArray = string.getBytes("US-ASCII");
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] >= 48 && byArray[i] <= 57) continue;
                        RJLunGdata.MsgBox(1110, 65752);
                        bl = false;
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    RJLunGdata.MsgBox(1110, 65752);
                    bl = false;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    RJLunGdata.MsgBox(1110, 65752);
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean chkCharacter() {
        boolean bl = true;
        int n = 0;
        try {
            byte[] byArray = this.m_UUIDText.getText().getBytes("US-ASCII");
            block2: for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] < 32) {
                    n = 65751;
                    break;
                }
                for (int j = 0; j < RJLunConstants.byUUIDProhibitionCharacter.length; ++j) {
                    if (byArray[i] != RJLunConstants.byUUIDProhibitionCharacter[j]) continue;
                    n = 65751;
                    continue block2;
                }
            }
            if (n == 0 && RJComUty.HeadTaleSpaceChecker(this.m_UUIDText.getText())) {
                n = 65751;
            }
            if (n != 0) {
                RJLunGdata.MsgBox(1110, n);
                bl = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            RJLunGdata.MsgBox(1110, 65751);
            bl = false;
        }
        return bl;
    }

    class CommentLabel
    extends JLabel {
        CommentLabel() {
            this(null, Color.BLACK);
        }

        CommentLabel(String string, Color color) {
            this.setForeground(color);
            this.setText(string);
            this.setPreferredSize(new Dimension(120, 24));
        }
    }
}

