/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.hihsm.manualplan;

import javax.swing.Icon;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihHiLdevElement;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.client.monitor.com.RJHihPGrpElement;
import sanproject.client.monitor.hihsm.manualplan.RJHihMpTableModel;
import sanproject.client.monitor.hihsm.manualplan.RJHihMpTablePanel;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.data.HIHsmLDEVUseRate;
import sanproject.serverux.data.HIHsmUseRateBase;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJHihMpLdevElement
extends RJHihHiLdevElement {
    private RJHihMpTablePanel table;
    private Integer progress = null;
    private Integer status = null;
    private Integer useRateAverage = null;
    private Integer useRateMaximum = null;
    private Boolean moveHistory = null;
    private boolean moveok = false;
    private boolean usage = false;
    private RJHihPGrpElement pgElement = null;
    private long aouVolUsed = 0L;
    private Long aouVolCapa = null;
    private int vVolThreshold;
    private int poolThreshold = 0;
    private long poolStatus = 0L;
    private long poolUsed = 0L;
    private long poolLCapacity = 0L;
    private boolean open0VInfo = false;
    public static final int DP_CALC_OVER = 0;
    public static final int DP_CALC_MAYBE_OVER = 1;
    public static final int POOLCHECK_MOVE_OK = 0;
    public static final int POOLCHECK_MOVE_NG = 1;
    public static final int POOLCHECK_MOVE_NG_MAYBE = 2;

    public RJHihMpLdevElement(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3, RJHihDataSupplier rJHihDataSupplier) {
        super((Robj_interface_RJiLDEVIndex)rJiLDEVInfoDetail3, rJHihDataSupplier, null);
        this.initDetail(rJiLDEVInfoDetail3);
    }

    public RJHihMpLdevElement(int n, int n2, int n3, RJHihDataSupplier rJHihDataSupplier) {
        super(n, n2, n3, rJHihDataSupplier, null);
    }

    public RJHihMpLdevElement() {
        super(-1, -1, -1, null, null);
    }

    public void initDetail(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        super.initDetail(rJiLDEVInfoDetail3);
        if (this.isReserve()) {
            this.setOwnerID(this.supplier.getOwnerID(this.ldkc, this.cu, this.ldev));
        }
        if (this.isExternal()) {
            this.setHDD(RJcGuide.text("Performance/ExternalHDD"));
        }
    }

    public void collectUseRate(MonitorInfoCollection monitorInfoCollection, int n) {
        this.useRateAverage = null;
        this.useRateMaximum = null;
        this.moveHistory = null;
        if (monitorInfoCollection != null) {
            HIHsmUseRateBase hIHsmUseRateBase = (HIHsmUseRateBase)monitorInfoCollection.get(n);
            this.useRateAverage = RJHihMpLdevElement.newInteger(hIHsmUseRateBase.getTotalAverage());
            this.useRateMaximum = RJHihMpLdevElement.newInteger(hIHsmUseRateBase.getTotalMax());
            this.moveHistory = new Boolean(((HIHsmLDEVUseRate)hIHsmUseRateBase).getTotalMoveHistory() == 1);
        }
    }

    public RJHihPGrpElement getPGElement() {
        RJHihPGrpElement rJHihPGrpElement = this.pgElement;
        if (rJHihPGrpElement == null) {
            rJHihPGrpElement = super.getPGElement();
        }
        return rJHihPGrpElement;
    }

    public void setPGElement(RJHihPGrpElement rJHihPGrpElement) {
        this.pgElement = rJHihPGrpElement;
    }

    public String getHDD() {
        String string = super.getHDD();
        if (this.pgElement != null) {
            string = this.pgElement.getHDD();
        }
        return string;
    }

    public Icon getIcon(boolean bl) {
        Icon icon = super.getIcon(false);
        if (this.isReserve()) {
            icon = this.getOwnerID() != 0 ? RJHihIconTable.getIcon(46) : RJHihIconTable.getIcon(42);
        } else if (this.isMoving()) {
            icon = RJHihIconTable.getIcon(43);
        }
        if (icon == null) {
            icon = super.getIcon(bl);
        }
        return icon;
    }

    public boolean isMoveOk(RJHihMpLdevElement rJHihMpLdevElement) {
        this.moveok = false;
        Long l = null;
        Long l2 = null;
        if (this.getVolumeFlg() == 3) {
            l = rJHihMpLdevElement.getLBACount();
            l2 = this.getLBACount();
        } else {
            l = rJHihMpLdevElement.getCapacity();
            l2 = this.getCapacity();
        }
        if ((this.getFB4() != rJHihMpLdevElement.getFB4() || this.getPG() != rJHihMpLdevElement.getPG() || this.isAouPGMoveOk(rJHihMpLdevElement)) && rJHihMpLdevElement.getEmulationType().equals(this.getEmulationType()) && l.equals(l2) && this.isReserve() && this.getOwnerID() == 0 && (rJHihMpLdevElement.getVmaInfo() == 0 && this.getVmaInfo() == 0 || rJHihMpLdevElement.getVmaInfo() != 0 && this.getVmaInfo() != 0) && this.isMoveOkWithOpen0V(rJHihMpLdevElement) && !this.isMoving()) {
            this.moveok = true;
        }
        return this.moveok;
    }

    private boolean isAouPGMoveOk(RJHihMpLdevElement rJHihMpLdevElement) {
        boolean bl = false;
        if (this.isAouVol() && rJHihMpLdevElement.isAouVol()) {
            bl = true;
        }
        return bl;
    }

    public void setProgress(int n) {
        this.progress = new Integer(n);
    }

    public Integer getProgress() {
        return this.progress;
    }

    public void setStatus(int n) {
        this.status = new Integer(n);
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getRateAverage() {
        return this.useRateAverage;
    }

    public Integer getRateMaximum() {
        return this.useRateMaximum;
    }

    public Boolean getMoveHistory() {
        Boolean bl = null;
        if (this.usage) {
            bl = this.moveHistory;
        }
        return bl;
    }

    public boolean getMoveOk() {
        return this.moveok;
    }

    public boolean isMoving() {
        RJHihMpTableModel rJHihMpTableModel = (RJHihMpTableModel)this.table.getDataModel();
        boolean bl = rJHihMpTableModel.contains(this);
        return bl;
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
    }

    public void usageAction(boolean bl) {
        this.usage = bl;
    }

    public void setTable(RJHihMpTablePanel rJHihMpTablePanel) {
        this.table = rJHihMpTablePanel;
    }

    public void setVVolUsed(long l) {
        this.aouVolUsed = l;
    }

    public long getVVolUsed() {
        return this.aouVolUsed;
    }

    public String getVVolUsedGB() {
        return RJComUty.ktoGSlong(this.aouVolUsed);
    }

    public void setPoolTreshold(short s) {
        this.poolThreshold = s;
    }

    public int getPoolThreshold() {
        return this.poolThreshold;
    }

    public void setPoolStatus(long l) {
        this.poolStatus = l;
    }

    public long getPoolStatus() {
        return this.poolStatus;
    }

    public boolean isPoolNormal() {
        boolean bl = false;
        if (this.poolStatus == 4101L) {
            bl = true;
        }
        return bl;
    }

    public boolean isPoolBlockade() {
        boolean bl = false;
        if (this.poolStatus == 4097L || this.poolStatus == 4096L || this.poolStatus == 4098L) {
            bl = true;
        }
        return bl;
    }

    public boolean isPoolOverThreshold() {
        boolean bl = false;
        if (this.poolStatus == 4102L) {
            bl = true;
        }
        return bl;
    }

    public boolean isPoolUsageNG(RJHihMpLdevElement rJHihMpLdevElement, int n) {
        boolean bl = true;
        boolean bl2 = false;
        long l = 0L;
        if (rJHihMpLdevElement.isAouVol()) {
            l = rJHihMpLdevElement.getVVolUsed();
            bl2 = true;
        } else {
            l = rJHihMpLdevElement.getVolumeFlg() == 3 ? rJHihMpLdevElement.getCapacity() : rJHihMpLdevElement.getLBACount() / 2L;
        }
        int[] nArray = this.calcPoolUsage(l, bl2);
        if (nArray[0] < n) {
            bl = false;
        }
        return bl;
    }

    public int isPoolUsageNG2(RJHihMpLdevElement rJHihMpLdevElement, int n) {
        int n2 = 0;
        boolean bl = false;
        long l = 0L;
        if (rJHihMpLdevElement.isAouVol()) {
            l = rJHihMpLdevElement.getVVolUsed();
            bl = true;
        } else if (rJHihMpLdevElement.getVolumeFlg() == 3) {
            l = rJHihMpLdevElement.getCapacity();
        } else {
            return n2;
        }
        int[] nArray = this.calcPoolUsage(l, bl);
        n2 = nArray[0] < n ? 0 : (nArray[1] == 1 ? 2 : 1);
        return n2;
    }

    private int calcPoolUsage(long l) {
        int n = 1024;
        double d = 0.0;
        if (this.poolLCapacity > 0L) {
            d = (double)((l + this.poolUsed) * 100L) / (double)this.poolLCapacity;
            n = (int)(d > 0.0 && d < 1.0 ? Math.ceil(d) : Math.floor(d));
        } else {
            this.supplier.putLog("[HIHSM]", "ManualPlan", "calcPoolUsage() poolCapacity Zero Devide:" + this);
        }
        return n;
    }

    private int[] calcPoolUsage(long l, boolean bl) {
        int[] nArray = new int[]{1024, 0};
        double d = 0.0;
        if (this.poolLCapacity > 0L) {
            if (!bl) {
                d = (double)((l + this.poolUsed - this.aouVolUsed) * 100L) / (double)this.poolLCapacity;
            } else if (l + this.aouVolUsed >= this.getCapacity()) {
                nArray[1] = 1;
                d = (double)((this.poolUsed - this.aouVolUsed + this.getCapacity()) * 100L) / (double)this.poolLCapacity;
            } else {
                d = (double)((this.poolUsed + l) * 100L) / (double)this.poolLCapacity;
            }
            nArray[0] = (int)(d > 0.0 && d < 1.0 ? Math.ceil(d) : Math.floor(d));
        } else {
            this.supplier.putLog("[HIHSM]", "ManualPlan", "calcPoolUsage() poolCapacity Zero Devide:" + this);
        }
        return nArray;
    }

    public void setPoolUsed(long l) {
        this.poolUsed = l;
    }

    public void setPoolLCapacity(long l) {
        this.poolLCapacity = l;
    }

    public boolean isOpen0V() {
        return this.open0VInfo;
    }

    private boolean isMoveOkWithOpen0V(RJHihMpLdevElement rJHihMpLdevElement) {
        boolean bl = false;
        if (this.isAouVol() && rJHihMpLdevElement.isAouVol()) {
            bl = true;
        } else if (this.isOpen0V() == rJHihMpLdevElement.isOpen0V()) {
            bl = true;
        }
        return bl;
    }
}

