/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import sanproject.client.openldevguard.com.ComponentConstants;
import sanproject.client.openldevguard.com.StandardPanel;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;

public class TitleValueListPanel
extends StandardPanel {
    private GridBagLayout mgblPanelLayout = new GridBagLayout();
    private int miPairCont = 0;

    public TitleValueListPanel() {
        this.setLayout(this.mgblPanelLayout);
        this.setOpaque(false);
    }

    public final synchronized void addPair(TitleValuePair titleValuePair) {
        titleValuePair.addList(this);
        ++this.miPairCont;
    }

    public final synchronized int getPairCont() {
        return this.miPairCont;
    }

    public static class TitleValuePair {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        private static final int ROWEIGHTCOMPONENT_HEIGHT;
        private static final Insets EMPTY_INSETS;
        private static final Insets NORTH_INSETS;
        private static final Insets EAST_INSETS;
        private static final Insets NORTH_EAST_INSETS;
        private int miOrientation = 0;
        private int miRowWeight = 0;
        private JComponent mcmpTitleComponent;
        private JComponent mcmpValueComponent;

        public TitleValuePair() {
            ComponentFactory componentFactory = ComponentFactory.getDefaultFactory();
            this.mcmpTitleComponent = ComponentUtilities.buildListTitleComponent(componentFactory, "");
            this.mcmpTitleComponent.setOpaque(false);
            this.mcmpValueComponent = ComponentUtilities.buildListValueComponent(componentFactory, "");
            this.mcmpValueComponent.setOpaque(false);
            this.setOrientation(0);
            this.setRowWeight(0);
        }

        public TitleValuePair(String string, String string2) {
            this(ComponentFactory.getDefaultFactory(), string, string2);
        }

        public TitleValuePair(ComponentFactory componentFactory, String string, String string2) {
            this.mcmpTitleComponent = ComponentUtilities.buildListTitleComponent(componentFactory, string);
            this.mcmpValueComponent = ComponentUtilities.buildListValueComponent(componentFactory, string2);
            this.setOrientation(0);
            this.setRowWeight(0);
        }

        public TitleValuePair(String string, JComponent jComponent) {
            this(ComponentFactory.getDefaultFactory(), string, jComponent);
        }

        public TitleValuePair(ComponentFactory componentFactory, String string, JComponent jComponent) {
            this.mcmpTitleComponent = ComponentUtilities.buildListTitleComponent(componentFactory, string);
            this.mcmpValueComponent = ComponentUtilities.buildListValueComponent(componentFactory, jComponent);
            this.setOrientation(0);
            this.setRowWeight(0);
        }

        private synchronized void addList(TitleValueListPanel titleValueListPanel) {
            if (this.miOrientation == 1) {
                this.addVertivalTypePair(titleValueListPanel);
            } else {
                this.addHorizontalTypePair(titleValueListPanel);
            }
        }

        private void addHorizontalTypePair(TitleValueListPanel titleValueListPanel) {
            GridBagLayout gridBagLayout = (GridBagLayout)titleValueListPanel.getLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridheight = this.miRowWeight == 0 ? 1 : this.miRowWeight;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = this.getTitleInsets(titleValueListPanel);
            gridBagLayout.setConstraints(this.mcmpTitleComponent, gridBagConstraints);
            titleValueListPanel.add(this.mcmpTitleComponent);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.getValueInsets(titleValueListPanel);
            gridBagLayout.setConstraints(this.mcmpValueComponent, gridBagConstraints);
            titleValueListPanel.add(this.mcmpValueComponent);
            for (int i = 0; i < this.miRowWeight - 1; ++i) {
                this.addAdjustmentRowWeightComponent(titleValueListPanel);
            }
            this.addAdjustmentRowWeightComponent(titleValueListPanel);
        }

        private void addVertivalTypePair(TitleValueListPanel titleValueListPanel) {
            GridBagLayout gridBagLayout = (GridBagLayout)titleValueListPanel.getLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = this.getTitleInsets(titleValueListPanel);
            gridBagLayout.setConstraints(this.mcmpTitleComponent, gridBagConstraints);
            titleValueListPanel.add(this.mcmpTitleComponent);
            this.addAdjustmentRowWeightComponent(titleValueListPanel);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = this.getValueInsets(titleValueListPanel);
            if (this.miRowWeight == 0) {
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridheight = 1;
            } else {
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridheight = this.miRowWeight;
            }
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.mcmpValueComponent, gridBagConstraints);
            titleValueListPanel.add(this.mcmpValueComponent);
            for (int i = 0; i < this.miRowWeight - 1; ++i) {
                this.addAdjustmentRowWeightComponent(titleValueListPanel);
            }
            this.addAdjustmentRowWeightComponent(titleValueListPanel);
        }

        private void addAdjustmentRowWeightComponent(TitleValueListPanel titleValueListPanel) {
            GridBagLayout gridBagLayout = (GridBagLayout)titleValueListPanel.getLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = this.getValueInsets(titleValueListPanel);
            Dimension dimension = new Dimension(0, ROWEIGHTCOMPONENT_HEIGHT);
            ComponentFactory componentFactory = ComponentFactory.getDefaultFactory();
            JComponent jComponent = ComponentUtilities.buildListValueComponent(componentFactory, "");
            jComponent.setOpaque(false);
            jComponent.setPreferredSize(dimension);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            titleValueListPanel.add(jComponent);
        }

        private Insets getTitleInsets(TitleValueListPanel titleValueListPanel) {
            Insets insets = titleValueListPanel.getPairCont() == 0 ? (this.miOrientation == 1 ? EMPTY_INSETS : EAST_INSETS) : (this.miOrientation == 1 ? NORTH_INSETS : NORTH_EAST_INSETS);
            return insets;
        }

        private Insets getValueInsets(TitleValueListPanel titleValueListPanel) {
            Insets insets = titleValueListPanel.getPairCont() == 0 && this.miOrientation != 1 ? EMPTY_INSETS : NORTH_INSETS;
            return insets;
        }

        public final synchronized void setOrientation(int n) {
            this.miOrientation = n;
        }

        public final int getOrientation() {
            return this.miOrientation;
        }

        public final synchronized void setRowWeight(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Illegal weight.");
            }
            this.miRowWeight = n;
        }

        public final int getRowWeight() {
            return this.miRowWeight;
        }

        static {
            Dimension dimension = ComponentConstants.MINIMUM_LISTTITLE_SIZE;
            ROWEIGHTCOMPONENT_HEIGHT = dimension.height;
            EMPTY_INSETS = new Insets(0, 0, 0, 0);
            NORTH_INSETS = new Insets(4, 0, 0, 0);
            EAST_INSETS = new Insets(0, 0, 0, 4);
            NORTH_EAST_INSETS = new Insets(4, 0, 0, 4);
        }
    }
}

