/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaMenuItemActionListener;
import sanproject.client.com.abs.RJaPopupMenuSTD;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.pool.RJPoolAddVolDialog;
import sanproject.client.pool.RJPoolApplyData;
import sanproject.client.pool.RJPoolApplyItem;
import sanproject.client.pool.RJPoolComboBox;
import sanproject.client.pool.RJPoolComboItem;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolFreeLdevTableModel;
import sanproject.client.pool.RJPoolGuideDef;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.client.pool.RJPoolLdevTableModel;
import sanproject.client.pool.RJPoolPoolElement;
import sanproject.client.pool.RJPoolPoolTablePanel;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetailEUx;

public class RJPoolFreeTablePanel
extends RJcTablePanel
implements RJPoolGuideDef,
ActionListener,
RJaMenuItemActionListener {
    protected RJPoolDataSupplier supplier;
    private JLabel selectField = new JLabel();
    private RJPoolPoolTablePanel poolTablePanel = null;
    private RJcButton addButton = null;
    private RJPoolComboBox ldkcComboBox = null;
    private RJPoolComboBox cuComboBox = null;
    private static final String[] menuItems = new String[]{RJcGuide.text("Pool/PopupAddVol")};
    private RJaPopupMenuSTD menu = null;
    private int currentClprNo = -1;
    private int poolKind = 0;
    private boolean intVOLInfo = false;
    private boolean extVOLInfo = false;
    private boolean cacheModeEnable = false;
    private boolean cacheModeDisable = false;
    private boolean intFCDrive = false;
    private boolean intSATADrive = false;
    private boolean intSSDDrive = false;
    private boolean encEnable = false;
    private boolean encDisable = false;
    private int raidLevel = -1;
    private RJPoolFreeLdevTableModel saveModel = null;

    public RJPoolFreeTablePanel() {
        this((RJPoolDataSupplier)null);
    }

    public RJPoolFreeTablePanel(RJPoolDataSupplier rJPoolDataSupplier) {
        this.supplier = rJPoolDataSupplier;
        this.add((Component)this.createSouthPanel(), "South");
    }

    public void init() {
        super.init();
        this.currentClprNo = -1;
        this.intVOLInfo = false;
        this.extVOLInfo = false;
        this.cacheModeEnable = false;
        this.cacheModeDisable = false;
        this.intFCDrive = false;
        this.intSATADrive = false;
        this.intSSDDrive = false;
        this.encEnable = false;
        this.encDisable = false;
        this.raidLevel = -1;
        this.createTable(null);
    }

    public void showVolumeList(Robj_interface_RJiCUIndex robj_interface_RJiCUIndex) {
        RJPoolFreeLdevTableModel rJPoolFreeLdevTableModel = this.createTableModel(robj_interface_RJiCUIndex);
        this.createTable(rJPoolFreeLdevTableModel);
        this.completedTable();
        this.setClprNo(this.currentClprNo);
        this.setIntVOLInfo(this.intVOLInfo);
        this.setExtVOLInfo(this.extVOLInfo);
        this.setCacheModeEnable(this.cacheModeEnable);
        this.setCacheModeDisable(this.cacheModeDisable);
        this.setIntFCDrive(this.intFCDrive);
        this.setIntSATADrive(this.intSATADrive);
        this.setIntSSDDrive(this.intSSDDrive);
        this.setEncEnable(this.encEnable);
        this.setEncDisable(this.encDisable);
        this.setRaidLevel(this.raidLevel);
        rJPoolFreeLdevTableModel.sortLdev();
    }

    private RJPoolFreeLdevTableModel createTableModel(Robj_interface_RJiCUIndex robj_interface_RJiCUIndex) {
        RJPoolFreeLdevTableModel rJPoolFreeLdevTableModel = null;
        rJPoolFreeLdevTableModel = new RJPoolFreeLdevTableModel(this.supplier);
        rJPoolFreeLdevTableModel.setLdkcComboBox(this.ldkcComboBox);
        rJPoolFreeLdevTableModel.setCuComboBox(this.cuComboBox);
        if (robj_interface_RJiCUIndex != null) {
            this.createVolumeList(robj_interface_RJiCUIndex, rJPoolFreeLdevTableModel);
        }
        return rJPoolFreeLdevTableModel;
    }

    private void createVolumeList(Object object, RJPoolLdevTableModel rJPoolLdevTableModel) {
        this.supplier.putLog("[Pool]", "[FreeTable]", "createVolumeList(" + object + ")");
        ArrayList arrayList = this.supplier.getFreeLDEV(this.poolKind, (Robj_interface_RJiCUIndex)object);
        if (arrayList != null) {
            rJPoolLdevTableModel.beginSetting();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Robj_interface_RJiLDEVInfoDetailEUx robj_interface_RJiLDEVInfoDetailEUx = (Robj_interface_RJiLDEVInfoDetailEUx)iterator.next();
                RJPoolLdevElement rJPoolLdevElement = new RJPoolLdevElement(robj_interface_RJiLDEVInfoDetailEUx.getSLDKC(), robj_interface_RJiLDEVInfoDetailEUx.getSCU(), robj_interface_RJiLDEVInfoDetailEUx.getSLDEV());
                rJPoolLdevElement.setSupplier(this.supplier);
                rJPoolLdevElement.initDetail(robj_interface_RJiLDEVInfoDetailEUx);
                RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
                if (rJPoolApplyData.isExist(rJPoolLdevElement)) continue;
                rJPoolLdevTableModel.addRow(rJPoolLdevElement);
            }
            rJPoolLdevTableModel.completeSetting();
        }
    }

    public void addFreeVolume() {
        Robj_interface_RJiCUIndex robj_interface_RJiCUIndex = null;
        RJPoolComboItem rJPoolComboItem = (RJPoolComboItem)this.cuComboBox.getSelectedItem();
        if (rJPoolComboItem.isValidity()) {
            robj_interface_RJiCUIndex = (Robj_interface_RJiCUIndex)rJPoolComboItem.getValue();
        }
        RJPoolFreeLdevTableModel rJPoolFreeLdevTableModel = this.createTableModel(robj_interface_RJiCUIndex);
        this.setClprNo(this.currentClprNo);
        this.setIntVOLInfo(this.intVOLInfo);
        this.setExtVOLInfo(this.extVOLInfo);
        this.setCacheModeEnable(this.cacheModeEnable);
        this.setCacheModeDisable(this.cacheModeDisable);
        this.setIntFCDrive(this.intFCDrive);
        this.setIntSATADrive(this.intSATADrive);
        this.setIntSSDDrive(this.intSSDDrive);
        this.setEncEnable(this.encEnable);
        this.setEncDisable(this.encDisable);
        this.setRaidLevel(this.raidLevel);
        if (this.model == rJPoolFreeLdevTableModel) {
            rJPoolFreeLdevTableModel.sortLdev();
        }
    }

    public void createTable(RJaTableDataModel rJaTableDataModel) {
        if (rJaTableDataModel == null) {
            rJaTableDataModel = new RJPoolFreeLdevTableModel(this.supplier);
        }
        super.createTable(rJaTableDataModel);
        this.setSelCountLabel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setSelCountLabel();
    }

    private void setSelCountLabel() {
        int n = this.model.getSelectedRows().length;
        this.selectField.setText(String.valueOf(n));
        this.setAddButtonEnabled();
    }

    public void setAddButtonEnabled() {
        if (this.addButton != null) {
            this.addButton.setEnabled(this.isAddActionEnable());
        }
    }

    private boolean isAddActionEnable() {
        boolean bl = false;
        if (this.poolTablePanel != null) {
            RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
            int n = this.getSelectedCount();
            int n2 = this.poolTablePanel.getRremainVolCount();
            RJPoolPoolElement rJPoolPoolElement = this.poolTablePanel.getPoolElement();
            bl = n > 0 && n2 >= n && (!rJPoolPoolElement.isBlocked() || (rJPoolPoolElement.getStatus() & 0xFFFFL) == 4098L) && !rJPoolPoolElement.isTopVOLWarning() && rJPoolApplyData.isOK(1) && this.supplier.isModify() && this.supplier.isPPCheck(this.poolKind);
        }
        return bl;
    }

    private int getSelectedCount() {
        int[] nArray = this.model.getSelectedRows();
        int n = nArray.length;
        return n;
    }

    public void showPopupMenu(MouseEvent mouseEvent, Object object) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jPopupMenu.isPopupTrigger(mouseEvent) && this.isAddActionEnable()) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int[] nArray = jTable.getSelectedRows();
            Arrays.sort(nArray);
            int n2 = Arrays.binarySearch(nArray, n);
            if (n2 >= 0) {
                this.menu = new RJaPopupMenuSTD(this, menuItems);
                this.menu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void menuItemActionPerformed(ActionEvent actionEvent, int n) {
        this.actionPerformed(actionEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.addPoolVolume();
    }

    private void addPoolVolume() {
        Object object;
        RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem();
        int[] nArray = this.model.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            object = this.model.getRow(nArray[i]);
            RJPoolLdevElement rJPoolLdevElement = (RJPoolLdevElement)((RJaDataModelEntry)object).get("LDEV");
            rJPoolApplyItem.addPoolVol(rJPoolLdevElement);
        }
        this.supplier.sort(rJPoolApplyItem.getPoolVolList());
        Frame frame = (Frame)this.supplier.searchWindow(this.supplier.getParentPanel());
        object = new RJPoolAddVolDialog(frame, this.supplier);
        ((RJPoolAddVolDialog)object).show(rJPoolApplyItem);
        if (((RJPoolAddVolDialog)object).getResult()) {
            this.model.remove();
            this.poolTablePanel.addPoolVolume(rJPoolApplyItem);
        }
    }

    public void setPoolTablePanel(RJPoolPoolTablePanel rJPoolPoolTablePanel) {
        this.poolTablePanel = rJPoolPoolTablePanel;
        rJPoolPoolTablePanel.setFreeTablePanel(this);
    }

    public void setClprNo(int n) {
        this.currentClprNo = n;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setClprNo(n);
        }
        this.refresh();
    }

    public void setPoolKind(int n) {
        this.poolKind = n;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setPoolKind(n);
        }
        this.refresh();
    }

    public void setIntVOLInfo(boolean bl) {
        this.intVOLInfo = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setIntVOLInfo(bl);
        }
        this.refresh();
    }

    public void setExtVOLInfo(boolean bl) {
        this.extVOLInfo = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setExtVOLInfo(bl);
        }
        this.refresh();
    }

    public void setCacheModeEnable(boolean bl) {
        this.cacheModeEnable = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setCacheModeEnable(bl);
        }
        this.refresh();
    }

    public void setCacheModeDisable(boolean bl) {
        this.cacheModeDisable = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setCacheModeDisable(bl);
        }
        this.refresh();
    }

    public void setIntFCDrive(boolean bl) {
        this.intFCDrive = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setIntFCDrive(bl);
        }
        this.refresh();
    }

    public void setIntSATADrive(boolean bl) {
        this.intSATADrive = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setIntSATADrive(bl);
        }
        this.refresh();
    }

    public void setIntSSDDrive(boolean bl) {
        this.intSSDDrive = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setIntSSDDrive(bl);
        }
        this.refresh();
    }

    public void setEncEnable(boolean bl) {
        this.encEnable = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setEncEnable(bl);
        }
        this.refresh();
    }

    public void setEncDisable(boolean bl) {
        this.encDisable = bl;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setEncDisable(bl);
        }
        this.refresh();
    }

    public void clearMember() {
        this.currentClprNo = -1;
        this.poolKind = 0;
        this.intVOLInfo = false;
        this.extVOLInfo = false;
        this.cacheModeEnable = false;
        this.cacheModeDisable = false;
        this.intFCDrive = false;
        this.intSATADrive = false;
        this.intSSDDrive = false;
        this.encEnable = false;
        this.encDisable = false;
        this.raidLevel = -1;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).clearMember();
        }
        this.refresh();
    }

    public void setLdkcComboBox(RJPoolComboBox rJPoolComboBox) {
        this.ldkcComboBox = rJPoolComboBox;
    }

    public void setCuComboBox(RJPoolComboBox rJPoolComboBox) {
        this.cuComboBox = rJPoolComboBox;
    }

    public void setAddButton(RJcButton rJcButton) {
        this.addButton = rJcButton;
    }

    private JPanel createSouthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(200, 16));
        jPanel.setMinimumSize(new Dimension(200, 16));
        jPanel.setBackground(RJcGuide.color("Pool/FreeTableMarginBgClr"));
        JLabel jLabel = new JLabel(RJcGuide.text("Pool/FreeTableSelectVolLbl"));
        jLabel.setForeground(RJcGuide.color("Pool/FreeTableSelectVolLbl"));
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(RJcConst.boldFont);
        this.selectField.setForeground(RJcGuide.color("Pool/FreeTableSelectVolField"));
        this.selectField.setPreferredSize(new Dimension(24, 14));
        this.selectField.setMinimumSize(new Dimension(24, 14));
        this.selectField.setFont(RJcConst.boldFont);
        this.selectField.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.selectField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 8), 0, 0));
        return jPanel;
    }

    public void setRaidLevel(int n) {
        this.raidLevel = n;
        if (this.model != null) {
            ((RJPoolFreeLdevTableModel)this.model).setRaidLevel(n);
        }
        this.refresh();
    }
}

