/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import sanproject.client.openldevguard.utility.sort.DataSorter;
import sanproject.client.openldevguard.utility.sort.DataSorterFactory;
import sanproject.client.ppkey.LicenseCounterWrapperList;
import sanproject.client.ppkey.RJPPKeyGuidance;

public final class LicenseListTableModel
extends AbstractTableModel {
    private static final int COLUMN_INDEX = -1;
    public static final int ROW_NUMBER = 0;
    public static final int LICENSE_CAPACITY = 1;
    public static final int CURRENT_NUMBER = 2;
    public static final int TOTAL_NUMBER = 3;
    public static final int MAX_COLUMN_COUNT = 4;
    public static final SortType EMPTY_SORT = new SortType("empty");
    public static final SortType ASCENDING_SORT = new SortType("ascending");
    public static final SortType DESCENDING_SORT = new SortType("descending");
    private final Class[] columnClasses = new Class[4];
    private final String[] columnNames;
    private final int[] columnWidths;
    private int sortedIndex;
    private SortType sortType;
    private LicenseCounterWrapperList wrapperList;
    private Object[][] modelData;
    private ViewRow[] viewIndex;

    public LicenseListTableModel(RJPPKeyGuidance rJPPKeyGuidance, LicenseCounterWrapperList licenseCounterWrapperList) {
        this.columnClasses[0] = Integer.class;
        this.columnClasses[1] = Integer.class;
        this.columnClasses[2] = Integer.class;
        this.columnClasses[3] = Integer.class;
        this.columnNames = new String[4];
        this.columnNames[0] = " ";
        this.columnNames[1] = rJPPKeyGuidance.licenseCapacityHeader.getGuidance();
        this.columnNames[2] = rJPPKeyGuidance.currentNumberHeader.getGuidance();
        this.columnNames[3] = rJPPKeyGuidance.totalNumberHeader.getGuidance();
        this.columnWidths = new int[4];
        this.columnWidths[0] = 40;
        this.columnWidths[1] = 186;
        this.columnWidths[2] = 128;
        this.columnWidths[3] = 128;
        this.sortedIndex = -1;
        this.sortType = EMPTY_SORT;
        this.wrapperList = licenseCounterWrapperList;
        this.updateLicenseCount();
    }

    public int getRowCount() {
        int n = this.modelData.length;
        return n;
    }

    public int getColumnCount() {
        int n = this.columnNames.length;
        return n;
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.convertToModelIndex(n);
        Object object = this.modelData[n3][n2];
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("can not set.");
    }

    public Class getColumnClass(int n) {
        Class clazz = this.columnClasses[n];
        return clazz;
    }

    public String getColumnName(int n) {
        String string = this.columnNames[n];
        return string;
    }

    public int getPreferredColumnWidth(int n) {
        int n2 = 75;
        try {
            n2 = this.columnWidths[n];
        }
        catch (Exception exception) {
            Class<?> clazz = exception.getClass();
            String string = clazz.getName();
            System.err.println("not found preferred width. [" + n + "]");
        }
        return n2;
    }

    public int getCurrentLicenseCountAt(int n) {
        int n2 = this.convertToModelIndex(n);
        int n3 = this.wrapperList.getCurrentLicenseCountAt(n2);
        return n3;
    }

    public boolean isModifiedAt(int n) {
        int n2 = this.convertToModelIndex(n);
        boolean bl = this.wrapperList.isModifiedAt(n2);
        return bl;
    }

    public synchronized void updateLicenseCount() {
        int n = this.wrapperList.getWrapperCount();
        this.modelData = new Object[n][4];
        this.viewIndex = new ViewRow[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.wrapperList.getLicenseCapacityAt(i);
            int n3 = this.wrapperList.getCurrentLicenseCountAt(i);
            int n4 = this.wrapperList.getModifiedLicenseCountAt(i);
            this.modelData[i][0] = new Integer(i + 1);
            this.modelData[i][1] = new Integer(n2);
            this.modelData[i][2] = new Integer(n3);
            this.modelData[i][3] = new Integer(n4);
            this.viewIndex[i] = new ViewRow(i);
        }
        this.clearSortState();
        this.fireTableDataChanged();
    }

    public void updateLicenseCount(int n, int n2) {
        int n3 = this.convertToModelIndex(n);
        this.wrapperList.changeLicenseCountAt(n3, n2);
        int n4 = this.wrapperList.getModifiedLicenseCountAt(n3);
        this.modelData[n3][3] = new Integer(n4);
        this.fireTableRowsUpdated(n, n);
    }

    public synchronized void setSortAt(int n) {
        SortType sortType = ASCENDING_SORT;
        if (this.sortedIndex == n && this.sortType.equals(ASCENDING_SORT)) {
            sortType = DESCENDING_SORT;
        }
        DataSorter dataSorter = this.createSorter(n);
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Object object = this.getValueAt(i, n);
            ViewRow viewRow = this.viewIndex[i];
            dataSorter.put(object, viewRow);
        }
        List list = dataSorter.getSortedDataList();
        if (sortType.equals(DESCENDING_SORT)) {
            Collections.reverse(list);
        }
        this.viewIndex = new ViewRow[0];
        this.viewIndex = list.toArray(this.viewIndex);
        this.sortedIndex = n;
        this.sortType = sortType;
        this.fireTableDataChanged();
    }

    private int convertToModelIndex(int n) {
        ViewRow viewRow = this.viewIndex[n];
        int n2 = viewRow.getModelIndex();
        return n2;
    }

    private int convertToViewIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.viewIndex.length; ++i) {
            ViewRow viewRow = this.viewIndex[i];
            if (viewRow.getModelIndex() != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private DataSorter createSorter(int n) {
        switch (n) {
            default: 
        }
        DataSorter dataSorter = DataSorterFactory.createMixtureDataSorter();
        return dataSorter;
    }

    private void clearSortState() {
        this.sortedIndex = -1;
        this.sortType = EMPTY_SORT;
    }

    static final class ViewRow {
        private final int modelIndex;

        ViewRow(int n) {
            this.modelIndex = n;
        }

        public int getModelIndex() {
            int n = this.modelIndex;
            return n;
        }
    }

    public static final class SortType {
        private String identifier;

        private SortType(String string) {
            this.identifier = string;
        }
    }
}

