/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtELunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtSSDDriveInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtArraygroupReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public class SJdtHMArraygroupReportGenerator
extends SJdtArraygroupReportGenerator {
    private static final String[] HEADER_KEY_ARRAY = new String[]{"pg", "dkb", "raidLevel", "resourceGroupName", "resourceGroupId", "emulationType", "numberOfLdevsTotal", "numberOfLdevsUnallocated", "totalLdevCapacity", "unallocatedLdevCapacity", "driveTypeCode", "driveTypeRpm", "driveCapacity", "raidConcatenation0", "raidConcatenation1", "raidConcatenation2", "encryption", "acceleratedCompression"};
    private static final int COLUMN_LENGTH = SJdtHMArraygroupReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);

    @Override
    public String[] getTableHeaderKeyArray() {
        return HEADER_KEY_ARRAY;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        SJdtELunInfoCSVWrapper eLunInfo = (SJdtELunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ELunInfo.csv");
        SJdtSSDDriveInfoCSVWrapper ssdDriveInfo = (SJdtSSDDriveInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("SSDDriveInfo.csv");
        Map<String, String> eccGroupMap = pdevInfo.getEccGroupWithoutSpareDriveValueSet();
        eccGroupMap.putAll(eLunInfo.getAllRecordColumnValueSetMap("ECC Group"));
        ArrayList<String> eccGroupList = new ArrayList<String>(eccGroupMap.keySet());
        Map<String, String[]> eLunInfoEccGroupMap = eLunInfo.getMatchedAllRecordMap("ECC Group");
        Map<String, List<String[]>> ldevInfoEccGroupMap = ldevInfo.getMatchedSameAllRecordMap("ECC Group");
        for (String eccGroup : eccGroupList) {
            String[] oneRecord = new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"pg")).intValue()] = eccGroup;
            if (this.isInternalGroup(eccGroup)) {
                String acceleratedCompression;
                String encryption;
                String raidConcatenation2;
                String raidConcatenation1;
                String raidConcatenation0;
                String driveTypeCode;
                String dkb;
                String[] pdevInfoRecord = pdevInfo.getMatchedOneRecord(eccGroup, "ECC Group");
                ArrayList<String> dkaList = new ArrayList();
                List<String> allMachedEccGroupList = pdevInfo.getMatchedAllRecordColumnValue(eccGroup, "ECC Group", "ECC Group");
                dkaList = pdevInfo.getDkaValueSet(allMachedEccGroupList);
                Collections.sort(dkaList);
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"dkb")).intValue()] = dkb = SJdtRPTDTUtils.getAddSeparatorStr(dkaList, ";");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "RAID Level");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Resource Group Name (ECC Group)");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Resource Group ID (ECC Group)");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Emulation Type");
                List<String> driveTypeCodeList = pdevInfo.getMatchedAllRecordColumnValueSet(allMachedEccGroupList, "ECC Group", "Device Type-Code");
                Collections.sort(driveTypeCodeList);
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = driveTypeCode = SJdtRPTDTUtils.getAddSeparatorStr(driveTypeCodeList, ";");
                String deviceType = pdevInfo.getValue(pdevInfoRecord, "Device Type");
                String rpm = pdevInfo.getValue(pdevInfoRecord, "RPM");
                String pdevLocation = pdevInfo.getValue(pdevInfoRecord, "PDEV Location");
                String ssdDeviceType = ssdDriveInfo.getSsdDriveTypeStr(deviceType, pdevLocation);
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"driveTypeRpm")).intValue()] = this.getDriveTypeRpm(ssdDeviceType, rpm);
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation0")).intValue()] = raidConcatenation0 = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "RAID Concatenation#0"));
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation1")).intValue()] = raidConcatenation1 = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "RAID Concatenation#1"));
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation2")).intValue()] = raidConcatenation2 = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "RAID Concatenation#2"));
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"encryption")).intValue()] = encryption = pdevInfo.getValue(pdevInfoRecord, "Encryption");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"acceleratedCompression")).intValue()] = pdevInfo.isColumnExist("Accelerated Compression") ? (acceleratedCompression = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "Accelerated Compression"))) : "";
            } else {
                String driveTypeCode;
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"dkb")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = "";
                String[] eLunInfoRecord = eLunInfoEccGroupMap.get(eccGroup);
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = eLunInfo.getValue(eLunInfoRecord, "Resource Group Name (ECC Group)");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = eLunInfo.getValue(eLunInfoRecord, "Resource Group ID (ECC Group)");
                ArrayList<String> driveTypeCodeList = new ArrayList<String>();
                driveTypeCodeList.add(eLunInfo.getValue(eLunInfoRecord, "Vendor"));
                driveTypeCodeList.add(eLunInfo.getValue(eLunInfoRecord, "Product Name"));
                driveTypeCodeList.add(eLunInfo.getValue(eLunInfoRecord, "Serial Number#"));
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = driveTypeCode = SJdtRPTDTUtils.getAddSeparatorStr(driveTypeCodeList, ":");
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"driveTypeRpm")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation0")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation1")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation2")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"encryption")).intValue()] = "-";
                oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"acceleratedCompression")).intValue()] = "-";
            }
            List<String[]> ldevInfoRecordList = ldevInfoEccGroupMap.get(eccGroup);
            oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"numberOfLdevsTotal")).intValue()] = String.valueOf(ldevInfoRecordList.size());
            oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = ldevInfo.getSumSize(ldevInfoRecordList, "Volume Size(MB)");
            List<String[]> ldevInfoUnallocatedRecordList = ldevInfo.getUnallocatedRecordList(ldevInfoRecordList);
            oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"numberOfLdevsUnallocated")).intValue()] = String.valueOf(ldevInfoUnallocatedRecordList.size());
            oneRecord[((Integer)SJdtHMArraygroupReportGenerator.headerMap.get((Object)"unallocatedLdevCapacity")).intValue()] = ldevInfo.getSumSize(ldevInfoUnallocatedRecordList, "Volume Size(MB)");
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

