/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtELunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtJnlInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMfDMInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtMpbladeReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Mpblade";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"mpBladeId", "mpBladeName", "module", "autoAssignment", "numberOfResourcesLdev", "numberOfResourcesJournal", "numberOfResourcesExternalVolume", "numberOfResourcesTotal"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"mpUnitId", "autoAssignment", "numberOfResourcesLdev", "numberOfResourcesJournal", "numberOfResourcesExternalVolume", "numberOfResourcesTotal"};
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Mpblade";
    private static final String EXPLANATION_KEY = "Common.explanation.Mpblade";
    private static final String TABLE_HEADER_BASE_KEY = "Mpblade.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Mpblade.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Mpblade.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Mpblade.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Mpblade.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Mpblade.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Mpblade.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtELunInfoCSVWrapper eLunInfo = (SJdtELunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ELunInfo.csv");
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        SJdtJnlInfoCSVWrapper jnlInfo = (SJdtJnlInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("JnlInfo.csv");
        SJdtMfDMInfoCSVWrapper mfDMInfo = (SJdtMfDMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MfDMInfo.csv");
        if (SJdtRPTDTDevice.isHmdev()) {
            for (int i = 0; i < mpPcbStatus.getCsvDataListSize(); ++i) {
                String mpUId = mpPcbStatus.getValue(i, "MPU ID");
                String[] oneRecord = new String[HM_HEADER_KEY_ARRAY.length];
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"mpUnitId")).intValue()] = mpUId;
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = mpPcbStatus.getValue(i, "Auto Assignment");
                List<String[]> ldevInfoRecordList = ldevInfo.getMatchedAllRecord(mpUId, "Current MPU");
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesLdev")).intValue()] = String.valueOf(ldevInfoRecordList.size());
                List<String[]> jnlInfoRecordList = jnlInfo.getMatchedAllRecord(mpUId, "Current MPU");
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesJournal")).intValue()] = String.valueOf(jnlInfoRecordList.size());
                List<String> eccGroupList = eLunInfo.getMatchedAllRecordColumnValue(mpUId, "Current MPU", "ECC Group");
                LinkedHashSet<String> eccGroupSet = new LinkedHashSet<String>(eccGroupList);
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesExternalVolume")).intValue()] = String.valueOf(eccGroupSet.size());
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesTotal")).intValue()] = String.valueOf(ldevInfoRecordList.size() + jnlInfoRecordList.size() + eccGroupSet.size());
                tableDataList.add(oneRecord);
            }
        } else {
            for (int i = 0; i < mpPcbStatus.getCsvDataListSize(); ++i) {
                String mpPcbId = mpPcbStatus.getValue(i, "MP PCB ID");
                String mpPcbLocation = mpPcbStatus.getValue(i, "MP PCB Location");
                String mpBlade = mpPcbId + ";" + mpPcbLocation;
                String[] oneRecord = new String[HEADER_KEY_ARRAY.length];
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"mpBladeId")).intValue()] = mpPcbId;
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"mpBladeName")).intValue()] = mpPcbLocation;
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"module")).intValue()] = mpPcbStatus.getValue(i, "Module#");
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = mpPcbStatus.getValue(i, "Auto Assignment");
                List<String[]> ldevInfoRecordList = ldevInfo.getMatchedAllRecord(mpBlade, "Current MP Blade");
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesLdev")).intValue()] = String.valueOf(ldevInfoRecordList.size());
                List<String[]> jnlInfoRecordList = jnlInfo.getMatchedAllRecord(mpBlade, "Current MP Blade");
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesJournal")).intValue()] = String.valueOf(jnlInfoRecordList.size());
                List<String> eccGroupList = eLunInfo.getMatchedAllRecordColumnValue(mpBlade, "Current MP Blade", "ECC Group");
                LinkedHashSet<String> eccGroupSet = new LinkedHashSet<String>(eccGroupList);
                List<String[]> mVolGroupList = mfDMInfo.getMatchedAllRecord(mpBlade, "Current MP Blade");
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesExternalVolume")).intValue()] = String.valueOf(eccGroupSet.size() + mVolGroupList.size());
                oneRecord[((Integer)SJdtMpbladeReportGenerator.headerMap.get((Object)"numberOfResourcesTotal")).intValue()] = String.valueOf(ldevInfoRecordList.size() + jnlInfoRecordList.size() + eccGroupSet.size() + mVolGroupList.size());
                tableDataList.add(oneRecord);
            }
        }
        return tableDataList;
    }
}

