/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCacheInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtChaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkcInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtHduInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMicroVersionCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.Pdev;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;

public class SJdtPhysicalReportGenerator
extends SJdtReportGeneratorBase {
    private static Logger logger = Logger.getLogger(SJdtPhysicalReportGenerator.class.getName());
    private static final String REPORT_NAME = "Physical";
    private static final boolean IS_GRAPHIC_REPORT = true;
    private static final boolean USE_TABLE_SORT = false;
    private static final boolean USE_CONTENTS_FOOTER = true;
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Physical";
    private static final String EXPLANATION_KEY = "Common.explanation.Physical";
    public static final String VM_LIBLARY_PATH = "/sanproject/sn2/rptdt/template/physical/vm/VM_physical_library.vm";
    private static final String COMMON_DIR = SJdtReportGeneratorManager.outputDir + "common" + File.separator;
    private static final String COMMON_CSS_DIR = COMMON_DIR + "css" + File.separator;
    public static final String CONTENTS_TITLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsTitle_Physical.vm";
    public static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsBody_Physical.vm";
    private static final String CONTENTS_FOOTER_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsFooter_Physical.vm";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Physical.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Physical.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Physical.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Physical.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Physical.html";
    private static final String CONTENTS_FOOTER_HTML_FILE_NAME = "contentsFooter_Physical.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Physical.html";
    private static final String CONTENTS_MENU_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsMenu_Physical.vm";
    private static final String[] moduleNumberArray = new String[]{"0", "1"};
    private static final String[] dkuNumberArray = new String[]{"0", "1", "2", "3", "4", "5"};
    private static final String[] pdevLocationSuffixArray6 = new String[]{"00", "01", "02", "03", "04", "05"};
    private static final String[] pdevLocationSuffixArray10 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
    private static final String[] pdevLocationSuffixArray12 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11"};
    private static final String[] pdevLocationSuffixArray16 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F"};
    private static final String[] pdevLocationSuffixArray24 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private static final String DEVICE_CAPACITY_REGEX = "^[\\dPT]{2,4}$";
    private static final String DEVICE_CAPACITY_RAW_REGEX = "^[\\dT\\.]{2,5}$";
    private static final String DEVICE_CAPACITY_STR_REGEX = "^[\\dT\\.]{2,4}$";
    private static final String DKU_TYPE_SBX = "SBX";
    private static final String DKU_TYPE_UBX = "UBX";
    private static final String DKU_TYPE_FBX = "FBX";
    private static final String SLOTSIZE_2_5 = "2.5";
    private static final int SBX_HEIGHT = 423;
    private static final int UBX_HEIGHT = 423;
    private static final int FBX_HEIGHT = 279;
    protected static final String CONTENTS_FRAMESET_4PANE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsFrameset_4pane.vm";
    private static final String CONTENTS_MENU_HTML_FILE_NAME = "contentsMenu_Physical.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return true;
    }

    @Override
    public boolean useTableSort() {
        return false;
    }

    @Override
    public boolean useContentsFooter() {
        return true;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    public String getContentsMenuHtmlFileName() {
        return CONTENTS_MENU_HTML_FILE_NAME;
    }

    @Override
    public void generateReportDir() {
        super.generateReportDir();
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_CSS_DIR);
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_IMG_DIR);
    }

    @Override
    public void generateReportFrameset() throws SJdtRPTDTException {
        super.generateReportFrameset();
    }

    @Override
    public void generateContentsFrameset() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("contentsTitleName", (Object)this.getReportName());
            context.put("contentsBodyName", (Object)this.getReportName());
            context.put("contentsFooterName", (Object)this.getReportName());
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsFramesetHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FRAMESET_4PANE_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107104");
            throw e;
        }
    }

    @Override
    public void generateContentsTitle() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("libraryPath", (Object)VM_LIBLARY_PATH);
            context.put("contensTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getMenuLinkViewKey()));
            context.put("explanation", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getExplanationKey()));
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsTitleHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_TITLE_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107105");
            throw e;
        }
    }

    @Override
    public void generateContentsFooter() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("sas", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.sas"));
            context.put("ssd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.ssd"));
            context.put("spare", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.spare"));
            context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.notInstalled"));
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + CONTENTS_FOOTER_HTML_FILE_NAME;
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FOOTER_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107106");
            throw e;
        }
    }

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFrontFilePath);
        String cssFileName = "contentsBody_Physical.css";
        String originalFilePath = "/sanproject/sn2/rptdt/template/physical/css/" + cssFileName;
        String destFilePath = this.OUTPUT_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        SJdtReportGeneratorManager.copyAllFile(this, "/physical/img/", this.OUTPUT_IMG_DIR);
    }

    @Override
    public void generateContentsMenu() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        context.put("targetHtmlName", (Object)CONTENTS_BODY_HTML_FILE_NAME);
        String cssFileName = "contentsMenu.css";
        String originalCssFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
        String destCssFilePath = COMMON_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalCssFilePath, destCssFilePath);
        this.setCntentsMenuDkuInfo(context);
        String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsMenuHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_MENU_VM_FILE_PATH, generateFrontFilePath);
    }

    public void setFixedStr(VelocityContext context) {
        context.put("frontView", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.frontView"));
        context.put("backView", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.backView"));
        context.put("storageSystemType", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.storageSystemType"));
        context.put("microcodeVersion", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.microcodeVersion"));
        context.put("module", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.module"));
        context.put("dkc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.dkc"));
        context.put("dku", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.dku"));
        context.put("diskunit", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.diskunit"));
        context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.notInstalled"));
    }

    public void setVariableStr(VelocityContext context) {
        this.setSummaryInfo(context);
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        boolean useDkc1Flg = mpPcbStatus.existsModule1Data();
        context.put("useDkc1Flg", (Object)useDkc1Flg);
        this.setDkcInfo(context, useDkc1Flg);
        this.setDkuInfo(context, useDkc1Flg);
    }

    public void setSummaryInfo(VelocityContext context) {
        SJdtMicroVersionCSVWrapper microVersion = (SJdtMicroVersionCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MicroVersion.csv");
        SJdtDkcInfoCSVWrapper dkcInfo = (SJdtDkcInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkcInfo.csv");
        String[] dkcInfoRecord = dkcInfo.getRecord(0);
        String storageSystemType = dkcInfo.getValue(dkcInfoRecord, "Storage System Type");
        context.put("valueOfFrontStorageSystemType", (Object)storageSystemType);
        String serialNumber = dkcInfo.getValue(dkcInfoRecord, "Serial Number#");
        if (serialNumber.length() == 10) {
            context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.fullSerialNumber"));
        } else {
            context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.serialNumber"));
        }
        context.put("valueOfFrontSerialNumber", (Object)serialNumber);
        String[] microVersionRecord = microVersion.getRecord(0);
        String dkcmain = microVersion.getValue(microVersionRecord, "DKCMAIN");
        context.put("valueOfFrontMicrocodeVersion", (Object)dkcmain);
    }

    public void setDkcInfo(VelocityContext context, boolean useDkc1Flg) {
        SJdtCacheInfoCSVWrapper cacheInfo = (SJdtCacheInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("CacheInfo.csv");
        SJdtChaStatusCSVWrapper chaStatus = (SJdtChaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ChaStatus.csv");
        SJdtDkaStatusCSVWrapper dkaStatus = (SJdtDkaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkaStatus.csv");
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        HashMap<String, Boolean> dkcAllMap = new HashMap<String, Boolean>();
        for (String moduleNumber : moduleNumberArray) {
            List<String[]> cacheInfoRecordList = cacheInfo.getMatchedAllRecord(moduleNumber, "Module#");
            for (String[] cacheInfoRecord : cacheInfoRecordList) {
                String cmDimmSize = cacheInfo.getValue(cacheInfoRecord, "CM DIMM Size(GB)");
                String cacheSize = cacheInfo.getValue(cacheInfoRecord, "Cache Size(GB)");
                String smSize = cacheInfo.getValue(cacheInfoRecord, "SM Size(GB)");
                String cacheResidencySize = cacheInfo.getValue(cacheInfoRecord, "Cache Residency Size(MB)");
                if (!StringUtils.isNotEmpty((String)cmDimmSize) && !StringUtils.isNotEmpty((String)cacheSize) && !StringUtils.isNotEmpty((String)smSize) && !StringUtils.isNotEmpty((String)cacheResidencySize)) continue;
                String locationKey = cacheInfo.getValue(cacheInfoRecord, "Cache Location");
                dkcAllMap.put(locationKey, Boolean.TRUE);
            }
            List<String> mpPcbLocationList = mpPcbStatus.getMatchedAllRecordColumnValue(moduleNumber, "Module#", "MP PCB Location");
            for (String mpPcbLocation : mpPcbLocationList) {
                dkcAllMap.put(mpPcbLocation, Boolean.TRUE);
            }
            List<String> chaLocationList = chaStatus.getMatchedAllRecordColumnValue(moduleNumber, "Module#", "CHA Location");
            for (String chaLocation : chaLocationList) {
                dkcAllMap.put(chaLocation, Boolean.TRUE);
            }
            List<String> dkaLocationList = dkaStatus.getMatchedAllRecordColumnValue(moduleNumber, "Module#", "DKA Location");
            for (String dkaLocation : dkaLocationList) {
                dkcAllMap.put(dkaLocation, Boolean.TRUE);
            }
            if (!useDkc1Flg) break;
        }
        context.put("dkcAllMap", dkcAllMap);
    }

    public void setDkuInfo(VelocityContext context, boolean useDkc1Flg) {
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        HashMap<String, Boolean> dkuNotInstalledAllMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> hduNotInstalledAllMap = new HashMap<String, Boolean>();
        HashMap<String, HashMap<String, Pdev>> hduAllMap = new HashMap<String, HashMap<String, Pdev>>();
        HashMap<String, String> dkuTypeMap = new HashMap<String, String>();
        HashMap<String, Integer> dkuTopSizeMap = new HashMap<String, Integer>();
        HashMap<String, String> dkuBackImageMap = new HashMap<String, String>();
        for (String moduleNumber : moduleNumberArray) {
            for (String dkuNumber : dkuNumberArray) {
                String dkuIdNumber = moduleNumber + dkuNumber;
                String hdu = "HDU" + dkuIdNumber;
                List<String[]> hduInfoRecordList = hduInfo.getPrefixMatchedAllRecord(hdu, "HDU Location");
                int dkuTopSize = this.getDkuTopSize(hduInfoRecordList);
                dkuTopSizeMap.put(dkuIdNumber, dkuTopSize);
                String dkuTypeForBackImage = this.getdkuTypeForBackImage(hduInfoRecordList);
                dkuBackImageMap.put(dkuIdNumber, dkuTypeForBackImage);
                if (hduInfo.isAllHduNotInstalled(hduInfoRecordList)) {
                    dkuNotInstalledAllMap.put("dku" + dkuIdNumber + "NotInstalledFlg", Boolean.TRUE);
                    continue;
                }
                this.setHduInfo(hduNotInstalledAllMap, hduAllMap, hduInfoRecordList, dkuTypeMap);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            this.printPhysicalInfo(dkuNotInstalledAllMap, hduNotInstalledAllMap, hduAllMap);
        }
        context.put("dkuNotInstalledAllMap", dkuNotInstalledAllMap);
        context.put("hduNotInstalledAllMap", hduNotInstalledAllMap);
        context.put("hduAllMap", hduAllMap);
        context.put("dkuTypeMap", dkuTypeMap);
        context.put("dkuTopSizeMap", dkuTopSizeMap);
        context.put("dkuBackImageMap", dkuBackImageMap);
    }

    public void setHduInfo(HashMap<String, Boolean> hduNotInstalledAllMap, HashMap<String, HashMap<String, Pdev>> hduAllMap, List<String[]> hduInfoRecordList, HashMap<String, String> dkuTypeMap) {
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        for (String[] hduInfoRecord : hduInfoRecordList) {
            String[] pdevLocationSuffixArray;
            String hduLocation = hduInfo.getValue(hduInfoRecord, "HDU Location");
            String hduLocationAsLowerCase = hduLocation.toLowerCase();
            String hduStatus = hduInfo.getValue(hduInfoRecord, "HDU Status");
            String dkuType = this.getDkuType(hduInfoRecord);
            if (!hduStatus.equals("Installed")) {
                hduNotInstalledAllMap.put(hduLocationAsLowerCase + "NotInstalledFlg", Boolean.TRUE);
                continue;
            }
            HashMap<String, Pdev> hduMap = new HashMap<String, Pdev>();
            for (String pdevLocationSuffix : pdevLocationSuffixArray = this.getPdevLocationSuffixArray(dkuType)) {
                String location = hduLocation.replaceFirst("HDU", "");
                String pdevLocation = "HDD" + location + "-" + pdevLocationSuffix;
                String[] pdevInfoRecord = pdevInfo.getMatchedExistsOneRecord(pdevLocation, "PDEV Location");
                if (pdevInfoRecord == null) {
                    hduMap.put(pdevLocationSuffix, new Pdev());
                    continue;
                }
                String deviceType = pdevInfo.getValue(pdevInfoRecord, "Device Type");
                String deviceCapacity = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                String eccGroup = pdevInfo.getValue(pdevInfoRecord, "ECC Group");
                Pdev pdev = new Pdev();
                pdev.setDeviceType(deviceType);
                pdev.setDeviceCapacity(this.getDeviceCapacityAsCharArray(deviceCapacity));
                pdev.setEccGroup(eccGroup);
                pdev.setSpareFlg(eccGroup);
                pdev.setDeviceCapacityRaw(this.getDeviceCapacityRawAsCharArray(deviceCapacity));
                pdev.setDeviceCapacityStr(this.getDeviceCapacityAsStr(deviceCapacity));
                hduMap.put(pdevLocationSuffix, pdev);
            }
            hduAllMap.put(hduLocationAsLowerCase, hduMap);
            dkuTypeMap.put(hduLocationAsLowerCase, dkuType);
        }
    }

    public String[] getPdevLocationSuffixArray(String dkuType) {
        String[] pdevLocationSuffixArray = null;
        if (dkuType.equals(DKU_TYPE_SBX)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray24;
        } else if (dkuType.equals(DKU_TYPE_UBX)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray12;
        } else if (dkuType.equals(DKU_TYPE_FBX)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray6;
        } else {
            logger.warning("DKU Type is unexpected. DKU Type : " + dkuType);
            pdevLocationSuffixArray = pdevLocationSuffixArray24;
        }
        return pdevLocationSuffixArray;
    }

    public String getDkuType(String[] hduInfoRecord) {
        String result = "";
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        String dkuType = hduInfo.getValue(hduInfoRecord, "DKU Type");
        if (dkuType.equals(DKU_TYPE_SBX)) {
            result = DKU_TYPE_SBX;
        } else if (dkuType.equals(DKU_TYPE_UBX)) {
            result = DKU_TYPE_UBX;
        } else if (dkuType.equals(DKU_TYPE_FBX)) {
            result = DKU_TYPE_FBX;
        } else {
            logger.warning("DKU Type is unexpected. DKU Type : " + dkuType);
            result = dkuType;
        }
        return result;
    }

    public String getDkuTypeForSlotSize(String slotSize) {
        String result = "";
        result = slotSize.equals(SLOTSIZE_2_5) ? DKU_TYPE_SBX : DKU_TYPE_UBX;
        return result;
    }

    public int getDkuTopSize(List<String[]> hduInfoRecordList) {
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        int topSize = 423;
        for (String[] hduInfoRecord : hduInfoRecordList) {
            String dkuType = hduInfo.getValue(hduInfoRecord, "DKU Type");
            if (dkuType.equals(DKU_TYPE_SBX)) {
                topSize = 423;
                break;
            }
            if (dkuType.equals(DKU_TYPE_UBX)) {
                topSize = 423;
                break;
            }
            if (!dkuType.equals(DKU_TYPE_FBX)) continue;
            topSize = 279;
            break;
        }
        return topSize;
    }

    public String getdkuTypeForBackImage(List<String[]> hduInfoRecordList) {
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        String dkuType = "";
        for (String[] hduInfoRecord : hduInfoRecordList) {
            dkuType = hduInfo.getValue(hduInfoRecord, "DKU Type");
            if (dkuType.equals(DKU_TYPE_SBX)) {
                return dkuType;
            }
            if (dkuType.equals(DKU_TYPE_UBX)) {
                return dkuType;
            }
            if (!dkuType.equals(DKU_TYPE_FBX)) continue;
            return dkuType;
        }
        return dkuType;
    }

    public char[] getDeviceCapacityAsCharArray(String deviceCapacity) {
        char[] result = null;
        if (StringUtils.isNotEmpty((String)deviceCapacity)) {
            String tempStr = deviceCapacity.replaceAll("GB", "");
            tempStr = tempStr.replaceAll("TB", "T");
            if ((tempStr = tempStr.replaceAll("\\.", "P")).matches(DEVICE_CAPACITY_REGEX)) {
                result = tempStr.toCharArray();
            }
        }
        return result == null ? new char[]{} : result;
    }

    public char[] getDeviceCapacityRawAsCharArray(String deviceCapacity) {
        char[] result = null;
        if (StringUtils.isNotEmpty((String)deviceCapacity)) {
            String tempStr = deviceCapacity.replaceAll("GB", "");
            if ((tempStr = tempStr.replaceAll("TB", "T")).matches(DEVICE_CAPACITY_RAW_REGEX)) {
                result = tempStr.toCharArray();
            }
        }
        return result == null ? new char[]{} : result;
    }

    public String getDeviceCapacityAsStr(String deviceCapacity) {
        String result = "";
        if (StringUtils.isNotEmpty((String)deviceCapacity)) {
            String tempStr = deviceCapacity.replaceAll("GB", "");
            if ((tempStr = tempStr.replaceAll("TB", "T")).matches(DEVICE_CAPACITY_STR_REGEX)) {
                result = tempStr;
            }
        }
        return result;
    }

    public void printPhysicalInfo(HashMap<String, Boolean> dkuNotInstalledAllMap, HashMap<String, Boolean> hduNotInstalledAllMap, HashMap<String, HashMap<String, Pdev>> hduAllMap) {
        logger.fine("+--- dkuXXNotInstalled ------------ +");
        ArrayList<String> dkuNotInstalledKeyList = new ArrayList<String>(dkuNotInstalledAllMap.keySet());
        Collections.sort(dkuNotInstalledKeyList, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                String value1 = (String)object1;
                String value2 = (String)object2;
                return value1.compareTo(value2);
            }
        });
        for (String key : dkuNotInstalledKeyList) {
            logger.fine(key);
        }
        logger.fine("+---------------------------------- +");
        logger.fine("+--- hduXXXNotInstalled ----------- +");
        ArrayList<String> hduNotInstalledKeyList = new ArrayList<String>(hduNotInstalledAllMap.keySet());
        Collections.sort(hduNotInstalledKeyList, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                String value1 = (String)object1;
                String value2 = (String)object2;
                return value1.compareTo(value2);
            }
        });
        for (String key : hduNotInstalledKeyList) {
            logger.fine(key);
        }
        logger.fine("+---------------------------------- +");
        logger.fine("+--- hdu -------------------------- +");
        ArrayList<String> hduKeyList = new ArrayList<String>(hduAllMap.keySet());
        Collections.sort(hduKeyList, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                String value1 = (String)object1;
                String value2 = (String)object2;
                return value1.compareTo(value2);
            }
        });
        for (String key : hduKeyList) {
            HashMap<String, Pdev> map = hduAllMap.get(key);
            ArrayList<String> hduList = new ArrayList<String>(map.keySet());
            Collections.sort(hduList, new Comparator<Object>(){

                @Override
                public int compare(Object object1, Object object2) {
                    String value1 = (String)object1;
                    String value2 = (String)object2;
                    return value1.compareTo(value2);
                }
            });
            logger.fine(key);
            for (String hdu : hduList) {
                Pdev pdev = map.get(hdu);
                logger.fine("  " + hdu + " : " + pdev.toString());
            }
        }
    }

    public void setCntentsMenuDkuInfo(VelocityContext context) {
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        boolean useDkc1Flg = mpPcbStatus.existsModule1Data();
        context.put("useDkc1Flg", (Object)useDkc1Flg);
        HashMap<String, Boolean> dkuNotInstalledAllMap = new HashMap<String, Boolean>();
        for (String moduleNumber : moduleNumberArray) {
            for (String dkuNumber : dkuNumberArray) {
                String dkuIdNumber = moduleNumber + dkuNumber;
                String hdu = "HDU" + dkuIdNumber;
                List<String[]> hduInfoRecordList = hduInfo.getPrefixMatchedAllRecord(hdu, "HDU Location");
                if (!hduInfo.isAllHduNotInstalled(hduInfoRecordList)) continue;
                dkuNotInstalledAllMap.put("dku" + dkuIdNumber + "NotInstalledFlg", Boolean.TRUE);
            }
        }
        context.put("dkuNotInstalledAllMap", dkuNotInstalledAllMap);
    }
}

