/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.main.SJdtRPTDTMain;

public class SJdtRPTDTUtils {
    private static Logger logger = Logger.getLogger(SJdtRPTDTUtils.class.getName());
    private static final String MEMORY_FORMAT = "%12s";
    private static final String RATIO_FORMAT = "%4s";
    private static DecimalFormat MEMORY_UNIT_FORMRAT = new DecimalFormat("#,###KB");
    private static DecimalFormat RATIO_UNIT_FORMAT = new DecimalFormat("#0.0");

    public static String getMemoryInfo() {
        StringBuilder sb = new StringBuilder();
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long used = total - free;
        double ratio = (double)(used * 100L) / (double)max;
        sb.append("used/total/max=");
        sb.append("[");
        sb.append(String.format(MEMORY_FORMAT, MEMORY_UNIT_FORMRAT.format(used)));
        sb.append("(").append(String.format(RATIO_FORMAT, RATIO_UNIT_FORMAT.format(ratio))).append("%)").append("/");
        sb.append(String.format(MEMORY_FORMAT, MEMORY_UNIT_FORMRAT.format(total))).append("/");
        sb.append(String.format(MEMORY_FORMAT, MEMORY_UNIT_FORMRAT.format(max)));
        sb.append("]");
        return sb.toString();
    }

    public static String setEndPathSeparator(String path) {
        String result = path;
        if (path != null && !path.endsWith(File.separator)) {
            result = path + File.separator;
        }
        return result;
    }

    public static Properties getPropertyData(String filePath) throws IOException {
        Properties proc = new Properties();
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = SJdtRPTDTUtils.class.getClass().getResourceAsStream(filePath);
            bis = new BufferedInputStream(is);
            proc.load(is);
        }
        catch (IOException e) {
            logger.severe("filePath=[" + filePath + "]");
            throw e;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
        return proc;
    }

    public static Object getInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object obj = null;
        try {
            Class<?> clazz = Class.forName(className);
            obj = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.severe("className=[" + className + "]");
            throw e;
        }
        catch (InstantiationException e) {
            logger.severe("className=[" + className + "]");
            throw e;
        }
        catch (IllegalAccessException e) {
            logger.severe("className=[" + className + "]");
            throw e;
        }
        return obj;
    }

    public static List<String> getMapToList(Map<String, String> map) {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> keys = map.keySet();
        for (String value : keys) {
            result.add(value);
        }
        return result;
    }

    public static String getAddSeparatorStr(List<String> list, String separator) {
        String str = StringUtils.join(list, (String)separator);
        while (str.endsWith(separator)) {
            str = StringUtils.removeEnd((String)str, (String)separator);
        }
        return str;
    }

    public static boolean containsTrue(Boolean[] boolArray) {
        if (boolArray == null) {
            return false;
        }
        boolean result = false;
        for (Boolean bool : boolArray) {
            if (!BooleanUtils.isTrue((Boolean)bool)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getPrintStackTrace(Throwable th) {
        StringWriter sw = new StringWriter();
        th.printStackTrace(new PrintWriter(sw));
        StringBuffer buf = sw.getBuffer();
        int i = buf.lastIndexOf(SJdtRPTDTMain.LINE_SEPARATOR);
        buf.delete(i, buf.length());
        return sw.toString();
    }

    public static void deleteAllFile(String dirPath) {
        String target = null;
        try {
            File[] files;
            File dir = new File(dirPath);
            if (!dir.exists()) {
                return;
            }
            SJdtRPTDTUtils.printDirStructureInfo(dir, Level.SEVERE);
            for (File file : files = dir.listFiles()) {
                target = file.getAbsolutePath();
                if (SJdtRPTDTUtils.deleteAllFile(file)) continue;
                logger.warning("Failed to delete files [" + target + "]");
                break;
            }
        }
        catch (Throwable e) {
            logger.warning("Failed to delete files [" + target + "]");
            logger.warning(SJdtRPTDTUtils.getPrintStackTrace(e));
        }
    }

    public static boolean deleteAllFile(File file) {
        File[] files;
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        for (File f : files = file.listFiles()) {
            if (SJdtRPTDTUtils.deleteAllFile(f)) continue;
            return false;
        }
        return file.delete();
    }

    public static void printDirStructureInfo(File dir, Level logLevel) {
        logger.log(logLevel, "Directory Structure Infomation" + SJdtRPTDTMain.LINE_SEPARATOR + SJdtRPTDTUtils.getDirStructureInfo(dir));
    }

    public static String getDirStructureInfo(File dir) {
        StringBuilder sb = new StringBuilder();
        try {
            SJdtRPTDTUtils.putDirStructureInfo(dir, 0, sb);
        }
        catch (RuntimeException e) {
            logger.warning(SJdtRPTDTUtils.getPrintStackTrace(e));
        }
        return sb.toString();
    }

    private static void putDirStructureInfo(File file, int indentCount, StringBuilder sb) {
        for (int i = 0; i < indentCount; ++i) {
            sb.append("  ");
        }
        if (file.isDirectory()) {
            sb.append("[").append(file.getName()).append("]" + SJdtRPTDTMain.LINE_SEPARATOR);
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                SJdtRPTDTUtils.putDirStructureInfo(fileList[i], indentCount + 1, sb);
            }
        } else {
            sb.append(file.getName() + SJdtRPTDTMain.LINE_SEPARATOR);
        }
    }
}

