/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.coma.common;

import com.sun.net.httpserver.HttpExchange;
import com.ws.wbem.jserver.embed.Headers;
import com.ws.wbem.jserver.embed.HttpConnection;
import com.ws.wbem.jserver.embed.HttpPrincipal;
import com.ws.wbem.server.adapters.coma.common.HeadersImpl;
import com.ws.wbem.server.adapters.coma.common.HttpPrincipalImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;

public class HttpConnectionImpl
implements HttpConnection {
    private final HttpExchange exchange;
    private HttpPrincipal principal;
    private Headers reqHeaders;
    private Headers rspHeaders;

    public HttpConnectionImpl(HttpExchange httpExchange) throws NullPointerException {
        if (null == httpExchange) {
            throw new NullPointerException("Exchange must not be null");
        }
        this.exchange = httpExchange;
        this.principal = null;
        this.rspHeaders = null;
        this.reqHeaders = null;
    }

    public void close() {
        this.exchange.close();
    }

    public Object getAttribute(String string) {
        return this.exchange.getAttribute(string);
    }

    public InetSocketAddress getLocalAddress() {
        return this.exchange.getLocalAddress();
    }

    public HttpPrincipal getPrincipal() {
        if (null == this.principal) {
            this.principal = new HttpPrincipalImpl(this.exchange.getPrincipal());
        }
        return this.principal;
    }

    public String getProtocol() {
        return this.exchange.getProtocol();
    }

    public HttpExchange getRawConnectionObject() {
        return this.exchange;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.exchange.getRemoteAddress();
    }

    public InputStream getRequestBody() {
        return this.exchange.getRequestBody();
    }

    public Headers getRequestHeaders() {
        if (null == this.reqHeaders) {
            this.reqHeaders = new HeadersImpl(this.exchange.getRequestHeaders());
        }
        return this.reqHeaders;
    }

    public String getRequestMethod() {
        return this.exchange.getRequestMethod();
    }

    public URI getRequestURI() {
        return this.exchange.getRequestURI();
    }

    public OutputStream getResponseBody() {
        return this.exchange.getResponseBody();
    }

    public int getResponseCode() {
        return this.exchange.getResponseCode();
    }

    public Headers getResponseHeaders() {
        if (null == this.rspHeaders) {
            this.rspHeaders = new HeadersImpl(this.exchange.getResponseHeaders());
        }
        return this.rspHeaders;
    }

    public void sendResponseHeaders(int n, long l) throws IOException {
        this.exchange.sendResponseHeaders(n, l);
    }

    public void setAttribute(String string, Object object) {
        this.exchange.setAttribute(string, object);
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream) {
        this.exchange.setStreams(inputStream, outputStream);
    }
}

