/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Naming;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;
import sanproject.sn2.sn2com.utility.SJsncVersionCheckUty;

public class SJbaseGUMAuthentication
implements SJbaseAuthenticationModulePluginInterface {
    private static final String LOG_FUNC = SJbaseGUMAuthentication.class.getSimpleName();
    private static final String LOG_TITLE = "GUM Authentication";
    private static final String SUPERVISOR_HOST = "rmi://127.0.0.1:";
    private static final String SUPERVISOR_URL = "/com.hitachi.sanproject.rmi.supervisor.rmiserver";
    private static final String KEY_VALUE_PROP_PATH = "dkcman\\cnf\\env.properties";
    private static final String KEY_VALUE_PORT_KEY = "com.hitachi.sanproject.registry.privateport";
    private static final String KEY_VALUE_PORT_NUM_DEFAULT = "11099";
    private static final String GEN_PARAM_KEY = "GeneralParameter";
    private static final String CLIENT_INFO_KEY = "ClientInfo";
    private static final String HOST_NAME_KEY = "HostName";
    private static final String STORAGE_INFO_KEY = "StorageInfo";
    private static final String MODEL_KEY = "Model";
    private static final String SERIAL_NUM_KEY = "SerialNumber";
    private static final String USER_NAME_KEY = "UserName";
    private static final String PASSWORD_KEY = "Password";
    private static final String HCS_SSO_Option_KEY = "SsoOption";
    private static final String FUNC_ID_AUTHENTICATION = "SANauthenticateStorageUser";
    private static final String ERROR_INFO_KEY = "ErrorInfo";
    private static final String ERROR_CODE_KEY = "ErrorCode";
    private static final String ACCOUNT_INFO_KEY = "AccountInfo";
    private static final String AUTH_BITMAP_KEY = "AuthBitmap";
    private static final String RSG_BITMAP_KEY = "ResourceGroupBitmap";
    private static final String ALL_RSG_KEY = "AllResourceGroup";
    private static final int GUM_AUTH_RESULT_OK = 0;
    private static final int GUM_AUTH_RESULT_NG = -1;
    private static final String SN_GUM_AUTH_OBJ_KEEP_TIME_KEY = "SN_GUM_AUTH_OBJ_KEEP_TIME";
    private static final int ROLE_MAP_SIZE = 256;
    private static final int RESOURCE_MAP_SIZE = 1024;
    private static final long NANO_SEC = 1000000000L;
    private String userName = "";
    private String password = "";
    private String sessionID = "";
    private boolean[] roleMap = null;
    private boolean[] resourceGroupMap = null;
    private boolean isAllRSG = false;
    private HashMap authObject = null;
    private SanRemote remote = null;
    private int hcsSsoOpt = 0;
    static long keepTime = 60000000000L;

    public SJbaseGUMAuthentication() {
    }

    public SJbaseGUMAuthentication(int hcsSsoOpt) {
        this.hcsSsoOpt = hcsSsoOpt;
    }

    private static void init() {
        try {
            SJbaseSystemPropertiesManager propMgr = new SJbaseSystemPropertiesManager();
            propMgr.initialize(0);
            String keepTimeStr = System.getProperty(SN_GUM_AUTH_OBJ_KEEP_TIME_KEY);
            if (null != keepTimeStr) {
                keepTime = Long.valueOf(keepTimeStr) * 1000000000L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int authentication(String szUserName, String szPassword) {
        int ret;
        block6: {
            ret = 0;
            if (null == szUserName || null == szPassword) {
                SJcLogUty.error(LOG_FUNC, LOG_TITLE, "authentication", "Arguments are invalid.");
                return 11;
            }
            SanResponse gumAuthResult = this.authenticationToGum(szUserName, szPassword);
            this.userName = szUserName;
            this.password = szPassword;
            if (null != gumAuthResult) {
                try {
                    if (this.successAuthenticate(gumAuthResult)) {
                        SanObject authInfo = gumAuthResult.getObj(ACCOUNT_INFO_KEY);
                        this.roleMap = this.bitSetToBoolArray(authInfo.getBitSet(AUTH_BITMAP_KEY), 256);
                        this.resourceGroupMap = this.bitSetToBoolArray(authInfo.getBitSet(RSG_BITMAP_KEY), 1024);
                        this.isAllRSG = authInfo.getBoolean(ALL_RSG_KEY);
                        String randomId = UUID.randomUUID().toString().replace("-", "");
                        this.sessionID = SJcSecureUty.getHashValueStringHex(szUserName + randomId).substring(0, 32);
                        ret = 0;
                        break block6;
                    }
                    SJcLogUty.error(LOG_FUNC, LOG_TITLE, "authentication", "Failed to authenticate.");
                    ret = 6;
                }
                catch (Exception e) {
                    SJcLogUty.error(LOG_FUNC, LOG_TITLE, "authentication", "An error occurred.", e);
                    ret = 11;
                }
            } else {
                SJcLogUty.error(LOG_FUNC, LOG_TITLE, "authentication", "Connection error occured.");
                ret = 8;
            }
        }
        return ret;
    }

    private SanResponse authenticationToGum(String user, String pass) {
        SanResponse result = null;
        this.updateRemoteObj();
        if (null == this.remote) {
            SJcLogUty.error(LOG_FUNC, LOG_TITLE, "authenticationToGum", "Remote Object is null.");
            return result;
        }
        try {
            SanData genParam = this.createGeneralParam();
            SanRequest reqest = this.remote.newRequest(genParam, FUNC_ID_AUTHENTICATION);
            reqest.putString(USER_NAME_KEY, user);
            reqest.putString(PASSWORD_KEY, pass);
            reqest.putInt(HCS_SSO_Option_KEY, this.hcsSsoOpt);
            result = this.remote.invoke(genParam, reqest);
        }
        catch (Exception e) {
            this.remote = null;
            SJcLogUty.error(LOG_FUNC, LOG_TITLE, "authenticationToGum", "Failed to invoke RMI.", e);
        }
        return result;
    }

    private synchronized void updateRemoteObj() {
        if (null == this.remote) {
            String cmnBasePath = SJcEnvUty.getCmnBasePath();
            String kvPropPath = cmnBasePath + KEY_VALUE_PROP_PATH;
            Properties kvProps = new Properties();
            try {
                kvProps.load(new FileInputStream(kvPropPath));
            }
            catch (IOException ioe) {
                SJcLogUty.error(LOG_FUNC, LOG_TITLE, "", "Failed to read property.", ioe);
            }
            String port = kvProps.getProperty(KEY_VALUE_PORT_KEY, KEY_VALUE_PORT_NUM_DEFAULT);
            String url = SUPERVISOR_HOST + port + SUPERVISOR_URL;
            try {
                this.remote = (SanRemote)Naming.lookup(url);
            }
            catch (Exception e) {
                this.remote = null;
                SJcLogUty.error(LOG_FUNC, LOG_TITLE, "updateRemoteObj", "Failed to lookup Supervisor RMI. URL: " + url, e);
            }
        }
    }

    private SanData createGeneralParam() throws Exception {
        SanData genParam = this.remote.newData(GEN_PARAM_KEY);
        String hostName = InetAddress.getLocalHost().getHostName();
        genParam.newObj(CLIENT_INFO_KEY).putString(HOST_NAME_KEY, hostName);
        int model = Integer.parseInt(SJsncVersionCheckUty.getVersion() + SJsncProductModelUty.getProductModel());
        genParam.newObj(STORAGE_INFO_KEY).putInt(MODEL_KEY, model);
        int serialNum = Integer.parseInt(SJcProductUty.getSerialNumber());
        genParam.getObj(STORAGE_INFO_KEY).putInt(SERIAL_NUM_KEY, serialNum);
        return genParam;
    }

    private boolean successAuthenticate(SanResponse gumAuthResult) throws Exception {
        boolean ret = false;
        if (null != gumAuthResult) {
            SanObject errorInfo = gumAuthResult.getObj(ERROR_INFO_KEY);
            int errorCode = -1;
            if (null != errorInfo) {
                errorCode = errorInfo.getInt(ERROR_CODE_KEY);
                SJcLogUty.info(LOG_FUNC, LOG_TITLE, "successAuthenticate", "ErrorCode: " + errorCode);
            } else {
                SJcLogUty.error(LOG_FUNC, LOG_TITLE, "successAuthenticate", "ErrorInfo is null");
            }
            ret = errorCode == 0;
        } else {
            SJcLogUty.error(LOG_FUNC, LOG_TITLE, "successAuthenticate", "AuthenticateInfo is null");
        }
        return ret;
    }

    private boolean[] bitSetToBoolArray(BitSet source, int size) {
        boolean[] ret = null;
        if (null != source) {
            ret = new boolean[size];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = source.get(i);
            }
        }
        return ret;
    }

    @Override
    public HashMap getAuthObject() {
        return this.authObject;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        return szSystem;
    }

    @Override
    public String[] getGroupID() {
        return null;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        return this.resourceGroupMap;
    }

    @Override
    public String[] getRoleID() {
        return null;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isAllRSG() {
        return this.isAllRSG;
    }

    @Override
    public boolean[] getRoleMap() {
        return this.roleMap;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    static {
        SJbaseGUMAuthentication.init();
    }
}

