/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashSet;
import org.slf4j.LoggerFactory;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.SJcRollingPolicy;
import sanproject.sn2.com.utility.Logger.inf.SJcCustomLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcSystemUty;

public class SJcLogger
implements SJcCustomLoggerInterface {
    private static final String SECTION_PAUSE_START = "[";
    private static final String SECTION_PAUSE_END = "]";
    private static final String NO_SLF4J_LOGGER_MSG = "Please set Log4J Logger";
    private static final String LOG_OUTPUT_PATTERN = "[%d{yy/MM/dd HH:mm:ss.SSS}][%-5level][%thread]%msg%n";
    private static final String CHAR_SET = "utf-8";
    private static final String NUMBER_SYMBOL = "_%i";
    private static final String LOG_SIZE_UNIT = "MB";
    private static final String MEMORY_SIZE_UNIT = "KB";
    private static final String LOG_ITEM_SEPARETOR = ":";
    private static final String SEARCH_TEXT = ".";
    private static final String MEMORY_SEPARETOR = "/";
    private static final String LINE_FEED_CODE = SJcEnvUty.getProperty("line.separator");
    private static final String USER_INFO_DEFAULT = "System";
    private static final int CONVERT_BYTE = 1024;
    private static final String SJCAPPENDER = "SJCAPPENDER";
    private Logger logger = null;
    private String userInfo = "System";
    private static String processInfo = null;
    private static HashSet<String> loggerNameSet = new HashSet();

    private SJcLogger() {
    }

    public SJcLogger(String path, int logSize, int logCount) {
        this.initialize(path, logSize, logCount);
    }

    private void initialize(String path, int logSize, int logCount) {
        this.setProcessInfo();
        String filePath = this.getFilePath(path);
        String filePathUP = filePath.toUpperCase();
        Logger logger = (Logger)LoggerFactory.getLogger((String)filePathUP);
        int logLevel = SJcEnvUty.getProperty2int("SN_Log_Level", 20000);
        if (logLevel == 0) {
            logLevel = Integer.MIN_VALUE;
        }
        if (loggerNameSet.contains(filePathUP)) {
            this.logger = logger;
            this.setLogLevel(logLevel);
            this.setLogSize(logSize);
            this.setLogCount(logCount);
            this.trace("LoggerUtility", this.getClass().getSimpleName(), "initialize", "Set exist logger : " + logger.getName());
            return;
        }
        Level level = Level.toLevel((int)logLevel, (Level)Level.INFO);
        logger.setLevel(level);
        if (logSize == 0 || logCount == 0) {
            this.logger = logger;
            this.trace("LoggerUtility", this.getClass().getSimpleName(), "initialize", "Set No file output logger : " + logger.getName());
            return;
        }
        LoggerContext context = logger.getLoggerContext();
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)context);
        layout.setPattern(LOG_OUTPUT_PATTERN);
        layout.start();
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName(SJCAPPENDER);
        appender.setContext((Context)context);
        appender.setFile(filePath);
        appender.setEncoding(CHAR_SET);
        appender.setImmediateFlush(true);
        appender.setLayout((Layout)layout);
        SJcRollingPolicy policy = new SJcRollingPolicy();
        String fileRotationPath = this.getRotationFilePath(path);
        fileRotationPath = fileRotationPath.replace("(", "\\(");
        fileRotationPath = fileRotationPath.replace(")", "\\)");
        policy.setFileNamePattern(fileRotationPath);
        policy.setMaxIndex(logCount);
        policy.setContext((Context)context);
        policy.setParent((FileAppender)appender);
        appender.setRollingPolicy((RollingPolicy)policy);
        policy.start();
        SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
        String size = String.valueOf(logSize) + LOG_SIZE_UNIT;
        triggerPolicy.setMaxFileSize(size);
        triggerPolicy.setContext((Context)context);
        triggerPolicy.start();
        appender.setTriggeringPolicy((TriggeringPolicy)triggerPolicy);
        appender.start();
        logger.addAppender((Appender)appender);
        this.logger = logger;
        this.info("LoggerUtility", this.getClass().getSimpleName(), "initialize", "Set new logger : " + logger.getName());
        loggerNameSet.add(filePathUP);
    }

    private void setProcessInfo() {
        if (processInfo == null) {
            processInfo = "";
            RuntimeMXBean r = ManagementFactory.getRuntimeMXBean();
            if (r != null) {
                processInfo = r.getName();
            }
        }
    }

    private String getFilePath(String path) {
        String dir = SJcEnvUty.getProperty("SN_LogPath", null);
        dir = dir == null ? SJcFileUty.concatFolderPath("logs", "others") : SJcFileUty.concatFolderPath("logs", dir);
        String logDirPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), dir);
        String result = logDirPath + path;
        return result;
    }

    private String getRotationFilePath(String path) {
        File file = new File(path);
        String fileName = file.getName();
        int separatePosition = fileName.lastIndexOf(SEARCH_TEXT);
        if (separatePosition == -1) {
            separatePosition = fileName.length();
        }
        String rotationFile = fileName.substring(0, separatePosition) + NUMBER_SYMBOL + fileName.substring(separatePosition);
        if (file.getParent() != null) {
            rotationFile = file.getParent() + SJcConst.sjc_PathSeparator + rotationFile;
        }
        return this.getFilePath(rotationFile);
    }

    private void setLogLevel(int logLevel) {
        if (this.logger == null) {
            return;
        }
        Level nowLevel = this.logger.getLevel();
        int nowLevelInt = nowLevel.toInt();
        if (nowLevelInt != logLevel) {
            Level level = Level.toLevel((int)logLevel, (Level)Level.INFO);
            this.logger.setLevel(level);
            this.logger.trace("Set new level. " + level);
        }
    }

    private void setLogSize(int logSize) {
        String size;
        if (this.logger == null) {
            return;
        }
        RollingFileAppender appender = (RollingFileAppender)this.logger.getAppender(SJCAPPENDER);
        if (appender == null) {
            return;
        }
        if (logSize == 0) {
            boolean result = this.logger.detachAppender(SJCAPPENDER);
            this.trace("LoggerUtility", this.getClass().getSimpleName(), "setLogSize", "Appender Stop" + this.logger.getName());
            return;
        }
        SizeBasedTriggeringPolicy triggeringPolicy = (SizeBasedTriggeringPolicy)appender.getTriggeringPolicy();
        if (triggeringPolicy == null) {
            return;
        }
        String maxFileSize = triggeringPolicy.getMaxFileSize();
        if (!maxFileSize.equals(size = String.valueOf(logSize) + LOG_SIZE_UNIT)) {
            triggeringPolicy.setMaxFileSize(size);
            this.trace("LoggerUtility", this.getClass().getSimpleName(), "setLogSize", "Set new size. " + size);
        }
    }

    private void setLogCount(int logCount) {
        if (this.logger == null) {
            return;
        }
        RollingFileAppender appender = (RollingFileAppender)this.logger.getAppender(SJCAPPENDER);
        if (appender == null) {
            return;
        }
        if (logCount == 0) {
            boolean result = this.logger.detachAppender(SJCAPPENDER);
            this.trace("LoggerUtility", this.getClass().getSimpleName(), "setLogCount", "Appender Stop" + this.logger.getName());
            return;
        }
        FixedWindowRollingPolicy rollingPolicy = (FixedWindowRollingPolicy)appender.getRollingPolicy();
        if (rollingPolicy == null) {
            return;
        }
        int maxIndex = rollingPolicy.getMaxIndex();
        if (maxIndex != logCount) {
            rollingPolicy.setMaxIndex(logCount);
            this.trace("LoggerUtility", this.getClass().getSimpleName(), "setLogCount", "Set new max index. " + logCount);
        }
    }

    @Override
    public void trace(String function, String item1, String item2, String item3) {
        if (this.logger.isTraceEnabled()) {
            this.putLog(function, item1, item2, item3, 5000);
        }
    }

    @Override
    public void trace(String function, String item1, String item2, String item3, Throwable ex) {
        if (this.logger.isTraceEnabled()) {
            this.putLog(function, item1, item2, item3, ex, 5000);
        }
    }

    @Override
    public void debug(String function, String item1, String item2, String item3) {
        if (this.logger.isDebugEnabled()) {
            this.putLog(function, item1, item2, item3, 10000);
        }
    }

    @Override
    public void debug(String function, String item1, String item2, String item3, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.putLog(function, item1, item2, item3, ex, 10000);
        }
    }

    @Override
    public void info(String function, String item1, String item2, String item3) {
        if (this.logger.isInfoEnabled()) {
            this.putLog(function, item1, item2, item3, 20000);
        }
    }

    @Override
    public void info(String function, String item1, String item2, String item3, Throwable ex) {
        if (this.logger.isInfoEnabled()) {
            this.putLog(function, item1, item2, item3, ex, 20000);
        }
    }

    @Override
    public void warn(String function, String item1, String item2, String item3) {
        if (this.logger.isWarnEnabled()) {
            this.putLog(function, item1, item2, item3, 30000);
        }
    }

    @Override
    public void warn(String function, String item1, String item2, String item3, Throwable ex) {
        if (this.logger.isWarnEnabled()) {
            this.putLog(function, item1, item2, item3, ex, 30000);
        }
    }

    @Override
    public void error(String function, String item1, String item2, String item3) {
        if (this.logger.isErrorEnabled()) {
            this.putLog(function, item1, item2, item3, 40000);
        }
    }

    @Override
    public void error(String function, String item1, String item2, String item3, Throwable ex) {
        if (this.logger.isErrorEnabled()) {
            this.putLog(function, item1, item2, item3, ex, 40000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLog(String function, String item1, String item2, String item3, Throwable ex, int level) {
        StringBuffer buf = new StringBuffer();
        buf.append(item3);
        StringWriter writer = null;
        PrintWriter pWriter = null;
        try {
            if (ex != null) {
                writer = new StringWriter();
                pWriter = new PrintWriter(writer);
                ex.printStackTrace(pWriter);
                pWriter.flush();
                writer.flush();
                buf.append(LOG_ITEM_SEPARETOR);
                buf.append(LINE_FEED_CODE);
                buf.append(writer.toString());
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (pWriter != null) {
                    pWriter.close();
                }
            }
            catch (Throwable e) {
                System.out.println("Exception occured.");
            }
        }
        this.putLog(function, item1, item2, buf.toString(), level);
    }

    @Override
    public void putLog(String function, String item1, String item2, String item3, int level) {
        StringBuffer msg = new StringBuffer();
        msg.append(SECTION_PAUSE_START);
        msg.append(function);
        msg.append(SECTION_PAUSE_END);
        msg.append(SECTION_PAUSE_START);
        msg.append(item1);
        msg.append(SECTION_PAUSE_END);
        msg.append(SECTION_PAUSE_START);
        msg.append(item2);
        msg.append(SECTION_PAUSE_END);
        msg.append(SECTION_PAUSE_START);
        msg.append(item3);
        msg.append(SECTION_PAUSE_END);
        this.putLog(msg.toString(), level);
    }

    @Override
    public void putLog(String msg, int level) {
        if (level == 5000) {
            this.trace(msg);
        } else if (level == 10000) {
            this.debug(msg);
        } else if (level == 20000) {
            this.info(msg);
        } else if (level == 30000) {
            this.warn(msg);
        } else if (level == 40000) {
            this.error(msg);
        } else {
            this.info(msg);
        }
    }

    @Override
    public void trace(String msg) {
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace(this.getUserMsg() + msg + this.getMemoryInfo());
            }
            catch (NullPointerException ex) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug(this.getUserMsg() + msg + this.getMemoryInfo());
            }
            catch (NullPointerException ex) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void info(String msg) {
        if (this.logger.isInfoEnabled()) {
            try {
                this.logger.info(this.getUserMsg() + msg + this.getMemoryInfo());
            }
            catch (NullPointerException ex) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String msg) {
        if (this.logger.isWarnEnabled()) {
            try {
                this.logger.warn(this.getUserMsg() + msg + this.getMemoryInfo());
            }
            catch (NullPointerException ex) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void error(String msg) {
        if (this.logger.isErrorEnabled()) {
            try {
                this.logger.error(this.getUserMsg() + msg + this.getMemoryInfo());
            }
            catch (NullPointerException ex) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getMemoryInfo() {
        StringBuffer result = new StringBuffer();
        long usageMem = SJcSystemUty.getUsedMemory() / 1024L;
        long commitedMem = SJcSystemUty.getCommittedMemory() / 1024L;
        long maxMem = SJcSystemUty.getMaxMemory() / 1024L;
        result.append(SECTION_PAUSE_START);
        result.append(usageMem);
        result.append(MEMORY_SIZE_UNIT).append(MEMORY_SEPARETOR);
        result.append(commitedMem);
        result.append(MEMORY_SIZE_UNIT).append(MEMORY_SEPARETOR);
        result.append(maxMem);
        result.append(MEMORY_SIZE_UNIT);
        result.append(SECTION_PAUSE_END);
        return result.toString();
    }

    private String getUserMsg() {
        StringBuffer msg = new StringBuffer();
        msg.append(SECTION_PAUSE_START);
        msg.append(processInfo);
        msg.append(SECTION_PAUSE_END);
        msg.append(SECTION_PAUSE_START);
        msg.append(this.userInfo);
        msg.append(SECTION_PAUSE_END);
        return msg.toString();
    }

    @Override
    public void setUserInfo(String userName, String sessionId) {
        this.userInfo = userName == null && sessionId == null ? USER_INFO_DEFAULT : userName + LOG_ITEM_SEPARETOR + sessionId;
    }

    @Override
    public void putLog(String msg, String level) {
    }

    @Override
    public void putlog(String msg, String level) {
    }

    @Override
    public void putlog(String function, String item1, String item2, String item3, int level) {
    }

    @Override
    public void putlog(String function, String item1, String item2, String item3, Throwable ex, int level) {
    }
}

