/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.util.HashMap;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcSessionUty {
    private static final String LOG_FUNCTION = "SJcSessionUty";
    private static final String LOG_TITLE = "SJcSessionUty";
    public static final int SSO_OPTION_INVALID = 0;
    public static final int SSO_OPTION_HCS_SSO = 1;

    private SJcSessionUty() {
    }

    public static String getIPAddress(SJbaseUserSessionInterface us) {
        String LOG_SUBTITLE = "getIPAddress";
        SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "Start.");
        String IPAddress = null;
        if (null == us) {
            SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "SJbaseUserSession is null");
            SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "End.");
            return IPAddress;
        }
        if (us.getLoginType().equals("SVP")) {
            HashMap<String, Object> authObject = us.getAuthObject();
            if (null == authObject) {
                SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "authObject is null");
            } else if (!authObject.containsKey("RDPIPAddr")) {
                SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "No IP address authentication object");
            } else {
                try {
                    IPAddress = (String)authObject.get("RDPIPAddr");
                }
                catch (Exception e) {
                    SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "Failed to get IP address of the authentication object");
                }
            }
        } else if (null != us.getAddress()) {
            IPAddress = us.getAddress().getHostAddress();
        } else {
            SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "SJbaseUserSession#address is null");
        }
        SJcLogUty.getLogger().info("SJcSessionUty", "SJcSessionUty", "getIPAddress", "End.");
        return IPAddress;
    }

    public static int getSsoOption(SJbaseUserSessionInterface us) {
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        String LOG_SUBTITLE = "getSsoOption";
        logger.info("SJcSessionUty", "SJcSessionUty", "getSsoOption", "Start.");
        int ssoOption = 0;
        if (us == null) {
            logger.warn("SJcSessionUty", "SJcSessionUty", "getSsoOption", "SJbaseUserSession is null.");
            return ssoOption;
        }
        HashMap<String, Object> authObject = us.getAuthObject();
        if (authObject != null && authObject.containsKey("HDVMTOKEN")) {
            ssoOption = 1;
        }
        logger.info("SJcSessionUty", "SJcSessionUty", "getSsoOption", "End. SsoOption = " + ssoOption);
        return ssoOption;
    }
}

