/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.SJctrControllerManager;
import sanproject.sn2.controller.com.SJctrLicenseUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLicenseDetail;
import sanproject.sn2.model.data.system.SJmoLicenseDetail;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;

public class SJctrLicenseContainer {
    public static String PPID_ODCR = "8001";
    public static String PPID_DCR = "8002";
    public static String PPID_HPAV = "8003";
    public static String PPID_DRU = "8004";
    public static String PPID_VRM = "8005";
    public static String PPID_DB_VALIDATOR = "8006";
    public static String PPID_DP = "8007";
    public static String PPID_OCVSLUSE = "8008";
    public static String PPID_LUNM = "8009";
    public static String PPID_MONITOR = "8010";
    public static String PPID_PPC = "8011";
    public static String PPID_HIHSM = "8012";
    public static String PPID_HOMRCF = "8013";
    public static String PPID_HMRCF = "8014";
    public static String PPID_QS = "8015";
    public static String PPID_HCAFE = "8016";
    public static String PPID_HCAFE2 = "8017";
    public static String PPID_SN = "8018";
    public static String PPID_SNMP = "8019";
    public static String PPID_RMI = "8020";
    public static String PPID_HORC = "8021";
    public static String PPID_HRC = "8022";
    public static String PPID_HUR = "8023";
    public static String PPID_HURMF = "8024";
    public static String PPID_HORCA = "8025";
    public static String PPID_HRCA = "8026";
    public static String PPID_UVM = "8027";
    public static String PPID_CVS = "8028";
    public static String PPID_PRM = "8029";
    public static String PPID_SHRED = "8030";
    public static String PPID_LDEVSEC = "8031";
    public static String PPID_LDEVSEC_PORTOPT = "8032";
    public static String PPID_HXRC = "8033";
    public static String PPID_DR_EXT = "8035";
    public static String PPID_HIHSM2 = "8036";
    public static String PPID_HYPERPAV = "8037";
    public static String PPID_FDM = "8038";
    public static String PPID_ENCRYPTION = "8039";
    public static String PPID_HAM = "8040";
    public static String PPID_HPF = "8042";
    public static String PPID_HDTPM = "8043";
    public static String PPID_SMIS = "8044";
    public static String PPID_DPFM = "8045";
    public static String PPID_RSG = "8046";
    public static String PPID_FCSE = "8047";
    public static String PPID_MFDT = "8048";
    public static String PPID_ODM = "8049";
    public static String PPID_DSS = "8070";
    public static String PPID_HPA = "8071";
    public static String PPID_HPA2 = "8072";
    public static String PPID_NDM = "8073";
    public static String PPID_GAD = "8074";
    public static String PPID_SO = "8075";
    public static String PPID_ATM = "8076";
    public static String PPID_MUL = "8077";
    public static String PPID_HRT = "8078";
    public static String PPID_MFHRT = "8079";
    public static String PPID_FIPS = "8080";
    public static String PPID_AFA = "8081";
    public static String PPID_DKCDC = "8082";
    public static String PPID_PWSV = "8083";
    public static String PPID_PWSV_PLUS = "8084";
    public static final String HM_PPID_ODCR = "8501";
    public static final String HM_PPID_DCR = "8502";
    public static final String HM_PPID_HPAV = "8503";
    public static final String HM_PPID_DRU = "8504";
    public static final String HM_PPID_VRM = "8505";
    public static final String HM_PPID_DB_VALIDATOR = "8506";
    public static final String HM_PPID_DP = "8507";
    public static final String HM_PPID_OCVSLUSE = "8508";
    public static final String HM_PPID_LUNM = "8509";
    public static final String HM_PPID_MONITOR = "8510";
    public static final String HM_PPID_PPC = "8511";
    public static final String HM_PPID_HIHSM = "8512";
    public static final String HM_PPID_HOMRCF = "8513";
    public static final String HM_PPID_HMRCF = "8514";
    public static final String HM_PPID_QS = "8515";
    public static final String HM_PPID_HCAFE = "8516";
    public static final String HM_PPID_HCAFE2 = "8517";
    public static final String HM_PPID_SN = "8518";
    public static final String HM_PPID_SNMP = "8519";
    public static final String HM_PPID_RMI = "8520";
    public static final String HM_PPID_HORC = "8521";
    public static final String HM_PPID_HRC = "8522";
    public static final String HM_PPID_HUR = "8523";
    public static final String HM_PPID_HURMF = "8524";
    public static final String HM_PPID_HORCA = "8525";
    public static final String HM_PPID_HRCA = "8526";
    public static final String HM_PPID_UVM = "8527";
    public static final String HM_PPID_CVS = "8528";
    public static final String HM_PPID_PRM = "8529";
    public static final String HM_PPID_SHRED = "8530";
    public static final String HM_PPID_LDEVSEC = "8531";
    public static final String HM_PPID_LDEVSEC_PORTOPT = "8532";
    public static final String HM_PPID_HXRC = "8533";
    public static final String HM_PPID_DR_EXT = "8535";
    public static final String HM_PPID_HIHSM2 = "8536";
    public static final String HM_PPID_HYPERPAV = "8537";
    public static final String HM_PPID_FDM = "8538";
    public static final String HM_PPID_ENCRYPTION = "8539";
    public static final String HM_PPID_HAM = "8540";
    public static final String HM_PPID_HPF = "8542";
    public static final String HM_PPID_HDTPM = "8543";
    public static final String HM_PPID_SMIS = "8544";
    public static final String HM_PPID_DPFM = "8545";
    public static final String HM_PPID_RSG = "8546";
    public static final String HM_PPID_FCSE = "8547";
    public static final String HM_PPID_MFDT = "8548";
    public static final String HM_PPID_ODM = "8549";
    public static final String HM_PPID_DSS = "8570";
    public static final String HM_PPID_HPA = "8571";
    public static final String HM_PPID_HPA2 = "8572";
    public static final String HM_PPID_NDM = "8573";
    public static final String HM_PPID_GAD = "8574";
    public static final String HM_PPID_SO = "8575";
    public static final String HM_PPID_ATM = "8576";
    public static final String HM_PPID_MUL = "8577";
    public static final String HM_PPID_HRT = "8578";
    public static final String HM_PPID_MFHRT = "8579";
    public static final String HM_PPID_FIPS = "8580";
    public static final String HM_PPID_AFA = "8581";
    public static final String HM_PPID_DKCDC = "8582";
    public static final String HM_PPID_PWSV = "8583";
    public static final String HM_PPID_PWSV_PLUS = "8584";
    public static final int LICENSE_LIMIT = 45;
    public static final int KEY_TEMPORARY = 1;
    public static final int KEY_PERMANENT = 2;
    public static final int KEY_EMERGENCY = 3;
    public static final int KEY_ENTERPRIZE = 4;
    public static final int KEY_TERM = 7;
    public static final int KEY_METER = 8;
    public static final int STATUS_CAPA_INSTALL = 1;
    public static final int STATUS_CAPA_INSUFFICIENT = 3;
    public static final int TYPE_USE_CAPA = 4;
    public static final long CALC_UNIT = 1024L;
    private final List ppInfoList;
    private SJmoPPKget1PPInfo minLimitppinfo = null;
    private String[] minPpInfo = new String[1];
    private static final String[] PPID_LIST;

    public SJctrLicenseContainer(SJctrUserController userCtr) {
        SJmoGetAgent agent = userCtr.getModelAgent();
        ArrayList<SJmoGetDirect> inputList = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind((SJmoGetKind_IF)new SJmoGetLicenseDetail());
        inputList.add(direct);
        List outputList = agent.getDataInf(inputList);
        List licenseList = (List)outputList.get(0);
        if (licenseList != null && licenseList.size() > 0) {
            SJmoLicenseDetail license = (SJmoLicenseDetail)licenseList.get(0);
            this.ppInfoList = new ArrayList(license.getPpl1ppinfo());
            Collections.sort(this.ppInfoList);
        } else {
            this.ppInfoList = new ArrayList();
        }
    }

    List<SJmoPPKget1PPInfo> getLicenseInfoList() {
        return this.ppInfoList;
    }

    public boolean checkPP(String pp) {
        SJmoPPKget1PPInfo key = new SJmoPPKget1PPInfo();
        key.setStrPPID(pp);
        int index = Collections.binarySearch(this.ppInfoList, key);
        if (index < 0) {
            return false;
        }
        SJmoPPKget1PPInfo ppInfo = (SJmoPPKget1PPInfo)this.ppInfoList.get(index);
        return SJctrLicenseUtility.isInstall(ppInfo);
    }

    public boolean checkLimit() {
        SJmoPPKget1PPInfo key = new SJmoPPKget1PPInfo();
        boolean result = true;
        for (String pp : PPID_LIST) {
            SJmoPPKget1PPInfo ppInfo;
            key.setStrPPID(pp);
            int index = Collections.binarySearch(this.ppInfoList, key);
            if (index < 0 || !SJctrLicenseUtility.isLimit(ppInfo = (SJmoPPKget1PPInfo)this.ppInfoList.get(index)) || ppInfo.getIExpireDays() > 45) continue;
            if (this.minLimitppinfo == null || this.minLimitppinfo.getIExpireDays() > ppInfo.getIExpireDays()) {
                this.minLimitppinfo = ppInfo;
                this.minPpInfo[0] = Integer.toString(ppInfo.getIExpireDays());
            }
            result = false;
        }
        return result;
    }

    public boolean checkCapacty(long ldevTotal) {
        SJmoPPKget1PPInfo key = new SJmoPPKget1PPInfo();
        boolean result = true;
        for (String pp : PPID_LIST) {
            int account;
            key.setStrPPID(pp);
            int index = Collections.binarySearch(this.ppInfoList, key);
            if (index < 0) continue;
            SJmoPPKget1PPInfo ppInfo = (SJmoPPKget1PPInfo)this.ppInfoList.get(index);
            long useCapa = ppInfo.getIUsedCapa();
            int ipVol = ppInfo.getIPermitVol();
            if (ipVol == -1 || !SJctrLicenseUtility.isCapacity(ppInfo)) continue;
            long ipermitVol = 0L;
            ipermitVol = (long)ipVol * 1024L;
            if (ppInfo.getIKeyKind() == 8 && ppInfo.getLPermDiffCapa() >= 0L) {
                ipermitVol += ppInfo.getLPermDiffCapa();
            }
            if ((account = ppInfo.getIAccountType()) == 4) {
                if (useCapa <= ipermitVol) continue;
                result = false;
                break;
            }
            if (ldevTotal <= ipermitVol) continue;
            result = false;
            break;
        }
        return result;
    }

    public String[] getMinPpInfo() {
        return this.minPpInfo;
    }

    public boolean equalsPpEnable(SJctrLicenseContainer lc) {
        for (String ppid : PPID_LIST) {
            if (lc.checkPP(ppid) == this.checkPP(ppid)) continue;
            return false;
        }
        return true;
    }

    static {
        if (SJctrControllerManager.isHM()) {
            PPID_ODCR = HM_PPID_ODCR;
            PPID_DCR = HM_PPID_DCR;
            PPID_HPAV = HM_PPID_HPAV;
            PPID_DRU = HM_PPID_DRU;
            PPID_VRM = HM_PPID_VRM;
            PPID_DB_VALIDATOR = HM_PPID_DB_VALIDATOR;
            PPID_DP = HM_PPID_DP;
            PPID_OCVSLUSE = HM_PPID_OCVSLUSE;
            PPID_LUNM = HM_PPID_LUNM;
            PPID_MONITOR = HM_PPID_MONITOR;
            PPID_PPC = HM_PPID_PPC;
            PPID_HIHSM = HM_PPID_HIHSM;
            PPID_HOMRCF = HM_PPID_HOMRCF;
            PPID_HMRCF = HM_PPID_HMRCF;
            PPID_QS = HM_PPID_QS;
            PPID_HCAFE = HM_PPID_HCAFE;
            PPID_HCAFE2 = HM_PPID_HCAFE2;
            PPID_SN = HM_PPID_SN;
            PPID_SNMP = HM_PPID_SNMP;
            PPID_RMI = HM_PPID_RMI;
            PPID_HORC = HM_PPID_HORC;
            PPID_HRC = HM_PPID_HRC;
            PPID_HUR = HM_PPID_HUR;
            PPID_HURMF = HM_PPID_HURMF;
            PPID_HORCA = HM_PPID_HORCA;
            PPID_HRCA = HM_PPID_HRCA;
            PPID_UVM = HM_PPID_UVM;
            PPID_CVS = HM_PPID_CVS;
            PPID_PRM = HM_PPID_PRM;
            PPID_SHRED = HM_PPID_SHRED;
            PPID_LDEVSEC = HM_PPID_LDEVSEC;
            PPID_LDEVSEC_PORTOPT = HM_PPID_LDEVSEC_PORTOPT;
            PPID_HXRC = HM_PPID_HXRC;
            PPID_DR_EXT = HM_PPID_DR_EXT;
            PPID_HIHSM2 = HM_PPID_HIHSM2;
            PPID_HYPERPAV = HM_PPID_HYPERPAV;
            PPID_FDM = HM_PPID_FDM;
            PPID_ENCRYPTION = HM_PPID_ENCRYPTION;
            PPID_HAM = HM_PPID_HAM;
            PPID_HPF = HM_PPID_HPF;
            PPID_HDTPM = HM_PPID_HDTPM;
            PPID_SMIS = HM_PPID_SMIS;
            PPID_DPFM = HM_PPID_DPFM;
            PPID_RSG = HM_PPID_RSG;
            PPID_FCSE = HM_PPID_FCSE;
            PPID_MFDT = HM_PPID_MFDT;
            PPID_ODM = HM_PPID_ODM;
            PPID_DSS = HM_PPID_DSS;
            PPID_HPA = HM_PPID_HPA;
            PPID_HPA2 = HM_PPID_HPA2;
            PPID_NDM = HM_PPID_NDM;
            PPID_GAD = HM_PPID_GAD;
            PPID_SO = HM_PPID_SO;
            PPID_ATM = HM_PPID_ATM;
            PPID_MUL = HM_PPID_MUL;
            PPID_HRT = HM_PPID_HRT;
            PPID_MFHRT = HM_PPID_MFHRT;
            PPID_FIPS = HM_PPID_FIPS;
            PPID_AFA = HM_PPID_AFA;
            PPID_DKCDC = HM_PPID_DKCDC;
            PPID_PWSV = HM_PPID_PWSV;
            PPID_PWSV_PLUS = HM_PPID_PWSV_PLUS;
        }
        PPID_LIST = new String[]{PPID_ODCR, PPID_DCR, PPID_HPAV, PPID_DRU, PPID_VRM, PPID_DB_VALIDATOR, PPID_DP, PPID_OCVSLUSE, PPID_LUNM, PPID_MONITOR, PPID_PPC, PPID_HIHSM, PPID_HOMRCF, PPID_HMRCF, PPID_QS, PPID_HCAFE, PPID_HCAFE2, PPID_SN, PPID_SNMP, PPID_RMI, PPID_HORC, PPID_HRC, PPID_HUR, PPID_HURMF, PPID_HORCA, PPID_HRCA, PPID_UVM, PPID_CVS, PPID_PRM, PPID_SHRED, PPID_LDEVSEC, PPID_LDEVSEC_PORTOPT, PPID_HXRC, PPID_DR_EXT, PPID_HIHSM2, PPID_HYPERPAV, PPID_FDM, PPID_ENCRYPTION, PPID_HAM, PPID_HPF, PPID_HDTPM, PPID_SMIS, PPID_DPFM, PPID_RSG, PPID_FCSE, PPID_MFDT, PPID_ODM, PPID_DSS, PPID_HPA, PPID_HPA2, PPID_NDM, PPID_GAD, PPID_SO, PPID_ATM, PPID_MUL, PPID_HRT, PPID_MFHRT, PPID_FIPS, PPID_AFA, PPID_DKCDC, PPID_PWSV, PPID_PWSV_PLUS};
    }
}

