/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.HUR1DataVol;
import sanproject.serverux.dataimpl.HURget1PairDetail;
import sanproject.serverux.dataimpl.HURget1PairDetailParam;
import sanproject.serverux.dataimpl.HURgetECTGrps;
import sanproject.serverux.dataimpl.HURgetPairDetail;
import sanproject.serverux.dataimpl.HURgetPairDetailParam;
import sanproject.serverux.dataimpl.RJiHURget1PairInfo;
import sanproject.serverux.dataimpl.RMCPHorcLU;
import sanproject.serverux.dataimpl.RMCPget1PairDetail;
import sanproject.serverux.dataimpl.RMCPget1PairDetailList;
import sanproject.serverux.dataimpl.RMCPget1PairSummary;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.replication.SJctrDataCapacityColumnFromUrJnlGrp;
import sanproject.sn2.controller.com.column.replication.SJctrDataCapacityColumnFromUrJnlGrpMirror;
import sanproject.sn2.controller.com.column.replication.SJctrJournalCapacityColumnFromUrJnlGrp;
import sanproject.sn2.controller.com.column.replication.SJctrLocalCapacityColumnFromTcPairVolInfo;
import sanproject.sn2.controller.com.column.replication.SJctrLocalCapacityColumnFromUrPairVolInfo;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrEXCTGJournalsStorageSystemUnitInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrLDEVDetailWithJnlInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationHmPortNameMapDataMacro;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateTrueCopyPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateUniversalReplicatorPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.editremotefuncswitch.SJctrEditRemoteFuncSwitchInfo;
import sanproject.sn2.controller.wizard.replication.remote.editremotereplicaopts.SJctrUniversalReplicatorCuOptionInfo;
import sanproject.sn2.controller.wizard.replication.remote.editremotereplicaopts.SJctrUniversalReplicatorSystemInfo;
import sanproject.sn2.controller.wizard.replication.remote.exctgprops.SJctrGetHurgetECTGrpsList;
import sanproject.sn2.controller.wizard.replication.remote.removessids.SJctrRemoteConnectionSSIDInfo;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetHurPairDetail;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetRmcp1PairDetailList;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrGetRmcpPair;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateTcTcmfInfo;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateUrUrmfInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesBaseInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesTcInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesUrInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationCuOptionInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetThinProvisioningVolumesStatus;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.replication.SJmoJnlGroupIndex;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationCuOptionInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationLuPath;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUOptionInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyCUOptionSystemInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationCuOptionInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrRemoteReplicationUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public SJctrRemoteReplicationUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public Map<String, String> getNumOfRemotePairsMirrorsCountString(SJmoTrueCopyPairVolInfoMgr tcPairMgr, SJmoUniversalReplicatorPairVolInfoMgr urPairMgr, SJmoHAPairVolInfoMgr haPairMgr, SJmoUniversalReplicatorJnlGrpMgr urJnlGrpMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetails) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("COM_TC_PAIR_NUM", "?");
        retMap.put("COM_TCMF_PAIR_NUM", "?");
        retMap.put("COM_UR_PAIR_NUM", "?");
        retMap.put("COM_URMF_PAIR_NUM", "?");
        retMap.put("COM_HA_PAIR_NUM", "?");
        retMap.put("COM_TOTAL_PAIR_NUM", "?");
        retMap.put("COM_OPEN_MIRROR_NUM", "?");
        retMap.put("COM_MF_MIRROR_NUM", "?");
        retMap.put("COM_TOTAL_MIRROR_NUM", "?");
        int tcCnt = 0;
        int tcmfCnt = 0;
        if (tcPairMgr != null && rsgUty != null && ldevDetails != null) {
            ArrayList<SJmoTrueCopyPairVolInfo> tcPairVolInfoList = SJctrRemoteReplicationUtility.getTcPairVolInfoList(tcPairMgr, rsgUty, ldevDetails);
            for (SJmoTrueCopyPairVolInfo tcPairVolInfo : tcPairVolInfoList) {
                if (null == tcPairVolInfo) continue;
                if (SJctrRemoteReplicationUtility.isOpen(tcPairVolInfo)) {
                    ++tcCnt;
                    continue;
                }
                if (!SJctrRemoteReplicationUtility.isMainframe(tcPairVolInfo)) continue;
                ++tcmfCnt;
            }
            retMap.put("COM_TC_PAIR_NUM", Integer.toString(tcCnt));
            retMap.put("COM_TCMF_PAIR_NUM", Integer.toString(tcmfCnt));
        }
        int urCnt = 0;
        int urmfCnt = 0;
        if (urPairMgr != null && rsgUty != null && ldevDetails != null) {
            ArrayList<SJmoUniversalReplicatorPairVolInfo> urPairVolInfoList = SJctrRemoteReplicationUtility.getUrPairVolInfoList(urPairMgr, rsgUty, ldevDetails);
            for (SJmoUniversalReplicatorPairVolInfo urPairVolInfo : urPairVolInfoList) {
                if (null == urPairVolInfo) continue;
                if (SJctrRemoteReplicationUtility.isOpen(urPairVolInfo)) {
                    ++urCnt;
                    continue;
                }
                if (!SJctrRemoteReplicationUtility.isMainframe(urPairVolInfo)) continue;
                ++urmfCnt;
            }
            retMap.put("COM_UR_PAIR_NUM", Integer.toString(urCnt));
            retMap.put("COM_URMF_PAIR_NUM", Integer.toString(urmfCnt));
        }
        int haCnt = 0;
        if (haPairMgr != null && rsgUty != null && ldevDetails != null) {
            ArrayList<SJmoHAPairVolInfo> haPairVolInfoList = SJctrHaUtility.getHaPairVolInfoList(haPairMgr, rsgUty, ldevDetails);
            haCnt = haPairVolInfoList.size();
            retMap.put("COM_HA_PAIR_NUM", Integer.toString(haCnt));
        }
        if (tcPairMgr != null && urPairMgr != null && haPairMgr != null && rsgUty != null && ldevDetails != null) {
            retMap.put("COM_TOTAL_PAIR_NUM", Integer.toString(tcCnt + tcmfCnt + urCnt + urmfCnt + haCnt));
        }
        if (urJnlGrpMgr != null) {
            int openCnt = 0;
            int mfCnt = 0;
            SJmoUniversalReplicatorJnlGrp[] urJnlGrpArray = urJnlGrpMgr.getJnlGroupList();
            if (urJnlGrpArray != null) {
                for (SJmoUniversalReplicatorJnlGrp urJnlGrp : urJnlGrpArray) {
                    if (null == urJnlGrp) continue;
                    ArrayList alMirror = urJnlGrp.getMirrors();
                    int iMirrorCnt = alMirror.size();
                    int iValidty = urJnlGrp.getValidty();
                    if (1 == iValidty) {
                        openCnt += iMirrorCnt;
                        continue;
                    }
                    if (2 != iValidty) continue;
                    mfCnt += iMirrorCnt;
                }
                retMap.put("COM_OPEN_MIRROR_NUM", Integer.toString(openCnt));
                retMap.put("COM_MF_MIRROR_NUM", Integer.toString(mfCnt));
                retMap.put("COM_TOTAL_MIRROR_NUM", Integer.toString(openCnt + mfCnt));
            }
        }
        return retMap;
    }

    public static ArrayList<SJmoTrueCopyPairVolInfo> getTcPairVolInfoList(SJmoTrueCopyPairVolInfoMgr tcPairMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetails) {
        SJmoReplicationPairVolInfo[] localPairInfoList;
        ArrayList<SJmoTrueCopyPairVolInfo> retList = new ArrayList<SJmoTrueCopyPairVolInfo>();
        List<SJmoLdevIndex> enableVolList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoReplicationPairVolInfo localPairInfo : localPairInfoList = tcPairMgr.getTrueCopyPairVolInfoList()) {
            if (null == localPairInfo || 0 > Collections.binarySearch(enableVolList, localPairInfo) || !SJctrReplicationUtility.checkViewPair((SJmoLdevIndex)localPairInfo, ldevDetails)) continue;
            SJmoLdevIndex pRemotePairInfo = localPairInfo.getPVolIndex();
            if (null != pRemotePairInfo) {
                retList.add((SJmoTrueCopyPairVolInfo)pRemotePairInfo);
            }
            ArrayList sRemotePairInfoList = localPairInfo.getAlSVolIndex();
            for (SJmoLdevIndex sRemotePairInfo : sRemotePairInfoList) {
                retList.add((SJmoTrueCopyPairVolInfo)sRemotePairInfo);
            }
        }
        return retList;
    }

    public static ArrayList<SJmoUniversalReplicatorPairVolInfo> getUrPairVolInfoList(SJmoUniversalReplicatorPairVolInfoMgr urPairMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetails) {
        SJmoReplicationPairVolInfo[] localPairInfoList;
        ArrayList<SJmoUniversalReplicatorPairVolInfo> retList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        List<SJmoLdevIndex> enableVolList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoReplicationPairVolInfo localPairInfo : localPairInfoList = urPairMgr.getPairVolInfoList()) {
            if (null == localPairInfo || 0 > Collections.binarySearch(enableVolList, localPairInfo) || !SJctrReplicationUtility.checkViewPair((SJmoLdevIndex)localPairInfo, ldevDetails)) continue;
            ArrayList pRemotePairInfoList = localPairInfo.getAlPVolIndex();
            for (SJmoLdevIndex pRemotePairInfo : pRemotePairInfoList) {
                retList.add((SJmoUniversalReplicatorPairVolInfo)pRemotePairInfo);
            }
            ArrayList sRemotePairInfoList = localPairInfo.getAlSVolIndex();
            for (SJmoLdevIndex sRemotePairInfo : sRemotePairInfoList) {
                retList.add((SJmoUniversalReplicatorPairVolInfo)sRemotePairInfo);
            }
        }
        return retList;
    }

    public String getCopyTypeTcString(SJmoReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(2) ? this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(1) ? this.guidanceHandle.getGuidance("PRIMARY") : "-");
        }
        return ret;
    }

    public String getCopyTypeUrString(SJmoReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(4096) && pairVolInfo.isVolPos(8192) ? this.guidanceHandle.getGuidance("PRIMARY") + " " + "/" + " " + this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(8192) ? this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(4096) ? this.guidanceHandle.getGuidance("PRIMARY") : "-"));
        }
        return ret;
    }

    public String getCopyTypeTcmfString(SJmoReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(64) ? this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(32) ? this.guidanceHandle.getGuidance("PRIMARY") : "-");
        }
        return ret;
    }

    public String getCopyTypeUrmfString(SJmoReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(131072) && pairVolInfo.isVolPos(262144) ? this.guidanceHandle.getGuidance("PRIMARY") + " " + "/" + " " + this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(262144) ? this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(131072) ? this.guidanceHandle.getGuidance("PRIMARY") : "-"));
        }
        return ret;
    }

    public String getPathWatchTimeString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (jnlGrpMirror != null) {
            if (SJctrRemoteReplicationUtility.isDisableStatusForDispPathWatchTime(jnlGrpMirror)) {
                ret = "-";
            } else {
                int iPathBlockWatchTime = jnlGrpMirror.getPathBlockWatchTime();
                String strPathBlockWatchValue = Integer.toString(iPathBlockWatchTime & 0x3F);
                int iPathBlockWatchTimeUnit = iPathBlockWatchTime & 0xC0;
                switch (iPathBlockWatchTimeUnit) {
                    case 0: {
                        ret = strPathBlockWatchValue + " " + this.guidanceHandle.getGuidance("PATH_WATCH_TIME_MINUTE");
                        break;
                    }
                    case 64: {
                        ret = strPathBlockWatchValue + " " + this.guidanceHandle.getGuidance("PATH_WATCH_TIME_HOUR");
                        break;
                    }
                    case 128: {
                        ret = strPathBlockWatchValue + " " + this.guidanceHandle.getGuidance("PATH_WATCH_TIME_DAY");
                        break;
                    }
                    default: {
                        SJctrLogUty.error(this.getClass().getSimpleName(), "getPathWatchTimeString", "SJmoUniversalReplicatorJnlGrpMirror.getPathBlockWatchTime() has returned an invalid value.");
                    }
                }
            }
        }
        return ret;
    }

    public static boolean isDisableStatusForDispPathWatchTime(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        int iAttribute = jnlGrpMirror.getAttribute();
        int iDelta = jnlGrpMirror.getDelta();
        return 2 == iAttribute && (1 == iDelta || 2 == iDelta || 3 == iDelta);
    }

    public String getPathWatchTimeTranString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (jnlGrpMirror != null) {
            int iForward = jnlGrpMirror.getForward();
            if (0 == iForward) {
                ret = this.guidanceHandle.getGuidance("NO");
            } else if (1 == iForward) {
                ret = this.guidanceHandle.getGuidance("YES");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getPathWatchTimeTranString", "SJmoUniversalReplicatorJnlGrpMirror.getForward() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getTransferSpeedString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        int iLineSpeed;
        String ret = "?";
        if (jnlGrpMirror != null && -1 != (iLineSpeed = jnlGrpMirror.getLineSpeed())) {
            ret = Integer.toString(iLineSpeed) + " " + this.guidanceHandle.getGuidance("MBPS");
        }
        return ret;
    }

    public String getDeltaResyncFailureString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (jnlGrpMirror != null) {
            int iFailure = jnlGrpMirror.getFailure();
            if (0 == iFailure) {
                ret = this.guidanceHandle.getGuidance("NO_COPY");
            } else if (1 == iFailure) {
                ret = this.guidanceHandle.getGuidance("ENTIRE_COPY");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getDeltaResyncFailureString", "SJmoUniversalReplicatorJnlGrpMirror.getFailure() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getSplitModeString(int iSplitMode) {
        String ret = "?";
        if (2 == iSplitMode) {
            ret = this.guidanceHandle.getGuidance("FLUSH");
        } else if (1 == iSplitMode) {
            ret = this.guidanceHandle.getGuidance("PURGE");
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSplitModeString", "Invalid argument.");
        }
        return ret;
    }

    public String getCopyPaceString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            int iAttribute = jnlGrpMirror.getAttribute();
            if (2 == iAttribute) {
                ret = "-";
            } else {
                int iTransferRate = jnlGrpMirror.getTransferRate();
                switch (iTransferRate) {
                    case 500: {
                        ret = this.guidanceHandle.getGuidance("MEDIUM_CP");
                        break;
                    }
                    case 150: {
                        ret = this.guidanceHandle.getGuidance("LOWER_CP");
                        break;
                    }
                    case 1500: {
                        ret = this.guidanceHandle.getGuidance("FASTER_CP");
                        break;
                    }
                    default: {
                        SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "SJmoUniversalReplicatorJnlGrpMirror.getTransferRate() has returned an invalid value.");
                    }
                }
            }
        }
        return ret;
    }

    public String getJournalTypeString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            int iValidty = jnlGrp.getValidty();
            if (1 == iValidty) {
                ret = this.guidanceHandle.getGuidance("UR_COPY");
            } else if (2 == iValidty) {
                ret = this.guidanceHandle.getGuidance("UR_MF_COPY");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getJournalTypeString", "SJmoUniversalReplicatorJnlGrp.getValidty() has returned an invalid value.");
            }
            int iISite = jnlGrp.getIsite();
            if (0 != iISite) {
                ret = 1 == iValidty ? ret + " (" + this.guidanceHandle.getGuidance("2DC_CASCADE") + ")" : "?";
            }
        }
        return ret;
    }

    public String getAttributeString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            int iAttribute = jnlGrp.getAttribute();
            switch (iAttribute) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_INITIAL");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_MASTER");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_RESTORE");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_MASTER_AND_RESTORE");
                    break;
                }
                default: {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getAttributeString", "SJmoUniversalReplicatorJnlGrp.getAttribute() has returned an invalid value.");
                }
            }
        }
        return ret;
    }

    public String getNumOfJournalVolString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        ArrayList alJnlVols;
        String ret = "?";
        if (jnlGrp != null && (alJnlVols = jnlGrp.getJnlVols()) != null) {
            ret = Integer.toString(alJnlVols.size());
        }
        return ret;
    }

    public String getJournalCapacityString(SJmoUniversalReplicatorJnlGrp jnlGrp, List<?> ldevDetailList, SJctrCapacityUtility capUtil) {
        ArrayList alJnlVols;
        String ret = "?";
        if (jnlGrp != null && ldevDetailList != null && capUtil != null && (alJnlVols = jnlGrp.getJnlVols()) != null) {
            long capacity = 0L;
            int target = Collections.binarySearch(ldevDetailList, alJnlVols.get(0));
            if (0 > target) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getJournalCapacityString", "Journal Volume is not included in LdevDetail list.");
                return "?";
            }
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(target);
            ret = capUtil.toUnitString(capacity += ldevDetail.getLLDEVLBASize());
        }
        return ret;
    }

    public String getJournalCapacityString(SJmoUniversalReplicatorJnlGrp jnlGrp, List<?> ldevDetailList, SJctrCapacityUtility capUtil, SJctrCapacityUtility.UNIT unit) {
        ArrayList alJnlVols;
        String ret = "?";
        if (jnlGrp != null && ldevDetailList != null && capUtil != null && unit != null && (alJnlVols = jnlGrp.getJnlVols()) != null) {
            long capacity = 0L;
            int iEmulationType = -1;
            int target = Collections.binarySearch(ldevDetailList, alJnlVols.get(0));
            if (0 <= target) {
                SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(target);
                capacity += ldevDetail.getLLDEVLBASize();
                if (-1 == iEmulationType) {
                    iEmulationType = ldevDetail.getIEmulationType();
                }
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getJournalCapacityString", "Journal Volume is not included in LdevDetail list.");
                return "?";
            }
            ret = capUtil.toString(capacity, unit, iEmulationType) + " " + capUtil.getUnitString(unit);
        }
        return ret;
    }

    public String getNumOfDataVolString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            ret = Integer.toString(jnlGrp.getNumOfHdevs());
        }
        return ret;
    }

    public String getDataCapacityString(SJmoUniversalReplicatorJnlGrp jnlGrp, SJctrCapacityUtility capUtil, SJctrCapacityUtility.UNIT unit) {
        String ret = "?";
        if (jnlGrp != null && capUtil != null) {
            long capacity = jnlGrp.getHdevCapa();
            if (null == unit) {
                ret = capUtil.toUnitString(capacity);
            } else if (SJctrCapacityUtility.UNIT.CYL == unit) {
                String strDataVolEmu = jnlGrp.getDataVolEmu();
                ret = capUtil.toCylString(capacity, strDataVolEmu) + " " + capUtil.getUnitString(unit);
            } else {
                ret = capUtil.toString(capacity, unit) + " " + capUtil.getUnitString(unit);
            }
        }
        return ret;
    }

    public String getMpBladeIdString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            byte byOwner = jnlGrp.getOwner();
            if (-1 == byOwner) {
                ret = this.guidanceHandle.getGuidance("AUTO");
            } else {
                ret = this.guidanceHandle.getGuidance("MPB");
                ret = SJctrDataController.isHM() ? ret + String.valueOf(SJctrOwnerShipUtility.convertMpUnitNoToMpUnitId((int)byOwner)) : ret + SJctrComUtility.toHexString(byOwner, 1, true);
            }
        }
        return ret;
    }

    public String getInflowControlString(SJmoUniversalReplicatorJnlGrp jnlGrp, boolean isCreate) {
        String ret = "?";
        if (jnlGrp != null) {
            int iIoDelay = jnlGrp.getIoDelay();
            if (0 == iIoDelay) {
                ret = isCreate ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("ENABLED");
            } else if (1 == iIoDelay) {
                ret = isCreate ? this.guidanceHandle.getGuidance("DISABLE") : this.guidanceHandle.getGuidance("DISABLED");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getInflowControlString", "SJmoUniversalReplicatorJnlGrp.getIoDelay() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getInflowControlString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            ret = this.getInflowControlString(jnlGrp, false);
        }
        return ret;
    }

    public String getDataOverflowWatchString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            int iIoDelay = jnlGrp.getIoDelay();
            if (0 == iIoDelay) {
                int iDataOverFlowWatch = jnlGrp.getDataOverFlowWatch();
                if (-1 != iDataOverFlowWatch) {
                    ret = Integer.toString(iDataOverFlowWatch);
                }
            } else if (1 == iIoDelay) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getDataOverflowWatchString", "SJmoUniversalReplicatorJnlGrp.getIoDelay() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getCacheModeString(SJmoUniversalReplicatorJnlGrp jnlGrp, boolean isCreate) {
        String ret = "?";
        if (jnlGrp != null) {
            int iActionMode = jnlGrp.getActionMode();
            if (0 == iActionMode) {
                ret = isCreate ? this.guidanceHandle.getGuidance("DISABLE") : this.guidanceHandle.getGuidance("DISABLED");
            } else if (1 == iActionMode) {
                ret = isCreate ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("ENABLED");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getCacheModeString", "SJmoUniversalReplicatorJnlGrp.getActionMode() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getCacheModeString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            ret = this.getCacheModeString(jnlGrp, false);
        }
        return ret;
    }

    public String getTimerTypeString(SJmoUniversalReplicatorJnlGrp jnlGrp) {
        String ret = "?";
        if (jnlGrp != null) {
            int iValidty = jnlGrp.getValidty();
            if (1 == iValidty) {
                ret = "-";
            } else if (2 == iValidty) {
                int iTimerKind = jnlGrp.getTimerKind();
                if (0 == iTimerKind) {
                    ret = this.guidanceHandle.getGuidance("SYSTEM");
                } else if (1 == iTimerKind) {
                    ret = this.guidanceHandle.getGuidance("LOCAL");
                } else if (2 == iTimerKind) {
                    ret = this.guidanceHandle.getGuidance("NONE");
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getTimerTypeString", "SJmoUniversalReplicatorJnlGrp.getTimerKind() has returned an invalid value.");
                }
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getTimerTypeString", "SJmoUniversalReplicatorJnlGrp.getValidty() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getConnectionTypeString(SJmoRemoteReplicationCUInfo cuInfo) {
        String ret = "?";
        if (cuInfo != null) {
            int iCuFree = cuInfo.getICUFree();
            if (0 == iCuFree) {
                ret = this.guidanceHandle.getGuidance("CU");
            } else if (1 == iCuFree) {
                ret = this.guidanceHandle.getGuidance("SYSTEM");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getConnectionTypeString", "SJmoRemoteReplicationCUInfo.getICUFree() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getLocalCuString(SJmoRemoteReplicationCUInfo cuInfo) {
        String ret = "?";
        if (cuInfo != null) {
            int iCuFree = cuInfo.getICUFree();
            if (0 == iCuFree) {
                short sCUNo = cuInfo.getSCUNo();
                ret = SJctrComUtility.toHexString(sCUNo, 2, true);
            } else if (1 == iCuFree) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getLocalCuString", "SJmoRemoteReplicationCUInfo.getICUFree() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getModelSNoString(SJmoRemoteReplicationCUInfo cuInfo) {
        String ret = "?";
        if (cuInfo != null) {
            int iControllerID = cuInfo.getIControllerID();
            String strSN = cuInfo.getStrSN();
            ret = this.getModelSNoString(iControllerID, strSN);
        }
        return ret;
    }

    public String getModelSNoString(int controllerId, String serialNumStr) {
        if (null == serialNumStr) {
            serialNumStr = "?";
        }
        String modelSnStr = this.getControllerIdStr(controllerId) + " / " + serialNumStr;
        return modelSnStr;
    }

    public String getModelSNoString(SJmoSubsystemInfo systemInfo) {
        String modelSnStr = "?";
        if (null != systemInfo) {
            int modelId = this.getModelIDfromSubsysInfo(systemInfo);
            String serialNum = this.toPaddingZeroSerialNumber(modelId, systemInfo.getDKCSNString());
            modelSnStr = this.getModelSNoString(modelId, serialNum);
        }
        return modelSnStr;
    }

    private String getControllerIdStr(int controllerId) {
        String ret = "?";
        if (SJctrDataController.isHM()) {
            switch (controllerId) {
                case 18: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_18");
                    break;
                }
                case 19: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_19");
                    break;
                }
                case 7: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_7");
                    break;
                }
                default: {
                    if (6 <= controllerId && controllerId <= 255) {
                        ret = "(" + String.valueOf(controllerId) + ")";
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            switch (controllerId) {
                case 5: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_5");
                    break;
                }
                case 6: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_6");
                    break;
                }
                case 7: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_7");
                    break;
                }
                case 18: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_18");
                    break;
                }
                case 19: {
                    ret = this.guidanceHandle.getGuidance("DKC_MODEL_19");
                    break;
                }
                default: {
                    if (6 > controllerId || controllerId > 255) break;
                    ret = "(" + String.valueOf(controllerId) + ")";
                }
            }
        }
        return ret;
    }

    public String getRemoteCuString(SJmoRemoteReplicationCUInfo cuInfo) {
        String ret = "?";
        if (cuInfo != null) {
            int iCuFree = cuInfo.getICUFree();
            if (0 == iCuFree) {
                short sCu = cuInfo.getSCu();
                ret = SJctrComUtility.toHexString(sCu, 2, true);
            } else if (1 == iCuFree) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getRemoteCuString", "SJmoRemoteReplicationCUInfo.getICUFree() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getSsidString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        String ret = "?";
        if (rcuInfo != null) {
            int iCuFree = rcuInfo.getICUFree();
            if (0 == iCuFree) {
                int iNumofSSID = rcuInfo.getINumofSSID();
                int[] iSsid = rcuInfo.getISSID();
                if (-1 != iNumofSSID && iSsid != null) {
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 1; i <= iNumofSSID; ++i) {
                        buffer.append(SJctrComUtility.toHexString(iSsid[i - 1], 4, true));
                        if (i >= iNumofSSID) continue;
                        buffer.append(", ");
                    }
                    ret = buffer.toString();
                }
            } else if (1 == iCuFree) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getSsidString", "SJmoRemoteReplicationRCUInfo.getICUFree() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getSsidString(SJmoRemoteReplicationMCUInfo mcuInfo) {
        String ret = "?";
        if (mcuInfo != null) {
            int iCuFree = mcuInfo.getICUFree();
            if (0 == iCuFree) {
                int iSsid = mcuInfo.getISSID();
                if (-1 != iSsid) {
                    ret = SJctrComUtility.toHexString(iSsid, 4, true);
                }
            } else if (1 == iCuFree) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getSsidString", "SJmoRemoteReplicationMCUInfo.getICUFree() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getPathGroupIdString(SJmoRemoteReplicationCUInfo cuInfo) {
        String ret = "?";
        if (cuInfo != null) {
            int iCuFree = cuInfo.getICUFree();
            int iRCUID = cuInfo.getIRCUID();
            ret = this.getPathGroupIdString(iCuFree, iRCUID);
        }
        return ret;
    }

    private String getPathGroupIdString(int iConnectionType, int iPathGroupId) {
        String ret = "?";
        if (0 == iConnectionType) {
            ret = "-";
        } else if (1 == iConnectionType) {
            if (-1 != iPathGroupId) {
                ret = SJctrComUtility.toHexString(iPathGroupId, 2, true);
            }
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getPathGroupIdString", "Invalid argument.");
        }
        return ret;
    }

    public String getRcuStatusString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        ArrayList rcuPathInfoList;
        String ret = "?";
        if (rcuInfo != null && (rcuPathInfoList = rcuInfo.getPathInfoList()) != null) {
            if (rcuPathInfoList.size() > 0) {
                int iCntError = 0;
                for (SJmoRemoteReplicationRCUPathInfo rcuPathInfo : rcuPathInfoList) {
                    if (1 == rcuPathInfo.getIPathStatus()) continue;
                    ++iCntError;
                }
                ret = iCntError == 0 ? this.guidanceHandle.getGuidance("NORMAL2") : (iCntError == rcuPathInfoList.size() ? this.guidanceHandle.getGuidance("FAILED2") : this.guidanceHandle.getGuidance("STS_WARNING"));
            } else if (rcuPathInfoList.size() == 0) {
                ret = "-";
            }
        }
        return ret;
    }

    public String getNumOfRemotePathsString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        ArrayList rcuPathInfoList;
        String ret = "?";
        if (rcuInfo != null && (rcuPathInfoList = rcuInfo.getPathInfoList()) != null) {
            ret = Integer.toString(rcuPathInfoList.size());
        }
        return ret;
    }

    public String getMinNumOfPathsString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        int iNumofMimPath;
        SJmoRemoteReplicationRCUOptionInfo rcuOptionInfo;
        String ret = "?";
        if (rcuInfo != null && (rcuOptionInfo = rcuInfo.getRCUOption()) != null && -1 != (iNumofMimPath = rcuOptionInfo.getINumofMimPath())) {
            ret = Integer.toString(iNumofMimPath);
        }
        return ret;
    }

    public String getRioMihTimeString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        int iRIOMIHTime;
        SJmoRemoteReplicationRCUOptionInfo rcuOptionInfo;
        String ret = "?";
        if (rcuInfo != null && (rcuOptionInfo = rcuInfo.getRCUOption()) != null && -1 != (iRIOMIHTime = rcuOptionInfo.getIRIOMIHTime())) {
            ret = Integer.toString(iRIOMIHTime);
        }
        return ret;
    }

    public String getRoundTripTimeString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        int iRtTime;
        SJmoRemoteReplicationRCUOptionInfo rcuOptionInfo;
        String ret = "?";
        if (rcuInfo != null && (rcuOptionInfo = rcuInfo.getRCUOption()) != null && -1 != (iRtTime = rcuOptionInfo.getIRtTime())) {
            if (iRtTime == 0) {
                iRtTime = 1;
            }
            ret = Integer.toString(iRtTime);
        }
        return ret;
    }

    public String getFreezeOptionString(SJmoRemoteReplicationRCUInfo rcuInfo, boolean isCreate) {
        SJmoRemoteReplicationRCUOptionInfo rcuOptionInfo;
        String ret = "?";
        if (rcuInfo != null && (rcuOptionInfo = rcuInfo.getRCUOption()) != null) {
            int connType = rcuInfo.getICUFree();
            if (1 == connType) {
                ret = "-";
            } else {
                int iFreezeOption = rcuOptionInfo.getIFreezeOption();
                if (0 == iFreezeOption) {
                    ret = isCreate ? this.guidanceHandle.getGuidance("DISABLE") : this.guidanceHandle.getGuidance("DISABLED");
                } else if (1 == iFreezeOption) {
                    ret = isCreate ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("ENABLED");
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getFreezeOptionString", "SJmoRemoteReplicationRCUOptionInfo.getIFreezeOption() has returned an invalid value.");
                }
            }
        }
        return ret;
    }

    public String getFreezeOptionString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        String ret = "?";
        if (rcuInfo != null) {
            ret = this.getFreezeOptionString(rcuInfo, false);
        }
        return ret;
    }

    public String getPathStatusString(SJmoRemoteReplicationRCUPathInfo rcuPathInfo) {
        String ret = "?";
        if (rcuPathInfo != null) {
            int iPathStatus = rcuPathInfo.getIPathStatus();
            switch (iPathStatus) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("IN_PROGRESS");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("NORMAL");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("INITIALIZATION_FAILED");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("COMMUNICATION_TIME_OUT");
                    break;
                }
                case 4: {
                    ret = this.guidanceHandle.getGuidance("PORT_REJECTED");
                    break;
                }
                case 5: {
                    ret = this.guidanceHandle.getGuidance("PAIR_PORT_REJECTED");
                    break;
                }
                case 6: {
                    ret = this.guidanceHandle.getGuidance("SERIAL_NUM_MISMATCH");
                    break;
                }
                case 16: {
                    ret = this.guidanceHandle.getGuidance("INVALID_PORT");
                    break;
                }
                case 128: {
                    ret = this.guidanceHandle.getGuidance("PAIR_PORT_NUM_MISMATCH");
                    break;
                }
                case 129: {
                    ret = this.guidanceHandle.getGuidance("PAIR_PORT_TYPE_MISMATCH");
                    break;
                }
                case 130: {
                    ret = this.guidanceHandle.getGuidance("COMMUNICATION_FAILED");
                    break;
                }
                case 160: {
                    ret = this.guidanceHandle.getGuidance("IN_PROGRESS");
                    break;
                }
                case 161: {
                    ret = this.guidanceHandle.getGuidance("IN_PROGRESS");
                    break;
                }
                case 162: {
                    ret = this.guidanceHandle.getGuidance("PROGRAM_ERROR");
                    break;
                }
                case 163: {
                    ret = this.guidanceHandle.getGuidance("PATH_BLOCKADE");
                    break;
                }
                default: {
                    ret = this.guidanceHandle.getGuidance("INVALID_PORT");
                }
            }
        }
        return ret;
    }

    public String getMaxInitCopyString(SJmoRemoteReplicationCuOptionInfo cuOptionInfo) {
        int iDefCopyMaxTrack;
        String ret = "?";
        if (cuOptionInfo != null && -1 != (iDefCopyMaxTrack = cuOptionInfo.getIDefCopyMaxTrack())) {
            ret = Integer.toString(iDefCopyMaxTrack);
        }
        return ret;
    }

    public String getMaxInitCopyStringUr(SJctrUniversalReplicatorSystemInfo systemOptionInfo) {
        int iDefCopyMaxTrack;
        String ret = "?";
        if (systemOptionInfo != null && -1 != (iDefCopyMaxTrack = systemOptionInfo.getMaxInitCopyAct())) {
            ret = Integer.toString(iDefCopyMaxTrack);
        }
        return ret;
    }

    public String getMaxInitCopyStringHa(SJmoTrueCopyCUOptionSystemInfo systemOptionInfo) {
        int iDefCopyMaxTrack;
        String ret = "?";
        if (systemOptionInfo != null && -1 != (iDefCopyMaxTrack = systemOptionInfo.getIMaxInitCopyHA())) {
            ret = Integer.toString(iDefCopyMaxTrack);
        }
        return ret;
    }

    public String getPprcSupportString(SJmoRemoteReplicationCuOptionInfo cuOptionInfo) {
        String ret = "?";
        if (cuOptionInfo != null) {
            int iHostSupport = cuOptionInfo.getIHostSupport();
            if (0 == iHostSupport) {
                ret = this.guidanceHandle.getGuidance("NO");
            } else if (1 == iHostSupport) {
                ret = this.guidanceHandle.getGuidance("YES");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getPprcSupportString", "SJmoRemoteReplicationCuOptionInfo.getIHostSupport() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getServiceSimStringTc(SJmoRemoteReplicationCuOptionInfo cuOptionInfo) {
        String ret = "?";
        if (cuOptionInfo != null) {
            int iRcUServiceSim = cuOptionInfo.getIRcUServiceSim();
            if (0 == iRcUServiceSim) {
                ret = this.guidanceHandle.getGuidance("SIM_REPORT");
            } else if (1 == iRcUServiceSim) {
                ret = this.guidanceHandle.getGuidance("SIM_NO_REPORT");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getServiceSimStringTc", "Service sim is invalid value.");
            }
        }
        return ret;
    }

    public String getServiceSimStringUr(SJctrUniversalReplicatorCuOptionInfo cuOptionInfo) {
        String ret = "?";
        if (cuOptionInfo != null) {
            int iRcUServiceSim = cuOptionInfo.getServicesSim();
            if (1 == iRcUServiceSim) {
                ret = this.guidanceHandle.getGuidance("SIM_REPORT");
            } else if (0 == iRcUServiceSim) {
                ret = this.guidanceHandle.getGuidance("SIM_NO_REPORT");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getServiceSimStringUr", "Service sim is invalid value.");
            }
        }
        return ret;
    }

    public String getMaxInitCopyString(SJmoTrueCopyCUOptionSystemInfo trueCopyCuOptSysInfo) {
        int iMaxInitCopy;
        String ret = "?";
        if (trueCopyCuOptSysInfo != null && -1 != (iMaxInitCopy = trueCopyCuOptSysInfo.getIMaxInitCopy())) {
            ret = Integer.toString(iMaxInitCopy);
        }
        return ret;
    }

    public String getServiceSimString(SJmoTrueCopyCUOptionSystemInfo trueCopyCuOptSysInfo) {
        String ret = "?";
        if (trueCopyCuOptSysInfo != null) {
            int iServiceSIMReport = trueCopyCuOptSysInfo.getIServiceSIMReport();
            if (0 == iServiceSIMReport) {
                ret = this.guidanceHandle.getGuidance("SIM_REPORT");
            } else if (1 == iServiceSIMReport) {
                ret = this.guidanceHandle.getGuidance("SIM_NO_REPORT");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getServiceSimString", "SJmoTrueCopyCUOptionSystemInfo.getIServiceSIMReport() has returned an invalid value.");
            }
        }
        return ret;
    }

    public String getCtgIdString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            BitSet behaviorBitSet = pairVolInfo.getBehaviorBitSet();
            if (behaviorBitSet.get(13)) {
                int iCtgId = pairVolInfo.getICtgId();
                ret = SJctrComUtility.toHexString(iCtgId, 3, true);
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getCtgUtilizationString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            BitSet behaviorBitSet = pairVolInfo.getBehaviorBitSet();
            ret = behaviorBitSet.get(13) ? (behaviorBitSet.get(14) ? this.guidanceHandle.getGuidance("MULTI") : this.guidanceHandle.getGuidance("SINGLE")) : "-";
        }
        return ret;
    }

    public String getCtgUtilizationString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (jnlGrpMirror != null) {
            int iStatus = jnlGrpMirror.getStatus();
            if (0 == iStatus) {
                ret = "-";
            } else {
                int iCTGrp = jnlGrpMirror.getCtGrp();
                if (0 == iCTGrp) {
                    ret = "-";
                } else if (1 == iCTGrp) {
                    int iBelongToEXCTG = jnlGrpMirror.getBelongToEXCTG();
                    if (0 == iBelongToEXCTG) {
                        ret = this.guidanceHandle.getGuidance("SINGLE");
                    } else if (1 == iBelongToEXCTG) {
                        ret = this.guidanceHandle.getGuidance("MULTI");
                    } else {
                        SJctrLogUty.error(this.getClass().getSimpleName(), "getCtgUtilizationString", "SJmoUniversalReplicatorJnlGrpMirror.getBelongToEXCTG() has returned an invalid value.");
                    }
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getCtgUtilizationString", "SJmoUniversalReplicatorJnlGrpMirror.getCTGrp() has returned an invalid value.");
                }
            }
        }
        return ret;
    }

    public String getPortIdString(int attribute, SJmoRemoteReplicationRCUPathInfo rcuPathInfo, SJmoRemoteReplicationRCUInfo rcuInfo) {
        short iRCUPortNo;
        Map<Short, String> remotePortIDMap;
        String portName;
        String ret = "?";
        if (null != rcuPathInfo && null != rcuInfo && null != (portName = (remotePortIDMap = SJctrRemoteReplicationUtility.getPortNameMap(rcuInfo.getIControllerID())).get(iRCUPortNo = SJctrRemoteReplicationUtility.getRemotePortId(rcuPathInfo, attribute))) && portName.length() > 0) {
            ret = this.getRemotePortName(portName);
        }
        return ret;
    }

    public String getDifferentialManagementString(SJctrCreateTrueCopyPairVolInfo createPairInfo) {
        String ret = "?";
        if (null != createPairInfo) {
            int diffMng = createPairInfo.getDifferentialManagement();
            switch (diffMng) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("CYLINDER_JP");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("TRACK");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("AUTO");
                    break;
                }
            }
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getDifferentialManagementString", "Argument is null.");
        }
        return ret;
    }

    public String getDfwToSecondaryVolumeString(SJmoTrueCopyPairVolInfo pairInfo, boolean isCreate) {
        String ret = "?";
        if (null != pairInfo) {
            boolean isRequire;
            ret = pairInfo.isVolPos(64) ? ((isRequire = pairInfo.getBehaviorBitSet().get(1)) ? (isCreate ? this.guidanceHandle.getGuidance("DFW_REQUIRE") : this.guidanceHandle.getGuidance("DFW_REQUIRED")) : (isCreate ? this.guidanceHandle.getGuidance("DFW_NOT_REQUIRE") : this.guidanceHandle.getGuidance("DFW_NOT_REQUIRED"))) : "-";
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getDfwToSecondaryVolumeString", "Argument is null.");
        }
        return ret;
    }

    public String getDfwToSecondaryVolumeString(SJmoTrueCopyPairVolInfo pairInfo) {
        String ret = "?";
        if (pairInfo != null) {
            ret = this.getDfwToSecondaryVolumeString(pairInfo, false);
        }
        return ret;
    }

    public String getCfwDataString(SJmoTrueCopyPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            if (SJctrRemoteReplicationUtility.isMainframe(pairInfo)) {
                if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
                    boolean isPvolOnly = pairInfo.getBehaviorBitSet().get(0);
                    ret = isPvolOnly ? this.guidanceHandle.getGuidance("CFW_PVOL_ONLY") : this.guidanceHandle.getGuidance("CFW_SVOL_COPY");
                } else if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
                    ret = "-";
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Unknown Copy Type.");
                }
            } else if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Unknown Copy Type.");
            }
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getCfwDataString", "Argument is null.");
        }
        return ret;
    }

    public String getInitialCopyTypeString(SJctrCreateTrueCopyPairVolInfo tcPairVolInfo) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            switch (tcPairVolInfo.getInitCopyType()) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("NONE");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("INIT_CP_TYPE_ENTIRE_VOL");
                    break;
                }
            }
        }
        return ret;
    }

    public String getInitialCopyTypeString(SJctrCreateUniversalReplicatorPairVolInfo urPairVolInfo) {
        String ret = "?";
        if (null != urPairVolInfo) {
            switch (urPairVolInfo.getInitCopyType()) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("NONE");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("INIT_CP_TYPE_ENTIRE");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("INIT_CP_TYPE_DELTA");
                    break;
                }
            }
        }
        return ret;
    }

    public String getCopyPaceString(SJmoTrueCopyPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            int track = pairInfo.getITracks();
            if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
                if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
                    ret = this.getTcCopyPaceString(track);
                } else if (SJctrRemoteReplicationUtility.isMainframe(pairInfo)) {
                    ret = this.getTcmfCopyPaceString(track);
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Unknown Copy Type.");
                }
            } else if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Invalid Copy Type.");
            }
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Argument is null.");
        }
        return ret;
    }

    private String getTcCopyPaceString(int track) {
        String ret = "?";
        if (129 <= track && track <= 143) {
            ret = String.valueOf(track &= 0xFFFFFF7F);
        }
        return ret;
    }

    private String getTcmfCopyPaceString(int track) {
        String ret = "?";
        if (0 <= track && track <= 255) {
            ret = track == 1 ? "3" : "15";
        }
        return ret;
    }

    public String getCfwString(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            if (pairInfo.isVolPos(262144)) {
                switch (pairInfo.getCFW()) {
                    case 0: {
                        ret = this.guidanceHandle.getGuidance("CFW_PVOL_ONLY");
                        break;
                    }
                    case 1: {
                        ret = this.guidanceHandle.getGuidance("CFW_SVOL_COPY");
                        break;
                    }
                }
            } else if (SJctrRemoteReplicationUtility.isOpen(pairInfo) || pairInfo.isVolPos(131072)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Unknown Copy Type.");
            }
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getCfwString", "Argument is null.");
        }
        return ret;
    }

    public String getCapacityDisplayString(SJctrCapacityUtility capUtil, SJmoLdevDetail ldev, long block) {
        if (null == capUtil || null == ldev) {
            return "?";
        }
        if (ldev.getbOpenVolume()) {
            return capUtil.toUnitString(block);
        }
        return capUtil.toString(block, SJctrCapacityUtility.UNIT.CYL, ldev.getIEmulationType()) + " " + capUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
    }

    public String getLocalProvisioningTypeString(SJctrRemoteHistoriesBaseInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            ret = this.getProvisioningTypeString(histInfo.getLocalProvType());
        }
        return ret;
    }

    public String getRemoteProvisioningTypeString(SJctrRemoteHistoriesBaseInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            ret = this.getProvisioningTypeString(histInfo.getRemoteProvType());
        }
        return ret;
    }

    private String getProvisioningTypeString(String provTypeString) {
        String ret = "?";
        if (provTypeString != null) {
            if (provTypeString.length() == 0) {
                ret = this.guidanceHandle.getGuidance("BASIC_VOL");
            } else if (provTypeString.equals("X")) {
                ret = this.guidanceHandle.getGuidance("AOU-VVOL");
            } else if (provTypeString.equals("#")) {
                ret = this.guidanceHandle.getGuidance("EXTERNAL_VOL");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getProvisioningTypeString", "provTypeString is invalid.");
            }
        }
        return ret;
    }

    public String getCopyTimeString(SJctrRemoteHistoriesTcInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            String dateString;
            ret = SJctrRemoteReplicationUtility.isValidCopyTime(histInfo) ? (SJctrRemoteReplicationUtility.convHmsStringToLong(dateString = histInfo.getCopyTime()) >= 0L ? dateString : "-") : "-";
        }
        return ret;
    }

    public String getStartedString(SJctrRemoteHistoriesTcInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            String dateString;
            ret = SJctrRemoteReplicationUtility.isValidCopyTime(histInfo) ? (SJctrRemoteReplicationUtility.convYmdHmsStringToLong(dateString = histInfo.getCopyStartDate()) > 0L ? dateString : "-") : "-";
        }
        return ret;
    }

    public String getCopyTimeString(SJctrRemoteHistoriesUrInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            if (SJctrRemoteReplicationUtility.isValidCopyTime(histInfo)) {
                String dateString = histInfo.getCopyTime();
                if ("         ".equals(dateString)) {
                    ret = "-";
                } else if (SJctrRemoteReplicationUtility.convHmsStringToLong(dateString) >= 0L) {
                    ret = dateString;
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getDescriptionString(SJctrRemoteHistoriesTcInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            int operation = histInfo.getOperation();
            switch (operation) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_ADD_START");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_ADD_COMP");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_DELETE");
                    break;
                }
                case 4: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_SUSPEND_OPERATION");
                    break;
                }
                case 5: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_SUSPEND_FAILURE");
                    break;
                }
                case 6: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_RESYNC_START");
                    break;
                }
                case 7: {
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "TC_PAIR_RESYNC_COMP");
                    break;
                }
                default: {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getDescriptionString", "Description is unknown.");
                    ret = this.guidanceHandle.getGuidance("REPLICATION", "UNKNOWN_OPERATION");
                }
            }
        }
        return ret;
    }

    public String getSSIDString(SJctrRemoteConnectionSSIDInfo ssidInfo) {
        int ssid;
        String ret = "?";
        if (ssidInfo != null && -1 != (ssid = ssidInfo.getSSID())) {
            ret = SJctrComUtility.toHexString(ssid, 4, true);
        }
        return ret;
    }

    public static int getTcPairStatusIconId(SJmoTrueCopyPairVolInfo tcPairInfo) {
        int icon = 16431;
        if (null != tcPairInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(tcPairInfo)) {
                icon = SJctrRemoteReplicationUtility.getOpenTcPairStatusIconId(tcPairInfo);
            } else if (SJctrRemoteReplicationUtility.isMainframe(tcPairInfo)) {
                icon = SJctrRemoteReplicationUtility.getMFTcPairStatusIconId(tcPairInfo);
            } else {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getTcPairStatusIconId", "SJmoTrueCopyPairVolInfo has returned an invalid value.");
            }
        }
        return icon;
    }

    public static int getOpenTcPairStatusIconId(SJmoTrueCopyPairVolInfo tcPairInfo) {
        int icon = 16431;
        if (null != tcPairInfo) {
            int pairStatus = tcPairInfo.getIPairStatus();
            switch (pairStatus) {
                case 1: {
                    icon = 16406;
                    break;
                }
                case 2: 
                case 193: {
                    icon = 16403;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 99: {
                    icon = 16404;
                    break;
                }
                case 8: 
                case 9: 
                case 80: {
                    icon = 16405;
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getOpenTcPairStatusIconId", "SJmoTrueCopyPairVolInfo.getIPairStatus() has returned an invalid value.");
                }
            }
        }
        return icon;
    }

    public static int getMFTcPairStatusIconId(SJmoTrueCopyPairVolInfo tcPairInfo) {
        int icon = SJctrRemoteReplicationUtility.getOpenTcPairStatusIconId(tcPairInfo);
        return icon;
    }

    public static int getUrPairStatusIconId(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        int icon = 16431;
        if (null != urPairInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(urPairInfo)) {
                icon = SJctrRemoteReplicationUtility.getOpenUrPairStatusIconId(urPairInfo);
            } else if (SJctrRemoteReplicationUtility.isMainframe(urPairInfo)) {
                icon = SJctrRemoteReplicationUtility.getMFUrPairStatusIconId(urPairInfo);
            } else {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getUrPairStatusIconId", "SJmoUniversalReplicatorPairVolInfo has returned an invalid value.");
            }
        }
        return icon;
    }

    public static int getOpenUrPairStatusIconId(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        int icon = 16431;
        if (null != urPairInfo) {
            int delta = urPairInfo.getDelta();
            block0 : switch (delta) {
                case 0: {
                    int pairStatus = urPairInfo.getPairStatus();
                    switch (pairStatus) {
                        case 1: {
                            icon = 16406;
                            break block0;
                        }
                        case 2: {
                            icon = 16403;
                            break block0;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            icon = 16404;
                            break block0;
                        }
                        case 8: 
                        case 9: 
                        case 80: 
                        case 96: 
                        case 98: 
                        case 99: {
                            icon = 16405;
                            break block0;
                        }
                        case 97: {
                            icon = 16409;
                            break block0;
                        }
                    }
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getOpenUrPairStatusIconId", "SJmoUniversalReplicatorPairVolInfo.getIPairStatus() has returned an invalid value.");
                    break;
                }
                case 2: 
                case 6: {
                    icon = 16404;
                    break;
                }
                case 3: {
                    icon = 16405;
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getOpenUrPairStatusIconId", "SJmoUniversalReplicatorPairVolInfo.getDelta() has returned an invalid value.");
                }
            }
        }
        return icon;
    }

    public static int getMFUrPairStatusIconId(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        int icon = SJctrRemoteReplicationUtility.getOpenUrPairStatusIconId(urPairInfo);
        return icon;
    }

    public static int getMirrorStatusIconId(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        int icon = 16432;
        if (null != jnlGrpMirror) {
            int delta = jnlGrpMirror.getDelta();
            block0 : switch (delta) {
                case 0: {
                    int status = jnlGrpMirror.getStatus();
                    switch (status) {
                        case 0: {
                            icon = 16415;
                            break block0;
                        }
                        case 16: {
                            if (1 == jnlGrpMirror.getPairSuspend()) {
                                icon = 16417;
                                break block0;
                            }
                            icon = 16416;
                            break block0;
                        }
                        case 17: 
                        case 32: 
                        case 34: 
                        case 64: 
                        case 68: {
                            icon = 16418;
                            break block0;
                        }
                    }
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getMirrorStatusIconId", "SJmoUniversalReplicatorJnlGrpMirror.getStatus() has returned an invalid value.");
                    break;
                }
                case 1: 
                case 3: {
                    icon = 16418;
                    break;
                }
                case 2: {
                    icon = 16421;
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getMirrorStatusIconId", "SJmoUniversalReplicatorJnlGrpMirror.getDelta() has returned an invalid value.");
                }
            }
        }
        return icon;
    }

    public static int getPathStatusIconId(SJmoRemoteReplicationRCUInfo rcuInfo) {
        ArrayList rcuPathInfoList;
        int icon = 12294;
        if (null != rcuInfo && (rcuPathInfoList = rcuInfo.getPathInfoList()) != null) {
            if (rcuPathInfoList.size() > 0) {
                int iCntError = 0;
                for (SJmoRemoteReplicationRCUPathInfo rcuPathInfo : rcuPathInfoList) {
                    if (1 == rcuPathInfo.getIPathStatus()) continue;
                    ++iCntError;
                }
                icon = iCntError == 0 ? 12289 : (iCntError == rcuPathInfoList.size() ? 12292 : 12291);
            } else if (rcuPathInfoList.size() == 0) {
                icon = 12289;
            }
        }
        return icon;
    }

    public String getTcPairPositionString(SJmoTrueCopyPairVolInfo tcPairVolInfo) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isPvol(tcPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("SECONDARY");
            } else if (SJctrRemoteReplicationUtility.isSvol(tcPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("PRIMARY");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getTcPairPositionString", "Pair position is invalid.");
            }
        }
        return ret;
    }

    public String getUrPairPositionString(SJmoUniversalReplicatorPairVolInfo urPairVolInfo) {
        String ret = "?";
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isPvol(urPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("SECONDARY");
            } else if (SJctrRemoteReplicationUtility.isSvol(urPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("PRIMARY");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getUrPairPositionString", "Pair position is invalid.");
            }
        }
        return ret;
    }

    public String getUrCreatePairPositionString(SJctrCreateUniversalReplicatorPairVolInfo createPairInfo, SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String ret = this.guidanceHandle.getGuidance("PRIMARY");
        if (createPairInfo == null) {
            ret = "?";
        } else if (pairInfo == null) {
            ret = this.guidanceHandle.getGuidance("PRIMARY");
        } else if (SJctrRemoteReplicationUtility.isUrMultiPairDeltaSecodary(createPairInfo, pairInfo)) {
            ret = this.guidanceHandle.getGuidance("SECONDARY");
        }
        return ret;
    }

    public static boolean isUrMultiPairDeltaSecodary(SJctrCreateUniversalReplicatorPairVolInfo createPairInfo, SJmoUniversalReplicatorPairVolInfo pairInfo) {
        boolean ret = false;
        if (SJctrRemoteReplicationUtility.isPvol(pairInfo) && createPairInfo.getInitCopyType() == 2) {
            ret = true;
        }
        return ret;
    }

    public String getCopyTypeString(SJmoTrueCopyPairVolInfo tcPairVolInfo) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(tcPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("TC_COPY");
            } else if (SJctrRemoteReplicationUtility.isMainframe(tcPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("TC_MF_COPY");
            }
        }
        return ret;
    }

    public String getCopyTypeString(SJmoUniversalReplicatorPairVolInfo urPairVolInfo) {
        String ret = "?";
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(urPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("UR_COPY");
            } else if (SJctrRemoteReplicationUtility.isMainframe(urPairVolInfo)) {
                ret = this.guidanceHandle.getGuidance("UR_MF_COPY");
            }
        }
        return ret;
    }

    public String getTcCopyStatusString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        return this.getTcCopyStatusString(pairVolInfo, false);
    }

    public String getTcCopyStatusString(SJmoTrueCopyPairVolInfo pairVolInfo, boolean needSplit) {
        int hostPairEnable;
        String splitTypeKey;
        int status;
        String ret = "?";
        if (null == pairVolInfo) {
            return ret;
        }
        Map splitTypeMap = null;
        if (SJctrRemoteReplicationUtility.isOpen(pairVolInfo)) {
            splitTypeMap = SJctrRemoteReplicationDataMacro.GUID_SUSP_TYPE_MAP_TC;
            status = pairVolInfo.getIPairStatus();
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY");
                    break;
                }
                case 2: 
                case 193: {
                    ret = this.guidanceHandle.getGuidance("ST_PAIR");
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 99: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUS");
                    break;
                }
                case 8: 
                case 9: 
                case 80: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUE");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getTcCopyStatusString", "SJmoTrueCopyPairVolInfo.getIPairStatus() has returned an invalid value.");
                    break;
                }
            }
        } else if (SJctrRemoteReplicationUtility.isMainframe(pairVolInfo)) {
            splitTypeMap = SJctrRemoteReplicationDataMacro.GUID_SUSP_TYPE_MAP_TCMF;
            status = pairVolInfo.getIPairStatus();
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SIMPLEX");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ST_PENDING");
                    break;
                }
                case 2: 
                case 193: {
                    ret = this.guidanceHandle.getGuidance("ST_DUPLEX");
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 80: 
                case 99: {
                    ret = this.guidanceHandle.getGuidance("ST_SUSP");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getTcCopyStatusString", "SJmoTrueCopyPairVolInfo.getIPairStatus() has returned an invalid value.");
                }
            }
        }
        String status2 = new String(ret);
        if (needSplit && null != splitTypeMap && null != (splitTypeKey = (String)splitTypeMap.get(pairVolInfo.getIPairStatus()))) {
            ret = ret + this.guidanceHandle.getGuidance(splitTypeKey);
        }
        if (1 == (hostPairEnable = pairVolInfo.getIFormatinfo())) {
            String hostPairStat = pairVolInfo.getStrHostPairStatus();
            if (null != hostPairStat && hostPairStat.length() > 0) {
                if (!status2.equals(hostPairStat)) {
                    ret = ret + " / " + hostPairStat;
                }
            } else {
                ret = ret + " / ?";
            }
        }
        return ret;
    }

    public String getUrCopyStatusString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        return this.getUrCopyStatusString(pairVolInfo, false);
    }

    public String getUrCopyStatusString(SJmoUniversalReplicatorPairVolInfo pairVolInfo, boolean needSplit) {
        int hostPairEnable;
        String splitTypeKey;
        int status;
        int delta;
        String ret = "?";
        if (null == pairVolInfo) {
            return ret;
        }
        Map splitTypeMap = null;
        if (SJctrRemoteReplicationUtility.isOpen(pairVolInfo)) {
            delta = pairVolInfo.getDelta();
            block0 : switch (delta) {
                case 0: {
                    splitTypeMap = SJctrRemoteReplicationDataMacro.GUID_SUSP_TYPE_MAP_UR;
                    status = pairVolInfo.getPairStatus();
                    switch (status) {
                        case 0: {
                            ret = this.guidanceHandle.getGuidance("ST_SMPL");
                            break block0;
                        }
                        case 1: {
                            ret = this.guidanceHandle.getGuidance("ST_COPY");
                            break block0;
                        }
                        case 2: {
                            ret = this.guidanceHandle.getGuidance("ST_PAIR");
                            break block0;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ret = this.guidanceHandle.getGuidance("ST_PSUS");
                            break block0;
                        }
                        case 8: 
                        case 9: 
                        case 80: 
                        case 98: 
                        case 99: {
                            ret = this.guidanceHandle.getGuidance("ST_PSUE");
                            break block0;
                        }
                        case 96: {
                            ret = this.guidanceHandle.getGuidance("ST_S_SUSPENDING");
                            break block0;
                        }
                        case 97: {
                            ret = this.guidanceHandle.getGuidance("ST_S_DELETING");
                            break block0;
                        }
                    }
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getUrCopyStatusString", "SJmoUniversalReplicatorPairVolInfo.getPairStatus() has returned an invalid value.");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("PAIR_ST_UR_HOLD");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("PAIR_ST_UR_HLDE");
                    break;
                }
                case 6: {
                    ret = this.guidanceHandle.getGuidance("PAIR_ST_UR_HOLDING");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getUrCopyStatusString", "SJmoUniversalReplicatorPairVolInfo.getDelta() has returned an invalid value.");
                    break;
                }
            }
        } else if (SJctrRemoteReplicationUtility.isMainframe(pairVolInfo)) {
            delta = pairVolInfo.getDelta();
            block15 : switch (delta) {
                case 0: {
                    splitTypeMap = SJctrRemoteReplicationDataMacro.GUID_SUSP_TYPE_MAP_URMF;
                    status = pairVolInfo.getPairStatus();
                    switch (status) {
                        case 0: {
                            ret = this.guidanceHandle.getGuidance("ST_S_SIMPLEX");
                            break block15;
                        }
                        case 1: {
                            ret = this.guidanceHandle.getGuidance("ST_S_PENDING");
                            break block15;
                        }
                        case 2: {
                            ret = this.guidanceHandle.getGuidance("ST_S_DUPLEX");
                            break block15;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 80: 
                        case 98: 
                        case 99: {
                            ret = this.guidanceHandle.getGuidance("ST_SUSP");
                            break block15;
                        }
                        case 96: {
                            ret = this.guidanceHandle.getGuidance("ST_S_SUSPENDING");
                            break block15;
                        }
                        case 97: {
                            ret = this.guidanceHandle.getGuidance("ST_S_DELETING");
                            break block15;
                        }
                    }
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getUrCopyStatusString", "SJmoUniversalReplicatorPairVolInfo.getPairStatus() has returned an invalid value.");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("PAIR_ST_URMF_HOLD");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("PAIR_ST_URMF_HLDE");
                    break;
                }
                case 6: {
                    ret = this.guidanceHandle.getGuidance("PAIR_ST_URMF_HOLDING");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getUrCopyStatusString", "SJmoUniversalReplicatorPairVolInfo.getDelta() has returned an invalid value.");
                }
            }
        }
        String status2 = new String(ret);
        if (needSplit && null != splitTypeMap && null != (splitTypeKey = (String)splitTypeMap.get(pairVolInfo.getPairStatus()))) {
            ret = ret + this.guidanceHandle.getGuidance(splitTypeKey);
        }
        if (1 == (hostPairEnable = pairVolInfo.getHostPairEnable())) {
            String hostPairStat = pairVolInfo.getHostPairStatus();
            if (null != hostPairStat && hostPairStat.length() > 0) {
                if (!status2.equals(hostPairStat)) {
                    ret = ret + " / " + hostPairStat;
                }
            } else {
                ret = ret + " / ?";
            }
        }
        return ret;
    }

    public String getTcModelSerialString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            int controllerID = pairVolInfo.getIPairControllerID();
            String pairSN = pairVolInfo.getStrPairSN();
            ret = this.getModelSNoString(controllerID, pairSN);
        }
        return ret;
    }

    public String getUrModelSerialString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            int controllerID = pairVolInfo.getModelId();
            String pairSN = pairVolInfo.getPairSN();
            ret = this.getModelSNoString(controllerID, pairSN);
        }
        return ret;
    }

    public String getSsidString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null == pairVolInfo) {
            return ret;
        }
        ret = 1 == pairVolInfo.getICUFree() ? "-" : SJctrComUtility.toHexString(pairVolInfo.getIPairSSID(), 4, true);
        return ret;
    }

    public String getTcPathGrpIdString(SJmoTrueCopyPairVolInfo tcPairVolInfo) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            int iCuFree = tcPairVolInfo.getICUFree();
            int iPairRCUID = tcPairVolInfo.getIPairRCUID();
            ret = this.getPathGroupIdString(iCuFree, iPairRCUID);
        }
        return ret;
    }

    public String getUpdateTypeString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (this.checkBitSet(pairVolInfo.getTypeBitSet(), 4, 6, SJctrRemoteReplicationDataMacro.bsSync)) {
                BitSet behaviorBitSet = pairVolInfo.getBehaviorBitSet();
                ret = behaviorBitSet.get(13) ? this.guidanceHandle.getGuidance("UPDATE_TYPE_SYNC_SPECIFIED_CTG") : this.guidanceHandle.getGuidance("UPDATE_TYPE_SYNC");
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getUpdateTypeString", "Update type is invalid.");
            }
        }
        return ret;
    }

    private boolean checkBitSet(BitSet baseBitSet, int sPos, int ePos, BitSet compBitSet) {
        BitSet bitSet = new BitSet();
        for (int index = 0; index <= ePos - sPos; ++index) {
            bitSet.set(index, baseBitSet.get(sPos + index));
        }
        return compBitSet.equals(bitSet);
    }

    public String getPreserveMirrorStatus(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 15, 15, SJctrRemoteReplicationDataMacro.bsUsual)) {
                ret = "-";
            } else if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 15, 15, SJctrRemoteReplicationDataMacro.bsCancell)) {
                ret = this.guidanceHandle.getGuidance("WITHDRAWN");
            }
        }
        return ret;
    }

    public String getFenceLevelString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null == pairVolInfo) {
            return ret;
        }
        if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 2, 4, SJctrRemoteReplicationDataMacro.bsNever)) {
            ret = this.guidanceHandle.getGuidance("FENCE_LV_NEVER");
        } else if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 2, 4, SJctrRemoteReplicationDataMacro.bsSVolData)) {
            ret = this.guidanceHandle.getGuidance("FENCE_LV_DATA");
        } else if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 2, 4, SJctrRemoteReplicationDataMacro.bsSVolStatus)) {
            ret = this.guidanceHandle.getGuidance("FENCE_LV_STATUS");
        }
        return ret;
    }

    public String getDiffManageString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (this.checkBitSet(pairVolInfo.getTypeBitSet(), 7, 8, SJctrRemoteReplicationDataMacro.bsCylinder)) {
                ret = this.guidanceHandle.getGuidance("CYLINDER_JP");
            } else if (this.checkBitSet(pairVolInfo.getTypeBitSet(), 7, 8, SJctrRemoteReplicationDataMacro.bsTrack)) {
                ret = this.guidanceHandle.getGuidance("TRACK");
            }
        }
        return ret;
    }

    public String getLocalJnlIdString(SJmoUniversalReplicatorPairVolInfo urPairVolInfo) {
        String ret = "?";
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isPvol(urPairVolInfo)) {
                ret = this.getJnlIdString(urPairVolInfo.getRJnlGrpId());
            } else if (SJctrRemoteReplicationUtility.isSvol(urPairVolInfo)) {
                ret = this.getJnlIdString(urPairVolInfo.getMJnlGrpId());
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getLocalJnlIdString", "SJmoUniversalReplicatorPairVolInfo.iPairVolPos is invalid.");
            }
        }
        return ret;
    }

    public String getRemoteJnlIdString(SJmoUniversalReplicatorPairVolInfo urPairVolInfo) {
        String ret = "?";
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isPvol(urPairVolInfo)) {
                ret = this.getJnlIdString(urPairVolInfo.getMJnlGrpId());
            } else if (SJctrRemoteReplicationUtility.isSvol(urPairVolInfo)) {
                ret = this.getJnlIdString(urPairVolInfo.getRJnlGrpId());
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getRemoteJnlIdString", "SJmoUniversalReplicatorPairVolInfo.iPairVolPos is invalid.");
            }
        }
        return ret;
    }

    public String getJnlIdString(SJmoJnlGroupIndex jnlGrpIndex) {
        String ret = "?";
        if (jnlGrpIndex != null) {
            ret = this.getJnlIdString(jnlGrpIndex.getIJnlGroupId());
        }
        return ret;
    }

    public String getJnlEncryptionString(SJmoUniversalReplicatorJnlGrp jnlGrpInfo) {
        String ret = "?";
        if (jnlGrpInfo != null) {
            int jnlEncrypt = jnlGrpInfo.getIEncrypt();
            ret = (jnlEncrypt & 8) == 8 ? "-" : (jnlEncrypt == 4 ? "-" : (jnlEncrypt == 2 ? this.guidanceHandle.getGuidance("ENABLED") : (jnlEncrypt == 1 ? this.guidanceHandle.getGuidance("DISABLED") : (jnlEncrypt == 0 ? "-" : this.guidanceHandle.getGuidance("MIXED")))));
        }
        return ret;
    }

    public String getPairJnlIdString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            ret = 0 == jnlGrpMirror.getStatus() ? "-" : this.getJnlIdString(jnlGrpMirror.getPairJnlGrpId());
        }
        return ret;
    }

    public String getJnlIdString(int jnlGrpId) {
        return SJctrComUtility.toHexString(jnlGrpId, 3, true);
    }

    public String getMirrorIdString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            ret = SJctrRemoteReplicationUtility.getMirrorIdString(pairVolInfo.getMirrorId());
        }
        return ret;
    }

    public String getUrCtgIdString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null == pairVolInfo) {
            return ret;
        }
        int enableCtg = pairVolInfo.getCtgEnable();
        if (enableCtg == 1) {
            ret = this.editCtgIdString(pairVolInfo.getCtgId());
        } else if (enableCtg == 0) {
            ret = "-";
        }
        return ret;
    }

    private String editCtgIdString(int iCtgId) {
        String ret = SJctrComUtility.toHexString(iCtgId, 3, true);
        return ret;
    }

    public String getTimeStampTranString(SJmoTrueCopyPairVolInfo pairVolInfo, boolean isCreate) {
        String ret = "?";
        if (null == pairVolInfo) {
            return ret;
        }
        if (SJctrRemoteReplicationUtility.isMainframe(pairVolInfo)) {
            if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 12, 12, SJctrRemoteReplicationDataMacro.bsUntran)) {
                ret = isCreate ? this.guidanceHandle.getGuidance("DISABLE") : this.guidanceHandle.getGuidance("DISABLED");
            } else if (this.checkBitSet(pairVolInfo.getBehaviorBitSet(), 12, 12, SJctrRemoteReplicationDataMacro.bsTran)) {
                ret = isCreate ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("ENABLED");
            }
        } else if (SJctrRemoteReplicationUtility.isOpen(pairVolInfo)) {
            ret = "-";
        }
        return ret;
    }

    public String getTimeStampTranString(SJmoTrueCopyPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = this.getTimeStampTranString(pairVolInfo, false);
        }
        return ret;
    }

    public String getErrorLevelString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            switch (pairVolInfo.getErrLv()) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ERROR_LEVEL_MIRROR");
                    break;
                }
                case 1: {
                    if (SJctrRemoteReplicationUtility.isOpen(pairVolInfo)) {
                        ret = this.guidanceHandle.getGuidance("ERROR_LEVEL_LU");
                        break;
                    }
                    if (!SJctrRemoteReplicationUtility.isMainframe(pairVolInfo)) break;
                    ret = this.guidanceHandle.getGuidance("ERROR_LEVEL_VOLUME");
                }
            }
        }
        return ret;
    }

    public String getMirrorIdString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            ret = SJctrRemoteReplicationUtility.getMirrorIdString(jnlGrpMirror.getMirrorId());
        }
        return ret;
    }

    public static String getMirrorIdString(int mirrorId) {
        return Integer.toString(mirrorId);
    }

    public String getAttributeString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            int mirrorAttribute = jnlGrpMirror.getAttribute();
            switch (mirrorAttribute) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_INITIAL");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_MASTER");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("ATTRIBUTE_RESTORE");
                    break;
                }
            }
        }
        return ret;
    }

    public String getMirrorStatusString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null == jnlGrpMirror) {
            return ret;
        }
        int delta = jnlGrpMirror.getDelta();
        block0 : switch (delta) {
            case 0: {
                int status = jnlGrpMirror.getStatus();
                switch (status) {
                    case 0: {
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_INITIAL");
                        break block0;
                    }
                    case 16: {
                        if (1 == jnlGrpMirror.getPairSuspend()) {
                            ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_ACTIVE_WARNING");
                            break block0;
                        }
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_ACTIVE");
                        break block0;
                    }
                    case 17: {
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_HALT_ACCEPT");
                        break block0;
                    }
                    case 32: {
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_HALT");
                        break block0;
                    }
                    case 34: {
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_HALTING");
                        break block0;
                    }
                    case 64: {
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_STOPPED");
                        break block0;
                    }
                    case 68: {
                        ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_STOPPING");
                        break block0;
                    }
                }
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getMirrorStatusString", "SJmoUniversalReplicatorJnlGrpMirror.getStatus(); has returned an invalid value.");
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_HOLD");
                break;
            }
            case 2: {
                ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_HOLD_FAILURE");
                break;
            }
            case 3: {
                ret = this.guidanceHandle.getGuidance("MIRROR_STATUS_HOLDING");
                break;
            }
            default: {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getMirrorStatusString", "SJmoUniversalReplicatorJnlGrpMirror.getDelta(); has returned an invalid value.");
            }
        }
        int hostMirrorEnable = jnlGrpMirror.getHostMirrorEnable();
        if (1 == hostMirrorEnable) {
            String hostMirrorStat = jnlGrpMirror.getHostMirrorStatus();
            if (null != hostMirrorStat && hostMirrorStat.length() > 0) {
                if (!ret.equals(hostMirrorStat)) {
                    ret = ret + " / " + hostMirrorStat;
                }
            } else {
                ret = ret + " / ?";
            }
        }
        return ret;
    }

    public String getMirrorModelSerialString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            if (0 == jnlGrpMirror.getStatus()) {
                ret = "-";
            } else {
                int controllerID = jnlGrpMirror.getModelId();
                String pairSN = jnlGrpMirror.getPairSN();
                ret = this.getModelSNoString(controllerID, pairSN);
            }
        }
        return ret;
    }

    public String getNumOfDataVolsSerialString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            ret = Integer.toString(jnlGrpMirror.getNumOfDataVols());
        }
        return ret;
    }

    public String getDataCapacityString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror, SJmoUniversalReplicatorJnlGrp jnlGrp, SJctrCapacityUtility capUtil, SJctrCapacityUtility.UNIT unit) {
        String ret = "?";
        if (jnlGrpMirror != null && jnlGrp != null) {
            long capacity = jnlGrpMirror.getDataVolCapa();
            if (null == unit) {
                ret = capUtil.toUnitString(capacity);
            } else if (SJctrCapacityUtility.UNIT.CYL == unit) {
                String strDataVolEmu = jnlGrp.getDataVolEmu();
                ret = capUtil.toCylString(capacity, strDataVolEmu) + " " + capUtil.getUnitString(unit);
            } else {
                ret = capUtil.toString(capacity, unit) + " " + capUtil.getUnitString(unit);
            }
        }
        return ret;
    }

    public String getCtgIdString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            int ctgExist;
            ret = 0 == jnlGrpMirror.getStatus() ? "-" : (1 == (ctgExist = jnlGrpMirror.getCtGrp()) ? this.editCtgIdString(jnlGrpMirror.getCtGrpId()) : "-");
        }
        return ret;
    }

    public String getRemComDeviceString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror, SJmoUniversalReplicatorJnlGrp jnlGrp, SJctrLdevUtility ldevUtil) {
        String ret = "?";
        if (null != jnlGrpMirror && null != jnlGrp) {
            ret = 0 == jnlGrpMirror.getStatus() ? (0 == jnlGrpMirror.getIMirrorId() ? (0 != jnlGrp.getUcPathForTC() ? this.editRemComDeviceString(jnlGrp.getRcmdDevForTC(), ldevUtil) : "") : "-") : (0 != jnlGrpMirror.getUcPath() ? this.editRemComDeviceString(jnlGrpMirror.getRcmdDev(), ldevUtil) : "");
        }
        return ret;
    }

    public String editRemComDeviceString(int iRcmdDev, SJctrLdevUtility ldevUtil) {
        String ret = "?";
        if (-1 == iRcmdDev) {
            ret = this.guidanceHandle.getGuidance("UNUSED");
        } else {
            SJmoLdevIndex ldev = new SJmoLdevIndex();
            ldev.setLdevIndex((short)((iRcmdDev & 0xFF0000) >>> 16), (short)((iRcmdDev & 0xFF00) >>> 8), (short)(iRcmdDev & 0xFF));
            ret = ldevUtil.toLdevDisplay(ldev);
        }
        return ret;
    }

    public String getPortNameString(SJmoTrueCopyPairVolInfo tcPairVolInfo) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(tcPairVolInfo)) {
                Map<Short, String> remotePortIDMap = SJctrRemoteReplicationUtility.getPortNameMap(tcPairVolInfo.getIPairControllerID());
                String portName = remotePortIDMap.get(tcPairVolInfo.getPairLU().getSPort());
                if (null != portName) {
                    ret = this.getRemotePortName(portName);
                }
            } else if (SJctrRemoteReplicationUtility.isMainframe(tcPairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getPortNameString", "Invalid Copy Type.");
            }
        }
        return ret;
    }

    public String getUrPortNameString(SJmoUniversalReplicatorPairVolInfo urPairVolInfo) {
        String ret = "?";
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(urPairVolInfo)) {
                short sPort = -1;
                if (SJctrRemoteReplicationUtility.isPvol(urPairVolInfo)) {
                    sPort = urPairVolInfo.getPVolLuPath().getLuPath().getSPort();
                } else if (SJctrRemoteReplicationUtility.isSvol(urPairVolInfo)) {
                    sPort = urPairVolInfo.getSVolLuPath().getLuPath().getSPort();
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getUrPortNameString", "Pair position is invalid.");
                }
                if (sPort != -1) {
                    Map<Short, String> remotePortIDMap = SJctrRemoteReplicationUtility.getPortNameMap(urPairVolInfo.getModelId());
                    ret = this.getRemotePortName(remotePortIDMap.get(sPort));
                }
            } else if (SJctrRemoteReplicationUtility.isMainframe(urPairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getUrPortNameString", "Copy type pair position is invalid.");
            }
        }
        return ret;
    }

    public String getHgIdString(SJmoTrueCopyPairVolInfo tcPairVolInfo) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(tcPairVolInfo)) {
                ret = SJctrComUtility.toHexString(tcPairVolInfo.getPairLU().getSHostGroup(), 2, true);
            } else if (SJctrRemoteReplicationUtility.isMainframe(tcPairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getHgIdString", "Pair position is invalid.");
            }
        }
        return ret;
    }

    public String getUrHgIdString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(pairVolInfo)) {
                int sHostGroup = -1;
                if (SJctrRemoteReplicationUtility.isPvol(pairVolInfo)) {
                    sHostGroup = pairVolInfo.getPVolLuPath().getLuPath().getSHostGroup();
                    ret = SJctrComUtility.toHexString(sHostGroup, 2, true);
                } else if (SJctrRemoteReplicationUtility.isSvol(pairVolInfo)) {
                    sHostGroup = pairVolInfo.getSVolLuPath().getLuPath().getSHostGroup();
                    ret = SJctrComUtility.toHexString(sHostGroup, 2, true);
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getUrHgIdString", "Pair position is invalid.");
                }
            } else if (SJctrRemoteReplicationUtility.isMainframe(pairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getUrHgIdString", "Copy type pair position is invalid.");
            }
        }
        return ret;
    }

    public String getLunIdString(SJmoTrueCopyPairVolInfo tcPairVolInfo, boolean isLunDec) {
        String ret = "?";
        if (null != tcPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(tcPairVolInfo)) {
                ret = isLunDec ? Integer.toString(tcPairVolInfo.getPairLU().getILUN()) : SJctrComUtility.toHexString(tcPairVolInfo.getPairLU().getILUN(), 4, true);
            } else if (SJctrRemoteReplicationUtility.isMainframe(tcPairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getLunIdString", "Pair position is invalid.");
            }
        }
        return ret;
    }

    public String getUrLunIdString(SJmoUniversalReplicatorPairVolInfo urPairVolInfo, boolean isLunDec) {
        String ret = "?";
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.isOpen(urPairVolInfo)) {
                int iLUN = -1;
                if (SJctrRemoteReplicationUtility.isPvol(urPairVolInfo)) {
                    iLUN = urPairVolInfo.getPVolLuPath().getLuPath().getILUN();
                } else if (SJctrRemoteReplicationUtility.isSvol(urPairVolInfo)) {
                    iLUN = urPairVolInfo.getSVolLuPath().getLuPath().getILUN();
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getUrLunIdString", "Pair position is invalid.");
                }
                if (iLUN != -1) {
                    ret = isLunDec ? Integer.toString(iLUN) : SJctrComUtility.toHexString(iLUN, 4, true);
                }
            } else if (SJctrRemoteReplicationUtility.isMainframe(urPairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getUrLunIdString", "Copy type pair position is invalid.");
            }
        }
        return ret;
    }

    public String getSubStatusString(SJmoUniversalReplicatorPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (SJctrRemoteReplicationUtility.isMainframePvol(pairVolInfo)) {
                int iDelta = pairVolInfo.getDelta();
                if (iDelta == 0) {
                    int seqChk = pairVolInfo.getSeqChk();
                    String seqChkStr = "";
                    if (1 == seqChk) {
                        seqChkStr = this.guidanceHandle.getGuidance("SEQCHK");
                    } else if (0 != seqChk) {
                        SJctrLogUty.error(this.getClass().getSimpleName(), "getSubStatusString", "SEQCHK is failure.");
                        return ret;
                    }
                    String ctAgreeStr = "";
                    if (SJctrRemoteReplicationDataMacro.SUB_STATUS_PERMISSION_STATUS_UR.contains(pairVolInfo.getPairStatus())) {
                        int ctAgree = pairVolInfo.getCTAgree();
                        if (0 == ctAgree) {
                            ctAgreeStr = this.guidanceHandle.getGuidance("ERROR_LEVEL_MIRROR");
                        } else if (1 == ctAgree) {
                            ctAgreeStr = this.guidanceHandle.getGuidance("ERROR_LEVEL_VOLUME");
                        } else {
                            SJctrLogUty.error(this.getClass().getSimpleName(), "getSubStatusString", "CT agree is failure.");
                            return ret;
                        }
                    }
                    ret = !seqChkStr.equals("") && !ctAgreeStr.equals("") ? seqChkStr + "," + " " + ctAgreeStr : (!seqChkStr.equals("") && ctAgreeStr.equals("") ? seqChkStr : (seqChkStr.equals("") && !ctAgreeStr.equals("") ? ctAgreeStr : "-"));
                } else {
                    ret = "-";
                }
            } else if (SJctrRemoteReplicationUtility.isOpen(pairVolInfo) || SJctrRemoteReplicationUtility.isMainframeSvol(pairVolInfo)) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getSubStatusString", "Pair position is invalid.");
            }
        }
        return ret;
    }

    public String getPathGroupIdString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            if (0 == jnlGrpMirror.getStatus()) {
                ret = "-";
            } else {
                ArrayList pathIdList = jnlGrpMirror.getPathIdList();
                if (null != pathIdList && pathIdList.size() > 0) {
                    ret = this.getPathGroupIdString(1, (Integer)pathIdList.get(0));
                }
            }
        }
        return ret;
    }

    public int getModelIDfromSubsysInfo(SJmoSubsystemInfo sybsysInfo) {
        int ret = -1;
        ret = SJctrDataController.isHM() ? 18 : 5;
        if (sybsysInfo == null) {
            return ret;
        }
        String modelName = sybsysInfo.getDKCProductName();
        if (modelName.equals("RAID700") || modelName.equals("P9500")) {
            ret = 6;
        } else if (modelName.equals("RAID800") || modelName.equals("XP7")) {
            ret = 7;
        } else if (modelName.equals("HM700")) {
            ret = 19;
        } else if (modelName.equals("HM800")) {
            ret = 18;
        }
        return ret;
    }

    public String getModelGuidancekey(int modelID) {
        String ret = "INVALID_MODEL";
        switch (modelID) {
            case 6: {
                ret = "DKC_MODEL_6";
                break;
            }
            case 7: {
                ret = "DKC_MODEL_7";
                break;
            }
            case 19: {
                ret = "DKC_MODEL_19";
                break;
            }
            case 18: {
                ret = "DKC_MODEL_18";
            }
        }
        return ret;
    }

    public String getSvolWriteStringForTc(int svolwrite, SJmoTrueCopyPairVolInfo pairInfo) {
        String ret = "?";
        if (pairInfo == null) {
            return ret;
        }
        if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
            switch (svolwrite) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLED");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
            }
        } else if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
            ret = "-";
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSvolWriteStringForTc", "pairPosition is Invalid.");
        }
        return ret;
    }

    public String getSvolWriteStringForUr(int svolwrite, int pairPosition) {
        String ret = "?";
        if (pairPosition == 0) {
            switch (svolwrite) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLED");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
            }
        } else if (pairPosition == 1) {
            ret = "-";
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSvolWriteStringForUr", "pairPosition is Invalid.");
        }
        return ret;
    }

    public String getPvolWriteString(int pvolwrite, SJmoTrueCopyPairVolInfo pairInfo) {
        String ret = "?";
        if (pairInfo == null) {
            return ret;
        }
        if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
            switch (pvolwrite) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("DEPEND_ON_PVOL_FENCE_LEVEL");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
            }
        } else if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
            ret = "-";
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPvolWriteString", "pairInfo is Invalid.");
        }
        return ret;
    }

    public String getSSBTransferString(SJmoTrueCopyPairVolInfo pairInfo, int ssbTransfer) {
        String ret = "?";
        if (pairInfo == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSSBTransferString", " pairInfo is null.");
            return ret;
        }
        if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
            switch (ssbTransfer) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ENABLED");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSSBTransferString", "ssb is invalid. ssb = " + pairInfo);
                    break;
                }
            }
        } else if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
            ret = "-";
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSSBTransferString", "pairInfo is invalid.");
        }
        return ret;
    }

    public String getDeleteModeString(int mode) {
        String ret = "?";
        switch (mode) {
            case 0: {
                ret = this.guidanceHandle.getGuidance("DELETE_NORMAL");
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("DELETE_FORCE");
                break;
            }
            case 2: {
                ret = this.guidanceHandle.getGuidance("DELETE_FORCE_ALL");
                break;
            }
            default: {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getDeleteModeString", "DeleteMode is invalid data. mode = " + mode);
            }
        }
        return ret;
    }

    public String getResyncModeString(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String ret = "?";
        if (pairInfo != null) {
            int idelta = pairInfo.getDelta();
            switch (idelta) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_NORMAL");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_DELTA");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_RE_SATNDBY");
                    break;
                }
                case 6: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_DELTA");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getResyncModeString", "idelta is invalid data. idelta = " + idelta);
                    break;
                }
            }
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getResyncModeString", "pairInfo is null");
        }
        return ret;
    }

    public String getResyncModeString(SJmoUniversalReplicatorJnlGrpMirror mirror) {
        String ret = "?";
        if (mirror != null) {
            int iDelta = mirror.getDelta();
            switch (iDelta) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_NORMAL");
                    break;
                }
                case 1: 
                case 3: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_DELTA");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("RESYNC_RE_SATNDBY");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getResyncModeString", "iDelta is invalid data. iDelta = " + iDelta);
                    break;
                }
            }
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getResyncModeString", "mirror is null");
        }
        return ret;
    }

    public String getReverseResyncStr(int reverseResync) {
        String ret = "?";
        switch (reverseResync) {
            case 0: {
                ret = "-";
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("REVERSE");
                break;
            }
        }
        return ret;
    }

    public String getNewJnlStr(int newJnl) {
        String ret = "?";
        switch (newJnl) {
            case 0: {
                ret = this.guidanceHandle.getGuidance("NO");
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("YES");
                break;
            }
        }
        return ret;
    }

    protected static List<?> getCache(SJctrDataController dc, Class<?> key) {
        if (null != dc && null != key) {
            if (dc instanceof SJctrWizardDataController) {
                return ((SJctrWizardDataController)dc).getCache(key);
            }
            return dc.getProxy().getCache(key);
        }
        SJctrLogUty.error("SJctrRemoteReplicationUtility", "getCache", "param is invalid.");
        throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
    }

    public static void setNeedDataForJnlGrpProperty(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevLuseInfo.class));
        needDataMap.put(SJmoGetHDPRelation.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetHDPRelation.class));
        needDataMap.put(SJmoGetPoolNameInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetPoolNameInfo.class));
        needDataMap.put(SJmoGetSnapshotVvolRelation.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetSnapshotVvolRelation.class));
        needDataMap.put(SJmoGetRSGgetAllRsgs.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetRSGgetAllRsgs.class));
    }

    public static List<SJmoPortAttributeInfo> getSJmoPortAttributeInfo(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoPortAttributeInfo", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        List<SJmoPortAttributeInfo> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetPortAttributeInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortAttributeInfo", "Information of Port Attribute is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        return info;
    }

    public static SJmoRemoteReplicationMRCUInfoMgr getSJmoRemoteReplicationMRCUInfoMgr(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoRemoteReplicationMRCUInfoMgr", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        List<?> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetRemoteReplicationMRCUInfoMgr.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoRemoteReplicationMRCUInfoMgr", "Information of MCU/RCU List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        if (info.isEmpty()) {
            dc.getLogUty().putlog("getSJmoRemoteReplicationMRCUInfoMgr", "Size of MCU/RCU List size is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        SJmoRemoteReplicationMRCUInfoMgr retInfo = (SJmoRemoteReplicationMRCUInfoMgr)info.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoRemoteReplicationMRCUInfoMgr", "Information of MCU/RCU is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static void setFinishChangeCheck(SJctrDataController dc, boolean changeCheckFlg) {
        if (null != dc) {
            SJctrButtonDataModel finishButton;
            SJctrFooterDataModel footer = (SJctrFooterDataModel)dc.getDataObjectModel("COM_FOOTER");
            if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
                finishButton.setChangeCheck(changeCheckFlg);
            }
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "setFinishChangeCheck", "dc is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
    }

    public static List<SJmoPortDetail> createLocalPortIDList(List<SJmoPortDetail> portDtlList, List<SJmoPortAttributeInfo> portAtrInfoList, SJctrResourceGroupUtility rsgUtil) {
        if (null == portDtlList || null == portAtrInfoList || null == rsgUtil) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "createLocalPortIDList", "param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoPortDetail> localPortIDList = new ArrayList<SJmoPortDetail>();
        List<SJmoPortIndex> protIndexList = rsgUtil.extractPort(portDtlList);
        if (protIndexList.size() == 0) {
            return localPortIDList;
        }
        for (SJmoPortIndex portIdx : protIndexList) {
            Collections.sort(portDtlList);
            int targetDtl = Collections.binarySearch(portDtlList, portIdx);
            Collections.sort(portAtrInfoList);
            int targetAtr = Collections.binarySearch(portAtrInfoList, portIdx);
            if (0 > targetDtl || 0 > targetAtr) continue;
            SJmoPortDetail portDtl = portDtlList.get(targetDtl);
            SJmoPortAttributeInfo portAtrInfo = portAtrInfoList.get(targetAtr);
            if (!SJctrRemoteReplicationDataMacro.REMOTE_CONNECTION_ENABLE_PORT_KIND.contains(portDtl.getByPortKindNo()) || portAtrInfo.getByPortKind() != 5 && portAtrInfo.getByPortKind() != 9) continue;
            localPortIDList.add(portDtl);
        }
        return localPortIDList;
    }

    public static void createLocalPortID(SJctrComboBoxDataModel comboObj, List<SJmoPortDetail> localPortIDList, SJctrComUtility comUty) {
        if (comboObj != null && localPortIDList != null && comUty != null) {
            SJctrPortUtility portUtil = comUty.getPortUtility();
            comboObj.addItem("", "");
            for (SJmoPortDetail portDtl : localPortIDList) {
                comboObj.addItem(Integer.toString(portDtl.getIndex()), portUtil.toPortNameDisplay(portDtl));
            }
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "createLocalPortID", "param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        comboObj.setEnable(true);
    }

    public static void createRemotePortID(SJctrComboBoxDataModel comboObj, int remoteModelID, SJctrComUtility comUty) {
        if (comboObj != null && comUty != null) {
            SJctrRemoteReplicationUtility remoteReplicaUty = comUty.getRemoteReplicationUtility();
            comboObj.addItem("", "");
            Map<Short, String> remotePortIDMap = SJctrRemoteReplicationUtility.getPortNameMap(remoteModelID);
            Set<Short> remotePortID = remotePortIDMap.keySet();
            for (short portID : remotePortID) {
                comboObj.addItem(Short.toString(portID), remoteReplicaUty.getRemotePortName(remotePortIDMap.get(portID)));
            }
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "createRemotePortID", "param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        comboObj.setEnable(true);
    }

    public static Map<Short, String> getPortNameMap(int modelID) {
        LinkedHashMap<Short, String> portMap = new LinkedHashMap();
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            block0 : switch (modelID) {
                case 6: 
                case 7: {
                    switch (iHMKind) {
                        case 20: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_S_MODEL_REMOTE_RAID700_800_MAP;
                            break block0;
                        }
                        case 40: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_M_MODEL_REMOTE_RAID700_800_MAP;
                            break block0;
                        }
                        case 60: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_REMOTE_RAID700_800_MAP;
                            break block0;
                        }
                    }
                    portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_REMOTE_RAID700_800_MAP;
                    break;
                }
                case 19: {
                    switch (iHMKind) {
                        case 20: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_S_MODEL_REMOTE_HM700_MAP;
                            break block0;
                        }
                        case 40: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_M_MODEL_REMOTE_HM700_MAP;
                            break block0;
                        }
                        case 60: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_REMOTE_HM700_MAP;
                            break block0;
                        }
                    }
                    portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_REMOTE_HM700_MAP;
                    break;
                }
                case 18: {
                    switch (iHMKind) {
                        case 20: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_S_MODEL_MAP;
                            break block0;
                        }
                        case 40: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_M_MODEL_MAP;
                            break block0;
                        }
                        case 60: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_MAP;
                            break block0;
                        }
                    }
                    portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_MAP;
                    break;
                }
                default: {
                    switch (iHMKind) {
                        case 20: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_S_MODEL_FUTURE_MAP;
                            break block0;
                        }
                        case 40: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_M_MODEL_FUTURE_MAP;
                            break block0;
                        }
                        case 60: {
                            portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_FUTURE_MAP;
                            break block0;
                        }
                    }
                    portMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_FUTURE_MAP;
                    break;
                }
            }
        } else {
            switch (modelID) {
                case 5: {
                    portMap = SJctrRemoteReplicationDataMacro.PortList_R600_MAP;
                    break;
                }
                case 6: {
                    portMap = SJctrRemoteReplicationDataMacro.PortList_R700_MAP;
                    break;
                }
                case 7: {
                    portMap = SJctrRemoteReplicationDataMacro.PortList_R800_MAP;
                    break;
                }
                case 19: {
                    portMap = SJctrRemoteReplicationDataMacro.PortList_HM700_MAP;
                    break;
                }
                default: {
                    portMap = SJctrRemoteReplicationDataMacro.PortList_R600_MAP;
                }
            }
        }
        return portMap;
    }

    public String getRemotePortName(String portName) {
        String fullPortName = "?";
        if (null == portName) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getRemotePortName", "portName is invalid.");
            return fullPortName;
        }
        fullPortName = this.guidanceHandle.getGuidance("PORT_NAME_PART_CL") + portName;
        return fullPortName;
    }

    public static void setCacheTCPairDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetTrueCopyPairVolInfoMgr.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetTrueCopyPairVolInfoMgr.class));
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevLuseInfo.class));
    }

    public static void setCacheForceDeletePairDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevLuseInfo.class));
    }

    public static SJmoTrueCopyPairVolInfoMgr getSJmoTrueCopyPairVolInfoMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetTrueCopyPairVolInfoMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoTrueCopyPairVolInfoMgr", "Information of Remote Replication TrueCopy pair list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoTrueCopyPairVolInfoMgr", "Size of Remote Replication True Copy pair list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoTrueCopyPairVolInfoMgr retInfo = (SJmoTrueCopyPairVolInfoMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoTrueCopyPairVolInfoMgr", "Information of TrueCopy pairs is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static void chkCacheTrueCopyPairsDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoLdevLuseInfo(dc);
        SJctrReplicationUtility.getSJmoPortLunInfo(dc);
    }

    public static void chkCacheUniversalReplicatorDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoLdevLuseInfo(dc);
    }

    public static void chkCacheForceDeletePairsDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoLdevLuseInfo(dc);
        SJctrReplicationUtility.getSJmoPortLunInfo(dc);
    }

    public static List<SJmoTrueCopyPairVolInfo> checkAndGetExistTCPairVolInfo(List<SJmoTrueCopyPairVolInfo> checkList, SJmoTrueCopyPairVolInfoMgr allPairVolInfo) throws SJcException {
        if (checkList == null || allPairVolInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistTCPairVolInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoTrueCopyPairVolInfo> retList = new ArrayList<SJmoTrueCopyPairVolInfo>(checkList.size());
        for (SJmoTrueCopyPairVolInfo selectedVol : checkList) {
            SJmoReplicationPairVolInfo pairVol;
            SJcException exp;
            SJctrError err;
            boolean pflg = true;
            SJmoReplicationPairVolInfo localVol = (SJmoReplicationPairVolInfo)selectedVol.getPVolIndex();
            if (localVol == null) {
                ArrayList localVolList = selectedVol.getAlSVolIndex();
                pflg = false;
                if (localVolList == null || localVolList.size() == 0) {
                    SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistTCPairVolInfo", "Local volume is not exist");
                    err = new SJctrError(210, 22, 206502);
                    exp = err.createException();
                    throw exp;
                }
                localVol = (SJmoReplicationPairVolInfo)localVolList.get(0);
                if (localVol == null) {
                    SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistTCPairVolInfo", "Local volume is null");
                    err = new SJctrError(210, 22, 206502);
                    exp = err.createException();
                    throw exp;
                }
            }
            if ((pairVol = allPairVolInfo.getTrueCopyPairVolInfo((SJmoLdevIndex)localVol)) != null) {
                SJmoTrueCopyPairVolInfo remoteVol = null;
                if (pflg) {
                    ArrayList remoteVolList = pairVol.getAlSVolIndex();
                    Collections.sort(remoteVolList);
                    int index = Collections.binarySearch(remoteVolList, selectedVol);
                    if (index >= 0) {
                        remoteVol = (SJmoTrueCopyPairVolInfo)remoteVolList.get(index);
                    }
                } else {
                    remoteVol = (SJmoTrueCopyPairVolInfo)pairVol.getPVolIndex();
                }
                if (remoteVol != null) {
                    try {
                        retList.add((SJmoTrueCopyPairVolInfo)remoteVol.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistTCPairVolInfo", "Catch CloneNotSupportedException.");
                        SJctrError err2 = new SJctrError(210, 22, 107001);
                        SJcException exp2 = err2.createException();
                        throw exp2;
                    }
                }
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistTCPairVolInfo", "Remote volume is null");
                SJctrError err3 = new SJctrError(210, 22, 206502);
                SJcException exp3 = err3.createException();
                throw exp3;
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistTCPairVolInfo", "Remote volume is not exist");
            err = new SJctrError(210, 22, 206502);
            exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static List<SJmoTrueCopyPairVolInfo> getExistTcPairVolInfo(List<SJmoTrueCopyPairVolInfo> checkList, SJmoTrueCopyPairVolInfoMgr allPairVolInfo) throws SJcException {
        if (checkList == null || allPairVolInfo == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistTcPairVolInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoTrueCopyPairVolInfo> retList = new ArrayList<SJmoTrueCopyPairVolInfo>(checkList.size());
        for (SJmoTrueCopyPairVolInfo selectedVol : checkList) {
            SJmoReplicationPairVolInfo pairVol;
            boolean pflg = true;
            SJmoReplicationPairVolInfo localVol = (SJmoReplicationPairVolInfo)selectedVol.getPVolIndex();
            if (localVol == null) {
                SJcException exp;
                SJctrError err;
                ArrayList localVolList = selectedVol.getAlSVolIndex();
                pflg = false;
                if (localVolList == null || localVolList.size() == 0) {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistTcPairVolInfo", "Local volume is not exist");
                    err = new SJctrError(210, 22, 206502);
                    exp = err.createException();
                    throw exp;
                }
                localVol = (SJmoReplicationPairVolInfo)localVolList.get(0);
                if (localVol == null) {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistTcPairVolInfo", "Local volume is null");
                    err = new SJctrError(210, 22, 206502);
                    exp = err.createException();
                    throw exp;
                }
            }
            if ((pairVol = allPairVolInfo.getTrueCopyPairVolInfo((SJmoLdevIndex)localVol)) != null) {
                SJmoTrueCopyPairVolInfo remoteVol = null;
                if (pflg) {
                    ArrayList remoteVolList = pairVol.getAlSVolIndex();
                    Collections.sort(remoteVolList);
                    int index = Collections.binarySearch(remoteVolList, selectedVol);
                    if (index >= 0) {
                        remoteVol = (SJmoTrueCopyPairVolInfo)remoteVolList.get(index);
                    }
                } else {
                    remoteVol = (SJmoTrueCopyPairVolInfo)pairVol.getPVolIndex();
                }
                if (remoteVol != null) {
                    try {
                        retList.add((SJmoTrueCopyPairVolInfo)remoteVol.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistTcPairVolInfo", "Catch CloneNotSupportedException.");
                        SJctrError err = new SJctrError(210, 22, 107001);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                }
                SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistTcPairVolInfo", "Selected Remote VOL is not Exist");
                continue;
            }
            SJctrLogUty.debug(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistTcPairVolInfo", "Selected Local VOL is not Exist");
        }
        return retList;
    }

    public static List<SJmoLdevDetail> checkAndGetExistLdevlInfo(List<? extends SJmoLdevIndex> checkList, List<SJmoLdevDetail> allLdevInfo) throws SJcException {
        if (null == checkList || null == allLdevInfo) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistLdevlInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>();
        Collections.sort(allLdevInfo);
        for (SJmoLdevIndex sJmoLdevIndex : checkList) {
            int index = Collections.binarySearch(allLdevInfo, sJmoLdevIndex);
            if (0 <= index) {
                SJmoLdevDetail target = allLdevInfo.get(index);
                retList.add(target);
                continue;
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistLdevlInfo", "Check list data is different from local LDEV list.");
            SJctrError err = new SJctrError(210, 22, 206506);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static int checkCopyTypeForTcPairVol(List<SJmoTrueCopyPairVolInfo> pairList) {
        int copyType = -1;
        HashSet<Integer> selCopyType = new HashSet<Integer>();
        if (pairList != null && pairList.size() != 0) {
            for (SJmoTrueCopyPairVolInfo pairInfo : pairList) {
                selCopyType.add(SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVolInfo(pairInfo));
            }
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForPairVol", "Pair list is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (selCopyType.size() == 1) {
            copyType = (Integer)selCopyType.toArray()[0];
        } else {
            if (selCopyType.size() == 0) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForPairVol", "Pair list data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForLocalPairVolList", "Copy type is mix.size = " + selCopyType.size());
        }
        return copyType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCopyTypeForTcPairVolInfo(SJmoTrueCopyPairVolInfo pairInfo) {
        int copyType = -1;
        if (pairInfo != null) {
            if (pairInfo.isVolPos(1)) return 1;
            if (pairInfo.isVolPos(2)) {
                return 1;
            }
            if (pairInfo.isVolPos(32)) return 0;
            if (pairInfo.isVolPos(64)) {
                return 0;
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForTcPairVolInfo", "Copytype is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForPairVol", "Pair information is null.");
        SJctrError err = new SJctrError(210, 22, 107001);
        SJcException exp = err.createException();
        throw exp;
    }

    public static int checkVolTypeForLdev(List<SJmoLdevDetail> ldevlist) {
        int voltype = -1;
        if (null == ldevlist || 0 == ldevlist.size()) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkVolTypeForLdev", "LDEV list is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean masterVolType = SJctrLdevUtility.isMFVolume(ldevlist.get(0));
        voltype = masterVolType ? 0 : 1;
        for (SJmoLdevDetail selectedLdev : ldevlist) {
            if (masterVolType == SJctrLdevUtility.isMFVolume(selectedLdev)) continue;
            voltype = -1;
            break;
        }
        return voltype;
    }

    public static boolean isTrueCopyPairPositionPrimary(List<SJmoTrueCopyPairVolInfo> pairExist) {
        if (pairExist == null || pairExist.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoTrueCopyPairVolInfo pairInfo : pairExist) {
            if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) == 0) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static int checkCopyTypeForUrPairVol(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        int copyType = -1;
        HashSet<Integer> selCopyType = new HashSet<Integer>();
        if (pairList != null && pairList.size() != 0) {
            for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairList) {
                selCopyType.add(SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVolInfo(pairInfo));
            }
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForUrPairVol", "Pair list is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (selCopyType.size() == 1) {
            copyType = (Integer)selCopyType.toArray()[0];
        } else {
            if (selCopyType.size() == 0) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForUrPairVol", "Pair list data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForLocalPairVolList", "Copy type is mix.size = " + selCopyType.size());
        }
        return copyType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCopyTypeForUrPairVolInfo(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        int copyType = -1;
        if (pairInfo != null) {
            if (pairInfo.isVolPos(4096)) return 1;
            if (pairInfo.isVolPos(8192)) {
                return 1;
            }
            if (pairInfo.isVolPos(131072)) return 0;
            if (pairInfo.isVolPos(262144)) {
                return 0;
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForUrPairVolInfo", "Copytype is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForUrPairVolInfo", "Pair information is null.");
        SJctrError err = new SJctrError(210, 22, 107001);
        SJcException exp = err.createException();
        throw exp;
    }

    public static boolean checkURPairPositionPrimary(List<SJmoUniversalReplicatorPairVolInfo> pairExist) {
        boolean rtn = true;
        if (pairExist == null || pairExist.size() == 0) {
            return false;
        }
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairExist) {
            if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) == 0) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static SJcException convRReplicaLogicalErr(SJcException err, int msgID) {
        SJcMessage msgObj = err.getMsg();
        if ((msgObj.getFunctionID().equals(Integer.toString(209)) || msgObj.getFunctionID().equals(Integer.toString(210))) && msgObj.getModuleID().equals(Integer.toString(22)) && msgObj.getMsgID().equals(Integer.toString(107001))) {
            SJctrError errObj = new SJctrError(210, 22, msgID);
            err = errObj.createException();
        }
        return err;
    }

    public static List<SJctrLDEVDetailWithJnlInfo> getLdevDetailList(SJctrResourceGroupUtility rsgUty, List<SJmoLdevIndex> ldevIndexs, List<SJmoLdevDetail> ldevDetails, List<SJmoHDPRelation> hDPRelation) {
        ArrayList<SJctrLDEVDetailWithJnlInfo> retList = new ArrayList<SJctrLDEVDetailWithJnlInfo>();
        if (rsgUty == null || ldevIndexs == null || ldevDetails == null || hDPRelation == null) {
            return retList;
        }
        List<SJmoLdevIndex> enableVolList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLdevIndex ldevIndex : ldevIndexs) {
            SJmoLdevDetail checkVolDetail;
            int index;
            if (null == ldevIndex || 0 > Collections.binarySearch(enableVolList, ldevIndex) || 0 > (index = Collections.binarySearch(ldevDetails, ldevIndex)) || (checkVolDetail = ldevDetails.get(index)).getSLUSEEmlCount() == 0) continue;
            SJctrLDEVDetail tmpLdevDetail = new SJctrLDEVDetail();
            tmpLdevDetail.setDetailData(checkVolDetail);
            int hdpIndex = Collections.binarySearch(hDPRelation, ldevIndex);
            if (hdpIndex >= 0) {
                SJmoHDPRelation ldevHDP = hDPRelation.get(hdpIndex);
                tmpLdevDetail.setRelationData(ldevHDP);
            }
            int jnlVol = -1;
            jnlVol = SJctrRemoteReplicationUtility.getJnlVolType(ldevIndex, ldevIndexs);
            SJctrLDEVDetailWithJnlInfo ldevDetailWithJnl = new SJctrLDEVDetailWithJnlInfo(tmpLdevDetail, jnlVol);
            retList.add(ldevDetailWithJnl);
        }
        return retList;
    }

    public String getSecondaryVolumeWritten(RMCPget1PairDetail pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            if (pairInfo.PairStatus == 0) {
                ret = "-";
            } else {
                block0 : switch (pairInfo.HorcSVolWrPermit) {
                    case 0: {
                        ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_DISABLE");
                        break;
                    }
                    case 1: {
                        switch (pairInfo.VolumeType) {
                            case 0: {
                                ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE");
                                break block0;
                            }
                            case 1: {
                                switch (pairInfo.HorcSVolWrAccept) {
                                    case 0: {
                                        ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE_NOT_RCV");
                                        break block0;
                                    }
                                    case 1: {
                                        ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE_RCV");
                                        break block0;
                                    }
                                }
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }
        return ret;
    }

    public String getSecondaryVolumeWritten(HURget1PairDetail pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            if (pairInfo.status == 0) {
                ret = "-";
            } else {
                block0 : switch (pairInfo.svolWrt) {
                    case 0: {
                        ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_DISABLE");
                        break;
                    }
                    case 1: {
                        switch (pairInfo.volType) {
                            case 0: {
                                ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE");
                                break block0;
                            }
                            case 1: {
                                switch (pairInfo.svolWrtRcvd) {
                                    case 0: {
                                        ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE_NOT_RCV");
                                        break block0;
                                    }
                                    case 1: {
                                        ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE_RCV");
                                        break block0;
                                    }
                                }
                                ret = this.guidanceHandle.getGuidance("SVOL_WRITTEN_ENABLE");
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }
        return ret;
    }

    public static String convertConsistencyTime(int timerKind, String time) {
        String ret = "?";
        if (null == time) {
            return ret;
        }
        switch (timerKind) {
            case 0: {
                Pattern pattern = Pattern.compile("\\d{2}/\\d{2}/\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d{6}");
                Matcher matcher = pattern.matcher(time);
                if (matcher.matches()) {
                    String[] splitSpaceStrings = time.split(" ");
                    String[] splitSlashStrings = splitSpaceStrings[0].split("/");
                    ret = splitSlashStrings[2] + "/" + splitSlashStrings[0] + "/" + splitSlashStrings[1] + " " + splitSpaceStrings[1];
                    break;
                }
                if ("".equals(time)) {
                    ret = "-";
                    break;
                }
                if ("Overflow".equals(time)) {
                    ret = time;
                    break;
                }
                if (!"Underflow".equals(time)) break;
                ret = time;
                break;
            }
            case 1: 
            case 2: {
                ret = "-";
                break;
            }
        }
        return ret;
    }

    public static String convertRmiTime(String time) {
        String ret = "?";
        if (null != time) {
            Pattern pattern = Pattern.compile("\\d{2}/\\d{2}/\\d{4}\\s\\d{2}:\\d{2}:\\d{2}");
            Matcher matcher = pattern.matcher(time);
            if (matcher.matches()) {
                String[] splitSpaceStrings = time.split(" ");
                String[] splitSlashStrings = splitSpaceStrings[0].split("/");
                ret = splitSlashStrings[2] + "/" + splitSlashStrings[0] + "/" + splitSlashStrings[1] + " " + splitSpaceStrings[1];
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public static String getCopyTimeStringTC(RMCPget1PairDetail rmi) {
        String ret = "-";
        if (null == rmi) {
            return "?";
        }
        int volpos = rmi.VolumeType;
        int status = rmi.PairStatus;
        String copyTime = rmi.PairCopyTime;
        if (volpos == 0 && (status == 2 || status == 193)) {
            ret = SJctrRemoteReplicationUtility.convertPairCopyTime(copyTime);
        }
        return ret;
    }

    public static String getCopyTimeStringUR(HURget1PairDetail rmi) {
        String ret = "-";
        if (null == rmi) {
            return "?";
        }
        int volpos = rmi.volType;
        int status = rmi.status;
        String copyTime = rmi.copyTime;
        if (volpos == 0 && status == 2) {
            ret = SJctrRemoteReplicationUtility.convertPairCopyTime(copyTime);
        }
        return ret;
    }

    public static String convertPairCopyTime(String time) {
        String ret = "?";
        if (null != time) {
            Pattern pattern = Pattern.compile("\\d{3}:\\d{2}:\\d{2}");
            Matcher matcher = pattern.matcher(time);
            ret = matcher.matches() ? time : "-";
        }
        return ret;
    }

    private String getTimerTypeString(int type) {
        String ret = "?";
        switch (type) {
            case 1: {
                ret = this.guidanceHandle.getGuidance("LOCAL");
                break;
            }
            case 0: {
                ret = this.guidanceHandle.getGuidance("SYSTEM");
                break;
            }
            case 2: {
                ret = this.guidanceHandle.getGuidance("NONE");
                break;
            }
        }
        return ret;
    }

    public String getTimerTypeString(SJmoUniversalReplicatorPairVolInfo pair, int type) {
        String ret = "?";
        if (null == pair) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getTimerTypeString", "Unknown copy type.");
            return ret;
        }
        if (SJctrRemoteReplicationUtility.isOpen(pair)) {
            ret = "-";
        } else if (SJctrRemoteReplicationUtility.isMainframe(pair)) {
            ret = this.getTimerTypeString(type);
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getTimerTypeString", "Unknown copy type.");
        }
        return ret;
    }

    public String getMaximumCopyActivitiesString(SJmoUniversalReplicatorJnlGrp jnlGrpInfo) {
        String ret = "?";
        return ret;
    }

    public String getExctgMirrorStatusString(SJmoUniversalReplicatorEXCTGJnlGrp jnlInfo) {
        String rtn = "?";
        if (null == jnlInfo) {
            return rtn;
        }
        int status = jnlInfo.getJnlGrpStatus();
        switch (status) {
            case 0: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_INITIAL");
                break;
            }
            case 16: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_ACTIVE");
                break;
            }
            case 17: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_HALT_ACCEPT");
                break;
            }
            case 32: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_HALT");
                break;
            }
            case 34: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_HALTING");
                break;
            }
            case 64: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_STOPPED");
                break;
            }
            case 68: {
                rtn = this.guidanceHandle.getGuidance("MIRROR_STATUS_STOPPING");
                break;
            }
            default: {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExctgMirrorStatusString", "Has returned an invalid value. Status = " + status);
            }
        }
        return rtn;
    }

    public String getExctgAttribute(SJmoUniversalReplicatorEXCTG exctg) {
        String rtn = "?";
        if (exctg == null) {
            return rtn;
        }
        int used = exctg.getUsed();
        if (0 < used) {
            int iAttribute = exctg.getAttribute();
            ArrayList jnlList = null;
            switch (iAttribute) {
                case 0: {
                    rtn = this.guidanceHandle.getGuidance("ATTRIBUTE_INITIALIZING");
                    break;
                }
                case 128: {
                    jnlList = exctg.getJnlGrpList();
                    if (jnlList == null || jnlList.size() == 0) {
                        return rtn;
                    }
                    if (this.isExctgAttributeUpdating(jnlList)) {
                        rtn = this.guidanceHandle.getGuidance("ATTRIBUTE_UPDATING");
                        break;
                    }
                    rtn = this.guidanceHandle.getGuidance("ATTRIBUTE_MASTER");
                    break;
                }
                case 64: {
                    jnlList = exctg.getJnlGrpList();
                    if (jnlList == null || jnlList.size() == 0) {
                        return rtn;
                    }
                    if (this.isExctgAttributeUpdating(jnlList)) {
                        rtn = this.guidanceHandle.getGuidance("ATTRIBUTE_UPDATING");
                        break;
                    }
                    rtn = this.guidanceHandle.getGuidance("ATTRIBUTE_RESTORE");
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getEXCtgAttribute", "Has returned an invalid value. Attribute = " + iAttribute);
                    break;
                }
            }
        } else {
            rtn = this.guidanceHandle.getGuidance("ATTRIBUTE_FREE");
        }
        return rtn;
    }

    private boolean isExctgAttributeUpdating(ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> jnlGrpList) {
        boolean rtn = true;
        for (SJmoUniversalReplicatorEXCTGJnlGrp jnl : jnlGrpList) {
            int jnlGrpReg = jnl.getJnlGrpReg();
            if (jnlGrpReg == 2) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public String getExctgConsistencyTimeString(SJmoUniversalReplicatorEXCTG exctg) {
        String rtn = "?";
        if (exctg == null) {
            return rtn;
        }
        int ctState = exctg.getConsistency();
        if (ctState == 0) {
            rtn = "-";
        } else if (ctState == 1 || ctState == 2) {
            rtn = SJctrRemoteReplicationUtility.convertConsistencyTime(0, exctg.getStrCt());
        }
        return rtn;
    }

    public String getExctgStorageSystemNumString(SJmoUniversalReplicatorEXCTG exctg) {
        String rtn = "?";
        if (exctg == null || exctg.getJnlGrpList() == null) {
            return rtn;
        }
        ArrayList jnlList = exctg.getJnlGrpList();
        HashSet<String> set = new HashSet<String>();
        for (SJmoUniversalReplicatorEXCTGJnlGrp jnl : jnlList) {
            String id = SJctrComUtility.toHexString(jnl.getModelId(), 2, true);
            String sn = jnl.getSN();
            String idSn = id + sn;
            set.add(idSn);
        }
        rtn = Integer.toString(set.size());
        return rtn;
    }

    public String getExctgJournalsNumString(SJmoUniversalReplicatorEXCTG exctg) {
        String rtn = "?";
        if (exctg == null || exctg.getJnlGrpList() == null) {
            return rtn;
        }
        int count = exctg.getJnlGrpList().size();
        rtn = Integer.toString(count);
        return rtn;
    }

    public String getExctgAssignedMirrorIdString(SJmoUniversalReplicatorEXCTG exctg) {
        String rtn = "?";
        if (exctg == null || exctg.getJnlGrpList() == null) {
            return rtn;
        }
        rtn = exctg.getJnlGrpList().size() == 0 ? "-" : this.getExctgMirrorIdString((SJmoUniversalReplicatorEXCTGJnlGrp)exctg.getJnlGrpList().get(0));
        return rtn;
    }

    public String getExctgNumOfJnlsString(SJctrEXCTGJournalsStorageSystemUnitInfo jnl) {
        String rtn = "?";
        if (jnl != null) {
            rtn = Integer.toString(jnl.getNumOfJNLs());
        }
        return rtn;
    }

    public String getTypeString(int jnlVol) {
        String rtn = "?";
        if (jnlVol == 0) {
            rtn = this.guidanceHandle.getGuidance("JNL");
        } else if (jnlVol == 1) {
            rtn = this.guidanceHandle.getGuidance("RESERVE_JNL");
        }
        return rtn;
    }

    public static int bitSetToint(BitSet bitSet) {
        int ret = 0;
        for (int i = 31; 0 <= i; --i) {
            ret |= (bitSet.get(i) ? 1 : 0) << i;
        }
        return ret;
    }

    public static int getPairPos(SJmoTrueCopyPairVolInfo tcPairInfo) {
        int rtn = -1;
        if (tcPairInfo != null) {
            if (SJctrRemoteReplicationUtility.isSvol(tcPairInfo)) {
                rtn = 0;
            } else if (SJctrRemoteReplicationUtility.isPvol(tcPairInfo)) {
                rtn = 1;
            } else {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairPos", "SJmoTrueCopyPairVolInfo.iPairVolPos is invalid.");
            }
        }
        return rtn;
    }

    public static int getPairPos(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        int rtn = -1;
        if (urPairInfo != null) {
            if (SJctrRemoteReplicationUtility.isSvol(urPairInfo)) {
                rtn = 0;
            } else if (SJctrRemoteReplicationUtility.isPvol(urPairInfo)) {
                rtn = 1;
            } else {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairPos", "SJmoUniversalReplicatorPairVolInfo.iPairVolPos is invalid.");
            }
        }
        return rtn;
    }

    public static int getSelectedComboboxKeyNum(SJctrComboBoxDataModel comb) {
        int keyNum = -1;
        if (null != comb) {
            String key = comb.getSelection();
            try {
                keyNum = Integer.valueOf(key);
            }
            catch (Exception e) {
                SJctrLogUty.warn(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSelectedComboboxKeyNum", "Failed to parse integer. Key string: " + key);
            }
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSelectedComboboxKeyNum", "Argument is null.");
        }
        return keyNum;
    }

    public static int getSelectedRadioButtonKeyNum(SJctrRadioButtonGroupDataModel radio) {
        int keyNum = -1;
        if (radio != null) {
            String key = radio.getSelect();
            try {
                keyNum = Integer.valueOf(key);
            }
            catch (Exception e) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSelectedRadioButtonKeyNum", "failed to be converted to a number");
            }
        }
        return keyNum;
    }

    public static int getValueTextBoxNum(SJctrTextBoxDataModel txt) {
        int txtNum = -1;
        if (txt != null) {
            String key = txt.getValue();
            try {
                txtNum = Integer.valueOf(key);
            }
            catch (Exception e) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "getValueTextBoxNum", "failed to be converted to a number");
            }
        }
        return txtNum;
    }

    public static void setColumnVisible(SJctrTableDataModel table, Set<String> invisibleKeySet) {
        if (table != null && invisibleKeySet != null) {
            for (String key : table.getAllColumnKeySet(false)) {
                SJctrColumn colimn = table.getColumnInfo(key);
                if (colimn == null) continue;
                if (invisibleKeySet.contains(key) || !colimn.getSupportColumn()) {
                    colimn.setShowColumn(false);
                    continue;
                }
                colimn.setShowColumn(true);
            }
        }
    }

    public static SJmoReplicationPairVolInfo getLocalVolumeForTcPair(SJmoTrueCopyPairVolInfo pairInfo) {
        if (pairInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getLocalVolumeForTcPair", "Pair volume is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int pairPosition = SJctrRemoteReplicationUtility.getPairPos(pairInfo);
        SJmoReplicationPairVolInfo localVol = null;
        if (pairPosition == 0) {
            localVol = (SJmoReplicationPairVolInfo)pairInfo.getPVolIndex();
        } else if (pairPosition == 1) {
            localVol = (SJmoReplicationPairVolInfo)pairInfo.getAlSVolIndex().get(0);
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getLocalVolumeForTcPair", "Pair attribute is invalid");
        }
        return localVol;
    }

    public static SJmoReplicationPairVolInfo getLocalVolume(SJmoUniversalReplicatorPairVolInfo urPairVolInfo) {
        if (urPairVolInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getLocalVolume", "Argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        int pairPosition = SJctrRemoteReplicationUtility.getPairPos(urPairVolInfo);
        SJmoReplicationPairVolInfo localVol = null;
        if (pairPosition == 0) {
            localVol = (SJmoReplicationPairVolInfo)urPairVolInfo.getAlPVolIndex().get(0);
        } else if (pairPosition == 1) {
            localVol = (SJmoReplicationPairVolInfo)urPairVolInfo.getAlSVolIndex().get(0);
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getLocalVolume", "SJmoUniversalReplicatorPairVolInfo.iPairVolPos is invalid.");
        }
        return localVol;
    }

    public static RMCPHorcLU getLocalRMCPHorcLU(SJmoLdevIndex ldevIndex, int copyType, Map<Integer, List<SJmoPortLunDetail>> portLunMap) {
        List<SJmoPortLunDetail> portLunDetailList;
        RMCPHorcLU lu = new RMCPHorcLU();
        if (ldevIndex != null && portLunMap != null && copyType == 1 && (portLunDetailList = portLunMap.get(ldevIndex.getIndex())) != null && portLunDetailList.size() != 0) {
            SJmoPortLunDetail detail = portLunDetailList.get(0);
            lu.GroupNo = detail.getSHostGroup();
            lu.LUN = detail.getSLUN();
            lu.PortNo = detail.getSPort();
        }
        return lu;
    }

    public static HUR1DataVol getHUR1DataVol(SJmoLdevDetail ldev, int copyType, Map<Integer, List<SJmoPortLunDetail>> portLunMap) {
        HUR1DataVol lu = new HUR1DataVol();
        if (ldev != null && portLunMap != null) {
            List<SJmoPortLunDetail> portLunDetailList;
            lu.culdev = ldev.getIndex();
            if (copyType == 1 && (portLunDetailList = portLunMap.get(ldev.getIndex())) != null && portLunDetailList.size() != 0) {
                SJmoPortLunDetail detail = portLunDetailList.get(0);
                lu.hostGroup = detail.getSHostGroup();
                lu.lun = detail.getSLUN();
                lu.port = detail.getSPort();
            }
        }
        return lu;
    }

    public static RMCPHorcLU getRemoteRMCPHorcLU(SJmoTrueCopyPairVolInfo volInfo, int copyType) {
        SJmoLuIndex luIndex;
        RMCPHorcLU lu = new RMCPHorcLU();
        if (copyType == 1 && volInfo != null && (luIndex = volInfo.getPairLU()) != null) {
            lu.GroupNo = luIndex.getSHostGroup();
            lu.LUN = luIndex.getILUN();
            lu.PortNo = luIndex.getSPort();
        }
        return lu;
    }

    public static boolean checkSplitTCPairStatus(List<SJmoTrueCopyPairVolInfo> pairExist) {
        SJmoTrueCopyPairVolInfo pairinfo;
        if (pairExist == null || pairExist.size() == 0) {
            return false;
        }
        boolean rtn = true;
        Iterator<SJmoTrueCopyPairVolInfo> i$ = pairExist.iterator();
        while (i$.hasNext() && (rtn = SJctrRemoteReplicationDataMacro.SPLIT_PERMISSION_STATUS_TC.contains((pairinfo = i$.next()).getIPairStatus()))) {
        }
        return rtn;
    }

    public static boolean checkResyncTCPairStatus(List<SJmoTrueCopyPairVolInfo> pairExist) {
        SJmoTrueCopyPairVolInfo pairinfo;
        int pairStatus;
        if (pairExist == null || pairExist.size() == 0) {
            return false;
        }
        boolean rtn = true;
        Iterator<SJmoTrueCopyPairVolInfo> i$ = pairExist.iterator();
        while (i$.hasNext() && (rtn = SJctrRemoteReplicationDataMacro.RESYNC_PERMISSION_STATUS_TC.contains(pairStatus = (pairinfo = i$.next()).getIPairStatus()))) {
        }
        return rtn;
    }

    public static boolean checkEditTCPairOptionsStatus(SJmoTrueCopyPairVolInfo pairInfo) {
        if (pairInfo == null) {
            return false;
        }
        int pairStatus = pairInfo.getIPairStatus();
        boolean rtn = SJctrRemoteReplicationDataMacro.EDIT_OPTIONS_PERMISSION_STATUS_TC_TCMF.contains(pairStatus);
        return rtn;
    }

    public static boolean checkSplitURPairStatus(List<SJmoUniversalReplicatorPairVolInfo> pairExist) {
        SJmoUniversalReplicatorPairVolInfo pairinfo;
        int iDelta;
        if (pairExist == null || pairExist.size() == 0) {
            return false;
        }
        boolean rtn = true;
        Iterator<SJmoUniversalReplicatorPairVolInfo> i$ = pairExist.iterator();
        while (i$.hasNext() && (rtn = (iDelta = (pairinfo = i$.next()).getDelta()) == 0 ? SJctrRemoteReplicationDataMacro.SPLIT_PERMISSION_STATUS_UR.contains(pairinfo.getPairStatus()) : false)) {
        }
        return rtn;
    }

    public static boolean checkResyncURPairStatus(List<SJmoUniversalReplicatorPairVolInfo> pairExist) {
        if (pairExist == null || pairExist.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorPairVolInfo pairinfo : pairExist) {
            int iDelta = pairinfo.getDelta();
            if (iDelta == 0) {
                rtn = SJctrRemoteReplicationDataMacro.RESYNC_PERMISSION_STATUS_UR.contains(pairinfo.getPairStatus());
                if (rtn) continue;
                break;
            }
            rtn = false;
            break;
        }
        return rtn;
    }

    public static boolean checkEditURPairOptionsStatus(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (pairInfo == null) {
            return false;
        }
        boolean rtn = true;
        if (pairInfo.getDelta() == 0) {
            int pairStatus = pairInfo.getPairStatus();
            rtn = SJctrRemoteReplicationDataMacro.EDIT_OPTIONS_PERMISSION_STATUS_UR_URMF.contains(pairStatus);
        }
        return rtn;
    }

    public static boolean checkDeleteURPairStatus(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        if (pairList == null || pairList.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairList) {
            int status;
            if (pairInfo.getDelta() == 0 && !(rtn = SJctrRemoteReplicationDataMacro.DELETE_PERMISSION_STATUS_UR.contains(status = pairInfo.getPairStatus()))) break;
        }
        return rtn;
    }

    public static boolean checkSplitMirrorStatus(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorsList) {
        if (mirrorsList == null || mirrorsList.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorsList) {
            if (mirrorInfo.getDelta() == 0) {
                if (SJctrRemoteReplicationDataMacro.SPLIT_PERMISSION_STATUS_MIRROR.contains(mirrorInfo.getStatus())) continue;
                rtn = false;
                break;
            }
            rtn = false;
            break;
        }
        return rtn;
    }

    public static boolean checkResyncMirrorStatus(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorsList) {
        if (mirrorsList == null || mirrorsList.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorsList) {
            if (mirrorInfo.getDelta() != 0 || SJctrRemoteReplicationDataMacro.RESYNC_PERMISSION_STATUS_MIRROR.contains(mirrorInfo.getStatus())) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static boolean checkDeleteMirrorStatus(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorsList) {
        SJmoUniversalReplicatorJnlGrpMirror mirrorInfo;
        int iMStatus;
        if (mirrorsList == null || mirrorsList.size() == 0) {
            return false;
        }
        boolean rtn = true;
        boolean statusKind = true;
        if (mirrorsList.get(0).getDelta() == 0 && SJctrRemoteReplicationDataMacro.MIRROR_STAUTS_HALTING_STOPPING.contains(iMStatus = mirrorsList.get(0).getStatus())) {
            statusKind = false;
        }
        Iterator<SJmoUniversalReplicatorJnlGrpMirror> i$ = mirrorsList.iterator();
        while (i$.hasNext() && (rtn = SJctrRemoteReplicationUtility.chkDelMirrorStatusInfo(mirrorInfo = i$.next(), statusKind))) {
        }
        return rtn;
    }

    private static boolean chkDelMirrorStatusInfo(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo, boolean kind) {
        int iStatus;
        if (mirrorInfo == null) {
            return false;
        }
        boolean rtn = true;
        boolean pairStatusKind = true;
        if (mirrorInfo.getDelta() == 0 && SJctrRemoteReplicationDataMacro.MIRROR_STAUTS_HALTING_STOPPING.contains(iStatus = mirrorInfo.getStatus())) {
            pairStatusKind = false;
        }
        if (pairStatusKind != kind) {
            rtn = false;
        }
        return rtn;
    }

    public String getChannelTypeString(List<SJmoPortDetail> portInfoList, SJmoRemoteReplicationRCUInfo RCUInfo) {
        String ret = "?";
        if (portInfoList != null && RCUInfo != null) {
            List<SJmoPortDetail> PortDataList = portInfoList;
            HashSet<String> set = new HashSet<String>();
            ArrayList PathInfoList = RCUInfo.getPathInfoList();
            if (PathInfoList.size() > 0) {
                for (SJmoRemoteReplicationRCUPathInfo Index : PathInfoList) {
                    int channelType = Collections.binarySearch(PortDataList, Index);
                    if (0 > channelType) continue;
                    SJmoPortDetail portinfo = portInfoList.get(channelType);
                    set.add(portinfo.getStrPortKindName());
                }
                if (set.size() == 1 && set.iterator() != null) {
                    ret = (String)set.iterator().next();
                } else if (set.size() > 1) {
                    ret = this.guidanceHandle.getGuidance("MIXED");
                }
            } else if (PathInfoList.size() == 0) {
                ret = "-";
            }
        }
        return ret;
    }

    public static void makeRemotePairCapacityUnit(SJctrTableDataModel table, List<? extends SJmoReplicationPairVolInfo> basicDataList) {
        boolean isNecessary = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String key : keySet) {
            SJctrColumn sJctrColumn = table.getColumnInfo(key);
            if (sJctrColumn instanceof SJctrLocalCapacityColumnFromTcPairVolInfo) {
                isNecessary = true;
                break;
            }
            if (!(sJctrColumn instanceof SJctrLocalCapacityColumnFromUrPairVolInfo)) continue;
            isNecessary = true;
            break;
        }
        if (isNecessary) {
            List<SJmoLdevDetail> ldevDetails = table.getBasicDataMap().get(SJmoGetLdevDetail.class);
            if (ldevDetails == null) {
                SJctrLogUty.info("SJctrRemoteReplicationUtility", "makeRemotePairCapacityUnit", "SJmoLdevDetail is null.");
                return;
            }
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            for (SJmoReplicationPairVolInfo sJmoReplicationPairVolInfo : basicDataList) {
                ArrayList PVolList = sJmoReplicationPairVolInfo.getAlPVolIndex();
                for (SJmoLdevIndex PVol : PVolList) {
                    SJctrRemoteReplicationUtility.checkLdevEmuType(table, PVol, ldevDetails);
                }
                ArrayList SVolList = sJmoReplicationPairVolInfo.getAlSVolIndex();
                for (SJmoLdevIndex SVol : SVolList) {
                    SJctrRemoteReplicationUtility.checkLdevEmuType(table, SVol, ldevDetails);
                }
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    public static void makeJnlGrpCapacityUnit(SJctrTableDataModel table, List<? extends SJmoUniversalReplicatorJnlGrp> basicDataList) {
        boolean isNecessary = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String string : keySet) {
            SJctrColumn column = table.getColumnInfo(string);
            if (column instanceof SJctrDataCapacityColumnFromUrJnlGrp) {
                isNecessary = true;
                break;
            }
            if (column instanceof SJctrJournalCapacityColumnFromUrJnlGrp) {
                isNecessary = true;
                break;
            }
            if (!(column instanceof SJctrDataCapacityColumnFromUrJnlGrpMirror)) continue;
            isNecessary = true;
            break;
        }
        if (isNecessary) {
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            for (SJmoUniversalReplicatorJnlGrp sJmoUniversalReplicatorJnlGrp : basicDataList) {
                if (sJmoUniversalReplicatorJnlGrp == null) continue;
                if (1 == sJmoUniversalReplicatorJnlGrp.getValidty()) {
                    table.setOpenVolumeFlg(true);
                }
                if (2 == sJmoUniversalReplicatorJnlGrp.getValidty()) {
                    table.setMainframeVolumeFlg(true);
                }
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    private static void checkLdevEmuType(SJctrTableDataModel table, SJmoLdevIndex targetVol, List<SJmoLdevDetail> ldevDetails) {
        int index = Collections.binarySearch(ldevDetails, targetVol);
        if (index >= 0) {
            SJmoLdevDetail ldevInfo = ldevDetails.get(index);
            if (SJctrLdevUtility.isOpenVolume(ldevInfo)) {
                table.setOpenVolumeFlg(true);
            } else if (SJctrLdevUtility.isMFVolume(ldevInfo)) {
                table.setMainframeVolumeFlg(true);
            }
        }
    }

    public static boolean isOpenPvol(SJmoTrueCopyPairVolInfo tcPairInfo) {
        if (null == tcPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isOpenPvol", "Argument is null.");
            return false;
        }
        return tcPairInfo.isVolPos(1);
    }

    public static boolean isOpenSvol(SJmoTrueCopyPairVolInfo tcPairInfo) {
        if (null == tcPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isOpenSvol", "Argument is null.");
            return false;
        }
        return tcPairInfo.isVolPos(2);
    }

    public static boolean isOpenPvol(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        if (null == urPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isOpenPvol", "Argument is null.");
            return false;
        }
        return urPairInfo.isVolPos(4096);
    }

    public static boolean isOpenSvol(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        if (null == urPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isOpenSvol", "Argument is null.");
            return false;
        }
        return urPairInfo.isVolPos(8192);
    }

    public static boolean isMainframePvol(SJmoTrueCopyPairVolInfo tcPairInfo) {
        if (null == tcPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isMainframePvol", "Argument is null.");
            return false;
        }
        return tcPairInfo.isVolPos(32);
    }

    public static boolean isMainframeSvol(SJmoTrueCopyPairVolInfo tcPairInfo) {
        if (null == tcPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isMainframeSvol", "Argument is null.");
            return false;
        }
        return tcPairInfo.isVolPos(64);
    }

    public static boolean isMainframePvol(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        if (null == urPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isMainframePvol", "Argument is null.");
            return false;
        }
        return urPairInfo.isVolPos(131072);
    }

    public static boolean isMainframeSvol(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        if (null == urPairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isMainframeSvol", "Argument is null.");
            return false;
        }
        return urPairInfo.isVolPos(262144);
    }

    public static boolean isOpen(SJmoTrueCopyPairVolInfo tcPairInfo) {
        return SJctrRemoteReplicationUtility.isOpenPvol(tcPairInfo) || SJctrRemoteReplicationUtility.isOpenSvol(tcPairInfo);
    }

    public static boolean isOpen(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        return SJctrRemoteReplicationUtility.isOpenPvol(urPairInfo) || SJctrRemoteReplicationUtility.isOpenSvol(urPairInfo);
    }

    public static boolean isMainframe(SJmoTrueCopyPairVolInfo tcPairInfo) {
        return SJctrRemoteReplicationUtility.isMainframePvol(tcPairInfo) || SJctrRemoteReplicationUtility.isMainframeSvol(tcPairInfo);
    }

    public static boolean isMainframe(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        return SJctrRemoteReplicationUtility.isMainframePvol(urPairInfo) || SJctrRemoteReplicationUtility.isMainframeSvol(urPairInfo);
    }

    public static boolean isPvol(SJmoTrueCopyPairVolInfo tcPairInfo) {
        return SJctrRemoteReplicationUtility.isOpenPvol(tcPairInfo) || SJctrRemoteReplicationUtility.isMainframePvol(tcPairInfo);
    }

    public static boolean isPvol(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        return SJctrRemoteReplicationUtility.isOpenPvol(urPairInfo) || SJctrRemoteReplicationUtility.isMainframePvol(urPairInfo);
    }

    public static boolean isSvol(SJmoTrueCopyPairVolInfo tcPairInfo) {
        return SJctrRemoteReplicationUtility.isOpenSvol(tcPairInfo) || SJctrRemoteReplicationUtility.isMainframeSvol(tcPairInfo);
    }

    public static boolean isSvol(SJmoUniversalReplicatorPairVolInfo urPairInfo) {
        return SJctrRemoteReplicationUtility.isOpenSvol(urPairInfo) || SJctrRemoteReplicationUtility.isMainframeSvol(urPairInfo);
    }

    public static boolean checkPairVolPos(SJmoReplicationPairVolInfo pairVolInfo, int[] checkPosArray) {
        boolean ret = false;
        if (null != pairVolInfo && null != checkPosArray) {
            for (int checkPos : checkPosArray) {
                if (!pairVolInfo.isVolPos(checkPos)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String getMaxAllowedString(String maxAllowed) {
        return this.guidanceHandle.getGuidance("BRACKET_LEFT") + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + maxAllowed + this.guidanceHandle.getGuidance("BRACKET_RIGHT");
    }

    public static boolean isLunDec(SJbaseUserSessionInterface session) {
        return SJctrPortUtility.isLunIdDecimal(session);
    }

    public static boolean chkRemoteConPortIDDuplicate(int[][] portID, int portIDCount) {
        if (null == portID) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "chkRemoteConPortIDDuplicate", "portID is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        for (int chkIdx = 0; chkIdx < portIDCount; ++chkIdx) {
            for (int nextIdx = chkIdx + 1; nextIdx < portIDCount; ++nextIdx) {
                if (portID[chkIdx][0] == -1 || portID[chkIdx][1] == -1 || portID[chkIdx][0] != portID[nextIdx][0] || portID[chkIdx][1] != portID[nextIdx][1]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean chkRemoteConSSIDDuplicate(int[] ssid, int ssidCount) {
        if (null == ssid) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "chkRemoteConSSIDDuplicate", "ssid is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        for (int ssidIdx = 0; ssidIdx < ssidCount; ++ssidIdx) {
            for (int nextIdx = ssidIdx + 1; nextIdx < ssidCount; ++nextIdx) {
                if (ssid[ssidIdx] != ssid[nextIdx]) continue;
                return true;
            }
        }
        return false;
    }

    public static SJmoUniversalReplicatorPairVolInfoMgr getSJmoUniversalReplicatorPairVolInfoMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetUniversalReplicatorPairVolInfoMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorPairVolInfoMgr", "Information of Remote Replication UniversalReplicator pair List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorPairVolInfoMgr", "Size of Remote Replication UniversalReplicator pair List is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorPairVolInfoMgr retInfo = (SJmoUniversalReplicatorPairVolInfoMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorPairVolInfoMgr", "Information of UniversalReplicator pairs is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static List<SJmoUniversalReplicatorPairVolInfo> checkAndGetExistUrPairVolInfo(List<SJmoUniversalReplicatorPairVolInfo> checkList, SJmoUniversalReplicatorPairVolInfoMgr allPairVolInfo) throws SJcException {
        if (checkList == null || allPairVolInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistUrPairVolInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoUniversalReplicatorPairVolInfo> retList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>(checkList.size());
        for (SJmoUniversalReplicatorPairVolInfo selectedVol : checkList) {
            SJcException exp;
            SJctrError err;
            boolean pflg = true;
            SJmoReplicationPairVolInfo localVol = null;
            ArrayList localVolList = selectedVol.getAlPVolIndex();
            if (localVolList == null || localVolList.size() == 0) {
                localVolList = selectedVol.getAlSVolIndex();
                pflg = false;
                if (localVolList == null || localVolList.size() == 0) {
                    SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistUrPairVolInfo", "local Volume is not exist");
                    err = new SJctrError(210, 22, 206502);
                    exp = err.createException();
                    throw exp;
                }
            }
            if ((localVol = (SJmoReplicationPairVolInfo)localVolList.get(0)) == null) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistUrPairVolInfo", "local Volume is null");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            SJmoReplicationPairVolInfo piarVol = allPairVolInfo.getPairVolInfo((SJmoLdevIndex)localVol);
            if (piarVol != null) {
                SJmoUniversalReplicatorPairVolInfo remoteVol = null;
                ArrayList remoteVolList = new ArrayList();
                remoteVolList = pflg ? piarVol.getAlSVolIndex() : piarVol.getAlPVolIndex();
                Collections.sort(remoteVolList);
                int index = Collections.binarySearch(remoteVolList, selectedVol);
                if (index >= 0) {
                    remoteVol = (SJmoUniversalReplicatorPairVolInfo)remoteVolList.get(index);
                }
                if (remoteVol != null) {
                    try {
                        retList.add((SJmoUniversalReplicatorPairVolInfo)remoteVol.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistUrPairVolInfo", "Catch CloneNotSupportedException.");
                        SJctrError err2 = new SJctrError(210, 22, 107001);
                        SJcException exp2 = err2.createException();
                        throw exp2;
                    }
                }
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistUrPairVolInfo", "Remote Volume is null");
                SJctrError err3 = new SJctrError(210, 22, 206502);
                SJcException exp3 = err3.createException();
                throw exp3;
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistUrPairVolInfo", "Remote Volume is not exist");
            SJctrError err4 = new SJctrError(210, 22, 206502);
            SJcException exp4 = err4.createException();
            throw exp4;
        }
        return retList;
    }

    public static List<SJmoUniversalReplicatorPairVolInfo> getExistUrPairVolInfo(List<SJmoUniversalReplicatorPairVolInfo> checkList, SJmoUniversalReplicatorPairVolInfoMgr allPairVolInfo) throws SJcException {
        if (checkList == null || allPairVolInfo == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoUniversalReplicatorPairVolInfo> retList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>(checkList.size());
        for (SJmoUniversalReplicatorPairVolInfo selectedVol : checkList) {
            SJcException exp;
            SJctrError err;
            boolean pflg = true;
            SJmoReplicationPairVolInfo localVol = null;
            ArrayList localVolList = selectedVol.getAlPVolIndex();
            if (localVolList == null || localVolList.size() == 0) {
                localVolList = selectedVol.getAlSVolIndex();
                pflg = false;
                if (localVolList == null || localVolList.size() == 0) {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfo", "local Volume is not exist");
                    err = new SJctrError(210, 22, 206502);
                    exp = err.createException();
                    throw exp;
                }
            }
            if ((localVol = (SJmoReplicationPairVolInfo)localVolList.get(0)) == null) {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfo", "local Volume is null");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            SJmoReplicationPairVolInfo pairVol = allPairVolInfo.getPairVolInfo((SJmoLdevIndex)localVol);
            if (pairVol != null) {
                SJmoUniversalReplicatorPairVolInfo remoteVol = null;
                ArrayList remoteVolList = new ArrayList();
                remoteVolList = pflg ? pairVol.getAlSVolIndex() : pairVol.getAlPVolIndex();
                Collections.sort(remoteVolList);
                int index = Collections.binarySearch(remoteVolList, selectedVol);
                if (index >= 0) {
                    remoteVol = (SJmoUniversalReplicatorPairVolInfo)remoteVolList.get(index);
                }
                if (remoteVol != null) {
                    try {
                        retList.add((SJmoUniversalReplicatorPairVolInfo)remoteVol.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfo", "Catch CloneNotSupportedException.");
                        SJctrError err2 = new SJctrError(210, 22, 107001);
                        SJcException exp2 = err2.createException();
                        throw exp2;
                    }
                }
                SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfo", "Selected Remote VOL is not Exist");
                continue;
            }
            SJctrLogUty.debug(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfo", "Selected Local VOL is not Exist");
        }
        return retList;
    }

    public static List<SJmoUniversalReplicatorPairVolInfo> getExistUrPairVolInfoViewPairProps(List<SJmoUniversalReplicatorPairVolInfo> checkList, SJmoUniversalReplicatorPairVolInfoMgr allPairVolInfo) throws SJcException {
        if (checkList == null || allPairVolInfo == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfoViewPairProps", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoUniversalReplicatorPairVolInfo> retList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>(checkList.size());
        for (SJmoUniversalReplicatorPairVolInfo selectedVol : checkList) {
            SJcException exp;
            SJctrError err;
            SJmoReplicationPairVolInfo localVol = null;
            ArrayList localVolList = selectedVol.getAlPVolIndex();
            if (!(localVolList != null && localVolList.size() != 0 || (localVolList = selectedVol.getAlSVolIndex()) != null && localVolList.size() != 0)) {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfoViewPairProps", "local Volume is not exist");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            localVol = (SJmoReplicationPairVolInfo)localVolList.get(0);
            if (localVol == null) {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfoViewPairProps", "local Volume is null");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            SJmoReplicationPairVolInfo pairVol = allPairVolInfo.getPairVolInfo((SJmoLdevIndex)localVol);
            if (pairVol != null) {
                try {
                    SJmoReplicationPairVolInfo clonePairVolInfo = (SJmoReplicationPairVolInfo)pairVol.clone();
                    retList.addAll(SJctrRemoteReplicationUtility.getRemoteVolumeInfoList(clonePairVolInfo));
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "SJmoReplicationPairVolInfo", "CloneNotSupportedException occured.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
                }
            }
            SJctrLogUty.debug(SJctrRemoteReplicationUtility.class.getSimpleName(), "getExistUrPairVolInfoViewPairProps", "Selected Local VOL is not Exist");
        }
        Collections.sort(retList);
        return retList;
    }

    public static void setCacheURPairDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetUniversalReplicatorPairVolInfoMgr.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetUniversalReplicatorPairVolInfoMgr.class));
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevLuseInfo.class));
    }

    public static HUR1DataVol getHUR1DataVol(SJmoRemoteReplicationLuPath luPath, int copyType) {
        HUR1DataVol dataVol = new HUR1DataVol();
        if (luPath != null) {
            dataVol.culdev = luPath.getIndex();
            if (copyType == 1) {
                SJmoLuIndex lu = luPath.getLuPath();
                dataVol.port = lu.getSPort();
                dataVol.hostGroup = lu.getSHostGroup();
                dataVol.lun = lu.getILUN();
            }
        }
        return dataVol;
    }

    public static SJmoUniversalReplicatorJnlGrpMgr getSJmoUniversalReplicatorJnlGrpMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetUniversalReplicatorJnlGrpMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorJnlGrpMgr", "Information of Remote Replication UniversalReplicator Journals List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorJnlGrpMgr", "Size of Remote Replication UniversalReplicator Journals List is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorJnlGrpMgr retInfo = (SJmoUniversalReplicatorJnlGrpMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorJnlGrpMgr", "Information of UniversalReplicator Journal is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static List<SJmoAllDKCInfo> getSJmoAllDKCInfo(SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSJmoAllDKCInfo", "Argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List<SJmoAllDKCInfo> allDKCInfo = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetAllDKCInfo.class);
        if (null == allDKCInfo) {
            dc.getLogUty().putlog("getSJmoAllDKCInfo", "Information of All DKC Info is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return allDKCInfo;
    }

    public static List<SJmoUniversalReplicatorJnlGrpMirror> checkAndGetExistMirrorInfo(List<SJmoMirrorIndex> checkList, SJmoUniversalReplicatorJnlGrpMgr allJnlInfo) {
        if (checkList == null || allJnlInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistMirrorInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoUniversalReplicatorJnlGrpMirror> retList = new ArrayList<SJmoUniversalReplicatorJnlGrpMirror>(checkList.size());
        for (SJmoMirrorIndex selectedMirror : checkList) {
            int jnlId = selectedMirror.getIJnlGroupId();
            SJmoUniversalReplicatorJnlGrp jnlInfo = allJnlInfo.getJnlGroup(jnlId);
            if (jnlInfo == null) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistMirrorInfo", "JournalGrp is null.");
                SJctrError err = new SJctrError(210, 22, 206503);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList mirrorList = jnlInfo.getMirrors();
            if (mirrorList == null) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistMirrorInfo", "JournalGrpMirror is not exist.");
                SJctrError err = new SJctrError(210, 22, 206503);
                SJcException exp = err.createException();
                throw exp;
            }
            int index = Collections.binarySearch(mirrorList, selectedMirror);
            if (index >= 0) {
                SJmoUniversalReplicatorJnlGrpMirror mirrorInfo = (SJmoUniversalReplicatorJnlGrpMirror)mirrorList.get(index);
                if (mirrorInfo != null) {
                    try {
                        retList.add((SJmoUniversalReplicatorJnlGrpMirror)mirrorInfo.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistMirrorInfo", "Catch CloneNotSupportedException.");
                        SJctrError err = new SJctrError(210, 22, 107001);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                }
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistMirrorInfo", "JournalGrpMirror is null.");
                SJctrError err = new SJctrError(210, 22, 206503);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistMirrorInfo", "JournalGrpMirror Index is not exist.");
            SJctrError err = new SJctrError(210, 22, 206503);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static int checkCopyTypeForMirror(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoUniversalReplicatorJnlGrpMgr allJnlInfo) {
        if (mirrorList == null || mirrorList.size() == 0 || allJnlInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForMirror", "Mirror list data or JournalInfo data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int copyType = -1;
        HashSet<Integer> selCopyType = new HashSet<Integer>();
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            int jnlId = mirrorInfo.getIJnlGroupId();
            selCopyType.add(SJctrRemoteReplicationUtility.checkJnltypeForJnlInfo(allJnlInfo.getJnlGroup(jnlId)));
        }
        if (selCopyType.size() == 1) {
            copyType = (Integer)selCopyType.toArray()[0];
        } else {
            if (selCopyType.size() == 0) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkCopyTypeForMirror", "Mirror list data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForMirror", "Copy type is mix.size = " + selCopyType.size());
        }
        return copyType;
    }

    public static int checkJnltypeForJnlInfo(SJmoUniversalReplicatorJnlGrp jnlGroup) {
        if (jnlGroup == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkJnltypeForJnlInfo", "journalGroup data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int rtn = -1;
        if (jnlGroup.getValidty() == 1) {
            rtn = 1;
        } else if (jnlGroup.getValidty() == 2) {
            rtn = 0;
        }
        return rtn;
    }

    public static List<SJmoMirrorIndex> getMirrorsListFromPair(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        ArrayList<SJmoMirrorIndex> mirrorsList = new ArrayList<SJmoMirrorIndex>();
        for (SJmoUniversalReplicatorPairVolInfo pairinfo : pairList) {
            int jnlId = -1;
            int mirrorId = pairinfo.getMirrorId();
            if (SJctrRemoteReplicationUtility.getPairPos(pairinfo) == 0) {
                jnlId = pairinfo.getMJnlGrpId();
            } else if (SJctrRemoteReplicationUtility.getPairPos(pairinfo) == 1) {
                jnlId = pairinfo.getRJnlGrpId();
            }
            SJmoMirrorIndex mirrorInfo = new SJmoMirrorIndex();
            mirrorInfo.setIJnlGroupId(jnlId);
            mirrorInfo.setIMirrorId(mirrorId);
            int index = Collections.binarySearch(mirrorsList, mirrorInfo);
            if (index >= 0) continue;
            mirrorsList.add(mirrorInfo);
            Collections.sort(mirrorsList);
        }
        return mirrorsList;
    }

    public static SJmoMirrorIndex getMirrorIndexFromPair(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (pairInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getMirrorIndexFromPair", "Param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoMirrorIndex mirrorIdex = new SJmoMirrorIndex();
        mirrorIdex.setIJnlGroupId(SJctrRemoteReplicationUtility.getJnlIdFromPair(pairInfo));
        mirrorIdex.setIMirrorId(pairInfo.getMirrorId());
        return mirrorIdex;
    }

    public static int getJnlIdFromPair(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (pairInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getJnlIdFromPair", "Param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        int jnlId = -1;
        if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) == 0) {
            jnlId = pairInfo.getMJnlGrpId();
        } else if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) == 1) {
            jnlId = pairInfo.getRJnlGrpId();
        } else {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getJnlIdFromPair", "PairPosition is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return jnlId;
    }

    public static boolean checkMirrorAttributeMaster(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorsList, boolean poschkFlg) {
        if (mirrorsList == null || mirrorsList.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorsList) {
            int iAttribute = mirrorInfo.getAttribute();
            if (iAttribute == 0) {
                rtn = false;
                break;
            }
            if (!poschkFlg || iAttribute == 1) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static boolean isInitialOfMirrorAttribute(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorsList) {
        if (mirrorsList == null || mirrorsList.size() == 0) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "isInitialOfMirrorAttribute", "Param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorsList) {
            if (mirrorInfo.getAttribute() == 0) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static void setCacheMirrorDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetUniversalReplicatorJnlGrpMgr.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetUniversalReplicatorJnlGrpMgr.class));
    }

    public static void chkCacheJnlGrpPropertyDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoLdevLuseInfo(dc);
        SJctrRemoteReplicationUtility.getSJmoHDPRelation(dc);
        SJctrReplicationUtility.getSJmoPoolNameInfo(dc);
        SJctrRemoteReplicationUtility.getSJmoSnapshotVvolRelation(dc);
        SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
    }

    public static List<SJmoHDPRelation> getSJmoHDPRelation(SJctrDataController dc) {
        List<SJmoHDPRelation> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetHDPRelation.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoGetHDPRelation", "Information of HDPRelation is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getSJmoSnapshotVvolRelation(SJctrDataController dc) {
        List<SJmoLocalReplicationPairVolInfo> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetSnapshotVvolRelation.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoSnapshotVvolRelation", "Information of snapshotVvolRelation is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static int getDeleteModeFromUrPairVolInfo(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        int rtn = -1;
        if (pairInfo != null) {
            rtn = pairInfo.getDelta() == 0 ? (pairInfo.getPairStatus() == 96 || pairInfo.getPairStatus() == 97 ? 1 : 0) : 0;
        }
        return rtn;
    }

    public static int getMaxCuNum(int controllerId) {
        int maxCu = 254;
        switch (controllerId) {
            case 5: 
            case 6: 
            case 7: {
                maxCu = 254;
                break;
            }
            case 19: {
                maxCu = 63;
                break;
            }
        }
        return maxCu;
    }

    public static boolean checkDeleteJournalStatus(List<SJmoUniversalReplicatorJnlGrp> selectedJnlist) {
        if (selectedJnlist == null || selectedJnlist.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoUniversalReplicatorJnlGrp selectJnl : selectedJnlist) {
            int attrivbute = selectJnl.getAttribute();
            if (attrivbute == 0) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static List<SJmoUniversalReplicatorJnlGrp> checkAndGetExistJournalInfo(List<SJmoUniversalReplicatorJnlGrp> selectedJournalList, SJmoUniversalReplicatorJnlGrpMgr allJnlInfo) {
        if (selectedJournalList == null || allJnlInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistJournalInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoUniversalReplicatorJnlGrp> jnlList = new ArrayList<SJmoUniversalReplicatorJnlGrp>(selectedJournalList.size());
        for (SJmoUniversalReplicatorJnlGrp selectJnl : selectedJournalList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo = allJnlInfo.getJnlGroup(selectJnl.getIndex());
            if (jnlInfo != null) {
                try {
                    jnlList.add((SJmoUniversalReplicatorJnlGrp)jnlInfo.clone());
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistJournalInfo", "Catch CloneNotSupportedException.");
                    SJctrError err = new SJctrError(210, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistJournalInfo", "journal data is null.");
            SJctrError err = new SJctrError(210, 22, 206504);
            SJcException exp = err.createException();
            throw exp;
        }
        return jnlList;
    }

    public static int checkJournalType(List<SJmoUniversalReplicatorJnlGrp> jnlList) {
        if (jnlList == null || jnlList.size() == 0) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkJournalType", "journalGroup data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int jnlType = -1;
        HashSet<Integer> selCopyType = new HashSet<Integer>();
        for (SJmoUniversalReplicatorJnlGrp jnlInfo : jnlList) {
            selCopyType.add(SJctrRemoteReplicationUtility.checkJnltypeForJnlInfo(jnlInfo));
        }
        if (selCopyType.size() == 1) {
            jnlType = (Integer)selCopyType.toArray()[0];
        } else {
            if (selCopyType.size() == 0) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkJournalType", "Mirror list data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkJournalType", "Journal type is mix.size = " + selCopyType.size());
        }
        return jnlType;
    }

    public static boolean isLuseElement(SJmoLdevDetail ldevDetail) {
        boolean ret = false;
        if (null != ldevDetail) {
            ret = ldevDetail.getSLUSEEmlCount() == 0;
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "isLuseElement", "Argument is null.");
        }
        return ret;
    }

    public static int getMirrorPosition(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo) {
        int rtn = -1;
        if (mirrorInfo != null) {
            if (mirrorInfo.getAttribute() == 1) {
                rtn = 0;
            } else if (mirrorInfo.getAttribute() == 2) {
                rtn = 1;
            } else {
                SJctrLogUty.error("SJctrReplicationUtility", "getMirrorPosition", "Mirror posision is Initial or invalid");
            }
        }
        return rtn;
    }

    public static List<SJmoLdevDetail> getSJmoLdevDetailFilteredByAllRsg(SJctrDataController dc) {
        List<Object> ldevList = new ArrayList<SJmoLdevDetail>();
        if (null == dc) {
            return ldevList;
        }
        try {
            List<SJmoLdevDetail> allLdevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(dc);
            List<SJmoRSGgetAllRsgs> allRsgList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
            SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgList);
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(dc.getOwner(), allRsg);
            ldevList = rsgUty.extractLdev(allLdevDetailList);
        }
        catch (SJcException e) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoLdevDetailFilteredByAllRsg", "Failed to get LDEV Detail.");
        }
        return ldevList;
    }

    public static List<SJmoRemoteReplicationRCUInfo> checkAndGetExistConnectionInfoSelectableClone(List<SJmoRemoteReplicationRCUInfo> checkList, SJmoRemoteReplicationMRCUInfoMgr allRCUInfo, boolean bClone) throws SJcException {
        if (checkList == null || allRCUInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistConnectionInfoSelectableClone", "param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoRemoteReplicationRCUInfo> retList = new ArrayList<SJmoRemoteReplicationRCUInfo>(checkList.size());
        ArrayList rcuInfoList = null;
        for (SJmoRemoteReplicationRCUInfo selectedConn : checkList) {
            SJmoRemoteReplicationMRCUInfo mrcuInfo;
            int connType = selectedConn.getICUFree();
            if (connType == 0) {
                mrcuInfo = allRCUInfo.getMRCUInfo((int)selectedConn.getSCUNo());
                rcuInfoList = mrcuInfo.getTrueCopyRCUInfoList();
            } else {
                mrcuInfo = allRCUInfo.getMRCUFreeInfo();
                rcuInfoList = mrcuInfo.getTrueCopyRCUInfoList();
            }
            Collections.sort(rcuInfoList);
            int index = Collections.binarySearch(rcuInfoList, selectedConn);
            if (index < 0) continue;
            try {
                SJmoRemoteReplicationRCUInfo rcuInfo = null;
                rcuInfo = bClone ? (SJmoRemoteReplicationRCUInfo)((SJmoRemoteReplicationRCUInfo)rcuInfoList.get(index)).clone() : (SJmoRemoteReplicationRCUInfo)rcuInfoList.get(index);
                retList.add(rcuInfo);
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistConnectionInfoSelectableClone", "Information of SJmoRemoteReplicationRCUInfo cannot clone.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        if (retList.size() == 0) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistConnectionInfoSelectableClone", "conenction is not exist");
            SJctrError err = new SJctrError(210, 22, 206501);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static List<SJmoRemoteReplicationRCUInfo> checkAndGetExistConnectionInfo(List<SJmoRemoteReplicationRCUInfo> checkList, SJmoRemoteReplicationMRCUInfoMgr allRCUInfo) throws SJcException {
        List<SJmoRemoteReplicationRCUInfo> retList = SJctrRemoteReplicationUtility.checkAndGetExistConnectionInfoSelectableClone(checkList, allRCUInfo, true);
        return retList;
    }

    public static String getModelNameString(int modelID, SJctrComUtility utility) {
        String modelName = "?";
        if (utility == null) {
            return modelName;
        }
        if (SJctrDataController.isHM()) {
            switch (modelID) {
                case 7: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_7") + " " + "(" + 7 + ")");
                    break;
                }
                case 18: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_18") + " " + "(" + 18 + ")");
                    break;
                }
                case 19: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_19") + " " + "(" + 19 + ")");
                    break;
                }
                default: {
                    modelName = new String("(" + Integer.toString(modelID) + ")");
                    break;
                }
            }
        } else {
            switch (modelID) {
                case 5: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_5_2") + " " + "(" + 5 + ")");
                    break;
                }
                case 6: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_6") + " " + "(" + 6 + ")");
                    break;
                }
                case 7: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_7") + " " + "(" + 7 + ")");
                    break;
                }
                case 18: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_18") + " " + "(" + 18 + ")");
                    break;
                }
                case 19: {
                    modelName = new String(utility.getGuidance("DKC_MODEL_19") + " " + "(" + 19 + ")");
                    break;
                }
                default: {
                    modelName = new String("(" + Integer.toString(modelID) + ")");
                }
            }
        }
        return modelName;
    }

    public static List<? extends SJmoReplicationPairVolInfo> getRemoteCopyPairVolInfoList(SJmoReplicationPairVolInfo[] pairInfoArray) {
        ArrayList<? extends SJmoLdevIndex> pairVolInfoList = new ArrayList<SJmoLdevIndex>();
        if (null != pairInfoArray) {
            try {
                for (SJmoReplicationPairVolInfo pairInfo : pairInfoArray) {
                    if (null == pairInfo) continue;
                    SJmoReplicationPairVolInfo clonePairVolInfo = (SJmoReplicationPairVolInfo)pairInfo.clone();
                    pairVolInfoList.addAll(SJctrRemoteReplicationUtility.getRemoteVolumeInfoList(clonePairVolInfo));
                }
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "SJmoReplicationPairVolInfo", "CloneNotSupportedException occured.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRemoteCopyPairVolInfoList", "Argument is null.");
        }
        return pairVolInfoList;
    }

    public static List<? extends SJmoLdevIndex> getRemoteVolumeInfoList(SJmoReplicationPairVolInfo localVolumeInfo) {
        ArrayList remoteVolInfoList = null;
        ArrayList tmpList = new ArrayList();
        if (null != localVolumeInfo) {
            tmpList.addAll(localVolumeInfo.getAlSVolIndex());
            tmpList.addAll(localVolumeInfo.getAlPVolIndex());
        }
        remoteVolInfoList = tmpList;
        return remoteVolInfoList;
    }

    public static SJmoSubsystemInfo getSJmoSubsystemInfo(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoSubsystemInfo", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        List<?> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetSubsystemInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoSubsystemInfo", "Information of Subsystem List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == info.size()) {
            dc.getLogUty().putlog("getSJmoSubsystemInfo", "Size of Subsystem List size is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoSubsystemInfo retInfo = (SJmoSubsystemInfo)info.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoSubsystemInfo", "Information of Subsystem is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public String getOptStatusString(SJctrEditRemoteFuncSwitchInfo funcSwitchInfo) {
        boolean flg = funcSwitchInfo.isFuncSwStatus();
        String status = this.guidanceHandle.getGuidance("DISABLED");
        if (flg) {
            status = this.guidanceHandle.getGuidance("ENABLED");
        }
        return status;
    }

    public String getRegisteredTimeString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        String ret = "?";
        if (rcuInfo != null) {
            Date daRegisterTime = rcuInfo.getDaRegisterTime();
            ret = daRegisterTime != null ? SJctrRemoteReplicationDataMacro.REPLICATION_DATE_FORMAT_YMDHMS.format(daRegisterTime) : "-";
        }
        return ret;
    }

    public String getLastUpdateTimeString(SJmoRemoteReplicationRCUInfo rcuInfo) {
        String ret = "?";
        if (rcuInfo != null) {
            Date daUpdateTime = rcuInfo.getDaUpdateTime();
            ret = daUpdateTime != null ? SJctrRemoteReplicationDataMacro.REPLICATION_DATE_FORMAT_YMDHMS.format(daUpdateTime) : "-";
        }
        return ret;
    }

    public static List<SJmoRemoteReplicationRCUInfo> removeNoResourceRCUInfo(List<SJmoRemoteReplicationRCUInfo> checkList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoRemoteReplicationRCUInfo> retList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
        if (checkList == null || rsgUtil == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "removeNoResourceRCUInfo", "param is invalid.");
            return retList;
        }
        for (SJmoRemoteReplicationRCUInfo rcuInfo : checkList) {
            if (!rcuInfo.getPathInfoList().isEmpty() && rsgUtil.extractPort(rcuInfo.getPathInfoList().subList(0, 1)).isEmpty()) continue;
            retList.add(rcuInfo);
        }
        return retList;
    }

    public static SJmoRemoteReplicationCuOptionInfoMgr getSJmoRemoteReplicationCuOptionInfoMgr(SJctrDataController dc) {
        List<?> optInfoMgrList = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetRemoteReplicationCuOptionInfoMgr.class);
        if (null == optInfoMgrList) {
            dc.getLogUty().putlog("getSJmoRemoteReplicationMRCUInfoMgr", "Information of Remote Replication CU Option info is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == optInfoMgrList.size()) {
            dc.getLogUty().putlog("getSJmoLocalReplicationPairVolInfoMgr", "Size of Remote Replication CU Option List size is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRemoteReplicationCuOptionInfoMgr optInfoMgr = (SJmoRemoteReplicationCuOptionInfoMgr)optInfoMgrList.get(0);
        if (null == optInfoMgr) {
            dc.getLogUty().putlog("getSJmoLocalReplicationPairVolInfoMgr", "Information of Remote Replication CU Option is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return optInfoMgr;
    }

    public static boolean isUsedTcPairVol(List<SJmoLdevDetail> ldevlist, SJmoTrueCopyPairVolInfoMgr tcPairMgr) {
        boolean result = false;
        if (null == ldevlist || 0 == ldevlist.size() || null == tcPairMgr) {
            return result;
        }
        for (SJmoLdevDetail ldev : ldevlist) {
            SJmoReplicationPairVolInfo tcPairVolInfo = tcPairMgr.getTrueCopyPairVolInfo((SJmoLdevIndex)ldev);
            if (null == tcPairVolInfo) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isUsedUrPairVol(List<SJmoLdevDetail> ldevlist, SJmoUniversalReplicatorPairVolInfoMgr urPairMgr) {
        boolean result = false;
        if (null == ldevlist || 0 == ldevlist.size() || null == urPairMgr) {
            return result;
        }
        for (SJmoLdevDetail ldev : ldevlist) {
            SJmoReplicationPairVolInfo urPairVolInfo = urPairMgr.getPairVolInfo((SJmoLdevIndex)ldev);
            if (null == urPairVolInfo) continue;
            result = true;
            break;
        }
        return result;
    }

    public static ArrayList<SJmoLdevDetail> getJournalVolTargetList(List<SJmoLdevDetail> ldevDetailList, List<SJmoLdevStatusInfo> ldevStatusList, SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr, List<SJmoHUVMVirtualLdev> vLdevList, boolean isOpen, List<SJmoHDPRelation> hdpRelationList, List<SJmoThinProvisioningVolumesStatus> dpVolStatusList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>();
        if (ldevDetailList == null || ldevStatusList == null || urPairVolInfoMgr == null || vLdevList == null || hdpRelationList == null || dpVolStatusList == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getJournalVolTargetList", "Argument is null.");
            return retList;
        }
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            if (SJctrRemoteReplicationUtility.isUrVol(urPairVolInfoMgr, ldevDetail) || !SJctrRemoteReplicationUtility.isJournalVolTarget(ldevDetail, ldevStatusList, vLdevList, hdpRelationList, dpVolStatusList)) continue;
            retList.add(ldevDetail);
        }
        return retList;
    }

    public static boolean isUrVol(SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr, SJmoLdevDetail ldevDetail) {
        if (urPairVolInfoMgr == null || ldevDetail == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "isUrVol", "Argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoReplicationPairVolInfo urPairVolInfo = urPairVolInfoMgr.getPairVolInfo((SJmoLdevIndex)ldevDetail);
        if (null != urPairVolInfo) {
            if (SJctrRemoteReplicationUtility.checkPairVolPos(urPairVolInfo, SJctrRemoteReplicationDataMacro.BITMAPDATA_VOL_POS_UR)) {
                return true;
            }
            if (SJctrRemoteReplicationUtility.checkPairVolPos(urPairVolInfo, SJctrRemoteReplicationDataMacro.BITMAPDATA_VOL_POS_URMF)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isJournalVolTarget(SJmoLdevDetail ldevDetail, List<SJmoLdevStatusInfo> ldevStatusList, List<SJmoHUVMVirtualLdev> vLdevList, List<SJmoHDPRelation> hdpRelationList, List<SJmoThinProvisioningVolumesStatus> dpVolStatusList) {
        if (ldevDetail == null || ldevStatusList == null || vLdevList == null || hdpRelationList == null || dpVolStatusList == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "isJournalVolTarget", "Argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        long MIN_JNL_VOL_LBA_SIZE = 0x300000L;
        if (ldevDetail.getbJNLVolume()) {
            return false;
        }
        if (625 != ldevDetail.getIEmulationType()) {
            return false;
        }
        if (!ldevDetail.getbVvol() || !ldevDetail.getbAouVvol()) {
            return false;
        }
        if (SJctrLdevUtility.isAllocateVolume(ldevDetail)) {
            return false;
        }
        if (ldevDetail.getbPoolVol()) {
            return false;
        }
        if (ldevDetail.getbQsVvol()) {
            return false;
        }
        if (ldevDetail.getbLUPathCmdDev()) {
            return false;
        }
        if (ldevDetail.getbRmtComDev()) {
            return false;
        }
        if (ldevDetail.getbSystemDisk()) {
            return false;
        }
        if (ldevDetail.getbHIHSMReserve()) {
            return false;
        }
        if (ldevDetail.getBLockVolume()) {
            return false;
        }
        if (0x300000L > ldevDetail.getLLDEVLBASize()) {
            return false;
        }
        int ldevStatusIndex = Collections.binarySearch(ldevStatusList, ldevDetail);
        if (ldevStatusIndex >= 0 && !SJctrCreatePairUtility.checkCreatePiarUsableStatus((SJmoLdevStatusInfo)ldevStatusList.get(ldevStatusIndex))) {
            return false;
        }
        int vLdevIndex = Collections.binarySearch(vLdevList, ldevDetail);
        if (vLdevIndex >= 0) {
            SJmoHUVMVirtualLdev virtualLdev = vLdevList.get(vLdevIndex);
            if (!virtualLdev.isValidIndexVirtualLdev()) {
                return false;
            }
            if (SJctrHaUtility.isHuvmReserve(virtualLdev)) {
                return false;
            }
        } else {
            return false;
        }
        if (ldevDetail.getBDM()) {
            return false;
        }
        if (ldevDetail.getBPoolOnlyLDEV()) {
            return false;
        }
        if (SJctrComCVSUtility.isDRDVol(ldevDetail, hdpRelationList, dpVolStatusList)) {
            return false;
        }
        return !ldevDetail.getBFPTVol();
    }

    public static int getLeadTime(int applySize, int progressUnit, int progressTime) {
        if (progressTime <= 0) {
            progressTime = 1;
            return progressTime;
        }
        if (progressUnit <= 0) {
            return progressTime;
        }
        if (applySize <= 0) {
            return progressTime;
        }
        int ret = (applySize + (progressUnit - 1)) / progressUnit * progressTime;
        return ret;
    }

    public static boolean checkAvailableFunction(SJmoUniversalReplicatorJnlGrp jnlGrp, int[][] availablePatterns) {
        boolean ret = false;
        if (jnlGrp != null && availablePatterns != null) {
            int iAttribute = jnlGrp.getAttribute();
            int iStatus1 = 0;
            int iStatus2 = 0;
            ArrayList jnlGrpMirrorList = jnlGrp.getMirrors();
            for (SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror : jnlGrpMirrorList) {
                int iStatus = jnlGrpMirror.getStatus();
                if (16 == iStatus) {
                    int iPairSuspend = jnlGrpMirror.getPairSuspend();
                    if (1 == iPairSuspend) {
                        iStatus = 2048;
                    }
                } else if (64 == iStatus) {
                    int iDelta = jnlGrpMirror.getDelta();
                    if (1 == iDelta) {
                        iStatus = 256;
                    } else if (2 == iDelta) {
                        iStatus = 512;
                    } else if (3 == iDelta) {
                        iStatus = 1024;
                    }
                }
                if (0 == iStatus) continue;
                if (0 == iStatus1) {
                    iStatus1 = iStatus;
                    continue;
                }
                if (0 == iStatus2) {
                    iStatus2 = iStatus;
                    continue;
                }
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkFunctionByMirrorStatus", "Mirrors are too much.");
                return ret;
            }
            int[] pattern = new int[]{iAttribute, iStatus1, iStatus2};
            for (int[] availablePattern : availablePatterns) {
                if (!Arrays.equals(pattern, availablePattern)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static SJcException createRemoteReplicationException(int err) {
        return new SJctrError(210, 22, err).createException();
    }

    public static void setCacheRemoteConnectionDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        if (null == dc || null == needDataMap) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "setCacheRemoteConnectionDetailData", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        needDataMap.put(SJmoGetPortDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetPortDetail.class));
    }

    public static void setCacheRemoveRemoteConnectionDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        if (null == dc || null == needDataMap) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "setCacheRemoveRemoteConnectionDetailData", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        needDataMap.put(SJmoGetPortDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetPortDetail.class));
        needDataMap.put(SJmoGetPortIscsiTargetPathInfo.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetPortIscsiTargetPathInfo.class));
    }

    public static List<RMCPget1PairDetail> getRMCPget1PairDetailList(SJctrDataController dc, List<SJmoTrueCopyPairVolInfo> pairList) {
        if (null == dc || null == pairList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRMCPget1PairDetailList", "Argument is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (pairList.isEmpty()) {
            return new ArrayList<RMCPget1PairDetail>(0);
        }
        List<SJmoThroughRmiData> rmiData = SJctrRemoteReplicationUtility.getRMCPget1PairDetailListModelDirect(dc, pairList);
        RMCPget1PairDetailList tcPairDetail = (RMCPget1PairDetailList)rmiData.get(0).getObjRmi();
        if (null == tcPairDetail) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRMCPget1PairDetailList", "TC Pair Detail is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        RMCPget1PairDetail[] detailArray = tcPairDetail.pairList;
        if (null == detailArray) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRMCPget1PairDetailList", "TC Pair Detail List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (detailArray.length == 0) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRMCPget1PairDetailList", "TC Pair Detail List is empty.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<RMCPget1PairDetail> ret = new ArrayList<RMCPget1PairDetail>(tcPairDetail.numofPairs);
        for (int i = 0; i < tcPairDetail.numofPairs; ++i) {
            if (null == detailArray[i]) continue;
            ret.add(detailArray[i]);
        }
        return ret;
    }

    private static List<SJmoThroughRmiData> getRMCPget1PairDetailListModelDirect(SJctrDataController dc, List<SJmoTrueCopyPairVolInfo> pairList) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        if (null == dc || null == pairList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRMCPget1PairDetailListModelDirect", "Argument is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int[] pairType = SJctrRemoteReplicationUtility.createPairDetailFlag(pairList);
        Robj_interface_RJiLDEVIndex[] param = SJctrRemoteReplicationUtility.createPairDetailParam(pairList);
        for (int pairTypeIndex = 0; pairTypeIndex < pairType.length; ++pairTypeIndex) {
            SJctrLogUty.info("SJctrRemoteReplicationUtility", "getRMCPget1PairDetailListModelDirect ###getRmcp1PairDetail input Copy Type###", "pairType[" + pairTypeIndex + "]=" + pairType[pairTypeIndex]);
        }
        for (int paramIndex = 0; paramIndex < param.length; ++paramIndex) {
            SJctrLogUty.info("SJctrRemoteReplicationUtility", "getRMCPget1PairDetailListModelDirect ###getRmcp1PairDetail input param###", "param[" + paramIndex + "].getSLDKC()=" + param[paramIndex].getSLDKC() + ":param[" + paramIndex + "].getSCU()=" + param[paramIndex].getSCU() + ":param[" + paramIndex + "].getSLDEV()=" + param[paramIndex].getSLDEV());
        }
        SJctrGetRmcp1PairDetailList kind = new SJctrGetRmcp1PairDetailList(pairType, param);
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        set.add(directWrapper);
        SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRMCPget1PairDetailListModelDirect", "Number of Pair = " + pairList.size() + ", Kind Class = " + SJctrGetRmcp1PairDetailList.class.getName());
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> rmiData = map.get(directWrapper);
        return rmiData;
    }

    private static Robj_interface_RJiLDEVIndex[] createPairDetailParam(List<SJmoTrueCopyPairVolInfo> pairList) {
        Robj_interface_RJiLDEVIndex[] ret = new RJiLDEVIndex[pairList.size()];
        for (int i = 0; i < pairList.size(); ++i) {
            SJmoTrueCopyPairVolInfo remoteVol = pairList.get(i);
            SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(remoteVol);
            ret[i] = new RJiLDEVIndex();
            ((RJiLDEVIndex)ret[i]).sLDKC = localVol.getSLdkc();
            ((RJiLDEVIndex)ret[i]).sCU = localVol.getSCu();
            ((RJiLDEVIndex)ret[i]).sLDEV = localVol.getSLdev();
        }
        return ret;
    }

    public static Robj_interface_RJiLDEVIndex[] createPairDetailUrParam(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        Robj_interface_RJiLDEVIndex[] ret = new RJiLDEVIndex[pairList.size()];
        for (int i = 0; i < pairList.size(); ++i) {
            SJmoUniversalReplicatorPairVolInfo remoteVol = pairList.get(i);
            SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolume(remoteVol);
            ret[i] = new RJiLDEVIndex();
            ((RJiLDEVIndex)ret[i]).sLDKC = localVol.getSLdkc();
            ((RJiLDEVIndex)ret[i]).sCU = localVol.getSCu();
            ((RJiLDEVIndex)ret[i]).sLDEV = localVol.getSLdev();
        }
        return ret;
    }

    public static List<HURget1PairDetail> getHURgetPairDetail(SJctrDataController dc, List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        if (null == dc || null == pairList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getHURgetPairDetail", "Argument is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (pairList.isEmpty()) {
            return new ArrayList<HURget1PairDetail>(0);
        }
        List<SJmoThroughRmiData> rmiData = SJctrRemoteReplicationUtility.getHURgetPairDetailModelDirect(dc, pairList);
        HURgetPairDetail urPairDetail = (HURgetPairDetail)rmiData.get(0).getObjRmi();
        if (null == urPairDetail) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getHURgetPairDetail", "UR Pair Detail is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList urPairDetailList = urPairDetail.details;
        if (null == urPairDetailList || urPairDetailList.isEmpty()) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getHURgetPairDetail", "UR Pair Detail List is null or empty.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return urPairDetailList;
    }

    private static List<SJmoThroughRmiData> getHURgetPairDetailModelDirect(SJctrDataController dc, List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        int pairType = -1;
        HURgetPairDetailParam param = SJctrRemoteReplicationUtility.createUrPairDetailParam(pairList);
        SJctrGetHurPairDetail kind = new SJctrGetHurPairDetail(pairType, param);
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> rmiData = map.get(directWrapper);
        return rmiData;
    }

    private static HURgetPairDetailParam createUrPairDetailParam(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        HURgetPairDetailParam ret = new HURgetPairDetailParam();
        ArrayList<HURget1PairDetailParam> paramList = new ArrayList<HURget1PairDetailParam>(pairList.size());
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairList) {
            SJmoReplicationPairVolInfo localVol;
            if (null == pairInfo || null == (localVol = SJctrRemoteReplicationUtility.getLocalVolume(pairInfo))) continue;
            HURget1PairDetailParam param = new HURget1PairDetailParam();
            HUR1DataVol dataVolInfo = new HUR1DataVol();
            short cu = localVol.getSCu();
            short ldev = localVol.getSLdev();
            dataVolInfo.culdev = cu << 8 | ldev;
            param.vol = dataVolInfo;
            if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
                param.pairFlag = 1;
            } else if (SJctrRemoteReplicationUtility.isMainframe(pairInfo)) {
                param.pairFlag = 0;
            } else {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "createUrPairDetailParam", "Unknown Copy Type");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            param.mirrorID = pairInfo.getMirrorId();
            param.modelID = pairInfo.getModelId();
            SJctrLogUty.info("SJctrRemoteReplicationUtility", "createUrPairDetailParam  ###getHurPairDetail input param###", "param.vol.culdev=" + param.vol.culdev + ":param.pairFlag=" + param.pairFlag + ":param.mirrorID=" + param.mirrorID + ":param.modelID=" + param.modelID);
            paramList.add(param);
        }
        ret.pair = paramList;
        return ret;
    }

    public static RMCPget1PairDetail getRmiPairRelatedModelPair(List<RMCPget1PairDetail> rmiPairList, SJmoTrueCopyPairVolInfo remoteVol) {
        if (null == rmiPairList || null == remoteVol) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(remoteVol);
        boolean isPvol = false;
        if (SJctrRemoteReplicationUtility.isSvol(remoteVol)) {
            isPvol = true;
        }
        RMCPget1PairDetail ret = null;
        for (RMCPget1PairDetail rmiPair : rmiPairList) {
            if (isPvol && rmiPair.VolumeType != 0 || !isPvol && rmiPair.VolumeType != 1) {
                SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair ###Pair Position is invalid###", "rmiPair.VolumeType=" + rmiPair.VolumeType + ":isPvol(remoteVol)=" + SJctrRemoteReplicationUtility.isPvol(remoteVol));
                continue;
            }
            if (isPvol) {
                if (localVol.getSLdkc() == rmiPair.PLDKC && localVol.getSCu() == rmiPair.PCUNo && localVol.getSLdev() == rmiPair.PVolNo) {
                    ret = rmiPair;
                    break;
                }
                SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair ###LDEV ID is invalid###", "rmiPair.PLDKC=" + rmiPair.PLDKC + ":rmiPair.PCUNo=" + rmiPair.PCUNo + ":rmiPair.PVolNo=" + rmiPair.PVolNo + ":localVol.getSLdkc()=" + localVol.getSLdkc() + ":localVol.getSCu()=" + rmiPair.PVolNo + ":localVol.getSLdev()=" + localVol.getSLdev());
                continue;
            }
            if (localVol.getSLdkc() == rmiPair.SLDKC && localVol.getSCu() == rmiPair.SCUNo && localVol.getSLdev() == rmiPair.SVolNo) {
                ret = rmiPair;
                break;
            }
            SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair ###LDEV ID is invalid###", "rmiPair.SLDKC=" + rmiPair.SLDKC + ":rmiPair.SCUNo=" + rmiPair.SCUNo + ":rmiPair.SVolNo=" + rmiPair.SVolNo + ":localVol.getSLdkc()=" + localVol.getSLdkc() + ":localVol.getSCu()=" + rmiPair.PVolNo + ":localVol.getSLdev()=" + localVol.getSLdev());
        }
        return ret;
    }

    public static HURget1PairDetail getRmiPairRelatedModelPair(List<HURget1PairDetail> rmiPairList, SJmoUniversalReplicatorPairVolInfo remoteVol) {
        if (null == rmiPairList || null == remoteVol) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        HURget1PairDetail ret = null;
        for (HURget1PairDetail rmiPair : rmiPairList) {
            int rmiCuLdev;
            int modelCuLdev = remoteVol.getSCu() << 8 | remoteVol.getSLdev();
            if (SJctrRemoteReplicationUtility.isPvol(remoteVol)) {
                if (rmiPair.volType == 0) {
                    SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "Pair Position is invalid:rmiPair.volType=" + rmiPair.volType + ":isPvol(remoteVol)=" + SJctrRemoteReplicationUtility.isPvol(remoteVol));
                    continue;
                }
                rmiCuLdev = rmiPair.pvol.culdev;
            } else {
                if (rmiPair.volType == 1) {
                    SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "Pair Position is invalid:rmiPair.volType=" + rmiPair.volType + ":isPvol(remoteVol)=" + SJctrRemoteReplicationUtility.isPvol(remoteVol));
                    continue;
                }
                rmiCuLdev = rmiPair.svol.culdev;
            }
            if (rmiCuLdev != modelCuLdev) {
                SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "LDEV ID is invalid:rmiCuLdev=" + Integer.toString(rmiCuLdev, 16) + ":modelCuLdev=" + Integer.toString(modelCuLdev, 16));
                continue;
            }
            if (rmiPair.mjnlGrp != remoteVol.getMJnlGrpId()) {
                SJctrLogUty.info(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "LDEV ID is invalid:rmiCuLdev=" + Integer.toString(rmiCuLdev, 16) + ":modelCuLdev=" + Integer.toString(modelCuLdev, 16));
                continue;
            }
            if (rmiPair.mirrorID != remoteVol.getMirrorId()) {
                SJctrLogUty.debug(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRmiPairRelatedModelPair", "Mirror ID is invalid:rmiPair.mirrorID=" + Integer.toString(rmiPair.mirrorID, 16) + ":remoteVol.getMirrorId()" + Integer.toString(remoteVol.getMirrorId(), 16));
                continue;
            }
            ret = rmiPair;
            break;
        }
        return ret;
    }

    public static String getLdevIdWithLdevName(SJmoLdevIndex index, List<SJmoLdevNicknameInfo> ldevNameList, SJctrLdevUtility ldevUty) {
        String ret = "?";
        if (null == index || null == ldevNameList || null == ldevUty) {
            return ret;
        }
        SJmoLdevIndex newIndex = new SJmoLdevIndex();
        newIndex.setLdevIndex(index.getSLdkc(), index.getSCu(), index.getSLdev());
        int i = Collections.binarySearch(ldevNameList, newIndex);
        String name = "?";
        if (0 <= i) {
            name = ldevNameList.get(i).getStrNickname();
        }
        ret = ldevUty.toLdevDisplay(newIndex) + "(" + name + ")";
        return ret;
    }

    public static List<SJmoLdevStatusInfo> getSJmoLdevStatusInfo(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoLdevStatusInfo", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        List<SJmoLdevStatusInfo> retInfoList = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevStatusInfo.class);
        if (null == retInfoList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoLdevStatusInfo", "LDEV Status Info List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        return retInfoList;
    }

    public static boolean checkSelectedMirrorListAssignMultiJnl(List<SJmoUniversalReplicatorJnlGrpMirror> selectedMirrorList) {
        boolean rtn = false;
        if (selectedMirrorList == null || selectedMirrorList.size() == 0) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkSelectedMirrorListAssignMultiJnl", "inheritedList is null.");
            return rtn;
        }
        HashSet<Integer> mirrorInfoMap = new HashSet<Integer>();
        for (SJmoMirrorIndex sJmoMirrorIndex : selectedMirrorList) {
            mirrorInfoMap.add(sJmoMirrorIndex.getIJnlGroupId());
        }
        if (mirrorInfoMap.size() == 1) {
            rtn = true;
        }
        return rtn;
    }

    public static List<SJmoLdevDetail> getRemoteCommadDevices(List<SJmoLdevDetail> ldevDetailList, SJctrResourceGroupUtility rsgUtil, List<SJmoLdevStatusInfo> ldevStatusList) {
        ArrayList<SJmoLdevDetail> remoteCmdDevsList = new ArrayList<SJmoLdevDetail>();
        if (null == ldevDetailList || null == rsgUtil || null == ldevStatusList) {
            return remoteCmdDevsList;
        }
        List<SJmoLdevIndex> enableVolList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUtil);
        for (SJmoLdevIndex ldevIndex : enableVolList) {
            int index = Collections.binarySearch(ldevDetailList, ldevIndex);
            if (index < 0 || !SJctrLdevUtility.isOpenVolume(ldevDetailList.get(index)) || !ldevDetailList.get(index).getbRmtComDev() || !SJctrReplicationUtility.checkLdevStatus(ldevDetailList.get(index), ldevStatusList)) continue;
            remoteCmdDevsList.add(ldevDetailList.get(index));
        }
        return remoteCmdDevsList;
    }

    public static int checkReleaseRCmdDevs(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoUniversalReplicatorJnlGrpMgr alljnlInfo) {
        int iRtn = 0;
        if (mirrorList == null || mirrorList.size() == 0 || alljnlInfo == null) {
            iRtn = -1;
            return iRtn;
        }
        for (SJmoUniversalReplicatorJnlGrpMirror jnlMirror : mirrorList) {
            if (jnlMirror == null) {
                iRtn = -1;
                break;
            }
            if (0 != jnlMirror.getUcPath()) continue;
            if (0 == jnlMirror.getIMirrorId()) {
                int jnlGrpId = jnlMirror.getIJnlGroupId();
                SJmoUniversalReplicatorJnlGrp jnlGrp = alljnlInfo.getJnlGroup(jnlGrpId);
                if (jnlGrp == null) {
                    iRtn = -1;
                    break;
                }
                if (0 != jnlGrp.getUcPathForTC()) continue;
                iRtn = 1;
                break;
            }
            iRtn = 1;
            break;
        }
        return iRtn;
    }

    public static List<Short> getMFLDEVExistCuList(List<SJmoLdevDetail> ldevList) {
        if (ldevList == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getMFLDEVExistCuList", "param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        HashSet<Short> cuSet = new HashSet<Short>();
        for (SJmoLdevDetail ldev : ldevList) {
            byte volFlag = ldev.getByVolumeFlag();
            if (volFlag != 1) continue;
            cuSet.add(ldev.getSCu());
        }
        ArrayList<Short> retList = new ArrayList<Short>(cuSet);
        Collections.sort(retList);
        return retList;
    }

    public static List<SJmoPortLunDetail> getDisplayLunDetailList(SJmoLdevIndex ldevIndex, Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap) {
        List<SJmoPortLunDetail> ret = null;
        if (ldevIndex != null && ldevLUPathInfoMap != null) {
            ret = ldevLUPathInfoMap.get(SJctrReplicationUtility.getLdevIndexKey(ldevIndex));
        }
        return ret;
    }

    public static SJmoPortLunDetail getDisplayLunDetailInfo(SJmoLdevIndex ldevIndex, Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap) {
        SJmoPortLunDetail ret = null;
        List<SJmoPortLunDetail> lunDetailList = SJctrRemoteReplicationUtility.getDisplayLunDetailList(ldevIndex, ldevLUPathInfoMap);
        if (lunDetailList != null && lunDetailList.size() > 0) {
            ret = lunDetailList.get(0);
        }
        return ret;
    }

    public static long convHmsStringToLong(String dateString) {
        long retValue = -1L;
        String[] hmsStrArray = dateString.split(":");
        if (hmsStrArray.length == 3) {
            try {
                retValue = Long.parseLong(hmsStrArray[0]) * 60L * 60L;
                retValue += Long.parseLong(hmsStrArray[1]) * 60L;
                retValue += Long.parseLong(hmsStrArray[2]);
            }
            catch (NumberFormatException nfe) {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "convHmsStringToLong", "dateString is invalid String");
                retValue = -1L;
            }
        }
        return retValue;
    }

    public static long convYmdHmsStringToLong(String dateString) {
        long retValue = 0L;
        try {
            if (dateString != null && dateString.length() > 0) {
                Date date = SJctrRemoteReplicationDataMacro.REPLICATION_DATE_FORMAT_YMDHMS.parse(dateString);
                retValue = date.getTime();
            }
        }
        catch (ParseException e) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "convYmdHmsStringToLong", "DateFormat: yyyy/mm/dd hh:mm:ss");
        }
        return retValue;
    }

    public static boolean isValidCopyTime(SJctrRemoteHistoriesTcInfo histInfo) {
        int operation;
        boolean ret = false;
        if (histInfo != null && ((operation = histInfo.getOperation()) == 2 || operation == 7)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isValidCopyTime(SJctrRemoteHistoriesUrInfo histInfo) {
        String operation;
        boolean ret = false;
        if (histInfo != null && ((operation = histInfo.getOperation()).equals("Paircreate Complete") || operation.equals("Pairresync Complete") || operation.equals("Add Pair Complete") || operation.equals("Resume Pair Complete"))) {
            ret = true;
        }
        return ret;
    }

    public static SJmoThroughRmiData getRmiObject(SJctrDataController dc, SJmoGetKind_IF kind) {
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        wrapperSet.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        List<?> rmiDataList = dataMap.get(directWrapper);
        if (null == rmiDataList) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getRmiObject", "RMI data list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == rmiDataList.size()) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getRmiObject", "RMI data list size is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)rmiDataList.get(0);
        if (null == rmiData) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getRmiObject", "RMI data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return rmiData;
    }

    public static SJmoThroughRmiData getRMCPgetPairModelDirect(SJctrDataController dc, List<SJmoTrueCopyPairVolInfo> pairList, int pairType) {
        if (dc == null || pairList == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getRMCPgetPairModelDirect", "dc or pairList is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Robj_interface_RJiLDEVIndex[] param = SJctrRemoteReplicationUtility.createPairDetailParam(pairList);
        SJctrGetRmcpPair kind = new SJctrGetRmcpPair(pairType, param);
        SJmoThroughRmiData rmiData = SJctrRemoteReplicationUtility.getRmiObject(dc, (SJmoGetKind_IF)kind);
        return rmiData;
    }

    public String getTcSyncrateString(SJctrViewPairSyncRateTcTcmfInfo syncRateInfo) {
        String ret = "?";
        if (syncRateInfo != null) {
            ret = SJctrRemoteReplicationUtility.isEffectiveStatusViewSyncRate((SJmoReplicationPairVolInfo)syncRateInfo, syncRateInfo.getIPairStatus()) && syncRateInfo.isSyncRateSupported() ? (syncRateInfo.getQueu() == 1 ? this.guidanceHandle.getGuidance("QUEUING") : Integer.toString(syncRateInfo.getSyncRate())) : "-";
        }
        return ret;
    }

    public String getUrSyncrateString(SJctrViewPairSyncRateUrUrmfInfo syncRateInfo) {
        String ret = "?";
        if (syncRateInfo != null) {
            ret = SJctrRemoteReplicationUtility.isEffectiveStatusViewSyncRate((SJmoReplicationPairVolInfo)syncRateInfo, syncRateInfo.getPairStatus()) && syncRateInfo.getDelta() == 0 ? (syncRateInfo.getQueu() == 1 ? this.guidanceHandle.getGuidance("QUEUING") : Integer.toString(syncRateInfo.getSyncRate())) : "-";
        }
        return ret;
    }

    public static boolean isEffectiveStatusViewSyncRate(SJmoReplicationPairVolInfo pairVolInfo, int status) {
        boolean ret;
        block4: {
            block7: {
                block6: {
                    block5: {
                        ret = false;
                        if (pairVolInfo == null) break block4;
                        if (!pairVolInfo.isVolPos(2) && !pairVolInfo.isVolPos(64)) break block5;
                        for (int okStat : SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_PRIMARY_TC_TCMF) {
                            if (okStat != status) continue;
                            ret = true;
                            break block4;
                        }
                        break block4;
                    }
                    if (!pairVolInfo.isVolPos(1)) break block6;
                    for (int okStat : SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_SECONDARY_TC) {
                        if (okStat != status) continue;
                        ret = true;
                        break block4;
                    }
                    break block4;
                }
                if (!pairVolInfo.isVolPos(8192) && !pairVolInfo.isVolPos(262144)) break block7;
                for (int okStat : SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_PRIMARY_UR_URMF) {
                    if (okStat != status) continue;
                    ret = true;
                    break block4;
                }
                break block4;
            }
            if (!pairVolInfo.isVolPos(4096) && !pairVolInfo.isVolPos(131072)) break block4;
            for (int okStat : SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_SECONDARY_UR_URMF) {
                if (okStat != status) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String getUrPathGroupIdString(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            int pathIdFlg = pairInfo.getPathIDEnable();
            if (1 == pathIdFlg) {
                ret = SJctrComUtility.toHexString(pairInfo.getPathID(), 2, true);
            } else if (0 == pathIdFlg) {
                ret = "-";
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getUrPathGroupIdString", "Path group id flg is invalid.");
            }
        }
        return ret;
    }

    public static List<?> getSpecifiedModelInfoMgrNotUsedCache(SJctrDataController dc, SJmoGetKind_IF kind) {
        if (dc == null || kind == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSpecifiedModelInfoMgrNotUsedCache", "dc or kind is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> retInfoList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        if (null == retInfoList) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSpecifiedModelInfoMgrNotUsedCache", "Information of " + kind.getClass().getName() + " List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSpecifiedModelInfoMgrNotUsedCache", "Size of " + kind.getClass().getName() + " List is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    public static List<?> getSpecifiedModelInfoNotUsedCache(SJctrDataController dc, SJmoGetKind_IF kind) {
        if (dc == null || kind == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSpecifiedModelInfoNotUsedCache", "dc or kind is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> retInfoList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        if (null == retInfoList) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSpecifiedModelInfoNotUsedCache", "Information of " + kind.getClass().getName() + " is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    public String getTcCopyPriorityString(SJmoTrueCopyPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
                ret = "-";
            } else if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
                int priority = pairInfo.getIPriority();
                ret = String.valueOf(priority);
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getTcCopyPriorityString", "Pair position is invalid.");
            }
        }
        return ret;
    }

    public String getUrCopyPriorityString(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            int priority = pairInfo.getCopyPriority();
            ret = String.valueOf(priority);
        }
        return ret;
    }

    public static int getLocalJnlId(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (null == pairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getLocalJnlId", "Argument is null.");
        }
        int ret = -1;
        if (SJctrRemoteReplicationUtility.isPvol(pairInfo)) {
            ret = pairInfo.getRJnlGrpId();
        } else if (SJctrRemoteReplicationUtility.isSvol(pairInfo)) {
            ret = pairInfo.getMJnlGrpId();
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getLocalJnlId", "iPairVolPos is invalid.");
        }
        return ret;
    }

    public static boolean isHP() {
        boolean bHP = false;
        String venderStr = SJcProductUty.getVenderID();
        if ("HPE".equals(venderStr) || "HPJ".equals(venderStr)) {
            bHP = true;
        }
        return bHP;
    }

    private static int[] createPairDetailFlag(List<SJmoTrueCopyPairVolInfo> pairList) {
        int[] ret = new int[pairList.size()];
        for (int i = 0; i < pairList.size(); ++i) {
            SJmoTrueCopyPairVolInfo remoteVol = pairList.get(i);
            if (SJctrRemoteReplicationUtility.isOpen(remoteVol)) {
                ret[i] = 1;
                continue;
            }
            if (SJctrRemoteReplicationUtility.isMainframe(remoteVol)) {
                ret[i] = 0;
                continue;
            }
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "createPairDetailFlag", "Pair Type is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    public static int checkAssignRCmdDevs(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo, SJmoUniversalReplicatorJnlGrp jnlInfo) {
        int assginFlg = -1;
        if (null == mirrorInfo || null == jnlInfo) {
            return assginFlg;
        }
        if (mirrorInfo.getIJnlGroupId() != jnlInfo.getIJnlGroupId()) {
            return assginFlg;
        }
        assginFlg = mirrorInfo.getMirrorId() == 0 ? (jnlInfo.getUcPathForTC() == 0 ? (mirrorInfo.getUcPath() == 0 ? 0 : 1) : 1) : (mirrorInfo.getUcPath() == 0 ? 0 : 1);
        return assginFlg;
    }

    public static void setCacheLdevDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRemoteReplicationUtility.getCache(dc, SJmoGetLdevDetail.class));
    }

    public static int getPairVolPosInfoFromPairSummaryTCTCMF(int copytype, RMCPget1PairSummary rmiData) {
        if (rmiData == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairVolPosInfoFromPairSummaryTCTCMF", "RMCPget1PairSummary is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int pairVolPosInfo = -1;
        boolean isLocalSvol = false;
        if ((rmiData.getType() & 2) == 2) {
            isLocalSvol = true;
        }
        if (copytype == 1) {
            pairVolPosInfo = isLocalSvol ? 1 : 2;
        } else if (copytype == 0) {
            pairVolPosInfo = isLocalSvol ? 32 : 64;
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairVolPosInfoFromPairSummaryTCTCMF", "Pair Type is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return pairVolPosInfo;
    }

    public static int getPairVolPosInfoFromPairSummaryURURMF(int copytype, RJiHURget1PairInfo rmiData) {
        if (rmiData == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairVolPosInfoFromPairSummaryURURMF", "RJiHURget1PairInfo is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int pairVolPosInfo = -1;
        boolean isLocalSvol = false;
        if ((rmiData.getPairKind() & 1) == 1) {
            isLocalSvol = true;
        }
        if (copytype == 1) {
            pairVolPosInfo = isLocalSvol ? 4096 : 8192;
        } else if (copytype == 0) {
            pairVolPosInfo = isLocalSvol ? 131072 : 262144;
        } else {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairVolPosInfoFromPairSummaryURURMF", "Pair Type is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return pairVolPosInfo;
    }

    public static Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> getEnableStatusOptionMapForEditMirrorOptions(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        if (mirrorList == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getEnableStatusOptionMapForEditMirrorOptions", "SJmoUniversalReplicatorJnlGrpMirror list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        HashMap<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap = new HashMap<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean>();
        enableStatusMap.put(SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_PATH_WATCH_TIME, SJctrRemoteReplicationUtility.isEnableStatusOptionsForEditMirrorOptions(SJctrRemoteReplicationDataMacro.ENABLE_STATUS_PATTERN_PATH_WATCH_TIME, mirrorList));
        enableStatusMap.put(SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_PATH_WATCH_TIME_TRANSFER, SJctrRemoteReplicationUtility.isEnableStatusOptionsForEditMirrorOptions(SJctrRemoteReplicationDataMacro.ENABLE_STATUS_PATTERN_PATH_WATCH_TIME_TRANSFER, mirrorList));
        enableStatusMap.put(SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_COPY_PACE, SJctrRemoteReplicationUtility.isEnableStatusOptionsForEditMirrorOptions(SJctrRemoteReplicationDataMacro.ENABLE_STATUS_PATTERN_COPY_PACE, mirrorList));
        enableStatusMap.put(SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_TRANSFER_SPEED, SJctrRemoteReplicationUtility.isEnableStatusOptionsForEditMirrorOptions(SJctrRemoteReplicationDataMacro.ENABLE_STATUS_PATTERN_TRANSFER_SPEED, mirrorList));
        enableStatusMap.put(SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_DELTA_RESYNC_FAILURE, SJctrRemoteReplicationUtility.isEnableStatusOptionsForEditMirrorOptions(SJctrRemoteReplicationDataMacro.ENABLE_STATUS_PATTERN_DELTA_RESYNC_FAILURE, mirrorList));
        return enableStatusMap;
    }

    private static boolean isEnableStatusOptionsForEditMirrorOptions(int[][] enableStatusPattern, List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        boolean ret = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirror : mirrorList) {
            int[] statusPattern = SJctrRemoteReplicationUtility.getMirrorStatusPattern(mirror);
            if (SJctrRemoteReplicationUtility.isPatternContains(enableStatusPattern, statusPattern)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private static boolean isPatternContains(int[][] availablePatterns, int[] pattern) {
        boolean ret = false;
        for (int[] availablePattern : availablePatterns) {
            if (!Arrays.equals(availablePattern, pattern)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean hasTopJnlVolRs(SJmoUniversalReplicatorJnlGrp jnlInfo, SJctrResourceGroupUtility rsgUty) {
        if (null == jnlInfo || null == rsgUty) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasTopJnlVolRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList jnlVolList = jnlInfo.getJnlVols();
        List topJnlVol = null;
        if (jnlVolList.isEmpty()) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasTopJnlVolRs", "Journal volumes list is empty.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        topJnlVol = jnlVolList.subList(0, 1);
        return !rsgUty.extractLdev(topJnlVol).isEmpty();
    }

    public static boolean hasTopJnlVolRs(List<SJmoUniversalReplicatorJnlGrp> jnlList, SJctrResourceGroupUtility rsgUty) {
        if (null == jnlList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasTopJnlVolRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean hasTopJnlVolRs = true;
        for (SJmoUniversalReplicatorJnlGrp jnlInfo : jnlList) {
            if (SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnlInfo, rsgUty)) continue;
            hasTopJnlVolRs = false;
            break;
        }
        return hasTopJnlVolRs;
    }

    public static List<SJmoUniversalReplicatorJnlGrp> getSelectedMirrorJournal(SJmoUniversalReplicatorJnlGrpMgr jnlMgr, List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        if (null == jnlMgr || null == mirrorList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSelectedMirrorJournal", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        HashSet<SJmoUniversalReplicatorJnlGrp> jnlSet = new HashSet<SJmoUniversalReplicatorJnlGrp>();
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo = jnlMgr.getJnlGroup(mirrorInfo.getIJnlGroupId());
            if (null == jnlInfo) continue;
            jnlSet.add(jnlInfo);
        }
        ArrayList<SJmoUniversalReplicatorJnlGrp> ret = new ArrayList<SJmoUniversalReplicatorJnlGrp>(jnlSet);
        Collections.sort(ret);
        return ret;
    }

    public static List<SJmoUniversalReplicatorJnlGrp> getSelectedMirrorJournal(SJctrDataController dc, List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSelectedMirrorJournal", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(dc);
        return SJctrRemoteReplicationUtility.getSelectedMirrorJournal(jnlMgr, mirrorList);
    }

    public static void checkTopJnlVolRsSelectedMirror(SJctrDataController dc, List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        SJctrResourceGroupUtility rsgUty;
        List<SJmoUniversalReplicatorJnlGrp> jnlList = SJctrRemoteReplicationUtility.getSelectedMirrorJournal(dc, mirrorList);
        if (!SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnlList, rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(dc))) {
            dc.logUty.putlog("checkTopJnlVolRsSelectedMirror", "Specified jounal is not authorized.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206117);
        }
    }

    public static boolean hasMirrorTypicalVolRs(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo, SJctrResourceGroupUtility rsgUty) {
        if (null == mirrorInfo || null == rsgUty) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasMirrorTypicalVolRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean hasMirrorTypicalVolRs = false;
        ArrayList<SJmoRemoteReplicationLuPath> searchList = new ArrayList<SJmoRemoteReplicationLuPath>(1);
        switch (mirrorInfo.getAttribute()) {
            case 0: {
                hasMirrorTypicalVolRs = true;
                break;
            }
            case 1: {
                searchList.add(mirrorInfo.getPDataVol());
                hasMirrorTypicalVolRs = !rsgUty.extractLdev(searchList).isEmpty();
                break;
            }
            case 2: {
                searchList.add(mirrorInfo.getSDataVol());
                hasMirrorTypicalVolRs = !rsgUty.extractLdev(searchList).isEmpty();
                break;
            }
            default: {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasMirrorTypicalVolRs", "Unknown mirror attribute: " + mirrorInfo.getAttribute());
            }
        }
        return hasMirrorTypicalVolRs;
    }

    public static boolean hasMirrorTypicalVolRs(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJctrResourceGroupUtility rsgUty) {
        if (null == mirrorList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasMirrorTypicalVolRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean hasMirrorTypicalVolRs = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            if (SJctrRemoteReplicationUtility.hasMirrorTypicalVolRs(mirrorInfo, rsgUty)) continue;
            hasMirrorTypicalVolRs = false;
            break;
        }
        return hasMirrorTypicalVolRs;
    }

    public static boolean hasJnlTypicalVolRs(SJmoUniversalReplicatorJnlGrp jnlInfo, SJctrResourceGroupUtility rsgUty) {
        if (null == jnlInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasJnlTypicalVolRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return SJctrRemoteReplicationUtility.hasMirrorTypicalVolRs(jnlInfo.getMirrors(), rsgUty);
    }

    public static boolean hasJnlTypicalVolRs(List<SJmoUniversalReplicatorJnlGrp> jnlList, SJctrResourceGroupUtility rsgUty) {
        if (null == jnlList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasJnlTypicalVolRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean hasMirrorTypicalVolRs = true;
        for (SJmoUniversalReplicatorJnlGrp jnlInfo : jnlList) {
            if (SJctrRemoteReplicationUtility.hasJnlTypicalVolRs(jnlInfo, rsgUty)) continue;
            hasMirrorTypicalVolRs = false;
            break;
        }
        return hasMirrorTypicalVolRs;
    }

    public static SJctrResourceGroupUtility getSJctrResourceGroupUtility(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJctrResourceGroupUtility", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List<SJmoRSGgetAllRsgs> rsgList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
        SJmoRSGgetAllRsgs rsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, rsgList);
        return new SJctrResourceGroupUtility(dc.getOwner(), rsgInfo);
    }

    public static void checkMirrorTypicalVolRs(SJctrDataController dc, List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        SJctrResourceGroupUtility rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(dc);
        if (!SJctrRemoteReplicationUtility.hasMirrorTypicalVolRs(mirrorList, rsgUty)) {
            dc.logUty.putlog("checkMirrorTypicalVolRs", "Specified mirror is not authorized.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206119);
        }
    }

    public static void checkJournalTypicalVolRs(SJctrDataController dc, List<SJmoUniversalReplicatorJnlGrp> jnlList) {
        SJctrResourceGroupUtility rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(dc);
        if (!SJctrRemoteReplicationUtility.hasJnlTypicalVolRs(jnlList, rsgUty)) {
            dc.logUty.putlog("checkJournalTypicalVolRs", "Specified mirror is not authorized.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206118);
        }
    }

    public static SJmoRemoteReplicationRCUInfo getRcuInfo(boolean isCuFree, short ldkc, short mcu, short rcu, int controllerId, String serialNum, int pathId, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr) {
        if (null == serialNum || null == mrcuMgr) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRcuInfo", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoRemoteReplicationMRCUInfo mrcuInfo = null;
        mrcuInfo = isCuFree ? mrcuMgr.getMRCUFreeInfo() : mrcuMgr.getMRCUInfo((int)mcu);
        if (null == mrcuInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRcuInfo", "Arguments are invalid.  MCU: " + mcu);
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList rcuInfoList = mrcuInfo.getTrueCopyRCUInfoList();
        Collections.sort(rcuInfoList);
        SJmoRemoteReplicationRCUInfo keyInfo = SJctrRemoteReplicationUtility.getKeyRcuInfo(isCuFree, ldkc, mcu, rcu, controllerId, serialNum, pathId);
        int index = Collections.binarySearch(rcuInfoList, keyInfo);
        if (index >= 0) {
            return (SJmoRemoteReplicationRCUInfo)rcuInfoList.get(index);
        }
        SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasMirrorTypicalVolRs", "Pair RCU information is not found. CU Free: " + isCuFree + ", LDKC: " + ldkc + ", MCU: " + mcu + ", RCU: " + rcu + ", Controller ID: " + controllerId + ", Serial Number: " + serialNum + ", Path ID: " + pathId);
        throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
    }

    private static SJmoRemoteReplicationRCUInfo getKeyRcuInfo(boolean isCuFree, short ldkc, short mcu, short rcu, int controllerId, String serialNum, int pathId) {
        SJmoRemoteReplicationRCUInfo keyInfo = new SJmoRemoteReplicationRCUInfo();
        keyInfo.setSLdkc(ldkc);
        if (isCuFree) {
            keyInfo.setSCu((short)-1);
            keyInfo.setSCUNo((short)-1);
        } else {
            keyInfo.setSCu(rcu);
            keyInfo.setSCUNo(mcu);
        }
        keyInfo.setIControllerID(controllerId);
        keyInfo.setStrSN(serialNum);
        keyInfo.setIRCUID(pathId);
        return keyInfo;
    }

    public static SJmoRemoteReplicationRCUInfo getPairRcuInfo(SJmoTrueCopyPairVolInfo tcPair, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr) {
        if (null == tcPair) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(tcPair);
        if (null == localVol) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Failed to get local volume.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean isCuFree = tcPair.getICUFree() == 1;
        return SJctrRemoteReplicationUtility.getRcuInfo(isCuFree, localVol.getSLdkc(), localVol.getSCu(), tcPair.getSCu(), tcPair.getIPairControllerID(), tcPair.getStrPairSN(), tcPair.getIPairRCUID(), mrcuMgr);
    }

    public static SJmoRemoteReplicationRCUInfo getPairRcuInfo(SJmoUniversalReplicatorPairVolInfo urPair, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr) {
        if (null == urPair) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolume(urPair);
        if (null == localVol) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Failed to get local volume.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return SJctrRemoteReplicationUtility.getRcuInfo(true, localVol.getSLdkc(), localVol.getSCu(), urPair.getSCu(), urPair.getModelId(), urPair.getPairSN(), urPair.getPathID(), mrcuMgr);
    }

    public static SJmoRemoteReplicationRCUInfo getPairRcuInfo(SJmoHAPairVolInfo haPair, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr) {
        if (null == haPair) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(haPair);
        if (null == localVol) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Failed to get HA local volume.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return SJctrRemoteReplicationUtility.getRcuInfo(true, localVol.getSLdkc(), localVol.getSCu(), haPair.getSCu(), haPair.getIPairModel(), haPair.getStrPairSN(), haPair.getIPathGroup(), mrcuMgr);
    }

    public static SJmoRemoteReplicationRCUInfo getPairRcuInfo(SJmoReplicationPairVolInfo pairInfo, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr) {
        if (pairInfo instanceof SJmoTrueCopyPairVolInfo) {
            return SJctrRemoteReplicationUtility.getPairRcuInfo((SJmoTrueCopyPairVolInfo)pairInfo, mrcuMgr);
        }
        if (pairInfo instanceof SJmoUniversalReplicatorPairVolInfo) {
            return SJctrRemoteReplicationUtility.getPairRcuInfo((SJmoUniversalReplicatorPairVolInfo)pairInfo, mrcuMgr);
        }
        if (pairInfo instanceof SJmoHAPairVolInfo) {
            return SJctrRemoteReplicationUtility.getPairRcuInfo((SJmoHAPairVolInfo)pairInfo, mrcuMgr);
        }
        SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Unknown pair information instance.");
        throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
    }

    public static boolean hasRcuPortRs(SJmoRemoteReplicationRCUInfo rcuInfo, SJctrResourceGroupUtility rsgUty) {
        if (null == rcuInfo || null == rsgUty) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "hasRcuPortRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (rcuInfo.getPathInfoList().isEmpty()) {
            return true;
        }
        List topPathList = rcuInfo.getPathInfoList().subList(0, 1);
        return !rsgUty.extractPort(topPathList).isEmpty();
    }

    public static void checkPairPortRs(SJmoReplicationPairVolInfo pairInfo, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr, SJctrResourceGroupUtility rsgUty, int errorMsgType) {
        if (null == rsgUty || null == pairInfo) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkPairPortRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (pairInfo.isVolPos(1) || pairInfo.isVolPos(32) || pairInfo.isVolPos(4096) || pairInfo.isVolPos(131072)) {
            return;
        }
        SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteReplicationUtility.getPairRcuInfo(pairInfo, mrcuMgr);
        if (!SJctrRemoteReplicationUtility.hasRcuPortRs(rcuInfo, rsgUty)) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkPairPortRs", "Pair RCU Port is not authorized.");
            if (errorMsgType == 0) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206115);
            }
            if (errorMsgType == 1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206150);
            }
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkPairPortRs", "Unknown pair information instance.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
    }

    public static void checkPairPortRs(List<? extends SJmoReplicationPairVolInfo> pairList, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr, SJctrResourceGroupUtility rsgUty) {
        if (null == pairList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkPairPortRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        for (SJmoReplicationPairVolInfo sJmoReplicationPairVolInfo : pairList) {
            SJctrRemoteReplicationUtility.checkPairPortRs(sJmoReplicationPairVolInfo, mrcuMgr, rsgUty, 0);
        }
    }

    public static void checkPairPortRs(List<? extends SJmoReplicationPairVolInfo> pairList, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr, SJctrResourceGroupUtility rsgUty, int errorMsgType) {
        if (null == pairList || mrcuMgr == null || rsgUty == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkPairPortRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        for (SJmoReplicationPairVolInfo sJmoReplicationPairVolInfo : pairList) {
            SJctrRemoteReplicationUtility.checkPairPortRs(sJmoReplicationPairVolInfo, mrcuMgr, rsgUty, errorMsgType);
        }
    }

    public static void checkMirrorPortRs(SJmoUniversalReplicatorJnlGrpMirror mirror, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr, SJctrResourceGroupUtility rsgUty) {
        if (null == mirror) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfo", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        switch (mirror.getAttribute()) {
            case 1: {
                SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteReplicationUtility.getRcuInfo(true, (short)mirror.getLdkc(), (short)-1, (short)-1, mirror.getModelId(), mirror.getPairSN(), (Integer)mirror.getPathIdList().get(0), mrcuMgr);
                if (SJctrRemoteReplicationUtility.hasRcuPortRs(rcuInfo, rsgUty)) break;
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkMirrorPortRs", "Pair RCU Port is not authorized.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206116);
            }
        }
    }

    public static void checkMirrorPortRs(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr, SJctrResourceGroupUtility rsgUty) {
        if (null == mirrorList) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkMirrorPortRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        for (SJmoUniversalReplicatorJnlGrpMirror mirror : mirrorList) {
            SJctrRemoteReplicationUtility.checkMirrorPortRs(mirror, mrcuMgr, rsgUty);
        }
    }

    private static SJmoLdevIndex getRcmdDevIndex(int rcmdDev) {
        SJmoLdevIndex index = new SJmoLdevIndex();
        short ldkc = (short)((rcmdDev & 0xFF0000) >> 16);
        short cu = (short)((rcmdDev & 0xFF00) >> 8);
        short ldev = (short)(rcmdDev & 0xFF);
        index.setLdevIndex(ldkc, cu, ldev);
        return index;
    }

    public static void checkRcmdDevRs(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoUniversalReplicatorJnlGrpMgr jnlMgr, SJctrDataController dc) {
        if (null == mirrorList || null == jnlMgr) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkRcmdDevRs", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrResourceGroupUtility rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(dc);
        ArrayList<SJmoLdevIndex> rcmdDevList = new ArrayList<SJmoLdevIndex>();
        for (SJmoUniversalReplicatorJnlGrpMirror mirror : mirrorList) {
            SJmoLdevIndex index;
            int rcmdDevIndex = -1;
            if (mirror.getMirrorId() == 0) {
                SJmoUniversalReplicatorJnlGrp jnl = jnlMgr.getJnlGroup(mirror.getIJnlGroupId());
                if (null != jnl && jnl.getUcPathForTC() == 1) {
                    rcmdDevIndex = jnl.getRcmdDevForTC();
                } else if (mirror.getUcPath() == 1) {
                    rcmdDevIndex = mirror.getRcmdDev();
                }
            } else if (mirror.getUcPath() == 1) {
                rcmdDevIndex = mirror.getRcmdDev();
            }
            if (!(index = SJctrRemoteReplicationUtility.getRcmdDevIndex(rcmdDevIndex)).isValidIndex()) continue;
            rcmdDevList.add(index);
        }
        List<SJmoLdevIndex> authrizedRcmdDevList = rsgUty.extractLdev(rcmdDevList);
        if (rcmdDevList.size() > authrizedRcmdDevList.size()) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkRcmdDevRs", "No authorized LDEV having.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206122);
        }
    }

    public static String getAuthorizedMaxJnlNumString(SJmoUniversalReplicatorJnlGrpMgr jnlMgr, SJctrResourceGroupUtility rsgUty) {
        String ret = "?";
        if (null != jnlMgr && null != rsgUty) {
            ArrayList<SJmoUniversalReplicatorJnlGrp> noAuthorizedList = new ArrayList<SJmoUniversalReplicatorJnlGrp>();
            for (SJmoUniversalReplicatorJnlGrp jnl : jnlMgr.getJnlGroupList()) {
                if (null == jnl || SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnl, rsgUty)) continue;
                noAuthorizedList.add(jnl);
            }
            int maxJnl = SJmoDataMacro_IF.MAX_JNLG_NUM - noAuthorizedList.size();
            ret = String.valueOf(maxJnl);
        }
        return ret;
    }

    public static int getMaxAddPairNumJnl() {
        int maxAddPairNumJnl = 16384;
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            switch (iHMKind) {
                case 20: {
                    maxAddPairNumJnl = 4096;
                    break;
                }
                case 40: {
                    maxAddPairNumJnl = 8192;
                    break;
                }
                case 60: {
                    maxAddPairNumJnl = 16384;
                    break;
                }
            }
        }
        return maxAddPairNumJnl;
    }

    public static int getMaxAddPairNumMirror() {
        int maxAddPairNumMirror = 8192;
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            switch (iHMKind) {
                case 20: {
                    maxAddPairNumMirror = 2048;
                    break;
                }
                case 40: {
                    maxAddPairNumMirror = 4096;
                    break;
                }
                case 60: {
                    maxAddPairNumMirror = 8192;
                    break;
                }
            }
        }
        return maxAddPairNumMirror;
    }

    public static int getMaxAddPairNumUrCtg() {
        int maxAddPairNumUrCtg = 8192;
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            switch (iHMKind) {
                case 20: {
                    maxAddPairNumUrCtg = 2048;
                    break;
                }
                case 40: {
                    maxAddPairNumUrCtg = 4096;
                    break;
                }
                case 60: {
                    maxAddPairNumUrCtg = 8192;
                    break;
                }
            }
        }
        return maxAddPairNumUrCtg;
    }

    public static List<SJmoReplicationPairVolInfo> getRemoteVolListfromSelectedPairVol(SJmoUniversalReplicatorPairVolInfo selectedPair) {
        ArrayList<SJmoReplicationPairVolInfo> remoteVolList = new ArrayList<SJmoReplicationPairVolInfo>();
        if (selectedPair == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRemoteVolListfromSelectedPairVol", "localVol is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolume(selectedPair);
        if (localVol == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRemoteVolListfromSelectedPairVol", "localVol is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoReplicationPairVolInfo[] pairInfoArray = new SJmoReplicationPairVolInfo[]{localVol};
        remoteVolList.addAll(SJctrRemoteReplicationUtility.getRemoteCopyPairVolInfoList(pairInfoArray));
        return remoteVolList;
    }

    public static short getLocalPortId(SJmoRemoteReplicationRCUPathInfo rcuPathInfo, int attribute) {
        short ret = -1;
        if (null != rcuPathInfo) {
            switch (attribute) {
                case 4: {
                    ret = (short)rcuPathInfo.getIRCUPortNo();
                    break;
                }
                case 5: {
                    ret = rcuPathInfo.getSPort();
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getLocalPortId", "Unknown attribute: " + attribute);
                }
            }
        }
        return ret;
    }

    public static short getRemotePortId(SJmoRemoteReplicationRCUPathInfo rcuPathInfo, int attribute) {
        short ret = -1;
        if (null != rcuPathInfo) {
            switch (attribute) {
                case 4: {
                    ret = rcuPathInfo.getSPort();
                    break;
                }
                case 5: {
                    ret = (short)rcuPathInfo.getIRCUPortNo();
                    break;
                }
                default: {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getRemotePortId", "Unknown attribute: " + attribute);
                }
            }
        }
        return ret;
    }

    public static int getPairPortAttribute(SJmoTrueCopyPairVolInfo tcPair) {
        int attribute = -1;
        if (SJctrRemoteReplicationUtility.isPvol(tcPair)) {
            attribute = 4;
        } else if (SJctrRemoteReplicationUtility.isSvol(tcPair)) {
            attribute = 5;
        }
        return attribute;
    }

    public static int getPairPortAttribute(SJmoUniversalReplicatorPairVolInfo urPair) {
        int attribute = -1;
        if (SJctrRemoteReplicationUtility.isPvol(urPair)) {
            attribute = 4;
        } else if (SJctrRemoteReplicationUtility.isSvol(urPair)) {
            attribute = 5;
        }
        return attribute;
    }

    public static long getCopyTimeNumber(String strCopyTme) {
        long ret = -1L;
        int COPY_TIME_SEPARATE_SIZE = 3;
        int HOUR_INDEX = 0;
        int MINUTE_INDEX = 1;
        int SECOND_INDEX = 2;
        if (strCopyTme != null) {
            String[] strAry = strCopyTme.split(":");
            if (!(strAry.length != COPY_TIME_SEPARATE_SIZE || strAry[HOUR_INDEX].isEmpty() || strAry[MINUTE_INDEX].isEmpty() || strAry[SECOND_INDEX].isEmpty())) {
                try {
                    long lHour = Long.parseLong(strAry[HOUR_INDEX]);
                    long lMin = Long.parseLong(strAry[MINUTE_INDEX]);
                    long lSec = Long.parseLong(strAry[SECOND_INDEX]);
                    ret = lSec + lMin * 60L + lHour * 60L * 60L;
                }
                catch (NumberFormatException e) {
                    SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getCopyTimeNumber", "Parse error occured. strCopyTme: " + strCopyTme);
                }
            } else {
                SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getCopyTimeNumber", "Parse error occured. strCopyTme: " + strCopyTme);
            }
        }
        return ret;
    }

    private static int[] getMirrorStatusPattern(SJmoUniversalReplicatorJnlGrpMirror mirror) {
        int mirrorStatus = mirror.getStatus();
        if (mirrorStatus == 16) {
            if (mirror.getPairSuspend() == 1) {
                mirrorStatus = 2048;
            }
        } else if (mirrorStatus == 64) {
            int iDelta = mirror.getDelta();
            if (iDelta == 1) {
                mirrorStatus = 256;
            } else if (iDelta == 2) {
                mirrorStatus = 512;
            } else if (iDelta == 3) {
                mirrorStatus = 1024;
            }
        }
        int[] statusPattern = new int[]{mirror.getAttribute(), mirrorStatus};
        return statusPattern;
    }

    public static SJmoLdevIndex convertToLdevIndexFromInt(int iLdev) {
        return SJctrRemoteReplicationUtility.getRcmdDevIndex(iLdev);
    }

    public static SJmoRemoteReplicationRCUInfo getPairRcuInfoNoThrow(SJmoReplicationPairVolInfo pairInfo, SJmoRemoteReplicationMRCUInfoMgr mrcuMgr) {
        SJmoRemoteReplicationRCUInfo ret = null;
        try {
            ret = SJctrRemoteReplicationUtility.getPairRcuInfo(pairInfo, mrcuMgr);
        }
        catch (SJcException e) {
            SJctrLogUty.warn(SJctrRemoteReplicationUtility.class.getSimpleName(), "getPairRcuInfoNoThrow", "Failed to get RCU Information.");
        }
        return ret;
    }

    public String getExctgIdString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            if (jnlGrpMirror.isBelongToEXCTG() && jnlGrpMirror.isSuperVisor()) {
                int iExctgId = jnlGrpMirror.getSvEXCTGrpId();
                ret = SJctrComUtility.toHexString(iExctgId, 2, true);
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getSuperDkcString(SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror) {
        String ret = "?";
        if (null != jnlGrpMirror) {
            if (jnlGrpMirror.isBelongToEXCTG() && jnlGrpMirror.isSuperVisor()) {
                int svModelId = jnlGrpMirror.getSvModelId();
                String svSn = jnlGrpMirror.getSvSN();
                ret = this.getModelSNoString(svModelId, svSn);
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public static boolean isExctgValid(List<SJmoUniversalReplicatorJnlGrp> selJnlList) {
        boolean exctgvalid = false;
        if (selJnlList == null || selJnlList.size() == 0) {
            return exctgvalid;
        }
        for (SJmoUniversalReplicatorJnlGrp selJnl : selJnlList) {
            exctgvalid = false;
            for (SJmoUniversalReplicatorJnlGrpMirror mirror : selJnl.getMirrors()) {
                exctgvalid |= mirror.isSuperVisor();
            }
            if (exctgvalid) continue;
            break;
        }
        return exctgvalid;
    }

    public static List<SJmoUniversalReplicatorJnlGrpMirror> getSelectJnlMirrorInfoList(List<SJmoUniversalReplicatorJnlGrp> selJnlList) {
        ArrayList<SJmoUniversalReplicatorJnlGrpMirror> mirrorList = new ArrayList<SJmoUniversalReplicatorJnlGrpMirror>();
        if (selJnlList == null || selJnlList.size() == 0) {
            return mirrorList;
        }
        for (SJmoUniversalReplicatorJnlGrp selJnl : selJnlList) {
            for (SJmoUniversalReplicatorJnlGrpMirror mirror : selJnl.getMirrors()) {
                mirrorList.add(mirror);
            }
        }
        return mirrorList;
    }

    public String getExctgMirrorIdString(SJmoUniversalReplicatorEXCTGJnlGrp exctgJnlGrp) {
        String ret = "?";
        if (null != exctgJnlGrp) {
            boolean rtn = SJctrRemoteReplicationDataMacro.EXCTG_PERMISSION_STATUS.contains(exctgJnlGrp.getJnlGrpAttr());
            ret = rtn ? SJctrRemoteReplicationUtility.getMirrorIdString(exctgJnlGrp.getMirrorId()) : "-";
        }
        return ret;
    }

    public static SJmoUniversalReplicatorEXCTGMgr getSJmoUniversalReplicatorEXCTGMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetUniversalReplicatorEXCTGMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorEXCTGMgr", "Information of Remote Replication UniversalReplicator EXCTG List is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorEXCTGMgr", "Size of Remote Replication UniversalReplicator EXCTG List is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoUniversalReplicatorEXCTGMgr retInfo = (SJmoUniversalReplicatorEXCTGMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoUniversalReplicatorEXCTGMgr", "Information of UniversalReplicator EXCTG is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return retInfo;
    }

    public static List<SJmoUniversalReplicatorEXCTG> checkAndGetExistExctgInfo(List<SJmoUniversalReplicatorEXCTG> selectedExctgList, SJmoUniversalReplicatorEXCTGMgr allExctgInfo) {
        if (selectedExctgList == null || selectedExctgList.size() == 0 || allExctgInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistExctgInfo", "Check data is invalid");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoUniversalReplicatorEXCTG> exctgJnlList = new ArrayList<SJmoUniversalReplicatorEXCTG>(selectedExctgList.size());
        for (SJmoUniversalReplicatorEXCTG selectExctg : selectedExctgList) {
            SJmoUniversalReplicatorEXCTG exctgInfo = allExctgInfo.getExCtGroup(selectExctg.getIndex());
            if (exctgInfo != null) {
                try {
                    exctgJnlList.add((SJmoUniversalReplicatorEXCTG)exctgInfo.clone());
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistExctgInfo", "Catch CloneNotSupportedException.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
                }
            }
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkAndGetExistExctgInfo", "Exctg data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206509);
        }
        return exctgJnlList;
    }

    public static boolean isExctgUsed(List<SJmoUniversalReplicatorEXCTG> selExctgList) {
        boolean exctgused = true;
        if (selExctgList == null || selExctgList.size() == 0) {
            exctgused = false;
            return exctgused;
        }
        for (SJmoUniversalReplicatorEXCTG selExctg : selExctgList) {
            int used = selExctg.getUsed();
            if (used <= 0) {
                exctgused = false;
                break;
            }
            if (SJctrRemoteReplicationDataMacro.EXCTG_PERMISSION_STATUS.contains(selExctg.getAttribute())) continue;
            exctgused = false;
            break;
        }
        return exctgused;
    }

    public static boolean isAddExctgAttribute(SJmoUniversalReplicatorEXCTG selExctg) {
        boolean exctgatt = true;
        if (selExctg == null) {
            exctgatt = false;
            return exctgatt;
        }
        int used = selExctg.getUsed();
        if (used > 0 && !SJctrRemoteReplicationDataMacro.EXCTG_PERMISSION_STATUS.contains(selExctg.getAttribute())) {
            exctgatt = false;
        }
        return exctgatt;
    }

    public boolean isUsedStorageSystemFromExctgJnl(int modelIdBase, String snBase, SJmoUniversalReplicatorEXCTGJnlGrp selExctgJnl) {
        boolean useSystem = false;
        if (snBase == null || selExctgJnl == null) {
            return useSystem;
        }
        int modelId = selExctgJnl.getModelId();
        int sn = Integer.parseInt(selExctgJnl.getSN());
        int snBaseEx = Integer.parseInt(snBase);
        if (modelIdBase == modelId && snBaseEx == sn) {
            useSystem = true;
        }
        return useSystem;
    }

    public static List<SJctrEXCTGJournalsStorageSystemUnitInfo> getEXCTGJournalsStorageSystemUnit(SJmoUniversalReplicatorEXCTG exctg) {
        ArrayList<SJctrEXCTGJournalsStorageSystemUnitInfo> jnlListUnitSystem = new ArrayList<SJctrEXCTGJournalsStorageSystemUnitInfo>();
        if (exctg == null || exctg.getJnlGrpList() == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getEXCTGJournalsStorageSystemUnit", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList alJnlGrp = exctg.getJnlGrpList();
        HashMap<String, SJctrEXCTGJournalsStorageSystemUnitInfo> storageSystemUnitMap = new HashMap<String, SJctrEXCTGJournalsStorageSystemUnitInfo>();
        for (SJmoUniversalReplicatorEXCTGJnlGrp jnlGrp : alJnlGrp) {
            String model = SJctrComUtility.toHexString(jnlGrp.getModelId(), 2, true);
            String sn = SJctrComUtility.toPaddingZeroString(Integer.valueOf(jnlGrp.getSN()), 6);
            String modelSn = model + sn;
            SJctrEXCTGJournalsStorageSystemUnitInfo storageSystem = (SJctrEXCTGJournalsStorageSystemUnitInfo)storageSystemUnitMap.get(modelSn);
            if (storageSystem == null) {
                SJctrEXCTGJournalsStorageSystemUnitInfo info = new SJctrEXCTGJournalsStorageSystemUnitInfo(jnlGrp);
                info.setNumOfJNLs(1);
                storageSystemUnitMap.put(modelSn, info);
                jnlListUnitSystem.add(info);
                continue;
            }
            int numJnl = storageSystem.getNumOfJNLs();
            storageSystem.setNumOfJNLs(numJnl + 1);
        }
        return jnlListUnitSystem;
    }

    public static String getExctgRemComDevString(int rcmdDev, SJctrLdevUtility ldevUtil) {
        String ret = "?";
        if (-1 == rcmdDev) {
            ret = "-";
        } else {
            SJmoLdevIndex ldev = new SJmoLdevIndex();
            ldev.setLdevIndex((short)((rcmdDev & 0xFF0000) >>> 16), (short)((rcmdDev & 0xFF00) >>> 8), (short)(rcmdDev & 0xFF));
            ret = ldevUtil.toLdevDisplay(ldev);
        }
        return ret;
    }

    public String toPaddingZeroSerialNumber(int modelID, String sn) {
        int digit;
        String retSn = "?";
        switch (modelID) {
            case 5: 
            case 6: 
            case 7: {
                digit = 5;
                break;
            }
            case 19: {
                digit = 6;
                break;
            }
            default: {
                digit = 5;
            }
        }
        try {
            retSn = SJctrComUtility.toPaddingZeroString(Integer.parseInt(sn), digit);
        }
        catch (NumberFormatException e) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "toPaddingZeroSerialNumber", "Serial Number is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return retSn;
    }

    public String getVssModelSNString(SJmoTrueCopyPairVolInfo tcPair) {
        String ret = "? / ?";
        if (tcPair != null) {
            if (tcPair.getIVirtualVolEnable() == 0) {
                int iPairControllerID = tcPair.getIPairControllerID();
                String strPairSN = tcPair.getStrPairSN();
                ret = this.getVssModelSNoString(iPairControllerID, strPairSN);
            } else if (tcPair.getIVirtualVolEnable() == 1) {
                int iVirtualDKCModelID = tcPair.getIVirtualDKCModelID();
                String strVirtualDKCSN = tcPair.getStrVirtualDKCSN();
                ret = this.getVssModelSNoString(iVirtualDKCModelID, strVirtualDKCSN);
            }
        }
        return ret;
    }

    public String getVssModelSNString(SJmoUniversalReplicatorPairVolInfo urPair) {
        String ret = "? / ?";
        if (urPair != null) {
            if (urPair.getIVirtualVolEnable() == 0) {
                int modelId = urPair.getModelId();
                String pairSN = urPair.getPairSN();
                ret = this.getVssModelSNoString(modelId, pairSN);
            } else if (urPair.getIVirtualVolEnable() == 1) {
                int iVirtualDKCModelID = urPair.getIVirtualDKCModelID();
                String strVirtualDKCSN = urPair.getStrVirtualDKCSN();
                ret = this.getVssModelSNoString(iVirtualDKCModelID, strVirtualDKCSN);
            }
        }
        return ret;
    }

    public String getVirtualPairLDEVString(SJmoTrueCopyPairVolInfo tcPair, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?";
        if (ldevUtil != null && tcPair != null) {
            if (tcPair.getIVirtualVolEnable() == 0) {
                ret = ldevUtil.toLdevDisplay((SJmoLdevIndex)tcPair);
            } else if (tcPair.getIVirtualVolEnable() == 1) {
                int iVirtualPairLDEV = tcPair.getIVirtualPairLDEV();
                ret = this.editVirtualPairLDEVString(iVirtualPairLDEV, ldevUtil);
            }
        }
        return ret;
    }

    public String getVirtualPairLDEVString(SJmoUniversalReplicatorPairVolInfo urPair, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?";
        if (ldevUtil != null && urPair != null) {
            if (urPair.getIVirtualVolEnable() == 0) {
                ret = ldevUtil.toLdevDisplay((SJmoLdevIndex)urPair);
            } else if (urPair.getIVirtualVolEnable() == 1) {
                int iVirtualPairLDEV = urPair.getIVirtualLDEV();
                ret = this.editVirtualPairLDEVString(iVirtualPairLDEV, ldevUtil);
            }
        }
        return ret;
    }

    public String editVirtualPairLDEVString(int iVirtualPairLDEV, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?";
        if (ldevUtil != null && 0 <= iVirtualPairLDEV && iVirtualPairLDEV < 65280) {
            SJmoLdevIndex ldev = new SJmoLdevIndex();
            ldev.setLdevIndex((short)((iVirtualPairLDEV & 0xFF0000) >>> 16), (short)((iVirtualPairLDEV & 0xFF00) >>> 8), (short)(iVirtualPairLDEV & 0xFF));
            ret = ldevUtil.toLdevDisplay(ldev);
        }
        return ret;
    }

    public static List<SJmoHUVMVirtualLdev> getSJmoHUVMVirtualLdev(SJctrDataController dc) {
        List<SJmoHUVMVirtualLdev> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetHUVMVirtualLdev.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualLdev", "Information of VirtualLDEV is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        return info;
    }

    public static List<SJmoHUVMVirtualDkc> getSJmoHUVMVirtualDkc(SJctrDataController dc) {
        List<SJmoHUVMVirtualDkc> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualDkc", "Information of VirtualDKC is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        return info;
    }

    public static HURgetECTGrps getHURgetECTGrpsList(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getHURgetECTGrpsList", "Argument is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List<SJmoThroughRmiData> rmiData = SJctrRemoteReplicationUtility.getHURgetECTGrpsListModelDirect(dc);
        HURgetECTGrps exctgrps = (HURgetECTGrps)rmiData.get(0).getObjRmi();
        if (null == exctgrps) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getHURgetECTGrpsList", "EXCTG detail is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return exctgrps;
    }

    private static List<SJmoThroughRmiData> getHURgetECTGrpsListModelDirect(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getHURgetECTGrpsListModelDirect", "Argument is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetHurgetECTGrpsList kind = new SJctrGetHurgetECTGrpsList(0);
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> rmiData = map.get(directWrapper);
        return rmiData;
    }

    public String getLocalEncryptedStr(SJmoLdevDetail ldevDetail) {
        String ret = "?";
        if (ldevDetail != null) {
            switch (ldevDetail.getByVolumeType()) {
                case 0: {
                    boolean isEncryptKey = ldevDetail.getbEncryptKey();
                    if (isEncryptKey) {
                        ret = this.guidanceHandle.getGuidance("ENCRYPTED");
                        break;
                    }
                    ret = "";
                    break;
                }
                case 3: {
                    int dpEncript = ldevDetail.getIDpEncrypt();
                    ret = this.getPairPropertyEncryptionString(dpEncript);
                    break;
                }
                default: {
                    ret = "";
                }
            }
        }
        return ret;
    }

    public String getVssModelSNoString(int controllerId, String serialNumStr) {
        if (null == serialNumStr) {
            serialNumStr = "?";
        }
        String modelStr = "?";
        switch (controllerId) {
            case 4: {
                modelStr = this.guidanceHandle.getGuidance("DKC_MODEL_4");
                break;
            }
            case 5: {
                modelStr = this.guidanceHandle.getGuidance("DKC_MODEL_5");
                break;
            }
            case 6: {
                modelStr = this.guidanceHandle.getGuidance("DKC_MODEL_6");
                break;
            }
            case 7: {
                modelStr = this.guidanceHandle.getGuidance("DKC_MODEL_7");
                break;
            }
            case 19: {
                modelStr = this.guidanceHandle.getGuidance("DKC_MODEL_19");
                break;
            }
            case 18: {
                modelStr = this.guidanceHandle.getGuidance("DKC_MODEL_18");
                break;
            }
            default: {
                if (6 > controllerId || controllerId > 255) break;
                modelStr = "(" + String.valueOf(controllerId) + ")";
            }
        }
        return modelStr + " / " + serialNumStr;
    }

    public static SJmoLdevDetail getSJmoLdevDetailFromUrPairInfo(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (pairInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getSJmoLdevDetailFromUrPairInfo", "Argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoLdevDetail ldev = new SJmoLdevDetail();
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolume(pairInfo);
        if (localVol == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSJmoLdevDetailFromUrPairInfo", "Information of SJmoReplicationPairVolInfo is null");
        } else {
            ldev.setLdevIndex(localVol.getSLdkc(), localVol.getSCu(), localVol.getSLdev());
        }
        return ldev;
    }

    public static int getJnlVolType(SJmoLdevIndex ldevIndex, List<? extends SJmoLdevIndex> jnlVolList) {
        int jnlVol = -1;
        if (ldevIndex.equals(jnlVolList.get(0))) {
            jnlVol = 0;
        } else if (ldevIndex.equals(jnlVolList.get(1))) {
            jnlVol = 1;
        }
        return jnlVol;
    }

    public static boolean checkPpLicenseForTCList(SJctrUserController uc, int copyType) {
        boolean ret = true;
        SJctrLicenseContainer licenseCnt = uc.getAuthorizeContainer().getLisenceContainer();
        boolean pp_tc = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HORC);
        boolean pp_tcmf = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HRC);
        if (copyType == 1) {
            if (!pp_tc) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkPpLicenseForTCList", "True Copy license not Install or Disable.");
                SJctrError err = new SJctrError(210, 22, 205080);
                SJcException exp = err.createException();
                throw exp;
            }
        } else if (copyType == 0) {
            if (!pp_tcmf) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkPpLicenseForTCList", "True Copy for Mainframe license not Install or Disable.");
                SJctrError err = new SJctrError(210, 22, 205081);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public static boolean checkPpLicenseForURList(SJctrUserController uc, int copyType) {
        boolean ret = true;
        SJctrLicenseContainer licenseCnt = uc.getAuthorizeContainer().getLisenceContainer();
        boolean pp_tc = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HORC);
        boolean pp_tcmf = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HRC);
        boolean pp_ur = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HUR);
        boolean pp_urmf = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HURMF);
        if (copyType == 1) {
            if (!pp_ur || !pp_tc) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkPpLicenseForURList", "UR or TC license not Install or Disable.");
                SJctrError err = new SJctrError(210, 22, 205075);
                SJcException exp = err.createException();
                throw exp;
            }
        } else if (copyType == 0) {
            if (!pp_urmf || !pp_tcmf) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkPpLicenseForURList", "URMF or TCMF license not Install or Disable.");
                SJctrError err = new SJctrError(210, 22, 205076);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public static boolean checkPpLicenseForGADList(SJctrUserController uc, int copyType) {
        boolean ret = true;
        SJctrLicenseContainer licenseCnt = uc.getAuthorizeContainer().getLisenceContainer();
        boolean pp_gad = licenseCnt.checkPP(SJctrLicenseContainer.PPID_GAD);
        if (copyType == 1) {
            if (!pp_gad) {
                SJctrLogUty.error("SJctrRemoteReplicationUtility", "checkPpLicenseForGADList", "GAD license not Install or Disable.");
                SJctrError err = new SJctrError(210, 22, 205077);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public static SJmoRemoteReplicationLuPath getLuPathFromLdev(SJmoLdevDetail ldev, int copyType, Map<Integer, List<SJmoPortLunDetail>> portLunMap) {
        SJmoRemoteReplicationLuPath lu = new SJmoRemoteReplicationLuPath();
        if (ldev != null && portLunMap != null) {
            List<SJmoPortLunDetail> portLunDetailList;
            lu.setSLdkc(ldev.getSLdkc());
            lu.setSCu(ldev.getSCu());
            lu.setSLdev(ldev.getSLdev());
            if (copyType == 1 && (portLunDetailList = portLunMap.get(ldev.getIndex())) != null && portLunDetailList.size() != 0) {
                SJmoLuIndex luIndex = new SJmoLuIndex();
                SJmoPortLunDetail detail = portLunDetailList.get(0);
                luIndex.setSHostGroup(detail.getSHostGroup());
                luIndex.setILUN((int)detail.getSLUN());
                luIndex.setSPort(detail.getSPort());
                lu.setLuPath(luIndex);
            }
        }
        return lu;
    }

    public static List<SJmoPortDetail> getTargetKindPortDetailList(List<SJmoPortDetail> portDetailList, int[] portKind) {
        if (portDetailList == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getTargetKindPortDetailList", "Argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoPortDetail> portList = new ArrayList<SJmoPortDetail>(portDetailList.size());
        block0: for (SJmoPortDetail port : portDetailList) {
            for (int kind : portKind) {
                if (port.getByPortKindNo() != kind) continue;
                portList.add(port);
                continue block0;
            }
        }
        return portList;
    }

    public static int[] getIpv4Address(String ip) {
        if (ip == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getIpv4Address. (arguments type is String.)", "argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        InetAddress inetAddress = SJctrRemoteReplicationUtility.getInetAddress(ip);
        int[] ipv4 = SJctrRemoteReplicationUtility.getIpv4Address(inetAddress);
        return ipv4;
    }

    public static int[] getIpv4Address(InetAddress inetAddress) {
        if (inetAddress == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getIpv4Address. (arguments type is InetAddress.)", "argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        byte[] address = inetAddress.getAddress();
        int[] ipv4 = new int[4];
        for (int i = 0; i < ipv4.length; ++i) {
            ipv4[i] = address[i] & 0xFF;
        }
        return ipv4;
    }

    public static int[] getIpv6Address(InetAddress inetAddress) {
        if (inetAddress == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getIpv6Address. (arguments type is InetAddress.)", "argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        byte[] address = inetAddress.getAddress();
        int[] ipv6 = new int[8];
        for (int i = 0; i < ipv6.length; ++i) {
            int addressIndex = i * 2;
            ipv6[i] = (address[addressIndex] & 0xFF) << 8 | address[addressIndex + 1] & 0xFF;
        }
        return ipv6;
    }

    public static InetAddress getInetAddress(String ipaddress) {
        if (ipaddress == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getInetAddress.", "argument is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ipaddress);
        }
        catch (UnknownHostException e) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        return address;
    }

    public String getT10PIString(SJmoLdevDetail ldevDetail) {
        String strT10pi = "?";
        if (ldevDetail == null) {
            return strT10pi;
        }
        strT10pi = ldevDetail.getBT10pi() ? this.guidanceHandle.getGuidance("T10PI") : "";
        return strT10pi;
    }

    public static String addDelimiter(String baseWord) {
        String addDelimiterWord = "";
        if (baseWord == null) {
            return addDelimiterWord;
        }
        if (!baseWord.equals("")) {
            addDelimiterWord = " , " + baseWord;
        }
        return addDelimiterWord;
    }

    public static ArrayList<SJmoChaDetail> getSJmoChaDetailList(SJctrDataController dc) {
        ArrayList info = (ArrayList)SJctrRemoteReplicationUtility.getCache(dc, SJmoGetChaDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoChaDetailList", "Information of ChaDetail is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return info;
    }

    public String getPairPropertyEncryptionString(int iEncrypt) {
        String ret = "?";
        ret = (iEncrypt & 8) == 8 ? "" : (iEncrypt == 4 ? "" : (iEncrypt == 2 ? this.guidanceHandle.getGuidance("ENCRYPTED") : (iEncrypt == 1 ? "" : (iEncrypt == 0 ? "" : this.guidanceHandle.getGuidance("MIXED_ENCRYPTION")))));
        return ret;
    }

    public static boolean isLocalVolDuplicateForUrPair(List<SJmoUniversalReplicatorPairVolInfo> pairExist) {
        boolean rtn = false;
        if (pairExist == null || pairExist.size() == 0) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "isLocalVolDuplicateForUrPair", "Param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        HashSet<Integer> selLdev = new HashSet<Integer>();
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairExist) {
            int volIndex = SJctrRemoteReplicationUtility.getLocalVolume(pairInfo).getIndex();
            if (selLdev.contains(volIndex)) {
                rtn = true;
                break;
            }
            selLdev.add(volIndex);
        }
        return rtn;
    }

    public static List<SJmoLdevIndex> getLdevIndexListFromPortLunTableKey(List<SJctrPortLunTableKey> portLunInfoList) {
        if (portLunInfoList == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getLdevIndexListFromPortLunTableKey", "Param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoLdevIndex> searchLdevList = new ArrayList<SJmoLdevIndex>();
        for (SJctrPortLunTableKey portLunInfo : portLunInfoList) {
            SJmoPortLunDetail ptLunDtl = portLunInfo.getPortLunDetail();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(ptLunDtl.getSLDKC(), ptLunDtl.getSCU(), ptLunDtl.getSLDEV());
            searchLdevList.add(ldevIndex);
        }
        return searchLdevList;
    }

    public static SJmoLdevIndex getLdevIndexFromPortLunTableKey(SJctrPortLunTableKey portLunInfo) {
        if (portLunInfo == null) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "getLdevIndexFromPortLunTableKey", "Param is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoPortLunDetail ptLunDtl = portLunInfo.getPortLunDetail();
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setLdevIndex(ptLunDtl.getSLDKC(), ptLunDtl.getSCU(), ptLunDtl.getSLDEV());
        return ldevIndex;
    }

    public static List<SJmoThinProvisioningVolumesStatus> getSJmoThinProvisioningVolumesStatus(SJctrDataController dc) {
        List<SJmoThinProvisioningVolumesStatus> info = SJctrRemoteReplicationUtility.getCache(dc, SJmoGetThinProvisioningVolumesStatus.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoThinProvisioningVolumesStatus", "Information of ThinProvisioningVolumesStatus is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }
}

