/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprSummary;
import sanproject.sn2.model.connector.kind.SJmoGetDCRInfo;
import sanproject.sn2.model.connector.kind.SJmoGetDcrCacheInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilClpr;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoDKCInfo;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoClprSummary;
import sanproject.sn2.model.data.system.SJmoDcrCacheInfo;
import sanproject.sn2.model.data.system.SJmoDiskAddress;
import sanproject.sn2.model.data.volume.SJmoDCRInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrVpmUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final String CLPR_GUIDE_CREATE_CL = "CREATE_CL";
    public static final String CLPR_GUIDE_EDIT_CL = "EDIT_CL";
    public static final String CLPR_GUIDE_DELETE_CL = "DELETE_CL";
    public static final String CLPR_GUIDE_MIGRATE_CL = "MIGRATE_CL";
    public static final String GUIDE_DISPID_VPM = "VPM";
    public static final String GUIDE_ANY = "ANY";
    public static final String CLPR_TAB_GUIDE_VPM = "CACHE_PARTITIONS";
    public static final String CLPR_TAB_GUIDE_PG = "ARRAY_GROUPS";
    public static final String CLPR_TAB_GUIDE_VVOL = "VVOL";
    public static final String GUIDE_CLPR = "CLPR";
    public static final String GUIDE_CLPR_NAME = "CLPR_NAME";
    public static final String GUIDE_CLPR_ID = "CLPR_ID";
    public static final String GUIDE_CACHE_SIZE = "CACHE_SIZE";
    public static final String GUIDE_GENERAL = "GENERAL";
    public static final String GUIDE_RESIDENT = "RESIDENT";
    public static final String GUIDE_TOTAL = "TOTAL";
    public static final String GUIDE_TOTAL_CACHE_SIZE = "TOTAL_CACHE_SIZE";
    public static final String GUIDE_NUM_OF_RSC = "NUM_OF_RSC";
    public static final String GUIDE_AG = "AG";
    public static final String GUIDE_VVOL_SIMPLE = "VVOL_SIMPLE";
    public static final String GUIDE_NUM_OF_RESIDENT = "NUM_OF_RESIDENT";
    public static final String GUIDE_MIGRATED = "MIGRATED";
    public static final String GUIDE_PARTITIONST = "CACHE_PARTITIONS";
    public static final String GUIDE_CAPACITY = "CAPACITY";
    public static final String KEY_TAB_VPM = "TAB_VPM";
    public static final String KEY_TAB_PG = "TAB_VPM_PG";
    public static final String KEY_TAB_VVOL = "TAB_VPM_VVOL";
    public static final String KEY_COL_RSGNAME = "COM_COL_RSGNAME";
    public static final String KEY_COL_RAIDLEV = "COM_COL_RAIDLEV";
    public static final String KEY_COL_CAPACITY = "COM_COL_CAPACITY";
    public static final String KEY_COL_MIGRATED = "COM_COL_MIGRATED";
    public static final String KEY_COL_CACHEPARTITION = "COM_COL_CACHEPARTITION";
    public static final String KEY_COL_CLPR_ID = "COM_COL_CLPR_ID";
    public static final String KEY_COL_CLPR_NAME = "COM_COL_CLPR_NAME";
    public static final String KEY_COL_CACHESIZE = "COM_COL_CACHESIZE";
    public static final String KEY_COL_GENERAL = "COM_COL_GENERAL";
    public static final String KEY_COL_RESIDENT = "COM_COL_RESIDENT";
    public static final String KEY_COL_CLPR_CAP_TOTAL = "COM_COL_CLPR_CAP_TOTAL";
    public static final String KEY_COL_TOTAL_CACHE = "COM_COL_TOTAL_CACHE";
    public static final String KEY_COL_NUM_OF_RSC = "COM_COL_NUM_OF_RSC";
    public static final String KEY_COL_PG_NUM = "COM_COL_PG_NUM";
    public static final String KEY_COL_VVOL_NUM = "COM_COL_VVOL_NUM";
    public static final String KEY_COL_RSC_NUM_TOTAL = "COM_COL_RSC_NUM_TOTAL";
    public static final String KEY_COL_NUM_OF_RESIDENT = "COM_COL_NUM_OF_RESIDENT";
    public static final String KEY_COL_LDEVID = "COM_COL_LDEVID";
    public static final String KEY_COL_LDEVNAME = "COM_COL_LDEVNAME";
    public static final String KEY_COL_EMUTYPE = "COM_COL_EMUTYPE";
    public static final String KEY_COL_VOLTYPE = "COM_COL_VOLTYPE";
    public static final String KEY_COL_VOLATTR = "COM_COL_ATTR";
    public static final String KEY_COL_PARITYGROUP_ID = "COM_COL_PARITYGROUP_ID";
    public static final String KEY_COL_BASE_EMU = "COM_COL_BASE_EMU";
    public static final String KEY_TAB = "COM_TAB";
    public static final String TAB_CACHE_PARTITIONS = "TAB_CACHE_PARTITIONS";
    public static final String TAB_VPM_PG = "TAB_VPM_PG";
    public static final String TAB_VPM_VVOL = "TAB_VPM_VVOL";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_TABLE_DEFAULT = "COM_TABLE_DEFAULT";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_TABLE_PG = "COM_TABLE_PG";
    public static final String KEY_TABLE_VVOL = "COM_TABLE_VVOL";
    public static final String KEY_TABLE_CLPR = "COM_TABLE_CLPR";
    public static final String KEY_ADD_BTN = "COM_ADD_BTN";
    public static final String KEY_CHANGE_BTN = "COM_CHANGE_BTN";
    public static final String KEY_SET_BTN = "COM_SET_BTN";
    public static final String KEY_DETAIL = "COM_DETAIL";
    public static final String KEY_DELETE = "COM_REMOVE";
    public static final String KEY_CHECKBOX = "COM_CHECKBOX";
    public static final String KEY_CACHESIZE_CMB = "COM_CACHESIZE_CMB";
    public static final String KEY_CLPR_CMB = "COM_CLPR_CMB";
    public static final String KEY_CU_CMB = "COM_CU_CMB";
    public static final String KEY_NAME = "COM_NAME";
    public static final String KEY_ID = "COM_ID";
    public static final String KEY_MIN = "COM_MIN";
    public static final String KEY_MAX = "COM_MAX";
    public static final String KEY_NUM_OF_CLPR = "COM_NUM_OF_CLPR";
    public static final String KEY_CLPR = "COM_CLPR";
    public static final String KEY_GENERAL = "COM_GENERAL";
    public static final String KEY_GENERAL_PER = "COM_GENERAL_PER";
    public static final String KEY_RESIDENT = "COM_RESIDENT";
    public static final String KEY_RESIDENT_PER = "COM_RESIDENT_PER";
    public static final String KEY_TOTAL_SIZE = "COM_TOTAL_SIZE";
    public static final String KEY_PG_NUM = "COM_PG_NUM";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_TOTAL_RSC = "COM_TOTAL_RSC";
    public static final String KEY_CLPR_ID = "COM_CLPR_ID";
    public static final String KEY_CLPR_NAME = "COM_CLPR_NAME";
    public static final String KEY_CLPR_NAME_INF = "COM_CLPR_NAME_INF";
    public static final String KEY_TOTAL_CACHE = "COM_TOTAL_CACHE";
    public static final String KEY_RESIDENT_CACHE = "COM_RESIDENT_CACHE";
    public static final String KEY_NUM_OF_RESIDENT = "COM_NUM_OF_RESIDENT";
    public static final String KEY_NUM_OF_EXTENTS = "COM_NUM_OF_EXTENTS";
    public static final String KEY_NUM_OF_EXTENTS_INF = "COM_NUM_OF_EXTENTS_INF";
    public static final Class KEY_CLASS_CLPR_SUMMARY = SJmoGetClprSummary.class;
    public static final Class KEY_CLASS_CLPR_INFO = SJmoGetClprInfo.class;
    public static final Class KEY_CLASS_DCR_CACHEINFO = SJmoGetDcrCacheInfo.class;
    public static final Class KEY_CLASS_DCR_INFO = SJmoGetDCRInfo.class;
    public static final Class KEY_CLASS_PG_DETAIL = SJmoGetPgDetail.class;
    public static final Class KEY_CLASS_PG_SCATTERED_INFO = SJmoGetPgScatteredInfo.class;
    public static final Class KEY_CLASS_LDEV_DETAIL = SJmoGetLdevDetail.class;
    public static final Class KEY_CLASS_VDEV_DETAIL = SJmoGetVdevDetail.class;
    public static final Class KEY_CLASS_PDEV_DETAIL = SJmoGetPdevDetail.class;
    public static final Class KEY_CLASS_CLPR_RSC_UTIL = SJmoGetRscUtilClpr.class;
    public static final Class KEY_CLASS_ALL_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final Class KEY_CLASS_ALL_DKC_INFO = SJmoGetAllDKCInfo.class;
    public static final String KEY_DISPID = "KEY_DISPID";
    public static final String KEY_SELECT_CLPR_INDEX = "KEY_SELECT_CLPR_INDEX";
    public static final String KEY_GET_DEFAULT_CLPRINFO = "KEY_GET_DEFAULT_CLPRINFO";
    public static final String KEY_GET_SELECTED_CLPRINFO = "KEY_GET_SELECTED_CLPRINFO";
    public static final String KEY_GET_SELECTED_CLPRINFO_ALL = "KEY_GET_SELECTED_CLPRINFO_ALL";
    public static final String KEY_DETAIL_CLPR_DETAIL = "KEY_DETAIL_CLPR_DETAIL";
    public static final String KEY_DETAIL_PG_DETAIL = "KEY_DETAIL_PG_DETAIL";
    public static final String KEY_DETAIL_LDEV_DETAIL = "KEY_DETAIL_LDEV_DETAIL";
    public static final String KEY_GET_BASE_CLPRINFO = "KEY_GET_BASE_CLPRINFO";
    public static final int VPM_GET_SUMMARY_INDEX = 0;
    public static final int ERR_VPM_FUNC = 85;
    public static final int ERR_VPM_MODULE = 22;
    public static final int ERR_VPM_HIC_FUNC = 85;
    public static final int ERR_VPM_HIC_MODULE = 5;
    public static final int RESULT_NORMAL = 0;
    public static final int STATUS_END = 0;
    public static final int STATUS_ENFORCEMENT = 1;
    public static int ERR_HIC_CONNECT_1 = 9005;
    public static final int ERR_SEL_ROW_MULTI = 105001;
    public static final int ERR_SEL_ROW_SINGLE = 105002;
    public static final int ERR_SET_CLPRNAME = 105003;
    public static final int ERR_SET_SYS_CLPRNAME = 105004;
    public static final int ERR_SET_DUP_CLPRNAME = 105009;
    public static final int ERR_SET_INIT_NUM_NOTINPUT = 105011;
    public static final int ERR_SET_INIT_NUM_INPUT_OVER = 105020;
    public static final int ERR_SET_TOTAL_CACHE = 105005;
    public static final int ERR_SET_RESIDENT_CACHE = 105006;
    public static final int ERR_SET_RESIDENT_EXTENTS_CACHE = 105007;
    public static final int ERR_MIG_PG_IN_DCR = 105014;
    public static final int ERR_CLPRNUM_MAX_W7 = 105017;
    public static final int ERR_MIG_SET_NOT_RES = 105018;
    public static final int ERR_MIG_SET_NOT_CLPR = 105019;
    public static final int WAR_CLPR_LOW_CACHE = 105022;
    public static final int ERR_CLPRNAME_LEN_OVER = 205187;
    public static final int ERR_CLPRNUM_MAX_W5 = 106001;
    public static final int ERR_DEL_CLPR00 = 106003;
    public static final int ERR_DEL_IN_PG_RES = 106004;
    public static final int ERR_DEL_IN_VVOL_RES = 106005;
    public static final int ERR_MIG_PG_CONALL = 106007;
    public static final int ERR_MIG_NOT_CLPR_MULTI = 106008;
    public static final int ERR_CLPR_CACHE_LOW_LESS_W5 = 106006;
    public static final int ERR_VPM_UNKNOWN_WIZ_W4 = 107001;
    public static final int ERR_VPM_UNKNOWN_WIZ_W5 = 107002;
    public static final int CLPR_MAX_NOT_PP = 4;
    public static int CLPR_MAX = 32;
    public static final int CLPR_ID_MIN = 0;
    public static int CLPR_ID_MAX = 31;
    public static final int CLPR_NAME_MIN = 1;
    public static final int CLPR_NAME_MAX = 16;
    public static final int CLPR_NAME_INITNUM_MAX = 9;
    public static int CLPR_CACHE_MIN = 8192;
    public static int CLPR_CACHE_DIV_UNIT = 4096;
    public static String STR_CLPR_CACHE_MIN = String.valueOf(CLPR_CACHE_MIN / 1024);
    public static final int CLPR_RESIDENT_CACHE_MIN = 0;
    public static int CLPR_RESIDENT_CACHE_DEV_UNIT = 512;
    public static final String STR_CLPR_RESIDENT_CACHE_MIN = "0.0";
    public static final int CLPR_RESIDENT_EXT_MIN = 0;
    public static int CLPR_RESIDENT_EXT_MAX = 16384;
    public static String STR_CLPR_RESIDENT_EXT_MIN = String.valueOf(0);
    public static final int CLPR_CACHESIZE_LOW_16 = 16384;
    public static final int CLPR_CACHESIZE_LOW_32 = 32768;
    public static final int CLPR_CACHESIZE_LOW_48 = 49152;
    public static final int CLPR_CACHESIZE_LOW_64 = 65536;
    public static final int DISK_FB4_INT_MIN = 1;
    public static final int DISK_FB4_INT_MAX = 24;
    public static final int DISK_FB4_EXT_MIN = 101;
    public static final int DISK_FB4_EXT_MAX = 16484;
    public static final int DISK_FB4_EXT_MF_MIN = 16641;
    public static final int DISK_FB4_EXT_MF_MAX = 17152;
    public static final int DISK_FB4_AOU_VVOL_MIN = 16485;
    public static final int DISK_FB4_AOU_VVOL_MAX = 16516;
    public static final int DISK_FB4_QS_VVOL_MIN = 65;
    public static final int DISK_FB4_QS_VVOL_MAX = 96;
    public static final int DISK_FB4_VASA = 97;
    public static final int DISK_PG_INT_MIN = 1;
    public static final int DISK_PG_INT_MAX = 32;
    public static final int DISK_PG_EXT_MIN = 1;
    public static final int DISK_PG_EXT_MAX = 4096;
    public static final int DISK_PG_EXT_MF_MIN = 1;
    public static final int DISK_PG_EXT_MF_MAX = 4096;
    public static final int DISK_PG_AOU_VVOL_MIN = 1;
    public static final int DISK_PG_AOU_VVOL_MAX = 2048;
    public static final int DISK_PG_QS_VVOL_MIN = 1;
    public static final int DISK_PG_QS_VVOL_MAX = 2048;
    public static final int DISK_PG_VASA_MIN = 1;
    public static final int DISK_PG_VASA_MAX = 64;
    public static final String DEFAULT_CLPRNAME = "CLPR";
    public static final String STR_DIFFERENCE = " >> ";
    public static final int FUNC_SIFTBIT = 2;

    public SJctrVpmUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
        this.getClprSummary();
    }

    private void getClprSummary() {
        ArrayList<SJmoGetDirect> alGetInf = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect getDir = new SJmoGetDirect((SJmoGetKind_IF)new SJmoGetClprSummary(), null, null);
        alGetInf.add(getDir);
        List retList = SJmoModelMgr.getModelMgr().getDataAgent().getDataInf(alGetInf);
        SJmoClprSummary moClprSummary = (SJmoClprSummary)((ArrayList)retList.get(0)).get(0);
        CLPR_MAX = moClprSummary.getSCLPRMax();
        CLPR_ID_MAX = CLPR_MAX - 1;
        CLPR_CACHE_MIN = moClprSummary.getICacheLowerLimit();
        CLPR_CACHE_DIV_UNIT = moClprSummary.getICacheAllocationUnit();
        CLPR_RESIDENT_CACHE_DEV_UNIT = moClprSummary.getIDCRAllocationUnit();
        CLPR_RESIDENT_EXT_MAX = moClprSummary.getIDCRExtentMax();
        STR_CLPR_CACHE_MIN = String.valueOf(CLPR_CACHE_MIN / 1024);
    }

    public static void makeErrorDialog(int iError) {
        SJcException exception = new SJctrError(85, 22, iError).createException();
        throw exception;
    }

    public static void makeErrorList(List<SJctrErrorColumnData> errList, Comparable keyObj, int iMsgID) {
        SJctrError errInf = new SJctrError(85, 22, iMsgID);
        SJctrErrorColumnData errClm = new SJctrErrorColumnData(keyObj, errInf);
        errList.add(errClm);
    }

    public static boolean chkClprId(int clprId) {
        boolean bRet = false;
        if (clprId >= 0 && clprId <= CLPR_ID_MAX) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean chkClprName(String strClprName, SJmoClprInfo clprInfo, List<SJmoClprInfo> clprInfoList) {
        boolean bRet = true;
        if (strClprName.length() < 1 || strClprName.length() > 16) {
            SJctrLogUty.warn("SJctrVpmUtility", "chkClprName", "Invalid value for CLPRName:" + strClprName);
            SJctrVpmUtility.makeErrorDialog(105003);
        }
        ArrayList<String> clprNameList = new ArrayList<String>();
        for (SJmoClprInfo clpr : clprInfoList) {
            if (clpr.getSClpr() == clprInfo.getSClpr()) continue;
            clprNameList.add(clpr.getStrClprName());
        }
        if (clprNameList.contains(strClprName)) {
            SJctrLogUty.warn("SJctrVpmUtility", "chkClprName", "reduplication value for CLPRName. CLPRID:" + clprInfo.getSClpr() + ",Name:" + strClprName);
            SJctrVpmUtility.makeErrorDialog(105009);
        }
        ArrayList<String> sysClprNameList = new ArrayList<String>();
        for (int clprId = 0; clprId <= CLPR_ID_MAX; clprId = (int)((short)(clprId + 1))) {
            if (clprId == clprInfo.getSClpr()) continue;
            sysClprNameList.add(SJctrVpmUtility.getDefaultClprName(clprId));
        }
        if (sysClprNameList.contains(strClprName)) {
            SJctrLogUty.warn("SJctrVpmUtility", "chkClprName", "reduplication value for Securing of SystemCLPRName. CLPRID:" + clprInfo.getSClpr() + ",Name:" + strClprName);
            SJctrVpmUtility.makeErrorDialog(105004);
        }
        return bRet;
    }

    public static boolean chkTotalCacheSize(int iTotalCache, SJmoClprSummary summary) {
        boolean bRet = true;
        if (iTotalCache < CLPR_CACHE_MIN || iTotalCache > summary.getICacheUpperLimit() || (float)iTotalCache % (float)CLPR_CACHE_DIV_UNIT != 0.0f) {
            SJctrLogUty.warn("SJctrVpmUtility", "chkTotalCacheSize", "Invalid value for TotalCache. Argument:" + iTotalCache + ",Limit:" + summary.getICacheUpperLimit());
            SJctrVpmUtility.makeErrorDialog(105005);
        }
        return bRet;
    }

    public static boolean chkResidentCacheSize(int iResidentCache, SJmoClprSummary summary) {
        boolean bRet = true;
        if (iResidentCache < 0 || iResidentCache > summary.getIDCRUpperLimit() || (float)iResidentCache % (float)CLPR_RESIDENT_CACHE_DEV_UNIT != 0.0f) {
            SJctrLogUty.warn("SJctrVpmUtility", "chkResidentCacheSize", "Invalid value for ResidentCache. Argument:" + iResidentCache + ",Limit:" + summary.getIDCRUpperLimit());
            SJctrVpmUtility.makeErrorDialog(105006);
        }
        return bRet;
    }

    public static boolean chkNumofResidentExts(int iResidentExtNum) {
        boolean bRet = true;
        if (iResidentExtNum < 0 || iResidentExtNum > CLPR_RESIDENT_EXT_MAX) {
            SJctrLogUty.warn("SJctrVpmUtility", "chkNumofResidentExts", "Invalid value for ResidentExtents. ResidentExtNum:" + iResidentExtNum);
            SJctrVpmUtility.makeErrorDialog(105007);
        }
        return bRet;
    }

    public static boolean chkMigClprForDcrCache(SJmoPgDetail pgDtl, List<SJmoLdevDetail> ldevDtlList, List<SJmoDCRInfo> dcrInfoList) {
        boolean bRet = true;
        ArrayList<SJmoLdevDetail> chkLdevList = new ArrayList<SJmoLdevDetail>();
        int iFb4 = pgDtl.getFB4();
        int iPg = pgDtl.getPG();
        for (SJmoLdevDetail ldevDtl : ldevDtlList) {
            if (iFb4 != ldevDtl.getIFB4() || iPg != ldevDtl.getIPG()) continue;
            chkLdevList.add(ldevDtl);
        }
        for (SJmoDCRInfo dcrInfo : dcrInfoList) {
            int iSearch = Collections.binarySearch(chkLdevList, dcrInfo);
            if (iSearch < 0) continue;
            bRet = false;
            break;
        }
        return bRet;
    }

    public static String getDefaultClprName(int iClprId) {
        String strRet = "?";
        if (SJctrVpmUtility.chkClprId(iClprId)) {
            strRet = "CLPR" + iClprId;
        }
        return strRet;
    }

    public static int getSecureDcrSpaceSize(SJmoDcrCacheInfo dcrInfo) {
        long lRet;
        long ldcrCacheSize = dcrInfo.getLDcrUseCacheSize();
        for (lRet = 0L; ldcrCacheSize > lRet; lRet += (long)(CLPR_CACHE_DIV_UNIT * 1024)) {
        }
        return (int)(lRet / 1024L);
    }

    public static int getSecureDcrSpaceSizeForResident(SJmoDcrCacheInfo dcrInfo) {
        long lRet;
        long ldcrCacheSize = dcrInfo.getLDcrUseCacheSize();
        for (lRet = 0L; ldcrCacheSize > lRet; lRet += (long)(CLPR_RESIDENT_CACHE_DEV_UNIT * 1024)) {
        }
        return (int)(lRet / 1024L);
    }

    public static int getClprDivSize(SJmoClprInfo clprInfo) {
        return SJctrVpmUtility.getClprDivSize(clprInfo, null);
    }

    public static int getClprDivSize(SJmoClprInfo clprInfo, SJmoDcrCacheInfo dcrInfo) {
        int iRet = -1;
        int iCacheSize = clprInfo.getICacheCapacity() - CLPR_CACHE_MIN - SJctrVpmUtility.getSecureDcrSpaceSize(clprInfo);
        if (iCacheSize >= CLPR_CACHE_MIN) {
            iRet = iCacheSize;
        }
        return iRet;
    }

    public static int getPgNum(SJmoClprInfo clprInfo) {
        int iRet = 0;
        for (SJmoDiskAddress diskadr : clprInfo.getDiskAddressList()) {
            if (!SJctrVpmUtility.chkPg(diskadr)) continue;
            ++iRet;
        }
        return iRet;
    }

    public static List<SJmoDiskAddress> getPgList(SJmoClprInfo clprInfo) {
        ArrayList<SJmoDiskAddress> retList = new ArrayList<SJmoDiskAddress>();
        for (SJmoDiskAddress diskadr : clprInfo.getDiskAddressList()) {
            if (!SJctrVpmUtility.chkPg(diskadr)) continue;
            retList.add(diskadr);
        }
        return retList;
    }

    public static List<SJmoPgDetail> getPgList(SJmoClprInfo clprInfo, List<SJmoPgDetail> pgDtlList) {
        ArrayList<SJmoPgDetail> retList = new ArrayList<SJmoPgDetail>();
        List<SJmoDiskAddress> pgList = SJctrVpmUtility.getPgList(clprInfo);
        if (pgList != null) {
            ArrayList<SJmoDiskAddress> chkPgList = new ArrayList<SJmoDiskAddress>(pgList);
            Collections.sort(chkPgList);
            for (SJmoPgDetail pgDtl : pgDtlList) {
                if (Collections.binarySearch(chkPgList, pgDtl) < 0) continue;
                retList.add(pgDtl);
            }
        }
        return retList;
    }

    public static int getPgListCnt(SJmoClprInfo clprInfo, List<SJmoPgDetail> pgDtlList) {
        List<SJmoPgDetail> pgList = SJctrVpmUtility.getPgList(clprInfo, pgDtlList);
        int iRetCnt = pgList.size();
        if (!pgList.isEmpty() && pgList.get(0) instanceof SJctrPGDetail) {
            for (SJmoPgDetail pgIdx : pgList) {
                if (!((SJctrPGDetail)pgIdx).isScTopPG()) continue;
                iRetCnt += ((SJctrPGDetail)pgIdx).getPGScatteredList().size();
            }
        }
        return iRetCnt;
    }

    public static int getVvolNum(SJmoClprInfo clprInfo) {
        int iRet = 0;
        for (SJmoDiskAddress diskadr : clprInfo.getDiskAddressList()) {
            if (!SJctrVpmUtility.chkVvol(diskadr)) continue;
            ++iRet;
        }
        return iRet;
    }

    public static List<SJmoDiskAddress> getVVolList(SJmoClprInfo clprInfo) {
        ArrayList<SJmoDiskAddress> retList = new ArrayList<SJmoDiskAddress>();
        for (SJmoDiskAddress diskadr : clprInfo.getDiskAddressList()) {
            if (!SJctrVpmUtility.chkVvol(diskadr)) continue;
            retList.add(diskadr);
        }
        return retList;
    }

    public static List<SJmoLdevDetail> getVVolList(List<SJmoLdevDetail> ldevDtlList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>();
        for (SJmoLdevDetail ldevDtl : ldevDtlList) {
            if (ldevDtl.getByVolumeType() != 3 && ldevDtl.getByVolumeType() != 2 && ldevDtl.getByVolumeType() != 5) continue;
            retList.add(ldevDtl);
        }
        return retList;
    }

    public static List<SJmoLdevDetail> getVVolList(SJmoClprInfo clprInfo, List<SJmoLdevDetail> ldevDtlList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>();
        List<SJmoDiskAddress> vVolList = SJctrVpmUtility.getVVolList(clprInfo);
        if (vVolList != null) {
            ArrayList<SJmoDiskAddress> chkVvolList = new ArrayList<SJmoDiskAddress>(vVolList);
            Collections.sort(chkVvolList);
            for (SJmoLdevDetail ldevDtl : ldevDtlList) {
                SJmoDiskAddress chkDiskAdr = new SJmoDiskAddress();
                chkDiskAdr.setFB4(ldevDtl.getIFB4());
                chkDiskAdr.setPG(ldevDtl.getIPG());
                if (Collections.binarySearch(chkVvolList, chkDiskAdr) < 0) continue;
                retList.add(ldevDtl);
            }
        }
        return retList;
    }

    public static String toClprNameIdDisplay(SJmoClprInfo clprInfo) {
        String strRet = "?:?";
        if (SJctrVpmUtility.chkClprId(clprInfo.getSClpr())) {
            strRet = SJctrComUtility.toDecString(clprInfo.getSClpr()) + ":" + clprInfo.getStrClprName();
        }
        return strRet;
    }

    public static String toDiffParamDisplay(String strBefor, String strAfter) {
        String strRet = null;
        strRet = !strBefor.equals(strAfter) ? strBefor + STR_DIFFERENCE + strAfter : strBefor;
        return strRet;
    }

    public static String toDiffParamDisplay(int iBefor, int iAfter) {
        String strRet = null;
        strRet = iBefor != iAfter ? iBefor + STR_DIFFERENCE + iAfter : String.valueOf(iBefor);
        return strRet;
    }

    public static String toDiffParamDisplay(int iBefor, int iAfter, SJctrCapacityUtility capaUtil, SJctrCapacityUtility.UNIT toLBAUnit) {
        return SJctrVpmUtility.toDiffParamDisplay(iBefor, iAfter, capaUtil, toLBAUnit, null);
    }

    public static String toDiffParamDisplay(int iBefor, int iAfter, SJctrCapacityUtility capaUtil, SJctrCapacityUtility.UNIT toLBAUnit, SJctrCapacityUtility.UNIT dispUnit) {
        String strBefor = null;
        String strAfter = null;
        long lCngBefor = capaUtil.valueOf((long)iBefor, toLBAUnit);
        long lCngAfter = capaUtil.valueOf((long)iAfter, toLBAUnit);
        if (dispUnit == null) {
            strBefor = capaUtil.toUnitString(lCngBefor);
            strAfter = capaUtil.toUnitString(lCngAfter);
        } else {
            strBefor = capaUtil.toString(lCngBefor, dispUnit) + dispUnit.toString();
            strAfter = capaUtil.toString(lCngAfter, dispUnit) + dispUnit.toString();
        }
        return SJctrVpmUtility.toDiffParamDisplay(strBefor, strAfter);
    }

    public static List<SJctrPGDetail> toCtrPgDetailList(List<? extends SJmoPgIndex> pgIdxList, List<SJmoPgDetail> pgDtlList, List<SJmoPgScatteredInfo> pgScList, List<SJmoVdevDetail> vdevList, List<SJmoPdevDetail> pdevList, List<SJmoLdevDetail> ldevList) {
        ArrayList<SJctrPGDetail> retList = new ArrayList<SJctrPGDetail>();
        for (SJmoPgIndex sJmoPgIndex : pgIdxList) {
            SJctrPGDetail pg = new SJctrPGDetail(sJmoPgIndex.getFB4(), sJmoPgIndex.getPG());
            pg.setPGScatteredList(pgScList);
            pg.setBasicDataList(pgDtlList, vdevList, ldevList, null);
            pg.setPDEVList(pdevList);
            retList.add(pg);
        }
        return retList;
    }

    public static SJctrError createErrorInfo(int iDetect, int iErrCode) {
        String strDetect = SJctrComUtility.toPaddingZeroString(iDetect, 5);
        int func = Integer.valueOf(strDetect.substring(0, strDetect.length() - 2));
        int module = Integer.valueOf(strDetect.substring(strDetect.length() - 2, strDetect.length()));
        return new SJctrError(func, module, iErrCode);
    }

    public static boolean chkPg(SJmoDiskAddress diskadr) {
        boolean bRet = false;
        int iFb4 = diskadr.getFB4();
        int iPg = diskadr.getPG();
        if (iFb4 >= 1 && iFb4 <= 24 && iPg >= 1 && iPg <= 32 || iFb4 >= 101 && iFb4 <= 16484 && iPg >= 1 && iPg <= 4096 || iFb4 >= 16641 && iFb4 <= 17152 && iPg >= 1 && iPg <= 4096) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean chkVvol(SJmoDiskAddress diskadr) {
        boolean bRet = false;
        int iFb4 = diskadr.getFB4();
        int iPg = diskadr.getPG();
        if (iFb4 >= 16485 && iFb4 <= 16516 && iPg >= 1 && iPg <= 2048 || iFb4 >= 65 && iFb4 <= 96 && iPg >= 1 && iPg <= 2048 || iFb4 == 97 && iPg >= 1 && iPg <= 64) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean checkConnectError(String strFunc, String strModule, String strMsg) {
        boolean bResult = true;
        int iFunc = Integer.valueOf(strFunc);
        int iModule = Integer.valueOf(strModule);
        int iMsg = Integer.valueOf(strMsg);
        if (iFunc != 85) {
            bResult = false;
        } else if (iModule != 5) {
            bResult = false;
        } else if (iMsg != ERR_HIC_CONNECT_1) {
            bResult = false;
        }
        return bResult;
    }

    public static SJcMessage getWarningMsg(int iMsgId) {
        String strFuncID = Integer.toString(85);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(iMsgId);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        return msg;
    }

    public static boolean chkClprLowCacheSize(List<SJmoAllDKCInfo> dkcInfoList, List<SJmoClprInfo> clorInfoList) {
        boolean bRet = false;
        int iMpbCnt = 0;
        for (SJmoDKCInfo dkcinfo : dkcInfoList.get(0).getDKCInfo()) {
            iMpbCnt += dkcinfo.getMPBladeInfo().size();
        }
        int iClprLowCacheSize = 0;
        if (iMpbCnt <= 4) {
            iClprLowCacheSize = 16384;
        } else if (iMpbCnt <= 8) {
            iClprLowCacheSize = 32768;
        } else if (iMpbCnt <= 12) {
            iClprLowCacheSize = 49152;
        } else if (iMpbCnt <= 16) {
            iClprLowCacheSize = 65536;
        }
        for (SJmoClprInfo clprinfo : clorInfoList) {
            if (iClprLowCacheSize <= (clprinfo.getICacheCapacity() - clprinfo.getIDCRCapacity()) * 2) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static int getSecureDcrSpaceSize(SJmoClprInfo clprInfo) {
        int iRet;
        int iDcrCapacity = clprInfo.getIDCRCapacity();
        for (iRet = 0; iDcrCapacity > iRet; iRet += CLPR_CACHE_DIV_UNIT) {
        }
        return iRet;
    }
}

