/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolUsedCapacity;

public class SJctrDKCSavingCapColumnFromPoolDetail
extends SJctrCapacityColumn {
    protected Map<Integer, Long> poolCapacityMap = Collections.emptyMap();
    protected final String CAP_UNIT_FORMAT = "%s %s";
    protected boolean chkDRDVolNum = true;

    public SJctrDKCSavingCapColumnFromPoolDetail(String key) {
        super(key);
        this.setPartsId("REDUCED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> retList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        retList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        retList.add(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        return retList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        List<?> retList = super.getNeedModelData(index, basicData);
        List<SJmoPoolUsedCapacity> poolUseCapInfoList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        SJmoPoolUsedCapacity poolUseCapInfo = SJctrPoolUtility.getPoolUsedCapacityInfo((SJmoPoolIndex)index, poolUseCapInfoList);
        if (poolUseCapInfo != null) {
            retList.add(poolUseCapInfo);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        if (this.poolCapacityMap == Collections.EMPTY_MAP) {
            int rowCount = this.getTable().getRowCount();
            this.poolCapacityMap = new HashMap<Integer, Long>(rowCount);
        }
        if (dataList == null || dataList.size() < 2) {
            return "?";
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(0);
        if (this.chkDRDVolNum && poolDtl.getLDRDVolCount() <= 0L) {
            return SJctrPoolUtility.HAIFUN_STR;
        }
        SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.GB;
        String strClmUnit = this.getTable().getUnitMenu();
        if (strClmUnit != null && 0 < strClmUnit.length()) {
            unit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        }
        if (unit.equals((Object)SJctrCapacityUtility.UNIT.CYL) && poolDtl.getEmulationType() == 0) {
            return SJctrPoolUtility.HAIFUN_STR;
        }
        long capacity = this.getCapacity(dataList);
        this.poolCapacityMap.put(poolDtl.getPoolId(), capacity);
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        SJctrCapacityUtility capUtil = comUtl.getCapacityUtility();
        int emuType = poolUtl.changeEmulationType(poolDtl.getEmulationType());
        String strCap = "";
        strCap = unit.equals((Object)SJctrCapacityUtility.UNIT.PAGE) ? SJctrComUtility.toDecString(this.blocktoPage(capacity, poolDtl)) : capUtil.toString(capacity, unit, emuType);
        String ret = String.format("%s %s", strCap, capUtil.getUnitString(unit));
        return ret;
    }

    protected long getCapacity(List<?> dataList) {
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(0);
        SJmoPoolUsedCapacity poolUseCap = (SJmoPoolUsedCapacity)dataList.get(1);
        long savingCap = SJctrPoolUtility.getDkcSavingCap(poolUseCap, poolDtl);
        return savingCap;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        String strCap = this.getString(dat);
        if (strCap.equals("?")) {
            return -2L;
        }
        if (strCap.equals(SJctrPoolUtility.HAIFUN_STR)) {
            return SJctrPoolUtility.HAIFUN_NUM;
        }
        long lbaCapacity = -2L;
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        Long value = this.poolCapacityMap.get(poolDtl.getPoolId());
        if (value != null) {
            lbaCapacity = value;
        }
        return lbaCapacity;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        long getNum = this.getNumber(dat);
        if (getNum == -2L || getNum == (long)SJctrPoolUtility.HAIFUN_NUM) {
            return getNum;
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        return this.blocktoPage(getNum, poolDtl);
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long getNum = this.getNumber(dat);
        if (getNum == -2L || getNum == (long)SJctrPoolUtility.HAIFUN_NUM) {
            return getNum;
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        int emuType = poolDtl.getEmulationType();
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        SJctrCapacityUtility capUtil = comUtl.getCapacityUtility();
        emuType = poolUtl.changeEmulationType(emuType);
        long cylinder = capUtil.toCylValue(getNum, emuType);
        return cylinder;
    }

    private long blocktoPage(long block, SJmoPoolDetail poolDtl) {
        long pageNum = 0L;
        long pageSize = poolDtl.getPageSize() * 2L;
        if (0L < pageSize) {
            pageNum = (block + pageSize - 1L) / pageSize;
        }
        return pageNum;
    }
}

