/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrPoolVolMappedCapacityColumnFromPoolLdevDetail
extends SJctrCapacityColumn {
    public SJctrPoolVolMappedCapacityColumnFromPoolLdevDetail(String key) {
        super(key);
        this.setPartsId("MAPPED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJmoGetLdevDetail.class);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrPoolLdevDetail poolLdevDetail = (SJctrPoolLdevDetail)dataList.get(0);
        SJmoPoolVolInfo poolVolInfo = poolLdevDetail.getPoolVolInfo();
        SJmoLdevDetail ldevDtl = poolLdevDetail.getLdevDetail();
        SJmoPoolDetail poolDtl = poolLdevDetail.getPoolDetail();
        SJctrComUtility comUtil = this.getTable().getComUtility();
        String strClmUnit = this.getUnitSelect();
        SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        String strRtn = comUtil.getPoolUtility().toPoolVolMappedCapaDisplay(poolVolInfo, ldevDtl, poolDtl, clmUnit, comUtil);
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = this.getPageNumber(dat);
        if (ret >= 0L) {
            SJctrPoolLdevDetail poolLdevDtl = (SJctrPoolLdevDetail)this.getPrimaryKeyObject(dat);
            SJmoPoolDetail poolDtl = poolLdevDtl.getPoolDetail();
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
            long lPageSize = poolDtl.getPageSize();
            long lPoolVolUsedCapa = ret * lPageSize;
            ret = capaUtil.valueOf(lPoolVolUsedCapa, SJctrCapacityUtility.UNIT.KB);
        }
        return ret;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJctrPoolLdevDetail poolLdevDtl = (SJctrPoolLdevDetail)this.getPrimaryKeyObject(dat);
        SJmoPoolVolInfo poolVolInfo = poolLdevDtl.getPoolVolInfo();
        SJmoLdevDetail ldevDtl = poolLdevDtl.getLdevDetail();
        if (poolVolInfo == null || ldevDtl == null) {
            return -2L;
        }
        int iEmulation = ldevDtl.getIEmulationType();
        String strClmUnit = this.getUnitSelect();
        SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        if (iEmulation == 625 && clmUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
            return SJctrPoolUtility.HAIFUN_NUM;
        }
        return poolVolInfo.getLPoolVolUsedPages();
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long ret = this.getNumber(dat);
        if (ret >= 0L) {
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
            SJctrPoolLdevDetail poolLdevDtl = (SJctrPoolLdevDetail)this.getPrimaryKeyObject(dat);
            SJmoLdevDetail ldevDetail = poolLdevDtl.getLdevDetail();
            int emuType = ldevDetail.getIEmulationType();
            ret = capaUtil.toCylValue(ret, emuType);
        }
        return ret;
    }
}

