/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVVolCapacityUsedRatioColumnFromLdevDetailColumn
extends SJctrCapacityColumn {
    public SJctrVVolCapacityUsedRatioColumnFromLdevDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("USED_PERCENT"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoHDPRelation hdpRelation = null;
        String strRtn = "?";
        SJctrComUtility comUtil = this.getTable().getComUtility();
        String strUnit = this.getTable().getUnitMenu();
        if (dataList.size() != 0) {
            hdpRelation = (SJmoHDPRelation)dataList.get(0);
            strRtn = this.getTable().getComUtility().getPoolUtility().toVVolUsedCapacityRatioDisplay(hdpRelation, strUnit, comUtil);
        }
        return strRtn;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHDPRelation> dataList = new ArrayList<SJmoHDPRelation>();
        List<Object> dpvolList = new ArrayList();
        SJmoHDPRelation hdpRelData = null;
        int iIndex = 0;
        dpvolList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        iIndex = Collections.binarySearch(dpvolList, index);
        if (iIndex >= 0) {
            hdpRelData = (SJmoHDPRelation)dpvolList.get(iIndex);
            dataList.add(hdpRelData);
        }
        return dataList;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        List<?> dpVolList = null;
        SJmoHDPRelation dpVolDetail = null;
        long lUsedPages = 0L;
        long lUsedCap = 0L;
        long lTotalCap = 0L;
        long lRatio = 0L;
        Map<Class<?>, List<?>> basicMap = null;
        int iEmu = 0;
        SJctrPoolUtility poolUtil = this.getTable().getComUtility().getPoolUtility();
        SJctrComUtility comUtil = this.getTable().getComUtility();
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        basicMap = this.getTable().getBasicDataMap();
        dpVolList = this.getNeedModelData(ldevDetail, basicMap);
        dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
        String strUnit = this.getTable().getUnitMenu();
        SJctrCapacityUtility.UNIT selCapaUnit = SJctrCapacityUtility.UNIT.valueOf(strUnit);
        if (selCapaUnit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
            lUsedCap = dpVolDetail.getLUsedpage() + dpVolDetail.getLReservedPage();
            iEmu = poolUtil.changeEmulationType(dpVolDetail.getIEmulationType());
            lTotalCap = poolUtil.getPages(iEmu, dpVolDetail.getLTotalCapaLBA(), comUtil);
        } else {
            lUsedPages = dpVolDetail.getLUsedpage() + dpVolDetail.getLReservedPage();
            lUsedCap = lUsedPages * dpVolDetail.getLPageCapa();
            lTotalCap = dpVolDetail.getLDPVolCapa();
        }
        lRatio = this.getTable().getComUtility().getPoolUtility().getNumRatio(lUsedCap, lTotalCap);
        if (lTotalCap == 0L) {
            lRatio = -3L;
        } else if (lRatio < 0L) {
            lRatio = -2L;
        }
        return lRatio;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }
}

