/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.portcondition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrAdapterTypeColumnFromPortDetail
extends SJctrColumn {
    public SJctrAdapterTypeColumnFromPortDetail(String key) {
        super(key);
        this.setPartsId("ADAPTER_TYPE");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        list.add(SJmoGetChaDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (index != null && index instanceof SJmoPortDetail) {
            retList.add(index);
            SJmoPortDetail portDetail = (SJmoPortDetail)index;
            short sPortId = portDetail.getSPort();
            List<?> chaDetailList = modelData.get(SJmoGetChaDetail.class);
            if (chaDetailList != null && !chaDetailList.isEmpty()) {
                for (Object chaDetailObj : chaDetailList) {
                    SJmoChaDetail chaDetail = (SJmoChaDetail)chaDetailObj;
                    short sCHAClusterNumber = SJctrPortUtility.getPortToCluster(sPortId);
                    short sCHANumber = SJctrPortUtility.getPortToCHANumber(sPortId);
                    if (chaDetail.getSCHAClusterNumber() != sCHAClusterNumber || chaDetail.getSCHANumber() != sCHANumber) continue;
                    retList.add(chaDetail);
                    break;
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoChaDetail List is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && !dataList.isEmpty()) {
            Object port = dataList.get(0);
            if (port instanceof SJmoPortDetail) {
                SJmoPortDetail portDtl = (SJmoPortDetail)dataList.get(0);
                if (SJctrPortUtility.isHnasPort(portDtl)) {
                    return SJctrPortUtility.STR_HYPHEN;
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList(0) is class error");
            }
            if (2 <= dataList.size()) {
                Object obj = dataList.get(1);
                if (obj instanceof SJmoChaDetail) {
                    SJmoChaDetail chaDetail = (SJmoChaDetail)obj;
                    strRtn = this.getTable().getComUtility().getPortUtility().toDispAdapterType(chaDetail);
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList(1) is class error");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList size 1");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

