/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrPortIndexComparator;
import sanproject.sn2.controller.wizard.replication.com.SJctrSelectedRmPathTableDataModelBase;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;

public class SJctrLocalPortIdColumnFromReplicaRcuPathInfo
extends SJctrColumn {
    private SJmoPortIndex portIndexObj = new SJmoPortIndex();

    public SJctrLocalPortIdColumnFromReplicaRcuPathInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("LOCAL_PORT_NAME"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>();
        SJmoRemoteReplicationRCUPathInfo rcuPathInfo = (SJmoRemoteReplicationRCUPathInfo)index;
        SJmoPortDetail portDtl = null;
        List<?> portDtlList = modelData.get(SJmoGetPortDetail.class);
        int attribute = ((SJctrSelectedRmPathTableDataModelBase)this.getTable()).getPortAttribute();
        short localPortId = SJctrRemoteReplicationUtility.getLocalPortId(rcuPathInfo, attribute);
        this.portIndexObj.setSPort(localPortId);
        int localPortIndex = Collections.binarySearch(portDtlList, this.portIndexObj);
        if (localPortIndex >= 0) {
            portDtl = (SJmoPortDetail)portDtlList.get(localPortIndex);
        }
        retList.add(portDtl);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        SJmoPortDetail portDtl = (SJmoPortDetail)dataList.get(0);
        if (portDtl != null) {
            ret = portDtl.getStrPortDisplayName();
        }
        return ret;
    }

    @Override
    public int getSortType() {
        return 3;
    }

    @Override
    protected Object getObject(Map<String, Object> dat) {
        SJmoPortIndex retObj = new SJmoPortIndex();
        SJmoRemoteReplicationRCUPathInfo rcuPathInfo = (SJmoRemoteReplicationRCUPathInfo)this.getPrimaryKeyObject(dat);
        int attribute = ((SJctrSelectedRmPathTableDataModelBase)this.getTable()).getPortAttribute();
        short localPortId = SJctrRemoteReplicationUtility.getLocalPortId(rcuPathInfo, attribute);
        retObj.setSPort(localPortId);
        return retObj;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new SJctrPortIndexComparator();
    }
}

