/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrSSIDColumnFromExdVolumeInfo
extends SJctrColumn {
    protected Map<String, Integer> numberMap = null;

    public SJctrSSIDColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("SSID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExDVirtualPgInfo.class);
        list.add(SJmoGetSsidDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Integer ssid = null;
        SJmoLdevIndex ldev = null;
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        SJmoExDVirtualPgInfo vpginfo = (SJmoExDVirtualPgInfo)modelData.get(SJmoGetExDVirtualPgInfo.class).get(0);
        ArrayList exdVpgList = vpginfo.getAlVpgForExd();
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(volumeInfo.getRmiExdVolumeInfo().getIFB4());
        pgIndex.setPG(volumeInfo.getRmiExdVolumeInfo().getIPG());
        SJmoExDPgInfo exdPGInfo = null;
        int searchId = Collections.binarySearch((List)exdVpgList, (Object)pgIndex);
        if (searchId >= 0) {
            exdPGInfo = (SJmoExDPgInfo)exdVpgList.get(searchId);
        }
        if (exdPGInfo != null && exdPGInfo.getSNumOfLdev() != 0) {
            ldev = exdPGInfo.getStartLdevId();
        }
        if (ldev != null) {
            List<?> ssidList = modelData.get(SJmoGetSsidDetail.class);
            ssid = SJctrCVSUtility.getSSID((short)ldev.getSLdkc(), (short)ldev.getSCu(), (short)ldev.getSLdev(), ssidList);
        }
        list.add(ssid);
        return list;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String getInputFormat() {
        return "^([0-9A-Fa-f]{1,4})$";
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        Integer ssid = (Integer)dataList.get(0);
        if (ssid != null) {
            ret = SJctrComUtility.toHexString(ssid, 4, true);
            if (this.numberMap == null) {
                this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
            }
            this.numberMap.put(ret, ssid);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        if (strNum.length() != 0) {
            num = this.numberMap.get(strNum);
        }
        return num;
    }
}

